/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ec4j.core.ResourceProperties;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.ConfigEncodingCharsetUtil;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorConfigEncodings", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0007\u0018\u0000 \u001c2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0003\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingCache;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "myCharsetMap", "", "", "Lorg/editorconfig/configmanagement/EditorConfigEncodingCache$CharsetData;", "computeAndCacheEncoding", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedCharsetData", "getCachedEncoding", "Ljava/nio/charset/Charset;", "getCharsetData", "withCache", "", "getState", "getUseUtf8Bom", "isIgnored", "loadState", "state", "reset", "setIgnored", "CharsetData", "Companion", "VfsListener", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigEncodingCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigEncodingCache.kt\norg/editorconfig/configmanagement/EditorConfigEncodingCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class EditorConfigEncodingCache
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, CharsetData> myCharsetMap = new ConcurrentHashMap();
    @NotNull
    private static final String ENTRY_ELEMENT = "file";
    @NotNull
    private static final String URL_ATTR = "url";
    @NotNull
    private static final String CHARSET_ATTR = "charset";
    @NotNull
    private static final String IGNORE_ATTR = "ignore";

    @NotNull
    public Element getState() {
        Element root = new Element("encodings");
        for (String url : this.myCharsetMap.keySet()) {
            String charsetStr;
            CharsetData charsetData = this.myCharsetMap.get(url);
            if (charsetData == null || (charsetStr = ConfigEncodingCharsetUtil.INSTANCE.toString(charsetData.getCharset(), charsetData.isUseBom())) == null) continue;
            Element entryElement = new Element(ENTRY_ELEMENT);
            Attribute urlAttr = new Attribute(URL_ATTR, url);
            Attribute charsetAttr = new Attribute(CHARSET_ATTR, charsetStr);
            entryElement.setAttribute(urlAttr);
            entryElement.setAttribute(charsetAttr);
            if (charsetData.isIgnored()) {
                entryElement.setAttribute(IGNORE_ATTR, Boolean.toString(charsetData.isIgnored()));
            }
            root.addContent(entryElement);
        }
        return root;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.myCharsetMap.clear();
        for (Element fileElement : state.getChildren(ENTRY_ELEMENT)) {
            Attribute urlAttr = fileElement.getAttribute(URL_ATTR);
            Attribute charsetAttr = fileElement.getAttribute(CHARSET_ATTR);
            if (urlAttr == null || charsetAttr == null) continue;
            String url = urlAttr.getValue();
            String charsetStr = charsetAttr.getValue();
            Intrinsics.checkNotNull((Object)charsetStr);
            Charset charset = ConfigEncodingCharsetUtil.INSTANCE.toCharset(charsetStr);
            boolean useBom = Intrinsics.areEqual((Object)"utf-8-bom", (Object)charsetStr);
            if (charset == null) continue;
            CharsetData charsetData = new CharsetData(charset, useBom);
            Intrinsics.checkNotNull((Object)url);
            this.myCharsetMap.put(url, charsetData);
            Attribute ignoreAttr = fileElement.getAttribute(IGNORE_ATTR);
            if (ignoreAttr == null) continue;
            try {
                charsetData.setIgnored(ignoreAttr.getBooleanValue());
            }
            catch (DataConversionException dataConversionException) {}
        }
    }

    public final boolean getUseUtf8Bom(@Nullable Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharsetData charsetData = this.getCharsetData(project, virtualFile, true);
        return charsetData != null ? charsetData.isUseBom() : false;
    }

    @Nullable
    public final CharsetData getCharsetData(@Nullable Project project, @NotNull VirtualFile virtualFile, boolean withCache) {
        CharsetData cached;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (project == null || !Utils.INSTANCE.isEnabledFor(project, virtualFile)) {
            return null;
        }
        if (withCache && (cached = this.getCachedCharsetData(virtualFile)) != null) {
            return cached;
        }
        return EditorConfigEncodingCache.Companion.computeCharsetData(project, virtualFile);
    }

    public final void computeAndCacheEncoding(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String key = EditorConfigEncodingCache.Companion.getKey(virtualFile);
        CharsetData charsetData = this.getCharsetData(project, virtualFile, false);
        if (charsetData != null) {
            this.myCharsetMap.put(key, charsetData);
            virtualFile.setCharset(charsetData.getCharset());
        }
    }

    @Nullable
    public final Charset getCachedEncoding(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharsetData charsetData = this.getCachedCharsetData(virtualFile);
        return charsetData != null && !charsetData.isIgnored() ? charsetData.getCharset() : null;
    }

    private final CharsetData getCachedCharsetData(VirtualFile virtualFile) {
        return this.myCharsetMap.get(EditorConfigEncodingCache.Companion.getKey(virtualFile));
    }

    public final boolean isIgnored(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharsetData it = this.getCachedCharsetData(virtualFile);
        boolean bl = false;
        return it != null && it.isIgnored();
    }

    public final void setIgnored(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharsetData charsetData = this.getCachedCharsetData(virtualFile);
        if (charsetData == null) {
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            charsetData = new CharsetData(charset, false);
            charsetData.setIgnored(true);
            this.myCharsetMap.put(EditorConfigEncodingCache.Companion.getKey(virtualFile), charsetData);
        } else {
            charsetData.setIgnored(true);
        }
    }

    public final void reset() {
        this.myCharsetMap.clear();
    }

    @JvmStatic
    @NotNull
    public static final EditorConfigEncodingCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\r"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingCache$CharsetData;", "", "charset", "Ljava/nio/charset/Charset;", "isUseBom", "", "(Ljava/nio/charset/Charset;Z)V", "getCharset", "()Ljava/nio/charset/Charset;", "isIgnored", "()Z", "setIgnored", "(Z)V", "intellij.editorconfig"})
    public static final class CharsetData {
        @NotNull
        private final Charset charset;
        private final boolean isUseBom;
        private boolean isIgnored;

        public CharsetData(@NotNull Charset charset, boolean isUseBom) {
            Intrinsics.checkNotNullParameter((Object)charset, (String)EditorConfigEncodingCache.CHARSET_ATTR);
            this.charset = charset;
            this.isUseBom = isUseBom;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        public final boolean isUseBom() {
            return this.isUseBom;
        }

        public final boolean isIgnored() {
            return this.isIgnored;
        }

        public final void setIgnored(boolean bl) {
            this.isIgnored = bl;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingCache$Companion;", "", "()V", "CHARSET_ATTR", "", "ENTRY_ELEMENT", "IGNORE_ATTR", "URL_ATTR", "computeCharsetData", "Lorg/editorconfig/configmanagement/EditorConfigEncodingCache$CharsetData;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/editorconfig/configmanagement/EditorConfigEncodingCache;", "getKey", "intellij.editorconfig"})
    @SourceDebugExtension(value={"SMAP\nEditorConfigEncodingCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigEncodingCache.kt\norg/editorconfig/configmanagement/EditorConfigEncodingCache$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,159:1\n43#2,3:160\n*S KotlinDebug\n*F\n+ 1 EditorConfigEncodingCache.kt\norg/editorconfig/configmanagement/EditorConfigEncodingCache$Companion\n*L\n142#1:160,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EditorConfigEncodingCache getInstance() {
            boolean $i$f$service = false;
            Class<EditorConfigEncodingCache> serviceClass$iv = EditorConfigEncodingCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (EditorConfigEncodingCache)object;
        }

        private final CharsetData computeCharsetData(Project project, VirtualFile virtualFile) {
            ResourceProperties properties = EditorConfigPropertiesService.Companion.getInstance(project).getProperties(virtualFile);
            String charsetStr = Utils.INSTANCE.configValueForKey(properties, EditorConfigEncodingCache.CHARSET_ATTR);
            if (!(((CharSequence)charsetStr).length() == 0)) {
                Charset charset = ConfigEncodingCharsetUtil.INSTANCE.toCharset(charsetStr);
                boolean useBom = Intrinsics.areEqual((Object)"utf-8-bom", (Object)charsetStr);
                if (charset != null) {
                    return new CharsetData(charset, useBom);
                }
            }
            return null;
        }

        private final String getKey(VirtualFile virtualFile) {
            String string = virtualFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigEncodingCache$VfsListener;", "Lcom/intellij/openapi/vfs/impl/BulkVirtualFileListenerAdapter;", "()V", "intellij.editorconfig"})
    public static final class VfsListener
    extends BulkVirtualFileListenerAdapter {
        public VfsListener() {
            super(new VirtualFileListener(){

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    VirtualFile file = virtualFile;
                    Project project = ProjectLocator.Companion.getInstance().guessProjectForFile(file);
                    if (project != null && Utils.INSTANCE.isEnabledFor(project, file)) {
                        EditorConfigEncodingCache editorConfigEncodingCache = Companion.getInstance();
                        VirtualFile virtualFile2 = event.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
                        editorConfigEncodingCache.computeAndCacheEncoding(project, virtualFile2);
                    }
                }
            });
        }
    }
}

