/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.JetgroovyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.CollapseAllAction;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ExpandAllAction;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.RemoveDynamicAction;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DItemElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DMethodElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DNamedElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DPropertyElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DRootElement;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;

public final class DynamicToolWindowWrapper {
    private static final Logger LOG = Logger.getInstance(DynamicToolWindowWrapper.class);
    private static final int CLASS_OR_ELEMENT_NAME_COLUMN = 0;
    private static final int TYPE_COLUMN = 1;
    private static final @NlsContexts.ColumnName String[] myColumnNames = new String[]{GroovyBundle.message("dynamic.members.column.name.element", new Object[0]), GroovyBundle.message("dynamic.members.column.name.type", new Object[0])};
    private final Project myProject;
    private ToolWindow myToolWindow = null;
    private JPanel myTreeTablePanel;
    private SimpleToolWindowPanel myBigPanel;
    private ListTreeTableModelOnColumns myTreeTableModel;
    private MyTreeTable myTreeTable;

    public DynamicToolWindowWrapper(Project project) {
        this.myProject = project;
    }

    public static DynamicToolWindowWrapper getInstance(Project project) {
        return (DynamicToolWindowWrapper)project.getService(DynamicToolWindowWrapper.class);
    }

    public TreeTable getTreeTable() {
        this.getToolWindow();
        return this.myTreeTable;
    }

    public ToolWindow getToolWindow() {
        if (this.myToolWindow == null) {
            this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(GroovyBundle.message("dynamic.tool.window.id", new Object[0]), false, ToolWindowAnchor.RIGHT);
            this.myToolWindow.setIcon(JetgroovyIcons.Groovy.Groovy_13x13);
            JPanel panel = this.buildBigPanel();
            ContentManager contentManager = this.myToolWindow.getContentManager();
            Content content = contentManager.getFactory().createContent((JComponent)panel, "", false);
            content.setPreferredFocusableComponent((JComponent)((Object)this.myTreeTable));
            contentManager.addContent(content);
        }
        return this.myToolWindow;
    }

    private JPanel buildBigPanel() {
        this.myBigPanel = new SimpleToolWindowPanel(true);
        this.myBigPanel.setBackground(UIUtil.getFieldForegroundColor());
        JPanel panel = new JPanel(new BorderLayout());
        this.myBigPanel.add((Component)panel, (Object)"Center");
        this.myTreeTablePanel = new JPanel(new BorderLayout());
        this.rebuildTreePanel();
        panel.add(this.myTreeTablePanel);
        this.myBigPanel.setPreferredSize(new Dimension(200, this.myBigPanel.getHeight()));
        this.myBigPanel.setToolbar(DynamicToolWindowWrapper.createToolbar().getComponent());
        this.myBigPanel.revalidate();
        return this.myBigPanel;
    }

    private static ActionToolbar createToolbar() {
        return ActionManager.getInstance().createActionToolbar("Groovy.Dynamic.Toolbar", DynamicToolWindowWrapper.createActions(), true);
    }

    private static ActionGroup createActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RemoveDynamicAction());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new ExpandAllAction());
        group.add((AnAction)new CollapseAllAction());
        return group;
    }

    public void rebuildTreePanel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.buildTree(rootNode);
        this.rebuildTreeView(rootNode, false);
    }

    private void rebuildTreeView(DefaultMutableTreeNode root, boolean expandAll) {
        this.myTreeTablePanel.removeAll();
        JScrollPane treeTable = this.createTable(root);
        if (expandAll) {
            TreeUtil.expandAll((JTree)this.myTreeTable.getTree());
        }
        this.myTreeTablePanel.add(treeTable);
        this.myTreeTablePanel.revalidate();
    }

    private DefaultMutableTreeNode buildTree(DefaultMutableTreeNode rootNode) {
        Collection<DClassElement> containingClasses = DynamicManager.getInstance(this.myProject).getAllContainingClasses();
        for (DClassElement containingClassElement : containingClasses) {
            DefaultMutableTreeNode containingClassNode = new DefaultMutableTreeNode(containingClassElement);
            Collection<DPropertyElement> properties = DynamicManager.getInstance(this.myProject).findDynamicPropertiesOfClass(containingClassElement.getName());
            for (DPropertyElement property : properties) {
                DefaultMutableTreeNode propertyTreeNode = new DefaultMutableTreeNode(property);
                containingClassNode.add(propertyTreeNode);
            }
            Set<DMethodElement> methods = containingClassElement.getMethods();
            for (DMethodElement methodElement : methods) {
                String[] psiTypes = QuickfixUtil.getArgumentsTypes(methodElement.getPairs());
                DMethodElement method = DynamicManager.getInstance(this.myProject).findConcreteDynamicMethod(containingClassElement.getName(), methodElement.getName(), psiTypes);
                DefaultMutableTreeNode methodTreeNode = new DefaultMutableTreeNode(method);
                containingClassNode.add(methodTreeNode);
            }
            rootNode.add(containingClassNode);
        }
        return rootNode;
    }

    private JScrollPane createTable(final MutableTreeNode myTreeRoot) {
        ColumnInfo[] columnInfos = new ColumnInfo[]{new ClassColumnInfo(), new PropertyTypeColumnInfo()};
        this.myTreeTableModel = new ListTreeTableModelOnColumns((TreeNode)myTreeRoot, columnInfos);
        this.myTreeTable = new MyTreeTable((TreeTableModel)this.myTreeTableModel);
        TreeTableSpeedSearch.installOn((TreeTable)this.myTreeTable, o -> {
            Object object;
            Object node = o.getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)node).getUserObject()) instanceof DNamedElement) {
                return ((DNamedElement)object).getName();
            }
            return "";
        });
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTreeTable), (ActionGroup)new DefaultActionGroup(new AnAction[]{new RemoveDynamicAction()}), (String)"DynamicToolWindowWrapperPopup");
        MyColoredTreeCellRenderer treeCellRenderer = new MyColoredTreeCellRenderer();
        this.myTreeTable.setDefaultRenderer(String.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value2 instanceof String) {
                    try {
                        PsiType type2 = JavaPsiFacade.getElementFactory((Project)DynamicToolWindowWrapper.this.myProject).createTypeFromText((String)value2, null);
                        String shortName = type2.getPresentableText();
                        return new JLabel(shortName);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.debug("Type cannot be created", (Throwable)e);
                        return new JLabel(QuickfixUtil.shortenType((String)value2));
                    }
                }
                return new JLabel();
            }
        });
        this.myTreeTable.setTreeCellRenderer((TreeCellRenderer)((Object)treeCellRenderer));
        this.myTreeTable.setRootVisible(false);
        this.myTreeTable.setSelectionMode(2);
        MyPropertyTypeCellEditor typeCellEditor = new MyPropertyTypeCellEditor();
        typeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DItemElement dynamicElement;
                Object editingClassObject;
                Object oldTypeValue;
                String newTypeValue;
                block12: {
                    block11: {
                        TreeTableTree tree = DynamicToolWindowWrapper.this.getTree();
                        newTypeValue = ((MyPropertyTypeCellEditor)((Object)e.getSource())).getCellEditorValue();
                        if (tree == null) {
                            DynamicToolWindowWrapper.this.myTreeTable.editingStopped(e);
                            return;
                        }
                        try {
                            PsiType type2 = JavaPsiFacade.getElementFactory((Project)DynamicToolWindowWrapper.this.myProject).createTypeFromText(newTypeValue, null);
                            newTypeValue = type2.getCanonicalText();
                        }
                        catch (IncorrectOperationException type2) {
                            // empty catch block
                        }
                        TreePath editingTypePath = tree.getSelectionPath();
                        if (editingTypePath == null) {
                            return;
                        }
                        TreePath editingClassPath = editingTypePath.getParentPath();
                        oldTypeValue = DynamicToolWindowWrapper.this.myTreeTable.getValueAt(tree.getRowForPath(editingTypePath), 1);
                        if (!(oldTypeValue instanceof String)) {
                            DynamicToolWindowWrapper.this.myTreeTable.editingStopped(e);
                            return;
                        }
                        Object editingPropertyObject = DynamicToolWindowWrapper.this.myTreeTable.getValueAt(tree.getRowForPath(editingTypePath), 0);
                        editingClassObject = DynamicToolWindowWrapper.this.myTreeTable.getValueAt(tree.getRowForPath(editingClassPath), 0);
                        if (!(editingPropertyObject instanceof DItemElement)) break block11;
                        dynamicElement = (DItemElement)editingPropertyObject;
                        if (editingClassObject instanceof DClassElement) break block12;
                    }
                    DynamicToolWindowWrapper.this.myTreeTable.editingStopped(e);
                    return;
                }
                String name = dynamicElement.getName();
                String className = ((DClassElement)editingClassObject).getName();
                if (dynamicElement instanceof DPropertyElement) {
                    DynamicManager.getInstance(DynamicToolWindowWrapper.this.myProject).replaceDynamicPropertyType(className, name, (String)oldTypeValue, newTypeValue);
                } else if (dynamicElement instanceof DMethodElement) {
                    List<ParamInfo> myPairList = ((DMethodElement)dynamicElement).getPairs();
                    DynamicManager.getInstance(DynamicToolWindowWrapper.this.myProject).replaceDynamicMethodType(className, name, myPairList, (String)oldTypeValue, newTypeValue);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DynamicToolWindowWrapper.this.myTreeTable.editingCanceled(e);
            }
        });
        RefactoringListenerManager.getInstance((Project)this.myProject).addListenerProvider(new RefactoringElementListenerProvider(){

            @Nullable
            public RefactoringElementListener getListener(PsiElement element) {
                if (element instanceof PsiClass) {
                    final String qualifiedName = ((PsiClass)element).getQualifiedName();
                    return new RefactoringElementListener(){

                        public void elementMoved(@NotNull PsiElement newElement) {
                            if (newElement == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.renameElement(qualifiedName, newElement);
                        }

                        public void elementRenamed(@NotNull PsiElement newElement) {
                            if (newElement == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            this.renameElement(qualifiedName, newElement);
                        }

                        private void renameElement(String oldClassName, PsiElement newElement) {
                            if (newElement instanceof PsiClass) {
                                String newClassName = ((PsiClass)newElement).getQualifiedName();
                                DRootElement rootElement = DynamicManager.getInstance(DynamicToolWindowWrapper.this.myProject).getRootElement();
                                DClassElement oldClassElement = rootElement.getClassElement(oldClassName);
                                DefaultMutableTreeNode oldClassNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)myTreeRoot), (Object)oldClassElement);
                                DynamicManager.getInstance(DynamicToolWindowWrapper.this.myProject).replaceClassName(oldClassElement, newClassName);
                                DynamicToolWindowWrapper.this.myTreeTableModel.nodeChanged((TreeNode)oldClassNode);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "newElement";
                            objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicToolWindowWrapper$3$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "elementMoved";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "elementRenamed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                }
                return null;
            }
        });
        this.myTreeTable.setDefaultEditor(String.class, (TableCellEditor)((Object)typeCellEditor));
        this.myTreeTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectionRow = DynamicToolWindowWrapper.this.myTreeTable.getTree().getLeadSelectionRow();
                DynamicToolWindowWrapper.this.myTreeTable.editCellAt(selectionRow, 0, event);
            }
        }, KeyStroke.getKeyStroke(113, 0), 0);
        this.myTreeTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectionRow = DynamicToolWindowWrapper.this.myTreeTable.getTree().getLeadSelectionRow();
                DynamicToolWindowWrapper.this.myTreeTable.editCellAt(selectionRow, 1, event);
            }
        }, KeyStroke.getKeyStroke(113, 2), 0);
        this.myTreeTable.getTree().setShowsRootHandles(true);
        this.myTreeTable.getTableHeader().setReorderingAllowed(false);
        this.myTreeTable.setVisibleRowCount(10);
        this.myTreeTable.getColumn(myColumnNames[0]).setPreferredWidth(200);
        this.myTreeTable.getColumn(myColumnNames[1]).setPreferredWidth(160);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        return scrollPane;
    }

    void deleteRow() {
        boolean isShowDialog = true;
        int rowsCount = this.myTreeTable.getSelectedRows().length;
        int i2 = 0;
        TreePath[] paths = this.myTreeTable.getTree().getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath selectionPath : paths) {
            boolean removeClass;
            Object classRow;
            if (rowsCount > 1) {
                isShowDialog = false;
            }
            if (i2 == 0) {
                isShowDialog = true;
            }
            ++i2;
            TreePath parent2 = selectionPath.getParentPath();
            if (parent2.getParentPath() == null) {
                classRow = selectionPath.getLastPathComponent();
                if (!(classRow instanceof DefaultMutableTreeNode)) {
                    return;
                }
                if (this.removeClass((DefaultMutableTreeNode)classRow, isShowDialog, rowsCount)) continue;
                return;
            }
            classRow = parent2.getLastPathComponent();
            Object dynamicRow = selectionPath.getLastPathComponent();
            if (!(classRow instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode classNode = (DefaultMutableTreeNode)classRow;
            if (!(dynamicRow instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode dynamicItemNode = (DefaultMutableTreeNode)dynamicRow;
            boolean bl = removeClass = classNode.getChildCount() == 1;
            if (!this.removeDynamicElement(dynamicItemNode, isShowDialog, rowsCount)) {
                return;
            }
            if (!removeClass) continue;
            this.removeNamedElement((DNamedElement)classNode.getUserObject());
        }
        DynamicManager.getInstance(this.myProject).fireChange();
    }

    private boolean removeClass(DefaultMutableTreeNode classNode, boolean isShowDialog, int rowsCount) {
        TreeNode rootObject = classNode.getParent();
        return rootObject instanceof DefaultMutableTreeNode && this.removeDynamicElement(classNode, isShowDialog, rowsCount);
    }

    private boolean removeDynamicElement(DefaultMutableTreeNode child, boolean isShowDialog, int rowsCount) {
        int result2;
        Object namedElement = child.getUserObject();
        if (!(namedElement instanceof DNamedElement)) {
            return false;
        }
        if (isShowDialog && (result2 = rowsCount > 1 ? Messages.showOkCancelDialog((Component)this.myBigPanel, (String)GroovyBundle.message("are.you.sure.to.delete.elements", String.valueOf(rowsCount)), (String)GroovyBundle.message("dynamic.element.deletion", new Object[0]), (Icon)Messages.getQuestionIcon()) : Messages.showOkCancelDialog((Component)this.myBigPanel, (String)GroovyBundle.message("are.you.sure.to.delete.dynamic.property", ((DNamedElement)namedElement).getName()), (String)GroovyBundle.message("dynamic.property.deletion", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return false;
        }
        this.removeNamedElement((DNamedElement)namedElement);
        return true;
    }

    private void removeNamedElement(DNamedElement namedElement) {
        if (namedElement instanceof DClassElement) {
            DynamicManager.getInstance(this.myProject).removeClassElement((DClassElement)namedElement);
        } else if (namedElement instanceof DItemElement) {
            DynamicManager.getInstance(this.myProject).removeItemElement((DItemElement)namedElement);
        }
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        TreeTableTree tree = this.myTreeTable.getTree();
        TreePath path = new TreePath(node.getPath());
        tree.expandPath(path.getParentPath());
        int row = tree.getRowForPath(path);
        this.myTreeTable.getSelectionModel().setSelectionInterval(row, row);
        this.myTreeTable.scrollRectToVisible(this.myTreeTable.getCellRect(row, 0, true));
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)this.myTreeTable), true);
    }

    public void removeFromParent(DefaultMutableTreeNode parent2, DefaultMutableTreeNode child) {
        int idx = this.myTreeTableModel.getIndexOfChild((Object)parent2, (Object)child);
        child.removeFromParent();
        this.myTreeTableModel.nodesWereRemoved((TreeNode)parent2, new int[]{idx}, (Object[])new TreeNode[]{child});
    }

    @Nullable
    private TreeTableTree getTree() {
        return this.myTreeTable != null ? this.myTreeTable.getTree() : null;
    }

    public ListTreeTableModelOnColumns getTreeTableModel() {
        this.getToolWindow();
        return this.myTreeTableModel;
    }

    private class MyTreeTable
    extends TreeTable
    implements DataProvider {
        MyTreeTable(TreeTableModel treeTableModel) {
            super(treeTableModel);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyTreeTable.$$$reportNull$$$0(0);
            }
            if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
                TreePath path = this.getTree().getSelectionPath();
                return path == null ? null : slowId -> this.getSlowData(slowId, path);
            }
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                return new DeleteProvider(){

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                        if (actionUpdateThread == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return actionUpdateThread;
                    }

                    public void deleteElement(@NotNull DataContext dataContext) {
                        if (dataContext == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        DynamicToolWindowWrapper.this.deleteRow();
                    }

                    public boolean canDeleteElement(@NotNull DataContext dataContext) {
                        if (dataContext == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return DynamicToolWindowWrapper.this.myTreeTable.getTree().getSelectionPaths() != null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1, 2 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicToolWindowWrapper$MyTreeTable$1";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "dataContext";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionUpdateThread";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicToolWindowWrapper$MyTreeTable$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "deleteElement";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "canDeleteElement";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1, 2 -> new IllegalArgumentException(string);
                        };
                    }
                };
            }
            return null;
        }

        @Nullable
        private Object getSlowData(@NotNull String dataId, @NotNull TreePath path) {
            if (dataId == null) {
                MyTreeTable.$$$reportNull$$$0(1);
            }
            if (path == null) {
                MyTreeTable.$$$reportNull$$$0(2);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return this.getElementFromPath(path);
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                PsiElement element = this.getElementFromPath(path);
                return element == null ? null : element.getContainingFile();
            }
            return null;
        }

        @Nullable
        private PsiElement getElementFromPath(@NotNull TreePath path) {
            Object selectedObject;
            if (path == null) {
                MyTreeTable.$$$reportNull$$$0(3);
            }
            if (!((selectedObject = path.getLastPathComponent()) instanceof DefaultMutableTreeNode)) {
                return null;
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectedObject;
            Object userObject = selectedNode.getUserObject();
            if (!(userObject instanceof DNamedElement)) {
                return null;
            }
            if (userObject instanceof DClassElement) {
                DClassElement classElement = (DClassElement)userObject;
                try {
                    PsiType type2 = JavaPsiFacade.getElementFactory((Project)DynamicToolWindowWrapper.this.myProject).createTypeFromText(classElement.getName(), null);
                    if (type2 instanceof PsiPrimitiveType) {
                        type2 = ((PsiPrimitiveType)type2).getBoxedType(PsiManager.getInstance((Project)DynamicToolWindowWrapper.this.myProject), GlobalSearchScope.allScope((Project)DynamicToolWindowWrapper.this.myProject));
                    }
                    if (!(type2 instanceof PsiClassType)) {
                        return null;
                    }
                    return ((PsiClassType)type2).resolve();
                }
                catch (IncorrectOperationException e) {
                    return null;
                }
            }
            if (userObject instanceof DItemElement) {
                DItemElement itemElement = (DItemElement)userObject;
                TreeNode parentNode = selectedNode.getParent();
                if (!(parentNode instanceof DefaultMutableTreeNode)) {
                    return null;
                }
                Object classObject = ((DefaultMutableTreeNode)parentNode).getUserObject();
                if (!(classObject instanceof DClassElement)) {
                    return null;
                }
                String className = ((DClassElement)classObject).getName();
                return itemElement.getPsi(PsiManager.getInstance((Project)DynamicToolWindowWrapper.this.myProject), className);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicToolWindowWrapper$MyTreeTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSlowData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementFromPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, DNamedElement> {
        ClassColumnInfo() {
            super(GroovyBundle.message("dynamic.members.column.name.element", new Object[0]));
        }

        public boolean isCellEditable(DefaultMutableTreeNode treeNode) {
            Object userObject = treeNode.getUserObject();
            return userObject instanceof DPropertyElement;
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }

        public DNamedElement valueOf(DefaultMutableTreeNode treeNode) {
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof DClassElement) {
                return (DClassElement)userObject;
            }
            if (userObject instanceof DPropertyElement) {
                return (DPropertyElement)userObject;
            }
            if (userObject instanceof DMethodElement) {
                return (DMethodElement)userObject;
            }
            return null;
        }
    }

    private static class PropertyTypeColumnInfo
    extends ColumnInfo<DefaultMutableTreeNode, String> {
        PropertyTypeColumnInfo() {
            super(GroovyBundle.message("dynamic.members.column.name.type", new Object[0]));
        }

        public boolean isCellEditable(DefaultMutableTreeNode node) {
            Object value2 = node.getUserObject();
            return !(value2 instanceof DClassElement);
        }

        public String valueOf(DefaultMutableTreeNode treeNode) {
            Object userObject = treeNode.getUserObject();
            if (userObject instanceof DItemElement) {
                return ((DItemElement)userObject).getType();
            }
            return null;
        }
    }

    private static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(0);
            }
            value2 = ((DefaultMutableTreeNode)value2).getUserObject();
            this.setPaintFocusBorder(false);
            if (!(value2 instanceof DNamedElement)) {
                return;
            }
            if (value2 instanceof DClassElement) {
                String containingClassName = ((DClassElement)value2).getName();
                String classShortName = QuickfixUtil.shortenType(containingClassName);
                this.append(classShortName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            if (value2 instanceof DItemElement) {
                DItemElement itemElement = (DItemElement)value2;
                String name = itemElement.getName();
                this.appendName(name);
                if (value2 instanceof DMethodElement) {
                    this.appendMethodParameters((DMethodElement)value2);
                }
            }
        }

        private void appendName(@NlsContexts.Label String name) {
            this.append(name, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        }

        private void appendMethodParameters(DMethodElement value2) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("(");
            String[] types = MyColoredTreeCellRenderer.mapToUnqualified(QuickfixUtil.getArgumentsNames(value2.getPairs()));
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (i2 != 0) {
                    buffer.append(", ");
                }
                String type2 = types[i2];
                buffer.append(type2);
            }
            buffer.append(")");
            this.append(buffer.toString(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        }

        private static String[] mapToUnqualified(String[] argumentsNames) {
            return (String[])ContainerUtil.map2Array((Object[])argumentsNames, String.class, (Function)((NullableFunction)s -> {
                if (s == null) {
                    return null;
                }
                int index = s.lastIndexOf(".");
                if (index > 0 && index < s.length() - 1) {
                    return s.substring(index + 1);
                }
                return s;
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicToolWindowWrapper$MyColoredTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private class MyPropertyTypeCellEditor
    extends AbstractTableCellEditor {
        final EditorTextField field;

        MyPropertyTypeCellEditor() {
            Document document = PsiDocumentManager.getInstance((Project)DynamicToolWindowWrapper.this.myProject).getDocument((PsiFile)new GroovyCodeFragment(DynamicToolWindowWrapper.this.myProject, ""));
            this.field = new EditorTextField(document, DynamicToolWindowWrapper.this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        }

        public String getCellEditorValue() {
            return this.field.getText();
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            if (value2 instanceof String) {
                this.field.setText((String)value2);
            }
            return this.field;
        }
    }
}

