/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;

public abstract class GrDocCommentUtil {
    @Nullable
    public static GrDocCommentOwner findDocOwner(GroovyDocPsiElement docElement) {
        GrMember[] members;
        GroovyDocPsiElement element;
        for (element = docElement; element != null && element.getParent() instanceof GroovyDocPsiElement; element = element.getParent()) {
        }
        if (element == null) {
            return null;
        }
        if ((element = GrDocCommentUtil.skipWhiteSpacesAndStopOnDoc(element, true)) instanceof GrDocCommentOwner) {
            return (GrDocCommentOwner)((Object)element);
        }
        if (element instanceof GrMembersDeclaration && (members = ((GrMembersDeclaration)((Object)element)).getMembers()).length > 0 && members[0] instanceof GrDocCommentOwner) {
            return (GrDocCommentOwner)((Object)members[0]);
        }
        return null;
    }

    @Nullable
    public static GrDocComment findDocComment(GrDocCommentOwner owner) {
        if (owner.getFirstChild() instanceof GrDocComment) {
            return (GrDocComment)owner.getFirstChild();
        }
        GrDocCommentOwner element = owner instanceof GrVariable && owner.getParent() instanceof GrVariableDeclaration ? owner.getParent() : owner;
        if ((element = GrDocCommentUtil.skipWhiteSpacesAndStopOnDoc(element, false)) instanceof GrDocComment) {
            return (GrDocComment)((Object)element);
        }
        return null;
    }

    private static PsiElement skipWhiteSpacesAndStopOnDoc(PsiElement element, boolean forward) {
        ASTNode node;
        do {
            PsiElement psiElement = element = forward ? element.getNextSibling() : element.getPrevSibling();
        } while (element != null && (node = element.getNode()) != null && !GroovyDocElementTypes.GROOVY_DOC_COMMENT.equals(node.getElementType()) && TokenSets.WHITE_SPACES_OR_COMMENTS.contains(node.getElementType()));
        return element;
    }

    public static GrDocComment setDocComment(@NotNull GrDocCommentOwner owner, @Nullable GrDocComment comment) {
        GrDocComment docComment;
        if (owner == null) {
            GrDocCommentUtil.$$$reportNull$$$0(0);
        }
        if ((docComment = owner.getDocComment()) != null) {
            if (comment == null) {
                docComment.delete();
                return null;
            }
            PsiElement added = docComment.replace(comment);
            assert (added instanceof GrDocComment);
            return (GrDocComment)added;
        }
        if (comment == null) {
            return null;
        }
        PsiElement parent2 = owner.getParent();
        ASTNode node = owner.getNode();
        parent2.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n ", node);
        PsiElement added = parent2.addBefore((PsiElement)comment, (PsiElement)owner);
        assert (added instanceof GrDocComment);
        return (GrDocComment)added;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocCommentUtil", "setDocComment"));
    }
}

