/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.jb;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.startup.importSettings.ImportSettingsBundle;
import com.intellij.ide.startup.importSettings.StartupImportIcons;
import com.intellij.ide.startup.importSettings.data.DataForSave;
import com.intellij.ide.startup.importSettings.data.DialogImportData;
import com.intellij.ide.startup.importSettings.data.IconProductSize;
import com.intellij.ide.startup.importSettings.data.JbService;
import com.intellij.ide.startup.importSettings.data.Product;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.jb.JbChildSetting;
import com.intellij.ide.startup.importSettings.jb.JbImportServiceImpl;
import com.intellij.ide.startup.importSettings.jb.JbProductInfo;
import com.intellij.ide.startup.importSettings.jb.JbSettingsCategory;
import com.intellij.ide.startup.importSettings.jb.JbSettingsCategoryConfigurable;
import com.intellij.ide.startup.importSettings.jb.JbSettingsImporter;
import com.intellij.ide.startup.importSettings.jb.NameMappings;
import com.intellij.ide.startup.importSettings.transfer.TransferSettingsProgress;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl;", "Lcom/intellij/ide/startup/importSettings/data/JbService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "productsLazy", "Lkotlin/Lazy;", "", "", "Lcom/intellij/ide/startup/importSettings/jb/JbProductInfo;", "doListProducts", "filterProducts", "", "Lcom/intellij/ide/startup/importSettings/data/Product;", "old", "", "getOldProducts", "getProductIcon", "Ljavax/swing/Icon;", "itemId", "size", "Lcom/intellij/ide/startup/importSettings/data/IconProductSize;", "getSettings", "Lcom/intellij/ide/startup/importSettings/jb/JbSettingsCategory;", "importSettings", "Lcom/intellij/ide/startup/importSettings/data/DialogImportData;", "productId", "saveDataList", "Lcom/intellij/ide/startup/importSettings/data/DataForSave;", "products", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nJbImportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,301:1\n766#2:302\n857#2,2:303\n766#2:305\n857#2,2:306\n10#3:308\n*S KotlinDebug\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl\n*L\n124#1:302\n124#1:303,2\n129#1:305\n129#1:306,2\n268#1:308\n*E\n"})
public final class JbImportServiceImpl
implements JbService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Lazy<Map<String, JbProductInfo>> productsLazy;
    @NotNull
    private static final Logger LOG;
    private static final Pattern IDE_NAME_PATTERN;
    @NotNull
    private static final JbSettingsCategory UI_CATEGORY;
    @NotNull
    private static final JbSettingsCategory KEYMAP_CATEGORY;
    @NotNull
    private static final JbSettingsCategory CODE_CATEGORY;
    @NotNull
    private static final JbSettingsCategory TOOLS_CATEGORY;
    @NotNull
    private static final JbSettingsCategory SYSTEM_CATEGORY;
    @NotNull
    private static final Map<String, JbSettingsCategory> DEFAULT_SETTINGS_CATEGORIES;

    public JbImportServiceImpl(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.productsLazy = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends JbProductInfo>>(this){
            final /* synthetic */ JbImportServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, JbProductInfo> invoke() {
                return JbImportServiceImpl.access$doListProducts(this.this$0);
            }
        }));
    }

    @Override
    @NotNull
    public List<Product> getOldProducts() {
        return this.filterProducts(true);
    }

    @Override
    @NotNull
    public List<Product> products() {
        return this.filterProducts(false);
    }

    private final List<Product> filterProducts(boolean old) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object version;
        List products = CollectionsKt.toList((Iterable)((Map)this.productsLazy.getValue()).values());
        HashMap newProducts = new HashMap();
        for (JbProductInfo product : products) {
            if (ConfigImportHelper.isConfigOld((FileTime)product.getLastUsageTime()) || (version = (String)newProducts.get(product.getCodeName$intellij_ide_startup_importSettings())) != null && ((String)version).compareTo(product.getVersion()) >= 0) continue;
            ((Map)newProducts).put(product.getCodeName$intellij_ide_startup_importSettings(), product.getVersion());
        }
        if (old) {
            $this$filter$iv = products;
            boolean $i$f$filter = false;
            version = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                JbProductInfo it = (JbProductInfo)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(newProducts.get(it.getCodeName$intellij_ide_startup_importSettings()), (Object)it.getVersion()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        $this$filter$iv = products;
        boolean $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JbProductInfo it = (JbProductInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(newProducts.get(it.getCodeName$intellij_ide_startup_importSettings()), (Object)it.getVersion())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, JbProductInfo> doListProducts() {
        HashMap retval = new HashMap();
        Path parentDir = Path.of(PathManager.getDefaultConfigPathFor((String)""), new String[0]);
        DescriptorListLoadingContext context2 = new DescriptorListLoadingContext(Collections.emptySet(), null, MapsKt.emptyMap(), (Function0)doListProducts.context.1.INSTANCE, false, false, false, false, 242, null);
        Intrinsics.checkNotNull((Object)parentDir);
        for (Path confDir : PathsKt.listDirectoryEntries$default((Path)parentDir, null, (int)1, null)) {
            Path optionsDir;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(confDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            LOG.info("Found " + PathsKt.getName((Path)confDir) + " under " + ((Object)parentDir).toString());
            Path pluginsDir = Path.of(PathManager.getDefaultPluginPathFor((String)PathsKt.getName((Path)confDir)), new String[0]);
            String dirName = PathsKt.getName((Path)confDir);
            Matcher matcher = IDE_NAME_PATTERN.matcher(dirName);
            if (!matcher.matches()) {
                LOG.info(PathsKt.getName((Path)confDir) + " doesn't match IDE_NAME_PATTERN, skipping it");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)confDir.resolve("options"), (String)"this.resolve(other)");
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(optionsDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                LOG.info(PathsKt.getName((Path)confDir) + " doesn't contain options directory, skipping it");
                continue;
            }
            List optionsEntries = PathsKt.listDirectoryEntries((Path)optionsDir, (String)"*.xml");
            if (optionsEntries.isEmpty()) {
                LOG.info(PathsKt.getName((Path)confDir) + "/options has no xml files, skipping it");
                continue;
            }
            FileTime lastModified = FileTime.fromMillis(0L);
            for (Path optionXml : optionsEntries) {
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(optionXml, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(this, *options)");
                if (fileTime.compareTo(lastModified) <= 0) continue;
                LinkOption[] linkOptionArray4 = new LinkOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.getLastModifiedTime(optionXml, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)), (String)"getLastModifiedTime(this, *options)");
            }
            LOG.info(PathsKt.getName((Path)confDir) + "/options' newest file is dated " + lastModified);
            String ideName = matcher.group(1);
            String ideVersion = matcher.group(2);
            Intrinsics.checkNotNull((Object)ideName);
            String fullName = NameMappings.INSTANCE.getFullName(ideName) + " " + ideVersion;
            Intrinsics.checkNotNull((Object)ideVersion);
            FileTime fileTime = lastModified;
            Intrinsics.checkNotNull((Object)fileTime);
            Intrinsics.checkNotNull((Object)pluginsDir);
            JbProductInfo jbProductInfo = new JbProductInfo(ideVersion, fileTime, dirName, fullName, ideName, confDir, pluginsDir);
            jbProductInfo.prefetchPluginDescriptors$intellij_ide_startup_importSettings(this.coroutineScope, context2);
            ((Map)retval).put(dirName, jbProductInfo);
        }
        return retval;
    }

    @NotNull
    public List<JbSettingsCategory> getSettings(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        LOG.info("User has selected " + itemId);
        JbProductInfo jbProductInfo = (JbProductInfo)((Map)this.productsLazy.getValue()).get(itemId);
        if (jbProductInfo == null) {
            throw new IllegalStateException("Can't find product".toString());
        }
        JbProductInfo productInfo = jbProductInfo;
        ArrayList<JbChildSetting> plugins = new ArrayList<JbChildSetting>();
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (IdeaPluginDescriptorImpl descriptor : productInfo.getPluginsDescriptors()) {
            String string = descriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
            plugins.add(new JbChildSetting(string, descriptor.getName()));
            pluginNames.add(descriptor.getName());
        }
        LOG.info("Found " + pluginNames.size() + " custom plugins: " + CollectionsKt.joinToString$default((Iterable)pluginNames, null, null, null, (int)0, null, null, (int)63, null));
        Icon icon = StartupImportIcons.Icons.Plugin;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Plugin");
        JbSettingsCategoryConfigurable pluginsCategory = new JbSettingsCategoryConfigurable(SettingsCategory.PLUGINS, icon, ImportSettingsBundle.INSTANCE.message("settings.category.plugins.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.plugins.description", new Object[0]), CollectionsKt.listOf(plugins));
        Object[] objectArray = new JbSettingsCategory[]{UI_CATEGORY, KEYMAP_CATEGORY, CODE_CATEGORY, pluginsCategory, TOOLS_CATEGORY, SYSTEM_CATEGORY};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public Icon getProductIcon(@NotNull String itemId, @NotNull IconProductSize size2) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)((Object)size2), (String)"size");
        JbProductInfo jbProductInfo = (JbProductInfo)((Map)this.productsLazy.getValue()).get(itemId);
        if (jbProductInfo == null) {
            throw new IllegalStateException("Can't find product".toString());
        }
        JbProductInfo productInfo = jbProductInfo;
        return NameMappings.INSTANCE.getIcon(productInfo.getCodeName$intellij_ide_startup_importSettings(), size2);
    }

    @Override
    @NotNull
    public DialogImportData importSettings(@NotNull String productId, @NotNull List<DataForSave> saveDataList) {
        Intrinsics.checkNotNullParameter((Object)productId, (String)"productId");
        Intrinsics.checkNotNullParameter(saveDataList, (String)"saveDataList");
        JbProductInfo jbProductInfo = (JbProductInfo)((Map)this.productsLazy.getValue()).get(productId);
        if (jbProductInfo == null) {
            throw new IllegalStateException("Can't find product".toString());
        }
        JbProductInfo productInfo = jbProductInfo;
        Set filteredCategories = new LinkedHashSet();
        Ref.ObjectRef plugins2import = new Ref.ObjectRef();
        for (DataForSave data2 : saveDataList) {
            JbSettingsCategory category;
            if (Intrinsics.areEqual((Object)data2.getId(), (Object)SettingsCategory.PLUGINS.name())) {
                filteredCategories.add(SettingsCategory.PLUGINS);
                plugins2import.element = data2.getChildIds();
                List list = (List)plugins2import.element;
                List list2 = (List)plugins2import.element;
                LOG.info("Will import " + (list != null ? Integer.valueOf(list.size()) : null) + " custom plugins: " + (list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, null, (int)63, null) : null));
                continue;
            }
            if (DEFAULT_SETTINGS_CATEGORIES.get(data2.getId()) == null) continue;
            filteredCategories.add(category.getSettingsCategory());
        }
        LOG.info("Will import the following categories: " + CollectionsKt.joinToString$default((Iterable)filteredCategories, null, null, null, (int)0, null, null, (int)63, null));
        TransferSettingsProgress importData = new TransferSettingsProgress(productInfo);
        JbSettingsImporter importer = new JbSettingsImporter(productInfo.getConfigDirPath(), productInfo.getPluginsDirPath());
        ProgressIndicator progressIndicator = importData.createProgressIndicatorAdapter();
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        ModalityState modalityState2 = modalityState;
        long startTime = System.currentTimeMillis();
        BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState2), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressIndicator, importer, (Set<SettingsCategory>)filteredCategories, startTime, (Ref.ObjectRef<List<String>>)plugins2import, modalityState2, null){
            int label;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ JbSettingsImporter $importer;
            final /* synthetic */ Set<SettingsCategory> $filteredCategories;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Ref.ObjectRef<List<String>> $plugins2import;
            final /* synthetic */ ModalityState $modalityState;
            {
                this.$progressIndicator = $progressIndicator;
                this.$importer = $importer;
                this.$filteredCategories = $filteredCategories;
                this.$startTime = $startTime;
                this.$plugins2import = $plugins2import;
                this.$modalityState = $modalityState;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$progressIndicator.setText2("Migrating options");
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Starting migration...");
                        this.$importer.importOptions(this.$filteredCategories);
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Options migrated in " + (System.currentTimeMillis() - this.$startTime) + " ms.");
                        this.$progressIndicator.setFraction(0.1);
                        ApplicationManager.getApplication().saveSettings();
                        if (this.$plugins2import.element == null) break;
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Started importing plugins...");
                        long pluginsImportStart = System.currentTimeMillis();
                        this.$importer.installPlugins(this.$progressIndicator, (List)this.$plugins2import.element);
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Plugins imported in " + (System.currentTimeMillis() - pluginsImportStart) + " ms. Migration completed in " + (System.currentTimeMillis() - this.$startTime) + " ms.");
                        JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Calling restart...");
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$modalityState, null){
                            int label;
                            final /* synthetic */ ModalityState $modalityState;
                            {
                                this.$modalityState = $modalityState;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ApplicationManager.getApplication().invokeLater(importSettings.1::invokeSuspend$lambda$0, this.$modalityState);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0() {
                                ApplicationManagerEx.getApplicationEx().restart(true);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                JbImportServiceImpl.Companion.getLOG$intellij_ide_startup_importSettings().info("Migration complete. Showing welcome screen");
                this.label = 2;
                Object object4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                SettingsService.Companion.getInstance().getDoClose().fire((Object)Unit.INSTANCE);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)((Continuation)this));
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return importData;
    }

    public static final /* synthetic */ Map access$doListProducts(JbImportServiceImpl $this) {
        return $this.doListProducts();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JbImportServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IDE_NAME_PATTERN = Pattern.compile("([a-zA-Z]+)(20\\d\\d\\.\\d)");
        Icon icon = StartupImportIcons.Icons.ColorPicker;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ColorPicker");
        UI_CATEGORY = new JbSettingsCategory(SettingsCategory.UI, icon, ImportSettingsBundle.INSTANCE.message("settings.category.ui.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.ui.description", new Object[0]));
        Icon icon2 = StartupImportIcons.Icons.Keyboard;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Keyboard");
        KEYMAP_CATEGORY = new JbSettingsCategory(SettingsCategory.KEYMAP, icon2, ImportSettingsBundle.INSTANCE.message("settings.category.keymap.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.keymap.description", new Object[0]));
        Icon icon3 = StartupImportIcons.Icons.Json;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Json");
        CODE_CATEGORY = new JbSettingsCategory(SettingsCategory.CODE, icon3, ImportSettingsBundle.INSTANCE.message("settings.category.code.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.code.description", new Object[0]));
        Icon icon4 = StartupImportIcons.Icons.Build;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Build");
        TOOLS_CATEGORY = new JbSettingsCategory(SettingsCategory.TOOLS, icon4, ImportSettingsBundle.INSTANCE.message("settings.category.tools.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.tools.description", new Object[0]));
        Icon icon5 = StartupImportIcons.Icons.Settings;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Settings");
        SYSTEM_CATEGORY = new JbSettingsCategory(SettingsCategory.SYSTEM, icon5, ImportSettingsBundle.INSTANCE.message("settings.category.system.name", new Object[0]), ImportSettingsBundle.INSTANCE.message("settings.category.system.description", new Object[0]));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SettingsCategory.UI.name(), (Object)UI_CATEGORY), TuplesKt.to((Object)SettingsCategory.KEYMAP.name(), (Object)KEYMAP_CATEGORY), TuplesKt.to((Object)SettingsCategory.CODE.name(), (Object)CODE_CATEGORY), TuplesKt.to((Object)SettingsCategory.TOOLS.name(), (Object)TOOLS_CATEGORY), TuplesKt.to((Object)SettingsCategory.SYSTEM.name(), (Object)SYSTEM_CATEGORY)};
        DEFAULT_SETTINGS_CATEGORIES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl$Companion;", "", "()V", "CODE_CATEGORY", "Lcom/intellij/ide/startup/importSettings/jb/JbSettingsCategory;", "DEFAULT_SETTINGS_CATEGORIES", "", "", "getDEFAULT_SETTINGS_CATEGORIES", "()Ljava/util/Map;", "IDE_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KEYMAP_CATEGORY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_ide_startup_importSettings", "()Lcom/intellij/openapi/diagnostic/Logger;", "SYSTEM_CATEGORY", "TOOLS_CATEGORY", "UI_CATEGORY", "getInstance", "Lcom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl;", "intellij.ide.startup.importSettings"})
    @SourceDebugExtension(value={"SMAP\nJbImportServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,301:1\n43#2,3:302\n*S KotlinDebug\n*F\n+ 1 JbImportServiceImpl.kt\ncom/intellij/ide/startup/importSettings/jb/JbImportServiceImpl$Companion\n*L\n270#1:302,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_ide_startup_importSettings() {
            return LOG;
        }

        @NotNull
        public final JbImportServiceImpl getInstance() {
            boolean $i$f$service = false;
            Class<JbImportServiceImpl> serviceClass$iv = JbImportServiceImpl.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (JbImportServiceImpl)object;
        }

        @NotNull
        public final Map<String, JbSettingsCategory> getDEFAULT_SETTINGS_CATEGORIES() {
            return DEFAULT_SETTINGS_CATEGORIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

