/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.notebooks.visualization.ChangesContext;
import org.jetbrains.plugins.notebooks.visualization.DocumentChangedContext;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesEvent;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLinesEventBeforeChange;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointer;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerFactory;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerImpl;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointersEvent;
import org.jetbrains.plugins.notebooks.visualization.RedoContext;
import org.jetbrains.plugins.notebooks.visualization.UndoContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0010\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020 0\u0014j\u0002`!H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020*H\u0016J\u001a\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0018\u0010/\u001a\u00020,2\u0006\u0010#\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020,2\u0006\u0010#\u001a\u00020*2\u0006\u00100\u001a\u000203H\u0002J$\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020(072\f\u00108\u001a\b\u0012\u0004\u0012\u00020(07H\u0002J\"\u00109\u001a\u00020\u001b2\u0010\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020 0\u0014j\u0002`!2\u0006\u0010:\u001a\u00020\u0015H\u0002J\u0010\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020 H\u0002J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020 072\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 07H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010@\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0010\u0010A\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020,H\u0002J\b\u0010B\u001a\u00020CH\u0007J\u0018\u0010D\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020,H\u0002J&\u0010F\u001a\u00020\u001b2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020 \u0018\u00010\u0014j\u0004\u0018\u0001`!2\u0006\u0010G\u001a\u00020HH\u0002J\"\u0010I\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020*2\u0010\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020 0\u0014j\u0002`!H\u0002J\u0016\u0010K\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 07H\u0002J\u0010\u0010L\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020*H\u0002R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006M"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactoryImpl;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactory;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$IntervalListener;", "notebookCellLines", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;", "documentReference", "Lcom/intellij/openapi/command/undo/DocumentReference;", "undoManager", "Lcom/intellij/openapi/command/undo/UndoManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines;Lcom/intellij/openapi/command/undo/DocumentReference;Lcom/intellij/openapi/command/undo/UndoManager;Lcom/intellij/openapi/project/Project;)V", "changeListeners", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactory$ChangeListener;", "getChangeListeners", "()Lcom/intellij/util/EventDispatcher;", "changesContext", "Lorg/jetbrains/plugins/notebooks/visualization/ChangesContext;", "pointers", "Ljava/util/ArrayList;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerImpl;", "Lkotlin/collections/ArrayList;", "validUndoManager", "getValidUndoManager", "()Lcom/intellij/openapi/command/undo/UndoManager;", "applyChanges", "", "changes", "", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactory$Change;", "eventChanges", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEvent$Change;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEventChanges;", "beforeDocumentChange", "event", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLinesEventBeforeChange;", "create", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "documentChanged", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLinesEvent;", "documentChangedByAction", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEvent;", "documentChangedContext", "Lorg/jetbrains/plugins/notebooks/visualization/DocumentChangedContext;", "documentChangedByRedo", "context", "Lorg/jetbrains/plugins/notebooks/visualization/RedoContext;", "documentChangedByUndo", "Lorg/jetbrains/plugins/notebooks/visualization/UndoContext;", "hasSingleIntervalsWithSameTypeAndLanguage", "", "oldIntervals", "", "newIntervals", "invalidatePointer", "ptr", "invertChange", "change", "invertChanges", "makeSnapshot", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEvent$PointerSnapshot;", "modifyPointers", "onUpdated", "pointersCount", "", "safelyUpdate", "listener", "trySwapPointers", "hint", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactory$Swap;", "updateChangedIntervals", "e", "updatePointersByChanges", "updateShiftedIntervals", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookIntervalPointerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookIntervalPointerImpl.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,349:1\n1#2:350\n8#3:351\n8#3:352\n8#3:369\n8#3:374\n1549#4:353\n1620#4,3:354\n1549#4:357\n1620#4,3:358\n1549#4:361\n1620#4,3:362\n1549#4:365\n1620#4,3:366\n1549#4:370\n1620#4,3:371\n*S KotlinDebug\n*F\n+ 1 NotebookIntervalPointerImpl.kt\norg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerFactoryImpl\n*L\n119#1:351\n143#1:352\n303#1:369\n342#1:374\n191#1:353\n191#1:354,3\n239#1:357\n239#1:358,3\n248#1:361\n248#1:362,3\n249#1:365\n249#1:366,3\n321#1:370\n321#1:371,3\n*E\n"})
public final class NotebookIntervalPointerFactoryImpl
implements NotebookIntervalPointerFactory,
NotebookCellLines.IntervalListener {
    @NotNull
    private final NotebookCellLines notebookCellLines;
    @NotNull
    private final DocumentReference documentReference;
    @NotNull
    private final Project project;
    @NotNull
    private final ArrayList<NotebookIntervalPointerImpl> pointers;
    @Nullable
    private ChangesContext changesContext;
    @NotNull
    private final EventDispatcher<NotebookIntervalPointerFactory.ChangeListener> changeListeners;
    @Nullable
    private final UndoManager validUndoManager;

    public NotebookIntervalPointerFactoryImpl(@NotNull NotebookCellLines notebookCellLines, @NotNull DocumentReference documentReference, @Nullable UndoManager undoManager, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)notebookCellLines, (String)"notebookCellLines");
        Intrinsics.checkNotNullParameter((Object)documentReference, (String)"documentReference");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.notebookCellLines = notebookCellLines;
        this.documentReference = documentReference;
        this.project = project;
        this.pointers = new ArrayList();
        EventDispatcher eventDispatcher = EventDispatcher.create(NotebookIntervalPointerFactory.ChangeListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.changeListeners = eventDispatcher;
        CollectionsKt.addAll((Collection)this.pointers, (Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.notebookCellLines.getIntervals()), (Function1)1.INSTANCE));
        this.validUndoManager = undoManager;
    }

    @Override
    @NotNull
    public EventDispatcher<NotebookIntervalPointerFactory.ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    private final UndoManager getValidUndoManager() {
        Object object;
        UndoManager undoManager = this.validUndoManager;
        if (undoManager != null) {
            UndoManager undoManager2;
            UndoManager it = undoManager2 = undoManager;
            boolean bl = false;
            object = !this.project.isDisposed() ? undoManager2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Override
    @NotNull
    public NotebookIntervalPointer create(@NotNull NotebookCellLines.Interval interval) {
        NotebookIntervalPointerImpl notebookIntervalPointerImpl;
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        ThreadingAssertions.softAssertReadAccess();
        NotebookIntervalPointerImpl it = notebookIntervalPointerImpl = this.pointers.get(interval.getOrdinal());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getInterval(), (Object)interval)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        NotebookIntervalPointerImpl notebookIntervalPointerImpl2 = notebookIntervalPointerImpl;
        Intrinsics.checkNotNullExpressionValue((Object)notebookIntervalPointerImpl2, (String)"also(...)");
        return notebookIntervalPointerImpl2;
    }

    @Override
    public void modifyPointers(@NotNull Iterable<? extends NotebookIntervalPointerFactory.Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        ThreadingAssertions.assertWriteAccess();
        ArrayList<NotebookIntervalPointersEvent.Change> eventChanges = new ArrayList<NotebookIntervalPointersEvent.Change>();
        this.applyChanges(changes, eventChanges);
        NotebookIntervalPointersEvent pointerEvent = new NotebookIntervalPointersEvent((List<? extends NotebookIntervalPointersEvent.Change>)eventChanges, null, NotebookIntervalPointersEvent.EventSource.ACTION);
        UndoManager undoManager = this.getValidUndoManager();
        if (undoManager != null) {
            DocumentReference[] documentReferenceArray = new DocumentReference[]{this.documentReference};
            DocumentReference[] documentReferenceArray2 = documentReferenceArray;
            undoManager.undoableActionPerformed((UndoableAction)new BasicUndoableAction(this, eventChanges, documentReferenceArray2){
                final /* synthetic */ NotebookIntervalPointerFactoryImpl this$0;
                final /* synthetic */ ArrayList<NotebookIntervalPointersEvent.Change> $eventChanges;
                {
                    this.this$0 = $receiver;
                    this.$eventChanges = $eventChanges;
                    super($super_call_param$1);
                }

                public void undo() {
                    List invertedChanges = NotebookIntervalPointerFactoryImpl.access$invertChanges(this.this$0, this.$eventChanges);
                    NotebookIntervalPointerFactoryImpl.access$updatePointersByChanges(this.this$0, invertedChanges);
                    NotebookIntervalPointerFactoryImpl.access$onUpdated(this.this$0, new NotebookIntervalPointersEvent(invertedChanges, null, NotebookIntervalPointersEvent.EventSource.UNDO_ACTION));
                }

                public void redo() {
                    NotebookIntervalPointerFactoryImpl.access$updatePointersByChanges(this.this$0, this.$eventChanges);
                    NotebookIntervalPointerFactoryImpl.access$onUpdated(this.this$0, new NotebookIntervalPointersEvent((List<? extends NotebookIntervalPointersEvent.Change>)this.$eventChanges, null, NotebookIntervalPointersEvent.EventSource.REDO_ACTION));
                }
            });
        }
        this.onUpdated(pointerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull NotebookCellLinesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingAssertions.assertWriteAccess();
        try {
            NotebookIntervalPointersEvent notebookIntervalPointersEvent;
            ChangesContext context2 = this.changesContext;
            if (context2 instanceof DocumentChangedContext) {
                notebookIntervalPointersEvent = this.documentChangedByAction(event, (DocumentChangedContext)context2);
            } else if (context2 instanceof UndoContext) {
                notebookIntervalPointersEvent = this.documentChangedByUndo(event, (UndoContext)context2);
            } else if (context2 instanceof RedoContext) {
                notebookIntervalPointersEvent = this.documentChangedByRedo(event, (RedoContext)context2);
            } else if (context2 == null) {
                notebookIntervalPointersEvent = this.documentChangedByAction(event, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            NotebookIntervalPointersEvent pointersEvent = notebookIntervalPointersEvent;
            this.onUpdated(pointersEvent);
        }
        catch (Exception ex) {
            NotebookIntervalPointerFactoryImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookIntervalPointerFactoryImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
        }
        finally {
            this.changesContext = null;
        }
    }

    @Override
    public void beforeDocumentChange(@NotNull NotebookCellLinesEventBeforeChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingAssertions.assertWriteAccess();
        UndoManager undoManager = this.getValidUndoManager();
        if (undoManager == null || undoManager.isUndoOrRedoInProgress()) {
            return;
        }
        DocumentChangedContext context2 = new DocumentChangedContext(null, 1, null);
        try {
            undoManager.undoableActionPerformed((UndoableAction)new BasicUndoableAction(this, context2){
                final /* synthetic */ NotebookIntervalPointerFactoryImpl this$0;
                final /* synthetic */ DocumentChangedContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                }

                public void undo() {
                }

                public void redo() {
                    NotebookIntervalPointerFactoryImpl.access$setChangesContext$p(this.this$0, this.$context.getRedoContext());
                }
            });
            this.changesContext = context2;
        }
        catch (Exception ex) {
            NotebookIntervalPointerFactoryImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookIntervalPointerFactoryImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
        }
    }

    private final NotebookIntervalPointersEvent documentChangedByAction(NotebookCellLinesEvent event, DocumentChangedContext documentChangedContext) {
        ArrayList<NotebookIntervalPointersEvent.Change> eventChanges;
        block1: {
            eventChanges = new ArrayList<NotebookIntervalPointersEvent.Change>();
            this.updateChangedIntervals(event, eventChanges);
            this.updateShiftedIntervals(event);
            UndoManager undoManager = this.getValidUndoManager();
            if (undoManager != null) {
                DocumentReference[] documentReferenceArray = new DocumentReference[]{this.documentReference};
                DocumentReference[] documentReferenceArray2 = documentReferenceArray;
                undoManager.undoableActionPerformed((UndoableAction)new BasicUndoableAction(this, eventChanges, documentReferenceArray2){
                    final /* synthetic */ NotebookIntervalPointerFactoryImpl this$0;
                    final /* synthetic */ ArrayList<NotebookIntervalPointersEvent.Change> $eventChanges;
                    {
                        this.this$0 = $receiver;
                        this.$eventChanges = $eventChanges;
                        super($super_call_param$1);
                    }

                    public void undo() {
                        NotebookIntervalPointerFactoryImpl.access$setChangesContext$p(this.this$0, new UndoContext((List<? extends NotebookIntervalPointersEvent.Change>)this.$eventChanges));
                    }

                    public void redo() {
                    }
                });
            }
            DocumentChangedContext documentChangedContext2 = documentChangedContext;
            if (documentChangedContext2 == null) break block1;
            DocumentChangedContext it = documentChangedContext2;
            boolean bl = false;
            it.setRedoContext(new RedoContext((List<? extends NotebookIntervalPointersEvent.Change>)eventChanges));
        }
        return new NotebookIntervalPointersEvent((List<? extends NotebookIntervalPointersEvent.Change>)eventChanges, event, NotebookIntervalPointersEvent.EventSource.ACTION);
    }

    private final NotebookIntervalPointersEvent documentChangedByUndo(NotebookCellLinesEvent event, UndoContext context2) {
        List<NotebookIntervalPointersEvent.Change> invertedChanges = this.invertChanges(context2.getChanges());
        this.updatePointersByChanges(invertedChanges);
        this.updateShiftedIntervals(event);
        return new NotebookIntervalPointersEvent(invertedChanges, event, NotebookIntervalPointersEvent.EventSource.UNDO_ACTION);
    }

    private final NotebookIntervalPointersEvent documentChangedByRedo(NotebookCellLinesEvent event, RedoContext context2) {
        this.updatePointersByChanges(context2.getChanges());
        this.updateShiftedIntervals(event);
        return new NotebookIntervalPointersEvent(context2.getChanges(), event, NotebookIntervalPointersEvent.EventSource.REDO_ACTION);
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePointersByChanges(List<? extends NotebookIntervalPointersEvent.Change> changes) {
        for (NotebookIntervalPointersEvent.Change change : changes) {
            NotebookIntervalPointersEvent.Change change2 = change;
            if (change2 instanceof NotebookIntervalPointersEvent.OnEdited) {
                NotebookIntervalPointer notebookIntervalPointer = ((NotebookIntervalPointersEvent.OnEdited)change).getPointer();
                Intrinsics.checkNotNull((Object)notebookIntervalPointer, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerImpl");
                ((NotebookIntervalPointerImpl)notebookIntervalPointer).setInterval(((NotebookIntervalPointersEvent.OnEdited)change).getIntervalAfter());
                continue;
            }
            if (change2 instanceof NotebookIntervalPointersEvent.OnInserted) {
                Collection<NotebookIntervalPointerImpl> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                for (NotebookIntervalPointersEvent.PointerSnapshot p : ((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers()) {
                    NotebookIntervalPointer notebookIntervalPointer = p.getPointer();
                    Intrinsics.checkNotNull((Object)notebookIntervalPointer, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerImpl");
                    ((NotebookIntervalPointerImpl)notebookIntervalPointer).setInterval(p.getInterval());
                }
                Iterable iterable = ((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers();
                int n = ((NotebookIntervalPointersEvent.OnInserted)change).getOrdinals().getFirst();
                ArrayList<NotebookIntervalPointerImpl> arrayList = this.pointers;
                boolean $i$f$map = false;
                void var7_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    NotebookIntervalPointersEvent.PointerSnapshot pointerSnapshot = (NotebookIntervalPointersEvent.PointerSnapshot)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    NotebookIntervalPointer notebookIntervalPointer = it.getPointer();
                    Intrinsics.checkNotNull((Object)notebookIntervalPointer, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerImpl");
                    collection.add((NotebookIntervalPointerImpl)notebookIntervalPointer);
                }
                collection = (List)destination$iv$iv;
                arrayList.addAll(n, collection);
                continue;
            }
            if (change2 instanceof NotebookIntervalPointersEvent.OnRemoved) {
                for (NotebookIntervalPointersEvent.PointerSnapshot p : CollectionsKt.asReversed(((NotebookIntervalPointersEvent.OnRemoved)change).getSubsequentPointers())) {
                    this.pointers.remove(p.getInterval().getOrdinal());
                    NotebookIntervalPointer notebookIntervalPointer = p.getPointer();
                    Intrinsics.checkNotNull((Object)notebookIntervalPointer, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerImpl");
                    ((NotebookIntervalPointerImpl)notebookIntervalPointer).setInterval(null);
                }
                continue;
            }
            if (!(change2 instanceof NotebookIntervalPointersEvent.OnSwapped)) continue;
            this.trySwapPointers(null, new NotebookIntervalPointerFactory.Swap(((NotebookIntervalPointersEvent.OnSwapped)change).getFirstOrdinal(), ((NotebookIntervalPointersEvent.OnSwapped)change).getSecondOrdinal()));
        }
    }

    private final NotebookIntervalPointersEvent.PointerSnapshot makeSnapshot(NotebookCellLines.Interval interval) {
        NotebookIntervalPointerImpl notebookIntervalPointerImpl = this.pointers.get(interval.getOrdinal());
        Intrinsics.checkNotNullExpressionValue((Object)notebookIntervalPointerImpl, (String)"get(...)");
        return new NotebookIntervalPointersEvent.PointerSnapshot(notebookIntervalPointerImpl, interval);
    }

    private final boolean hasSingleIntervalsWithSameTypeAndLanguage(List<NotebookCellLines.Interval> oldIntervals, List<NotebookCellLines.Interval> newIntervals) {
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.singleOrNull(oldIntervals);
        if (interval == null) {
            return false;
        }
        NotebookCellLines.Interval old = interval;
        NotebookCellLines.Interval interval2 = (NotebookCellLines.Interval)CollectionsKt.singleOrNull(newIntervals);
        if (interval2 == null) {
            return false;
        }
        NotebookCellLines.Interval interval3 = interval2;
        return old.getType() == interval3.getType() && Intrinsics.areEqual((Object)old.getLanguage(), (Object)interval3.getLanguage());
    }

    private final void updateChangedIntervals(NotebookCellLinesEvent e, ArrayList<NotebookIntervalPointersEvent.Change> eventChanges) {
        if (!e.isIntervalsChanged()) {
            for (NotebookCellLines.Interval editedInterval : SetsKt.plus((Set)new LinkedHashSet(e.getOldAffectedIntervals()), (Iterable)e.getNewAffectedIntervals())) {
                NotebookIntervalPointerImpl notebookIntervalPointerImpl = this.pointers.get(editedInterval.getOrdinal());
                Intrinsics.checkNotNullExpressionValue((Object)notebookIntervalPointerImpl, (String)"get(...)");
                NotebookIntervalPointer notebookIntervalPointer = notebookIntervalPointerImpl;
                Intrinsics.checkNotNull((Object)editedInterval);
                eventChanges.add(new NotebookIntervalPointersEvent.OnEdited(notebookIntervalPointer, editedInterval, editedInterval));
            }
        } else if (this.hasSingleIntervalsWithSameTypeAndLanguage(e.getOldIntervals(), e.getNewIntervals())) {
            for (NotebookCellLines.Interval editedInterval : e.getNewAffectedIntervals()) {
                NotebookIntervalPointerImpl ptr;
                Intrinsics.checkNotNullExpressionValue((Object)this.pointers.get(editedInterval.getOrdinal()), (String)"get(...)");
                NotebookIntervalPointer notebookIntervalPointer = ptr;
                NotebookCellLines.Interval interval = ptr.getInterval();
                Intrinsics.checkNotNull((Object)interval);
                eventChanges.add(new NotebookIntervalPointersEvent.OnEdited(notebookIntervalPointer, interval, editedInterval));
            }
            if (!e.getNewAffectedIntervals().contains(CollectionsKt.first(e.getNewIntervals()))) {
                NotebookIntervalPointerImpl notebookIntervalPointerImpl = this.pointers.get(((NotebookCellLines.Interval)CollectionsKt.first(e.getNewIntervals())).getOrdinal());
                Intrinsics.checkNotNullExpressionValue((Object)notebookIntervalPointerImpl, (String)"get(...)");
                NotebookIntervalPointerImpl ptr2 = notebookIntervalPointerImpl;
                NotebookIntervalPointer notebookIntervalPointer = ptr2;
                NotebookCellLines.Interval interval = ptr2.getInterval();
                Intrinsics.checkNotNull((Object)interval);
                eventChanges.add(new NotebookIntervalPointersEvent.OnEdited(notebookIntervalPointer, interval, (NotebookCellLines.Interval)CollectionsKt.first(e.getNewIntervals())));
            }
            this.pointers.get(((NotebookCellLines.Interval)CollectionsKt.first(e.getNewIntervals())).getOrdinal()).setInterval((NotebookCellLines.Interval)CollectionsKt.first(e.getNewIntervals()));
        } else {
            NotebookCellLines.Interval p0;
            Collection collection;
            Object item$iv$iv;
            Iterator iterator;
            Object $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            NotebookIntervalPointerImpl ptr;
            Object $this$map$iv;
            ArrayList<Object> arrayList;
            if (!((Collection)e.getOldIntervals()).isEmpty()) {
                Iterable ptr2 = e.getOldIntervals();
                arrayList = eventChanges;
                boolean $i$f$map = false;
                ptr = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.makeSnapshot(p0));
                }
                List list = (List)destination$iv$iv;
                arrayList.add(new NotebookIntervalPointersEvent.OnRemoved(list));
                for (NotebookCellLines.Interval old : CollectionsKt.asReversed(e.getOldIntervals())) {
                    this.pointers.get(old.getOrdinal()).setInterval(null);
                    this.pointers.remove(old.getOrdinal());
                }
            }
            if (!((Collection)e.getNewIntervals()).isEmpty()) {
                NotebookCellLines.Interval it;
                Collection<NotebookIntervalPointerImpl> collection2;
                $this$map$iv = e.getNewIntervals();
                int n = ((NotebookCellLines.Interval)CollectionsKt.first(e.getNewIntervals())).getOrdinal();
                arrayList = this.pointers;
                boolean $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    p0 = (NotebookCellLines.Interval)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new NotebookIntervalPointerImpl(it));
                }
                collection2 = (List)destination$iv$iv;
                arrayList.addAll(n, (Collection<Object>)collection2);
                $this$map$iv = e.getNewIntervals();
                arrayList = eventChanges;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    it = (NotebookCellLines.Interval)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.makeSnapshot(p0));
                }
                List list = (List)destination$iv$iv;
                arrayList.add(new NotebookIntervalPointersEvent.OnInserted(list));
            }
            for (NotebookCellLines.Interval interval : CollectionsKt.minus((Iterable)e.getNewAffectedIntervals(), (Iterable)CollectionsKt.toSet((Iterable)e.getNewIntervals()))) {
                Intrinsics.checkNotNullExpressionValue((Object)this.pointers.get(interval.getOrdinal()), (String)"get(...)");
                NotebookIntervalPointer notebookIntervalPointer = ptr;
                NotebookCellLines.Interval interval2 = ptr.getInterval();
                Intrinsics.checkNotNull((Object)interval2);
                eventChanges.add(new NotebookIntervalPointersEvent.OnEdited(notebookIntervalPointer, interval2, interval));
            }
        }
    }

    private final void updateShiftedIntervals(NotebookCellLinesEvent event) {
        int invalidPointersStart;
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(event.getNewIntervals());
        if (interval != null) {
            NotebookCellLines.Interval it = interval;
            boolean bl = false;
            v1 = it.getOrdinal() + event.getNewIntervals().size();
        } else {
            NotebookCellLines.Interval interval2 = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(event.getOldIntervals());
            v1 = interval2 != null ? interval2.getOrdinal() : this.pointers.size();
        }
        int n = this.pointers.size();
        for (int i = invalidPointersStart = (v1401681); i < n; ++i) {
            this.pointers.get(i).setInterval(this.notebookCellLines.getIntervals().get(i));
        }
    }

    private final void applyChanges(Iterable<? extends NotebookIntervalPointerFactory.Change> changes, ArrayList<NotebookIntervalPointersEvent.Change> eventChanges) {
        for (NotebookIntervalPointerFactory.Change change : changes) {
            NotebookIntervalPointerFactory.Change change2 = change;
            if (change2 instanceof NotebookIntervalPointerFactory.Invalidate) {
                NotebookIntervalPointer notebookIntervalPointer = this.create(((NotebookIntervalPointerFactory.Invalidate)change).getInterval());
                Intrinsics.checkNotNull((Object)notebookIntervalPointer, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerImpl");
                NotebookIntervalPointerImpl ptr = (NotebookIntervalPointerImpl)notebookIntervalPointer;
                this.invalidatePointer(eventChanges, ptr);
                continue;
            }
            if (!(change2 instanceof NotebookIntervalPointerFactory.Swap)) continue;
            this.trySwapPointers(eventChanges, (NotebookIntervalPointerFactory.Swap)change);
        }
    }

    private final void invalidatePointer(ArrayList<NotebookIntervalPointersEvent.Change> eventChanges, NotebookIntervalPointerImpl ptr) {
        NotebookCellLines.Interval interval = ptr.getInterval();
        if (interval == null) {
            return;
        }
        NotebookIntervalPointerImpl newPtr = new NotebookIntervalPointerImpl(interval);
        this.pointers.set(interval.getOrdinal(), newPtr);
        ptr.setInterval(null);
        eventChanges.add(new NotebookIntervalPointersEvent.OnRemoved(CollectionsKt.listOf((Object)new NotebookIntervalPointersEvent.PointerSnapshot(ptr, interval))));
        eventChanges.add(new NotebookIntervalPointersEvent.OnInserted(CollectionsKt.listOf((Object)new NotebookIntervalPointersEvent.PointerSnapshot(newPtr, interval))));
    }

    private final void trySwapPointers(ArrayList<NotebookIntervalPointersEvent.Change> eventChanges, NotebookIntervalPointerFactory.Swap hint) {
        block2: {
            NotebookIntervalPointerImpl firstPtr = (NotebookIntervalPointerImpl)CollectionsKt.getOrNull((List)this.pointers, (int)hint.getFirstOrdinal());
            NotebookIntervalPointerImpl secondPtr = (NotebookIntervalPointerImpl)CollectionsKt.getOrNull((List)this.pointers, (int)hint.getSecondOrdinal());
            if (firstPtr == null || secondPtr == null) {
                NotebookIntervalPointerFactoryImpl $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(NotebookIntervalPointerFactoryImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("cannot swap invalid NotebookIntervalPointers: " + hint.getFirstOrdinal() + " and " + hint.getSecondOrdinal());
                return;
            }
            if (hint.getFirstOrdinal() == hint.getSecondOrdinal()) {
                return;
            }
            NotebookCellLines.Interval interval = firstPtr.getInterval();
            Intrinsics.checkNotNull((Object)interval);
            NotebookCellLines.Interval interval2 = interval;
            firstPtr.setInterval(secondPtr.getInterval());
            secondPtr.setInterval(interval2);
            this.pointers.set(hint.getFirstOrdinal(), secondPtr);
            this.pointers.set(hint.getSecondOrdinal(), firstPtr);
            ArrayList<NotebookIntervalPointersEvent.Change> arrayList = eventChanges;
            if (arrayList == null) break block2;
            NotebookIntervalPointer notebookIntervalPointer = firstPtr;
            NotebookCellLines.Interval interval3 = firstPtr.getInterval();
            Intrinsics.checkNotNull((Object)interval3);
            NotebookIntervalPointersEvent.PointerSnapshot pointerSnapshot = new NotebookIntervalPointersEvent.PointerSnapshot(notebookIntervalPointer, interval3);
            NotebookIntervalPointer notebookIntervalPointer2 = secondPtr;
            NotebookCellLines.Interval interval4 = secondPtr.getInterval();
            Intrinsics.checkNotNull((Object)interval4);
            arrayList.add(new NotebookIntervalPointersEvent.OnSwapped(pointerSnapshot, new NotebookIntervalPointersEvent.PointerSnapshot(notebookIntervalPointer2, interval4)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotebookIntervalPointersEvent.Change> invertChanges(List<? extends NotebookIntervalPointersEvent.Change> changes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.asReversed(changes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            NotebookIntervalPointersEvent.Change change = (NotebookIntervalPointersEvent.Change)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.invertChange((NotebookIntervalPointersEvent.Change)p0));
        }
        return (List)destination$iv$iv;
    }

    private final NotebookIntervalPointersEvent.Change invertChange(NotebookIntervalPointersEvent.Change change) {
        NotebookIntervalPointersEvent.Change change2;
        NotebookIntervalPointersEvent.Change change3 = change;
        if (change3 instanceof NotebookIntervalPointersEvent.OnEdited) {
            NotebookIntervalPointersEvent.OnEdited onEdited = (NotebookIntervalPointersEvent.OnEdited)change;
            NotebookCellLines.Interval interval = ((NotebookIntervalPointersEvent.OnEdited)change).getIntervalBefore();
            NotebookCellLines.Interval interval2 = ((NotebookIntervalPointersEvent.OnEdited)change).getIntervalAfter();
            change2 = NotebookIntervalPointersEvent.OnEdited.copy$default(onEdited, null, interval2, interval, 1, null);
        } else if (change3 instanceof NotebookIntervalPointersEvent.OnInserted) {
            change2 = new NotebookIntervalPointersEvent.OnRemoved(((NotebookIntervalPointersEvent.OnInserted)change).getSubsequentPointers());
        } else if (change3 instanceof NotebookIntervalPointersEvent.OnRemoved) {
            change2 = new NotebookIntervalPointersEvent.OnInserted(((NotebookIntervalPointersEvent.OnRemoved)change).getSubsequentPointers());
        } else if (change3 instanceof NotebookIntervalPointersEvent.OnSwapped) {
            change2 = new NotebookIntervalPointersEvent.OnSwapped(new NotebookIntervalPointersEvent.PointerSnapshot(((NotebookIntervalPointersEvent.OnSwapped)change).getFirst().getPointer(), ((NotebookIntervalPointersEvent.OnSwapped)change).getSecond().getInterval()), new NotebookIntervalPointersEvent.PointerSnapshot(((NotebookIntervalPointersEvent.OnSwapped)change).getSecond().getPointer(), ((NotebookIntervalPointersEvent.OnSwapped)change).getFirst().getInterval()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return change2;
    }

    private final void onUpdated(NotebookIntervalPointersEvent event) {
        EventListener eventListener = this.getChangeListeners().getMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"getMulticaster(...)");
        this.safelyUpdate((NotebookIntervalPointerFactory.ChangeListener)eventListener, event);
        this.safelyUpdate((NotebookIntervalPointerFactory.ChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(NotebookIntervalPointerFactory.ChangeListener.Companion.getTOPIC()), event);
    }

    private final void safelyUpdate(NotebookIntervalPointerFactory.ChangeListener listener2, NotebookIntervalPointersEvent event) {
        try {
            listener2.onUpdated(event);
        }
        catch (Throwable t) {
            NotebookIntervalPointerFactoryImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookIntervalPointerFactoryImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(listener2 + " shouldn't throw exceptions", t);
        }
    }

    @TestOnly
    public final int pointersCount() {
        return this.pointers.size();
    }

    public static final /* synthetic */ List access$invertChanges(NotebookIntervalPointerFactoryImpl $this, List changes) {
        return $this.invertChanges(changes);
    }

    public static final /* synthetic */ void access$updatePointersByChanges(NotebookIntervalPointerFactoryImpl $this, List changes) {
        $this.updatePointersByChanges(changes);
    }

    public static final /* synthetic */ void access$onUpdated(NotebookIntervalPointerFactoryImpl $this, NotebookIntervalPointersEvent event) {
        $this.onUpdated(event);
    }

    public static final /* synthetic */ void access$setChangesContext$p(NotebookIntervalPointerFactoryImpl $this, ChangesContext changesContext) {
        $this.changesContext = changesContext;
    }
}

