/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.outputs.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayControllerUtilKt;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.NotebookOutputCollapseSingleInCellAction;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.ResizeHandlebarUpdater;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.ResizeController;
import org.jetbrains.plugins.notebooks.visualization.r.ui.UiCustomizer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 32\u00020\u0001:\u000234B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0011\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\u0010\fJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u001e\u0010)\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u000eH\u0016J\u0006\u00100\u001a\u00020&J\u0006\u00101\u001a\u00020&J\b\u00102\u001a\u00020&H\u0016R\u0019\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001b\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/CollapsingComponent;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "child", "Ljavax/swing/JComponent;", "resizable", "", "collapsedTextSupplier", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljavax/swing/JComponent;ZLkotlin/jvm/functions/Function0;)V", "customHeight", "", "getEditor$intellij_notebooks_visualization", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "hasBeenManuallyResized", "getHasBeenManuallyResized", "()Z", "value", "isSeen", "setSeen", "(Z)V", "isWorthCollapsing", "mainComponent", "getMainComponent", "()Ljavax/swing/JComponent;", "getResizable$intellij_notebooks_visualization", "resizeController", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ResizeController;", "getResizeController", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ResizeController;", "resizeController$delegate", "Lkotlin/Lazy;", "stubComponent", "getStubComponent", "doLayout", "", "getPreferredSize", "Ljava/awt/Dimension;", "paintGutter", "Lcom/intellij/openapi/editor/ex/EditorEx;", "yOffset", "g", "Ljava/awt/Graphics;", "remove", "index", "resetCustomHeight", "updateStubIfCollapsed", "updateUI", "Companion", "StubComponent", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nCollapsingComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollapsingComponent.kt\norg/jetbrains/plugins/notebooks/visualization/outputs/impl/CollapsingComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class CollapsingComponent
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    private final boolean resizable;
    @NotNull
    private final Function0<String> collapsedTextSupplier;
    private int customHeight;
    @NotNull
    private final Lazy resizeController$delegate;
    public static final int MIN_HEIGHT_TO_COLLAPSE = 50;
    public static final int COLLAPSING_RECT_WIDTH = 22;
    private static final int COLLAPSING_RECT_MARGIN_Y_BOTTOM = 5;
    @NotNull
    private static final Lazy<Logger> LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);

    public CollapsingComponent(@NotNull EditorImpl editor, @NotNull JComponent child, boolean resizable2, @NotNull Function0<String> collapsedTextSupplier) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter(collapsedTextSupplier, (String)"collapsedTextSupplier");
        super(null);
        this.editor = editor;
        this.resizable = resizable2;
        this.collapsedTextSupplier = collapsedTextSupplier;
        this.customHeight = -1;
        this.resizeController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResizeController>(this){
            final /* synthetic */ CollapsingComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ResizeController invoke() {
                return new ResizeController(this.this$0, (Editor)this.this$0.getEditor$intellij_notebooks_visualization(), (Function2<? super Integer, ? super Integer, Unit>)((Function2)new Function2<Integer, Integer, Unit>(this.this$0){
                    final /* synthetic */ CollapsingComponent this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(int n, int dy) {
                        if (CollapsingComponent.access$getCustomHeight$p(this.this$0) < 0) {
                            void $this$invoke_u24lambda_u240;
                            Insets insets = this.this$0.getInsets();
                            int n2 = this.this$0.getHeight();
                            CollapsingComponent collapsingComponent = this.this$0;
                            boolean bl = false;
                            int n3 = $this$invoke_u24lambda_u240.top + $this$invoke_u24lambda_u240.bottom;
                            CollapsingComponent.access$setCustomHeight$p(collapsingComponent, n2 - n3);
                        }
                        CollapsingComponent collapsingComponent = this.this$0;
                        CollapsingComponent.access$setCustomHeight$p(collapsingComponent, CollapsingComponent.access$getCustomHeight$p(collapsingComponent) + dy);
                        this.this$0.getMainComponent().revalidate();
                    }
                }));
            }
        }));
        this.add(child);
        this.add(new StubComponent(this.editor));
        this.setBorder(ResizeHandlebarUpdater.invisibleResizeBorder);
        this.setSeen(true);
    }

    @NotNull
    public final EditorImpl getEditor$intellij_notebooks_visualization() {
        return this.editor;
    }

    public final boolean getResizable$intellij_notebooks_visualization() {
        return this.resizable;
    }

    private final ResizeController getResizeController() {
        Lazy lazy = this.resizeController$delegate;
        return (ResizeController)lazy.getValue();
    }

    public final boolean isSeen() {
        return this.getMainComponent().isVisible();
    }

    public final void setSeen(boolean value) {
        this.getMainComponent().setVisible(value);
        this.getStubComponent().setVisible(!value);
        if (this.resizable) {
            if (value) {
                this.addMouseListener(this.getResizeController());
                this.addMouseMotionListener(this.getResizeController());
            } else {
                this.removeMouseListener(this.getResizeController());
                this.removeMouseMotionListener(this.getResizeController());
            }
        }
        if (!value) {
            JComponent jComponent = this.getStubComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent.StubComponent");
            ((StubComponent)jComponent).setText((String)this.collapsedTextSupplier.invoke());
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(false);
    }

    @Override
    public void remove(int index) {
        CollapsingComponent.Companion.getLOG().error("Components should not be deleted from " + this, new Throwable());
        super.remove(index);
    }

    @NotNull
    public final JComponent getMainComponent() {
        Component component = this.getComponent(0);
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        return (JComponent)component;
    }

    private final JComponent getStubComponent() {
        Component component = this.getComponent(1);
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        return (JComponent)component;
    }

    public final boolean isWorthCollapsing() {
        return !this.isSeen() || this.getMainComponent().getHeight() >= 50;
    }

    public final boolean getHasBeenManuallyResized() {
        return this.customHeight != -1;
    }

    public final void resetCustomHeight() {
        this.customHeight = -1;
        if (this.getMainComponent().isValid()) {
            this.getMainComponent().revalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension getPreferredSize() {
        void $this$getPreferredSize_u24lambda_u241;
        Cloneable $this$getPreferredSize_u24lambda_u240;
        Dimension dimension;
        if (!this.isSeen()) {
            dimension = this.getStubComponent().getPreferredSize();
        } else if (this.customHeight >= 0) {
            Dimension dimension2;
            $this$getPreferredSize_u24lambda_u240 = dimension2 = this.getMainComponent().getPreferredSize();
            boolean bl = false;
            $this$getPreferredSize_u24lambda_u240.height = this.customHeight;
            dimension = dimension2;
        } else {
            dimension = this.getMainComponent().getPreferredSize();
        }
        Dimension result2 = dimension;
        $this$getPreferredSize_u24lambda_u240 = this.getInsets();
        int n = result2.height;
        Dimension dimension3 = result2;
        boolean bl = false;
        int n2 = $this$getPreferredSize_u24lambda_u241.top + $this$getPreferredSize_u24lambda_u241.bottom;
        dimension3.height = n + n2;
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    @Override
    public void doLayout() {
        Insets $this$doLayout_u24lambda_u242 = this.getInsets();
        boolean bl = false;
        Pair pair = TuplesKt.to((Object)($this$doLayout_u24lambda_u242.left + $this$doLayout_u24lambda_u242.right), (Object)($this$doLayout_u24lambda_u242.top + $this$doLayout_u24lambda_u242.bottom));
        int borderWidth = ((Number)pair.component1()).intValue();
        int borderHeight = ((Number)pair.component2()).intValue();
        if (!this.isSeen()) {
            this.getStubComponent().setBounds(0, 0, this.getWidth() - borderWidth, this.getHeight() - borderHeight);
        } else if (this.customHeight >= 0) {
            this.getMainComponent().setBounds(0, 0, this.getWidth() - borderWidth, this.customHeight - borderHeight);
        } else {
            this.getMainComponent().setBounds(0, 0, this.getWidth() - borderWidth, this.getHeight() - borderHeight);
        }
    }

    public final void paintGutter(@NotNull EditorEx editor, int yOffset, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        NotebookEditorAppearance notebookAppearance = NotebookUtilKt.getNotebookAppearance((Editor)editor);
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        Color backgroundColor = notebookAppearance.getCodeCellBackground(editorColorsScheme);
        if (backgroundColor != null && this.isWorthCollapsing()) {
            int x = Companion.collapseRectHorizontalLeft(editor);
            Insets it = this.getInsets();
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)(yOffset + this.getY() + it.top), (Object)(this.getHeight() - it.top - it.bottom));
            int rectTop = ((Number)pair.component1()).intValue();
            int rectHeight = ((Number)pair.component2()).intValue();
            g.setColor(backgroundColor);
            EditorGutterComponentEx editorGutterComponentEx = editor.getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
            if (NotebookOutputInlayControllerUtilKt.getHoveredCollapsingComponentRect(editorGutterComponentEx) == this) {
                g.fillRect(x, rectTop, 22, rectHeight);
            }
            if (!this.isSeen()) {
                int outputAdjacentRectWidth = notebookAppearance.getLeftBorderWidth();
                g.setColor(UiCustomizer.Companion.getInstance().getTextOutputBackground((Editor)editor));
                g.fillRect(editor.getGutterComponentEx().getWidth() - outputAdjacentRectWidth, rectTop, outputAdjacentRectWidth, rectHeight);
            }
            Icon icon = this.isSeen() ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon();
            Intrinsics.checkNotNull((Object)icon);
            Icon icon2 = icon;
            int iconOffset = (22 - icon2.getIconWidth()) / 2;
            icon2.paintIcon(this, g, x + iconOffset + 1, yOffset + this.getY() + 5 + iconOffset);
        }
    }

    public final void updateStubIfCollapsed() {
        if (!this.isSeen()) {
            JComponent jComponent = this.getStubComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent.StubComponent");
            ((StubComponent)jComponent).setText((String)this.collapsedTextSupplier.invoke());
        }
    }

    @JvmStatic
    public static final int collapseRectHorizontalLeft(@NotNull EditorEx editor) {
        return Companion.collapseRectHorizontalLeft(editor);
    }

    public static final /* synthetic */ int access$getCustomHeight$p(CollapsingComponent $this) {
        return $this.customHeight;
    }

    public static final /* synthetic */ void access$setCustomHeight$p(CollapsingComponent $this, int n) {
        $this.customHeight = n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/CollapsingComponent$Companion;", "", "()V", "COLLAPSING_RECT_MARGIN_Y_BOTTOM", "", "COLLAPSING_RECT_WIDTH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "MIN_HEIGHT_TO_COLLAPSE", "collapseRectHorizontalLeft", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            return (Logger)lazy.getValue();
        }

        @JvmStatic
        public final int collapseRectHorizontalLeft(@NotNull EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return editor.getGutterComponentEx().getWidth() - 22 - NotebookUtilKt.getNotebookAppearance((Editor)editor).getLINE_NUMBERS_MARGIN() - NotebookUtilKt.getNotebookAppearance((Editor)editor).getCODE_CELL_LEFT_LINE_PADDING();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/CollapsingComponent$StubComponent;", "Ljavax/swing/JLabel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "onClick", "", "e", "Ljava/awt/event/MouseEvent;", "updateUI", "updateUIFromEditor", "intellij.notebooks.visualization"})
    private static final class StubComponent
    extends JLabel {
        @NotNull
        private final EditorImpl editor;

        public StubComponent(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super("...");
            this.editor = editor;
            this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(7, 0, 7, 0)));
            this.updateUIFromEditor();
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.onClick(e);
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setOpaque(true);
            if (this.editor != null) {
                this.updateUIFromEditor();
            }
        }

        private final void onClick(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            Container container = this.getParent();
            CollapsingComponent collapsingComponent = container instanceof CollapsingComponent ? (CollapsingComponent)container : null;
            if (collapsingComponent == null) {
                return;
            }
            CollapsingComponent parent = collapsingComponent;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction(NotebookOutputCollapseSingleInCellAction.class.getSimpleName());
            Intrinsics.checkNotNull((Object)anAction);
            AnAction action2 = anAction;
            if (actionManager.tryToExecute(action2, (InputEvent)e, (Component)parent, null, true).isProcessed()) {
                e.consume();
            }
        }

        private final void updateUIFromEditor() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
            int fontType = textAttributes != null ? textAttributes.getFontType() : 0;
            this.setForeground(JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND);
            this.setBackground(UiCustomizer.Companion.getInstance().getTextOutputBackground((Editor)this.editor));
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.setFont(EditorUtil.fontForChar((char)StringsKt.first((CharSequence)string), (int)fontType, (Editor)((Editor)this.editor)).getFont());
        }
    }
}

