/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestCombinedDiffFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestTimelineFile;
import org.jetbrains.plugins.gitlab.util.GitLabRegistry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016RP\u0010\u0004\u001aD\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b* \u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\t\u00a2\u0006\u0002\b\u00060\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$FilePath;", "()V", "filesCache", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "", "createDiffFile", "path", "project", "Lcom/intellij/openapi/project/Project;", "findOrCreateFile", "getPath", "", "sessionId", "repository", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mrIid", "isDiff", "", "getProtocol", "Companion", "FilePath", "PathSerializer", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabVirtualFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabVirtualFileSystem.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,74:1\n372#2,7:75\n*S KotlinDebug\n*F\n+ 1 GitLabVirtualFileSystem.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem\n*L\n25#1:75,7\n*E\n"})
public final class GitLabVirtualFileSystem
extends ComplexPathVirtualFileSystem<FilePath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FilePath, VirtualFile> filesCache;
    @NotNull
    private static final String PROTOCOL = "gitlabmr";

    public GitLabVirtualFileSystem() {
        super((ComplexPathVirtualFileSystem.ComplexPathSerializer)new PathSerializer());
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap(...)");
        this.filesCache = map2;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    protected VirtualFile findOrCreateFile(@NotNull Project project, @NotNull FilePath path) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Intrinsics.areEqual((Object)project.getLocationHash(), (Object)path.getProjectHash())) {
            return null;
        }
        Map<FilePath, VirtualFile> $this$getOrPut$iv = this.filesCache;
        boolean $i$f$getOrPut = false;
        VirtualFile value$iv = $this$getOrPut$iv.get(path);
        if (value$iv == null) {
            boolean bl = false;
            VirtualFile answer$iv = Intrinsics.areEqual((Object)path.isDiff(), (Object)true) ? this.createDiffFile(path, project) : (VirtualFile)new GitLabMergeRequestTimelineFile(path.getSessionId(), project, path.getRepository(), path.getMrIid());
            $this$getOrPut$iv.put(path, answer$iv);
            virtualFile = answer$iv;
        } else {
            virtualFile = value$iv;
        }
        return virtualFile;
    }

    private final VirtualFile createDiffFile(FilePath path, Project project) {
        if (GitLabRegistry.INSTANCE.isCombinedDiffEnabled()) {
            return (VirtualFile)new GitLabMergeRequestCombinedDiffFile(path.getSessionId(), project, path.getRepository(), path.getMrIid());
        }
        return (VirtualFile)new GitLabMergeRequestDiffFile(path.getSessionId(), project, path.getRepository(), path.getMrIid());
    }

    @NotNull
    public final String getPath(@NotNull String sessionId, @NotNull Project project, @NotNull GitLabProjectCoordinates repository, @NotNull String mrIid, boolean isDiff) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)mrIid, (String)"mrIid");
        String string = project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
        return this.getPath(new FilePath(sessionId, string, repository, mrIid, isDiff));
    }

    public static /* synthetic */ String getPath$default(GitLabVirtualFileSystem gitLabVirtualFileSystem, String string, Project project, GitLabProjectCoordinates gitLabProjectCoordinates, String string2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return gitLabVirtualFileSystem.getPath(string, project, gitLabProjectCoordinates, string2, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$Companion;", "", "()V", "PROTOCOL", "", "getInstance", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem;", "intellij.vcs.gitlab"})
    @SourceDebugExtension(value={"SMAP\nGitLabVirtualFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabVirtualFileSystem.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,74:1\n43#2,3:75\n*S KotlinDebug\n*F\n+ 1 GitLabVirtualFileSystem.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$Companion\n*L\n58#1:75,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitLabVirtualFileSystem getInstance() {
            boolean $i$f$service = false;
            Class<VirtualFileManager> serviceClass$iv = VirtualFileManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            VirtualFileSystem virtualFileSystem = ((VirtualFileManager)object).getFileSystem(GitLabVirtualFileSystem.PROTOCOL);
            Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem");
            return (GitLabVirtualFileSystem)virtualFileSystem;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJB\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\b\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$FilePath;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPath;", "sessionId", "", "projectHash", "repository", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mrIid", "isDiff", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Ljava/lang/String;Ljava/lang/Boolean;)V", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getMrIid", "()Ljava/lang/String;", "getProjectHash", "getRepository", "()Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "getSessionId", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$FilePath;", "equals", "other", "", "hashCode", "", "toString", "intellij.vcs.gitlab"})
    public static final class FilePath
    implements ComplexPathVirtualFileSystem.ComplexPath {
        @NotNull
        private final String sessionId;
        @NotNull
        private final String projectHash;
        @NotNull
        private final GitLabProjectCoordinates repository;
        @NotNull
        private final String mrIid;
        @Nullable
        private final Boolean isDiff;

        public FilePath(@NotNull String sessionId, @NotNull String projectHash, @NotNull GitLabProjectCoordinates repository, @NotNull String mrIid, @Nullable Boolean isDiff) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)mrIid, (String)"mrIid");
            this.sessionId = sessionId;
            this.projectHash = projectHash;
            this.repository = repository;
            this.mrIid = mrIid;
            this.isDiff = isDiff;
        }

        public /* synthetic */ FilePath(String string, String string2, GitLabProjectCoordinates gitLabProjectCoordinates, String string3, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = null;
            }
            this(string, string2, gitLabProjectCoordinates, string3, bl);
        }

        @NotNull
        public String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public String getProjectHash() {
            return this.projectHash;
        }

        @NotNull
        public final GitLabProjectCoordinates getRepository() {
            return this.repository;
        }

        @NotNull
        public final String getMrIid() {
            return this.mrIid;
        }

        @Nullable
        public final Boolean isDiff() {
            return this.isDiff;
        }

        @NotNull
        public final String component1() {
            return this.sessionId;
        }

        @NotNull
        public final String component2() {
            return this.projectHash;
        }

        @NotNull
        public final GitLabProjectCoordinates component3() {
            return this.repository;
        }

        @NotNull
        public final String component4() {
            return this.mrIid;
        }

        @Nullable
        public final Boolean component5() {
            return this.isDiff;
        }

        @NotNull
        public final FilePath copy(@NotNull String sessionId, @NotNull String projectHash, @NotNull GitLabProjectCoordinates repository, @NotNull String mrIid, @Nullable Boolean isDiff) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)mrIid, (String)"mrIid");
            return new FilePath(sessionId, projectHash, repository, mrIid, isDiff);
        }

        public static /* synthetic */ FilePath copy$default(FilePath filePath, String string, String string2, GitLabProjectCoordinates gitLabProjectCoordinates, String string3, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = filePath.sessionId;
            }
            if ((n & 2) != 0) {
                string2 = filePath.projectHash;
            }
            if ((n & 4) != 0) {
                gitLabProjectCoordinates = filePath.repository;
            }
            if ((n & 8) != 0) {
                string3 = filePath.mrIid;
            }
            if ((n & 0x10) != 0) {
                bl = filePath.isDiff;
            }
            return filePath.copy(string, string2, gitLabProjectCoordinates, string3, bl);
        }

        @NotNull
        public String toString() {
            return "FilePath(sessionId=" + this.sessionId + ", projectHash=" + this.projectHash + ", repository=" + this.repository + ", mrIid=" + this.mrIid + ", isDiff=" + this.isDiff + ")";
        }

        public int hashCode() {
            int result2 = this.sessionId.hashCode();
            result2 = result2 * 31 + this.projectHash.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            result2 = result2 * 31 + this.mrIid.hashCode();
            result2 = result2 * 31 + (this.isDiff == null ? 0 : ((Object)this.isDiff).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilePath)) {
                return false;
            }
            FilePath filePath = (FilePath)other;
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)filePath.sessionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.projectHash, (Object)filePath.projectHash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.repository, (Object)filePath.repository)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mrIid, (Object)filePath.mrIid)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isDiff, (Object)filePath.isDiff);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$PathSerializer;", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem$ComplexPathSerializer;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFileSystem$FilePath;", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserialize", "rawPath", "", "serialize", "path", "intellij.vcs.gitlab"})
    private static final class PathSerializer
    implements ComplexPathVirtualFileSystem.ComplexPathSerializer<FilePath> {
        @NotNull
        private final ObjectMapper mapper;

        /*
         * WARNING - void declaration
         */
        public PathSerializer() {
            void $this$mapper_u24lambda_u240;
            ObjectMapper objectMapper;
            ObjectMapper objectMapper2 = objectMapper = ExtensionsKt.jacksonObjectMapper();
            PathSerializer pathSerializer = this;
            boolean bl = false;
            $this$mapper_u24lambda_u240.setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
            pathSerializer.mapper = objectMapper;
        }

        @NotNull
        public String serialize(@NotNull FilePath path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = this.mapper.writeValueAsString((Object)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            return string;
        }

        @NotNull
        public FilePath deserialize(@NotNull String rawPath) {
            Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
            Object object = this.mapper.readValue(rawPath, FilePath.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (FilePath)object;
        }
    }
}

