/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.php;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.qodana.sarif.model.ArtifactContent;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Edge;
import com.jetbrains.qodana.sarif.model.Graph;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.LocationRelationship;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.Node;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.qodana.staticAnalysis.sarif.CommonDescriptor;
import org.jetbrains.qodana.staticAnalysis.sarif.ElementToSarifConverter;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a:\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001aQ\u0010\u0017\u001a\n \u0002*\u0004\u0018\u00010\u00180\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a \u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0005H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"vulnerableFlowMessage", "Lcom/jetbrains/qodana/sarif/model/Message;", "kotlin.jvm.PlatformType", "computeSink", "", "", "", "problem", "Lorg/jdom/Element;", "computeSources", "", "convertPhpFromXmlFormat", "Lcom/jetbrains/qodana/sarif/model/Result;", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "getLocationByAttributes", "Lcom/jetbrains/qodana/sarif/model/Location;", "fileUrl", "line", "", "startCharOffset", "endCharOffset", "language", "getPhpVulnerableRegion", "Lcom/jetbrains/qodana/sarif/model/Region;", "charOffset", "startColumn", "length", "snippet", "Lcom/jetbrains/qodana/sarif/model/ArtifactContent;", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Lcom/jetbrains/qodana/sarif/model/ArtifactContent;)Lcom/jetbrains/qodana/sarif/model/Region;", "getVulnerabilityValues", "marker", "tag", "intellij.qodana.php"})
@SourceDebugExtension(value={"SMAP\nPhpGlobalOutputConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpGlobalOutputConsumer.kt\norg/jetbrains/qodana/php/PhpGlobalOutputConsumerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1549#2:192\n1620#2,3:193\n1549#2:196\n1620#2,3:197\n1549#2:201\n1620#2,3:202\n1549#2:205\n1620#2,3:206\n1#3:200\n*S KotlinDebug\n*F\n+ 1 PhpGlobalOutputConsumer.kt\norg/jetbrains/qodana/php/PhpGlobalOutputConsumerKt\n*L\n86#1:192\n86#1:193,3\n87#1:196\n87#1:197,3\n129#1:201\n129#1:202,3\n187#1:205\n187#1:206,3\n*E\n"})
public final class PhpGlobalOutputConsumerKt {
    private static final Message vulnerableFlowMessage = new Message().withText("Vulnerable code flow").withMarkdown("Vulnerable code flow");

    /*
     * WARNING - void declaration
     */
    private static final Result convertPhpFromXmlFormat(Element problem, PathMacroManager macroManager) {
        PropertyBag it;
        PropertyBag propertyBag;
        Object object;
        CommonDescriptor problemLocation = ElementToSarifConverter.INSTANCE.commonDescriptor(problem);
        Result result = ElementToSarifConverter.INSTANCE.convertCommonXmlPart(problem, vulnerableFlowMessage);
        Set nodes = new LinkedHashSet();
        Set edges = new LinkedHashSet();
        List fragmentLocations = new ArrayList();
        for (Element fragment : problem.getChild("fragments").getChildren("fragment")) {
            Location location;
            String fragmentFile = fragment.getAttributeValue("file");
            String string = fragment.getAttributeValue("line");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            int fragmentLine = Integer.parseInt(string);
            String string2 = fragment.getAttributeValue("start");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
            int fragmentStart = Integer.parseInt(string2);
            String string3 = fragment.getAttributeValue("end");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
            int fragmentEnd = Integer.parseInt(string3);
            Set markerRelationships = new LinkedHashSet();
            for (Element marker : fragment.getChildren("marker")) {
                String string4 = marker.getAttributeValue("line");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeValue(...)");
                int markerLine = Integer.parseInt(string4);
                String string5 = marker.getAttributeValue("start");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAttributeValue(...)");
                int markerStart = Integer.parseInt(string5);
                String string6 = marker.getAttributeValue("end");
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAttributeValue(...)");
                int markerEnd = Integer.parseInt(string6);
                String markerOrder = marker.getAttributeValue("order");
                Intrinsics.checkNotNull((Object)fragmentFile);
                String string7 = problemLocation.getLanguage();
                Intrinsics.checkNotNull((Object)string7);
                Location location2 = PhpGlobalOutputConsumerKt.getLocationByAttributes(fragmentFile, markerLine, markerStart, markerEnd, string7, macroManager);
                if (location2 != null) {
                    PropertyBag it2;
                    PropertyBag $this$map$iv3;
                    List list2;
                    Object object2;
                    List successors;
                    Iterable destination$iv$iv;
                    Object object3 = marker.getChild("successors");
                    if (object3 != null && (object3 = object3.getChildren("marker")) != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv2 = (Iterable)object3;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv2;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            Element element2 = (Element)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl = false;
                            object.add(p0.getText());
                        }
                        v8 = (List)destination$iv$iv;
                    } else {
                        v8 = successors = null;
                    }
                    if ((object2 = marker.getChild("predecessors")) != null && (object2 = object2.getChildren("marker")) != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv3 = (Iterable)object2;
                        boolean $i$f$map = false;
                        destination$iv$iv = $this$map$iv3;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void p0;
                            Element bl = (Element)item$iv$iv;
                            object = destination$iv$iv2;
                            boolean bl2 = false;
                            object.add(p0.getText());
                        }
                        list2 = (List)destination$iv$iv2;
                    } else {
                        list2 = null;
                    }
                    List predecessors = list2;
                    Intrinsics.checkNotNull((Object)marker);
                    List<String> sanitizedVulnerabilities = PhpGlobalOutputConsumerKt.getVulnerabilityValues(marker, "sanitized_vulnerabilities");
                    PropertyBag $i$f$map = $this$map$iv3 = new PropertyBag();
                    Node node = new Node(markerOrder).withLocation(location2);
                    object = nodes;
                    boolean bl = false;
                    ((Map)it2).put("successors", successors);
                    Unit unit = Unit.INSTANCE;
                    it2 = $this$map$iv3;
                    boolean bl3 = false;
                    ((Map)it2).put("predecessors", predecessors);
                    unit = Unit.INSTANCE;
                    it2 = $this$map$iv3;
                    boolean bl4 = false;
                    ((Map)it2).put("sanitized_vulnerabilities", sanitizedVulnerabilities);
                    unit = Unit.INSTANCE;
                    Node node2 = node.withProperties($this$map$iv3);
                    Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"withProperties(...)");
                    object.add(node2);
                    if (successors != null) {
                        for (String successor : successors) {
                            String edgeCnt = String.valueOf(edges.size() + 1);
                            edges.add(new Edge(edgeCnt, markerOrder, successor));
                        }
                    }
                }
                LocationRelationship locationRelationship = new LocationRelationship();
                Intrinsics.checkNotNull((Object)markerOrder);
                LocationRelationship locationRelationship2 = locationRelationship.withTarget(Integer.parseInt(markerOrder)).withKinds(SetsKt.setOf((Object)"includes"));
                Intrinsics.checkNotNullExpressionValue((Object)locationRelationship2, (String)"withKinds(...)");
                markerRelationships.add(locationRelationship2);
            }
            Intrinsics.checkNotNull((Object)fragmentFile);
            String string8 = problemLocation.getLanguage();
            Intrinsics.checkNotNull((Object)string8);
            Location location3 = PhpGlobalOutputConsumerKt.getLocationByAttributes(fragmentFile, fragmentLine, fragmentStart, fragmentEnd, string8, macroManager);
            if (location3 == null || (location = location3.withRelationships(markerRelationships)) == null) continue;
            Location it3 = location;
            boolean bl = false;
            fragmentLocations.add(it3);
        }
        Map<String, Object> sinkMap = PhpGlobalOutputConsumerKt.computeSink(problem);
        List<Map<String, Object>> sources = PhpGlobalOutputConsumerKt.computeSources(problem);
        PropertyBag fragmentStart = propertyBag = result.getProperties();
        object = result.withLocations(fragmentLocations).withGraphs(SetsKt.setOf((Object)new Graph().withNodes(nodes).withEdges(edges)));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        ((Map)it).put("sink", sinkMap);
        it = propertyBag;
        boolean bl5 = false;
        Intrinsics.checkNotNull((Object)it);
        ((Map)it).put("sources", sources);
        Result result2 = ((Result)object).withProperties(propertyBag);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"withProperties(...)");
        result = result2;
        return ElementToSarifConverter.INSTANCE.computeHash(result);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Map<String, Object>> computeSources(Element problem) {
        void $this$mapTo$iv$iv;
        List list2 = problem.getChild("sources").getChildren("source");
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"file", (Object)it.getAttributeValue("file"));
            Intrinsics.checkNotNull((Object)it);
            pairArray[1] = TuplesKt.to((Object)"sanitized_vulnerabilities", PhpGlobalOutputConsumerKt.getVulnerabilityValues((Element)it, "sanitized_vulnerabilities"));
            pairArray[2] = TuplesKt.to((Object)"text", (Object)it.getAttributeValue("text"));
            pairArray[3] = TuplesKt.to((Object)"order", (Object)it.getAttributeValue("order"));
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        return (List)destination$iv$iv;
    }

    private static final Map<String, Object> computeSink(Element problem) {
        Element sink = problem.getChild("sink");
        String sinkText = sink.getAttributeValue("text");
        String sinkFqn = sink.getAttributeValue("fqn");
        Intrinsics.checkNotNull((Object)sink);
        List<String> vulnerabilityValues = PhpGlobalOutputConsumerKt.getVulnerabilityValues(sink, "vulnerabilities");
        Object object = sink.getChild("parameters");
        String sinkParams = object != null && (object = object.getChildren("parameter")) != null && (object = (Element)CollectionsKt.firstOrNull((List)object)) != null ? object.getAttributeValue("name") : null;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)sinkText), TuplesKt.to((Object)"fqn", (Object)sinkFqn), TuplesKt.to((Object)"vulnerabilities", vulnerabilityValues), TuplesKt.to((Object)"parameters", (Object)sinkParams)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final Location getLocationByAttributes(String fileUrl, int line, int startCharOffset, int endCharOffset, String language, PathMacroManager macroManager) {
        ArtifactLocation artifactLocation = SarifKt.getArtifactLocation(fileUrl);
        PhysicalLocation physicalLocation = new PhysicalLocation().withArtifactLocation(artifactLocation);
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(macroManager.expandPath(fileUrl));
        String text2 = SarifKt.loadTextFromVirtualFile(virtualFile2);
        if (text2 != null) {
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)text2, (int)startCharOffset);
            if (lineColumn == null) {
                return null;
            }
            int it = lineColumn.column;
            boolean bl = false;
            int startColumn = it + 1;
            ArtifactContent snippet = new ArtifactContent().withText((String)text2.subSequence(startCharOffset, endCharOffset));
            physicalLocation.withRegion(PhpGlobalOutputConsumerKt.getPhpVulnerableRegion(startCharOffset, startColumn, endCharOffset - startCharOffset, line, language, snippet));
        }
        return new Location().withPhysicalLocation(physicalLocation);
    }

    private static final Region getPhpVulnerableRegion(Integer charOffset, Integer startColumn, Integer length, Integer line, String language, ArtifactContent snippet) {
        return new Region().withCharOffset(charOffset).withStartColumn(startColumn).withCharLength(length).withStartLine(line).withSourceLanguage(language).withSnippet(snippet);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getVulnerabilityValues(Element marker, String tag) {
        List vulnerabilities;
        if (marker.getChild(tag) != null && (vulnerabilities = marker.getChild(tag).getChildren("vulnerability")) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = vulnerabilities;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element2 = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAttributeValue("name"));
            }
            return (List)destination$iv$iv;
        }
        return null;
    }

    public static final /* synthetic */ Result access$convertPhpFromXmlFormat(Element problem, PathMacroManager macroManager) {
        return PhpGlobalOutputConsumerKt.convertPhpFromXmlFormat(problem, macroManager);
    }
}

