/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.run;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.run.QodanaConverterInput;
import org.jetbrains.qodana.run.QodanaConverterResults;
import org.jetbrains.qodana.sarif.QodanaReportConverter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0019\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006\u001a\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "runQodanaConverter", "Lorg/jetbrains/qodana/run/QodanaConverterResults;", "input", "Lorg/jetbrains/qodana/run/QodanaConverterInput;", "(Lorg/jetbrains/qodana/run/QodanaConverterInput;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getChildByRelativePath", "Ljava/nio/file/Path;", "childRelativePath", "", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nqodana-converter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 qodana-converter.kt\norg/jetbrains/qodana/run/Qodana_converterKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n10#2:55\n*S KotlinDebug\n*F\n+ 1 qodana-converter.kt\norg/jetbrains/qodana/run/Qodana_converterKt\n*L\n11#1:55\n*E\n"})
public final class Qodana_converterKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final Object runQodanaConverter(@NotNull QodanaConverterInput input, @NotNull Continuation<? super QodanaConverterResults> $completion) {
        return InterruptibleKt.runInterruptible((CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getIO(), (Function0)((Function0)new Function0<QodanaConverterResults>(input){
            final /* synthetic */ QodanaConverterInput $input;
            {
                this.$input = $input;
                super(0);
            }

            @NotNull
            public final QodanaConverterResults invoke() {
                Path converterTempDir = FileUtilRt.createTempDirectory((String)"qodana-converter", (String)"", (boolean)true).toPath();
                QodanaConverterInput qodanaConverterInput = this.$input;
                if (qodanaConverterInput instanceof QodanaConverterInput.FullQodanaOutput) {
                    File file = ((QodanaConverterInput.FullQodanaOutput)this.$input).getQodanaOutput().getPath().toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    File file2 = converterTempDir.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                    FilesKt.copyRecursively$default((File)file, (File)file2, (boolean)false, null, (int)6, null);
                } else if (qodanaConverterInput instanceof QodanaConverterInput.SarifFileOnly) {
                    File file = ((QodanaConverterInput.SarifFileOnly)this.$input).getSarifFile().toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    File file3 = converterTempDir.resolve("qodana.sarif.json").toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                    FilesKt.copyRecursively$default((File)file, (File)file3, (boolean)false, null, (int)6, null);
                }
                Path converterOutputPath = converterTempDir.resolve("converter-results");
                Files.createDirectories(converterOutputPath, new FileAttribute[0]);
                File file = converterTempDir.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                File file4 = converterOutputPath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"toFile(...)");
                new QodanaReportConverter(new QodanaReportConverter.Options(Integer.MAX_VALUE, file, file4)).convert();
                Qodana_converterKt.access$getLOG$p().info("Ran Qodana converter, results directory: " + converterOutputPath);
                Intrinsics.checkNotNull((Object)converterOutputPath);
                return new QodanaConverterResults(converterOutputPath);
            }
        }), $completion);
    }

    private static final Path getChildByRelativePath(Path $this$getChildByRelativePath, String childRelativePath) {
        Path childFullPath = $this$getChildByRelativePath.resolve(childRelativePath);
        return childFullPath.startsWith($this$getChildByRelativePath) ? childFullPath : null;
    }

    public static final /* synthetic */ Path access$getChildByRelativePath(Path $receiver, String childRelativePath) {
        return Qodana_converterKt.getChildByRelativePath($receiver, childRelativePath);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(QodanaConverterResults.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

