/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.EnabledInspectionsProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.license.FeaturesCheckKt;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionProfileLoader;
import org.jetbrains.qodana.staticAnalysis.profile.MainInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.ProfilesKt;
import org.jetbrains.qodana.staticAnalysis.profile.PromoInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;
import org.jetbrains.qodana.staticAnalysis.profile.SanityInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.providers.QodanaEmbeddedProfile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "", "mainGroup", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "additionalGroups", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "project", "Lcom/intellij/openapi/project/Project;", "licenseType", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "(Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;Ljava/util/List;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/license/QodanaLicenseType;)V", "allGroups", "getAllGroups", "()Ljava/util/List;", "effectiveProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "getEffectiveProfile", "()Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "effectiveProfile$delegate", "Lkotlin/Lazy;", "idToEffectiveGroup", "", "", "getIdToEffectiveGroup", "()Ljava/util/Map;", "getMainGroup", "()Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "addDependentTools", "", "from", "Lcom/intellij/codeInspection/ex/ToolsImpl;", "to", "checkUnknownScopes", "createState", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "Companion", "QodanaProfileState", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n1271#2,2:180\n1285#2,4:182\n1238#2,4:188\n1238#2,4:194\n453#3:186\n403#3:187\n468#3:192\n414#3:193\n10#4:198\n*S KotlinDebug\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile\n*L\n146#1:180,2\n146#1:182,4\n147#1:188,4\n149#1:194,4\n147#1:186\n147#1:187\n149#1:192\n149#1:193\n37#1:198\n*E\n"})
public final class QodanaProfile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MainInspectionGroup mainGroup;
    @NotNull
    private final List<NamedInspectionGroup> additionalGroups;
    @NotNull
    private final Project project;
    @NotNull
    private final QodanaLicenseType licenseType;
    @NotNull
    private final List<NamedInspectionGroup> allGroups;
    @NotNull
    private final Map<String, NamedInspectionGroup> idToEffectiveGroup;
    @NotNull
    private final Lazy effectiveProfile$delegate;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public QodanaProfile(@NotNull MainInspectionGroup mainGroup, @NotNull List<? extends NamedInspectionGroup> additionalGroups, @NotNull Project project2, @NotNull QodanaLicenseType licenseType) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)mainGroup, (String)"mainGroup");
        Intrinsics.checkNotNullParameter(additionalGroups, (String)"additionalGroups");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        this.mainGroup = mainGroup;
        this.additionalGroups = additionalGroups;
        this.project = project2;
        this.licenseType = licenseType;
        this.allGroups = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.mainGroup), (Iterable)this.additionalGroups);
        Map map3 = map2 = (Map)new LinkedHashMap();
        QodanaProfile qodanaProfile = this;
        boolean bl = false;
        for (NamedInspectionGroup group : this.allGroups) {
            for (ToolsImpl tool : group.getProfile().getTools()) {
                void $this$idToEffectiveGroup_u24lambda_u240;
                if (!tool.isEnabled()) continue;
                $this$idToEffectiveGroup_u24lambda_u240.putIfAbsent(tool.getShortName(), group);
            }
        }
        qodanaProfile.idToEffectiveGroup = map2;
        this.effectiveProfile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<QodanaInspectionProfile>(this){
            final /* synthetic */ QodanaProfile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final QodanaInspectionProfile invoke() {
                void $this$forEach$iv;
                QodanaInspectionProfile effectiveProfile2 = QodanaInspectionProfile.Companion.newWithDisabledTools("qodana.effective.profile", QodanaInspectionProfileManager.Companion.getInstance(QodanaProfile.access$getProject$p(this.this$0)));
                for (NamedInspectionGroup group : this.this$0.getAllGroups()) {
                    for (ToolsImpl from : group.getProfile().getTools()) {
                        ToolsImpl to;
                        if (!from.isEnabled() || !Intrinsics.areEqual((Object)group, (Object)this.this$0.getIdToEffectiveGroup().get(from.getShortName())) || (to = effectiveProfile2.getToolsOrNull(from.getShortName(), QodanaProfile.access$getProject$p(this.this$0))) == null) continue;
                        Intrinsics.checkNotNull((Object)from);
                        ProfilesKt.copyTool(to, from, QodanaProfile.access$getProject$p(this.this$0));
                        QodanaProfile.access$addDependentTools(this.this$0, from, effectiveProfile2);
                    }
                }
                Collection collection = effectiveProfile2.getTools();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTools(...)");
                Iterable iterable = collection;
                QodanaProfile qodanaProfile = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ToolsImpl tool = (ToolsImpl)element$iv;
                    boolean bl = false;
                    QodanaLicenseType qodanaLicenseType = QodanaProfile.access$getLicenseType$p(qodanaProfile);
                    Intrinsics.checkNotNull((Object)tool);
                    if (FeaturesCheckKt.isInspectionLicensed(qodanaLicenseType, tool)) continue;
                    tool.setEnabled(false);
                }
                QodanaProfile.access$checkUnknownScopes(this.this$0, effectiveProfile2);
                return effectiveProfile2;
            }
        }));
    }

    @NotNull
    public final MainInspectionGroup getMainGroup() {
        return this.mainGroup;
    }

    @NotNull
    public final List<NamedInspectionGroup> getAllGroups() {
        return this.allGroups;
    }

    @NotNull
    public final Map<String, NamedInspectionGroup> getIdToEffectiveGroup() {
        return this.idToEffectiveGroup;
    }

    @NotNull
    public final QodanaInspectionProfile getEffectiveProfile() {
        Lazy lazy = this.effectiveProfile$delegate;
        return (QodanaInspectionProfile)((Object)lazy.getValue());
    }

    private final void checkUnknownScopes(QodanaInspectionProfile effectiveProfile2) {
        List list2 = effectiveProfile2.getAllEnabledInspectionTools(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllEnabledInspectionTools(...)");
        List tools = list2;
        Set seen = new LinkedHashSet();
        for (Tools tool : tools) {
            for (ScopeToolState scopeState : tool.getTools()) {
                if (scopeState.getScope(this.project) != null) continue;
                String string = scopeState.getScopeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScopeName(...)");
                if (!seen.add(string)) continue;
                LOG.warn("Unknown scope in profile: '" + scopeState.getScopeName() + "'");
            }
        }
    }

    private final void addDependentTools(ToolsImpl from, QodanaInspectionProfile to) {
        InspectionProfileEntry tool = from.getDefaultState().getTool().getTool();
        if (tool instanceof DynamicGroupTool) {
            for (LocalInspectionToolWrapper child : ((DynamicGroupTool)tool).getChildren()) {
                to.addTool(this.project, (InspectionToolWrapper)child, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QodanaProfileState createState(@NotNull QodanaGlobalInspectionContext context) {
        Map map2;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map.Entry it$iv$iv;
        Object object;
        Map.Entry entry;
        void $this$mapValuesTo$iv$iv;
        NamedInspectionGroup.State state;
        Map map3;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        MainInspectionGroup.State mainState = this.mainGroup.createState(context);
        Iterable $this$associateWith$iv = this.additionalGroups;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv$iv = iterator.next();
            NamedInspectionGroup namedInspectionGroup = (NamedInspectionGroup)element$iv$iv;
            object2 = element$iv$iv;
            map3 = result$iv;
            boolean bl = false;
            state = it.createState(context);
            map3.put(object2, state);
        }
        Map states = MapsKt.plus((Map)result$iv, (Pair)TuplesKt.to((Object)this.mainGroup, (Object)mainState));
        Map $this$mapValues$iv = this.idToEffectiveGroup;
        boolean $i$f$mapValues = false;
        $this$associateWithTo$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl3 = false;
            object = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            map3 = map4;
            boolean bl2 = false;
            NamedInspectionGroup value2 = (NamedInspectionGroup)object.getValue();
            Object v = states.get(value2);
            Intrinsics.checkNotNull(v);
            state = (NamedInspectionGroup.State)v;
            map3.put(object2, state);
        }
        Map statesMap = destination$iv$iv;
        $this$mapValues$iv = states;
        Map map5 = statesMap;
        state = mainState;
        boolean $i$f$mapKeys = false;
        $this$mapValuesTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv2;
            void it;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            object = ((NamedInspectionGroup)it.getKey()).getName();
            Map map6 = map2;
            boolean bl4 = false;
            entry = it$iv$iv2.getValue();
            map6.put(object, entry);
        }
        Map map7 = map2 = destination$iv$iv;
        Map map8 = map5;
        NamedInspectionGroup.State state2 = state;
        return new QodanaProfileState((MainInspectionGroup.State)state2, map8, map7);
    }

    public static final /* synthetic */ Project access$getProject$p(QodanaProfile $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$addDependentTools(QodanaProfile $this, ToolsImpl from, QodanaInspectionProfile to) {
        $this.addDependentTools(from, to);
    }

    public static final /* synthetic */ void access$checkUnknownScopes(QodanaProfile $this, QodanaInspectionProfile effectiveProfile2) {
        $this.checkUnknownScopes(effectiveProfile2);
    }

    public static final /* synthetic */ QodanaLicenseType access$getLicenseType$p(QodanaProfile $this) {
        return $this.licenseType;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(QodanaProfile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isRecommendedOrStarter", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "(Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;)Z", "create", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "project", "Lcom/intellij/openapi/project/Project;", "mainInspectionProfile", "inspectionProfileLoader", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionProfileLoader;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "sanity", "promo", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nQodanaProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,179:1\n1247#2,2:180\n*S KotlinDebug\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$Companion\n*L\n85#1:180,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaProfile create(@NotNull Project project2, @NotNull QodanaInspectionProfile mainInspectionProfile, @NotNull QodanaInspectionProfileLoader inspectionProfileLoader, @NotNull QodanaConfig config, boolean sanity, boolean promo) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)mainInspectionProfile), (String)"mainInspectionProfile");
            Intrinsics.checkNotNullParameter((Object)((Object)inspectionProfileLoader), (String)"inspectionProfileLoader");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            boolean addDefaultExclude = this.isRecommendedOrStarter(mainInspectionProfile);
            List inspectionGroups = new ArrayList();
            if (sanity) {
                String sanityProfileName = System.getProperty("qodana.sanity.profile.name", "qodana.sanity");
                Intrinsics.checkNotNull((Object)sanityProfileName);
                QodanaInspectionProfile sanityProfile = inspectionProfileLoader.loadProfileByName(sanityProfileName);
                if (sanityProfile != null) {
                    inspectionGroups.add(new SanityInspectionGroup("sanity", sanityProfile).applyConfig(config, project2, addDefaultExclude));
                    LOG.info("The '" + sanityProfileName + "' profile is configured for sanity checks");
                } else {
                    LOG.warn("Can't load the '" + sanityProfileName + "' sanity profile. Running sanity inspections is disabled.");
                }
            }
            if (promo) {
                String promoProfileName = System.getProperty("qodana.promo.profile.name", "qodana.recommended");
                Intrinsics.checkNotNull((Object)promoProfileName);
                QodanaInspectionProfile promoProfile = inspectionProfileLoader.loadProfileByName(promoProfileName);
                if (promoProfile != null) {
                    inspectionGroups.add(new PromoInspectionGroup("promo", promoProfile).applyConfig(config, project2, addDefaultExclude));
                    LOG.info("The '" + promoProfileName + "' profile is configured for promo checks");
                } else {
                    LOG.warn("Can't load the '" + promoProfileName + "' promo profile. Running promo inspections is disabled.");
                }
            }
            MainInspectionGroup userGroup = new MainInspectionGroup(mainInspectionProfile).applyConfig(config, project2, addDefaultExclude);
            return new QodanaProfile(userGroup, inspectionGroups, project2, config.getLicenseType());
        }

        private final boolean isRecommendedOrStarter(QodanaInspectionProfile $this$isRecommendedOrStarter) {
            boolean bl;
            block1: {
                QodanaEmbeddedProfile[] qodanaEmbeddedProfileArray = new QodanaEmbeddedProfile[]{QodanaEmbeddedProfile.QODANA_RECOMMENDED_OLD, QodanaEmbeddedProfile.QODANA_STARTER_OLD};
                Sequence $this$any$iv = SequencesKt.sequenceOf((Object[])qodanaEmbeddedProfileArray);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    QodanaEmbeddedProfile it = (QodanaEmbeddedProfile)((Object)element$iv);
                    boolean bl2 = false;
                    String string = $this$isRecommendedOrStarter.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!it.matchesName(string)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BA\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\t0\u0006\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\t0\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0010J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "", "mainState", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "stateByInspectionId", "", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "stateByGroupName", "(Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;Ljava/util/Map;Ljava/util/Map;)V", "getMainState", "()Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "receivedCounters", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getStateByGroupName", "()Ljava/util/Map;", "getStateByInspectionId", "dump", "", "onFinish", "onReceive", "inspectionId", "size", "shouldSkip", "", "file", "Lcom/intellij/psi/PsiFile;", "wrappers", "Lcom/intellij/codeInspection/ex/EnabledInspectionsProvider$ToolWrappers;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nQodanaProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1855#2,2:180\n*S KotlinDebug\n*F\n+ 1 QodanaProfile.kt\norg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState\n*L\n176#1:180,2\n*E\n"})
    public static final class QodanaProfileState {
        @NotNull
        private final MainInspectionGroup.State mainState;
        @NotNull
        private final Map<String, NamedInspectionGroup.State> stateByInspectionId;
        @NotNull
        private final Map<String, NamedInspectionGroup.State> stateByGroupName;
        @NotNull
        private final ConcurrentHashMap<String, Integer> receivedCounters;

        public QodanaProfileState(@NotNull MainInspectionGroup.State mainState, @NotNull Map<String, ? extends NamedInspectionGroup.State> stateByInspectionId, @NotNull Map<String, ? extends NamedInspectionGroup.State> stateByGroupName) {
            Intrinsics.checkNotNullParameter((Object)mainState, (String)"mainState");
            Intrinsics.checkNotNullParameter(stateByInspectionId, (String)"stateByInspectionId");
            Intrinsics.checkNotNullParameter(stateByGroupName, (String)"stateByGroupName");
            this.mainState = mainState;
            this.stateByInspectionId = stateByInspectionId;
            this.stateByGroupName = stateByGroupName;
            this.receivedCounters = new ConcurrentHashMap();
        }

        @NotNull
        public final MainInspectionGroup.State getMainState() {
            return this.mainState;
        }

        @NotNull
        public final Map<String, NamedInspectionGroup.State> getStateByInspectionId() {
            return this.stateByInspectionId;
        }

        @NotNull
        public final Map<String, NamedInspectionGroup.State> getStateByGroupName() {
            return this.stateByGroupName;
        }

        public final void onReceive(@NotNull String inspectionId, int size) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            this.receivedCounters.compute(inspectionId, new BiFunction(size){
                final /* synthetic */ int $size;
                {
                    this.$size = $size;
                }

                @Nullable
                public final Integer apply(@NotNull String string, @Nullable Integer v) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    Integer n = v;
                    return n == null ? Integer.valueOf(this.$size) : Integer.valueOf(n + this.$size);
                }
            });
        }

        public final void dump() {
            Set<Map.Entry<String, Integer>> set = this.receivedCounters.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            String receivedMessage2 = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.receivedMessage.1.INSTANCE, (int)30, null);
            LOG.debug("Received counters:\n " + receivedMessage2);
        }

        public final boolean shouldSkip(@NotNull String inspectionId, @NotNull PsiFile file, @NotNull EnabledInspectionsProvider.ToolWrappers wrappers) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)wrappers, (String)"wrappers");
            NamedInspectionGroup.State state = this.stateByInspectionId.get(inspectionId);
            return state != null ? state.shouldSkip(inspectionId, file, wrappers) : true;
        }

        public final void onFinish() {
            Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)this.stateByInspectionId.values());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NamedInspectionGroup.State it = (NamedInspectionGroup.State)element$iv;
                boolean bl = false;
                it.onFinish();
            }
        }
    }
}

