/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionDurationsAggregatorService;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionEventsCollector;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionFingerprintAggregatorService;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionInfoQodanaReporterService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016JJ\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionEventsListener;", "Lcom/intellij/codeInspection/ex/InspectListener;", "()V", "verboseLogging", "", "activityFinished", "", "duration", "", "threadId", "activityKind", "Lcom/intellij/codeInspection/ex/InspectListener$ActivityKind;", "project", "Lcom/intellij/openapi/project/Project;", "fileAnalyzed", "file", "Lcom/intellij/psi/PsiFile;", "inspectionFinished", "problemsCount", "", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "intellij.qodana"})
public final class InspectionEventsListener
implements InspectListener {
    private final boolean verboseLogging = Boolean.getBoolean("qodana.verbose.inspections.statistic");

    public void inspectionFinished(long duration, long threadId, int problemsCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull InspectListener.InspectionKind kind, @Nullable PsiFile file, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && this.verboseLogging) {
            InspectionEventsCollector.logInspectionFinished(duration, threadId, problemsCount, tool, kind, project2);
        }
        InspectionDurationsAggregatorService service = (InspectionDurationsAggregatorService)project2.getService(InspectionDurationsAggregatorService.class);
        service.addInspectionFinishedEvent(duration, problemsCount, tool, kind);
        PsiFile psiFile2 = file;
        ((InspectionInfoQodanaReporterService)project2.getService(InspectionInfoQodanaReporterService.class)).addInspectionFinishedEvent(duration, problemsCount, tool, kind, (VirtualFile)(psiFile2 != null ? psiFile2.getVirtualFile() : null));
    }

    public void activityFinished(long duration, long threadId, @NotNull InspectListener.ActivityKind activityKind, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)activityKind, (String)"activityKind");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && this.verboseLogging) {
            InspectionEventsCollector.logActivityFinished(duration, threadId, activityKind, project2);
        }
    }

    public void fileAnalyzed(@NotNull PsiFile file, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ((InspectionFingerprintAggregatorService)project2.getService(InspectionFingerprintAggregatorService.class)).registerAnalyzedFile(file);
    }
}

