/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.inspectionProfile.InspectionCategoryGroupProviderKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionInfoQodanaReporterService;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0007\u0018\u0000 02\u00020\u0001:\u000501234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0017\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\"H\u0002\u00f8\u0001\u0000J\u0010\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0006\u0010%\u001a\u00020\u0016J\u0006\u0010&\u001a\u00020\u0016J\u0015\u0010'\u001a\u00020(*\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0082\u0002J\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+*\u00020\u0007H\u0002J\u001d\u0010,\u001a\u00020\n\"\u0004\b\u0000\u0010-*\b\u0012\u0004\u0012\u0002H-0.H\u0002\u00a2\u0006\u0002\u0010/J\u0018\u0010,\u001a\u00020\n\"\u0004\b\u0000\u0010-*\b\u0012\u0004\u0012\u0002H-0+H\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "directoriesInspectionGroupsInfos", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection;", "inspectionsSummaryInfo", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionKey;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionInfo;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectRoot", "sumOfAllInspectionDurations", "Ljava/util/concurrent/atomic/AtomicLong;", "timeFirstInspectionStarted", "timeLastInspectionFinished", "", "addInspectionFinishedEvent", "", "duration", "problemsCount", "", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "file", "inspectionAbsoluteTime", "inspectionsDuration", "inspectionGroupsInfosAllProjectDirectories", "", "inspectionTimeProportionFromTotal", "", "logDirectoriesInspectionsInfo", "logInspectionsSummaryInfo", "contains", "", "other", "directoriesToProjectRoot", "", "toCSVLine", "T", "", "([Ljava/lang/Object;)Ljava/lang/String;", "Companion", "FinishedInspectionDescriptor", "InspectionGroup", "InspectionGroupsInfosCollection", "InspectionInfo", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nInspectionInfoQodanaReporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1054#2:334\n1855#2,2:335\n1855#2,2:337\n1045#2:342\n1855#2:344\n1855#2,2:345\n1856#2:347\n1549#2:348\n1620#2,3:349\n1855#2,2:352\n1549#2:354\n1620#2,3:355\n3792#3:339\n4307#3,2:340\n1#4:343\n*S KotlinDebug\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService\n*L\n206#1:334\n207#1:335,2\n230#1:337,2\n268#1:342\n292#1:344\n293#1:345,2\n292#1:347\n241#1:348\n241#1:349,3\n242#1:352,2\n59#1:354\n59#1:355,3\n267#1:339\n267#1:340,2\n*E\n"})
public final class InspectionInfoQodanaReporterService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, InspectionInfo> inspectionsSummaryInfo;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, InspectionGroupsInfosCollection> directoriesInspectionGroupsInfos;
    @NotNull
    private final AtomicLong timeFirstInspectionStarted;
    private long timeLastInspectionFinished;
    @NotNull
    private final AtomicLong sumOfAllInspectionDurations;
    @Nullable
    private final VirtualFile projectRoot;
    @NotNull
    private static final List<InspectionGroup> _inspectionGroups;
    @NotNull
    private static final List<InspectionGroup> inspectionGroups;
    @NotNull
    private static Map<String, Integer> mapInspectionGroupNameToIdx;

    public InspectionInfoQodanaReporterService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.inspectionsSummaryInfo = new ConcurrentHashMap();
        this.directoriesInspectionGroupsInfos = new ConcurrentHashMap();
        this.timeFirstInspectionStarted = new AtomicLong(-1L);
        this.sumOfAllInspectionDurations = new AtomicLong(0L);
        this.projectRoot = ProjectUtil.guessProjectDir((Project)this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void addInspectionFinishedEvent(long duration, int problemsCount, @NotNull InspectionToolWrapper<?, ?> tool, @NotNull InspectListener.InspectionKind kind, @Nullable VirtualFile file) {
        block2: {
            VirtualFile inspectedDirectory;
            Intrinsics.checkNotNullParameter(tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            long curTime = System.currentTimeMillis();
            this.timeFirstInspectionStarted.compareAndSet(-1L, curTime - duration);
            this.timeLastInspectionFinished = curTime;
            this.sumOfAllInspectionDurations.addAndGet(duration);
            FinishedInspectionDescriptor finishedInspection = new FinishedInspectionDescriptor(duration, problemsCount, kind, tool);
            this.inspectionsSummaryInfo.compute(finishedInspection.getInspectionKey(), new BiFunction(finishedInspection){
                final /* synthetic */ FinishedInspectionDescriptor $finishedInspection;
                {
                    this.$finishedInspection = $finishedInspection;
                }

                @Nullable
                public final InspectionInfo apply(@NotNull String string, @Nullable InspectionInfo v) {
                    InspectionInfo inspectionInfo;
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    if (v == null) {
                        inspectionInfo = new InspectionInfo(this.$finishedInspection);
                    } else {
                        v.addFinishedInspection(this.$finishedInspection);
                        inspectionInfo = v;
                    }
                    return inspectionInfo;
                }
            });
            VirtualFile virtualFile2 = file;
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.getParent()) == null) {
                virtualFile2 = this.projectRoot;
            }
            VirtualFile virtualFile3 = inspectedDirectory = virtualFile2;
            if (virtualFile3 == null) break block2;
            VirtualFile it = virtualFile3;
            boolean bl = false;
            InspectionGroupsInfosCollection inspectionGroupsInfosCollection = this.directoriesInspectionGroupsInfos.compute(it, new BiFunction(finishedInspection){
                final /* synthetic */ FinishedInspectionDescriptor $finishedInspection;
                {
                    this.$finishedInspection = $finishedInspection;
                }

                @Nullable
                public final InspectionGroupsInfosCollection.InspectionGroupInfo[] apply-CgQYNPs(@NotNull VirtualFile virtualFile2, @Nullable InspectionGroupsInfosCollection.InspectionGroupInfo[] v) {
                    Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"<anonymous parameter 0>");
                    InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupInfoArray = v;
                    if (v == null) {
                        inspectionGroupInfoArray = InspectionGroupsInfosCollection.constructor-impl$default(null, 1, null);
                    }
                    InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupsInfos = inspectionGroupInfoArray;
                    InspectionGroupsInfosCollection.addFinishedInspection-impl(inspectionGroupsInfos, this.$finishedInspection);
                    return inspectionGroupsInfos;
                }
            });
            Object object = inspectionGroupsInfosCollection != null ? inspectionGroupsInfosCollection.unbox-impl() : null;
            InspectionGroupsInfosCollection inspectionGroupsInfosCollection2 = object != null ? InspectionGroupsInfosCollection.box-impl(object) : null;
            if (inspectionGroupsInfosCollection2 != null) {
                inspectionGroupsInfosCollection2.unbox-impl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void logInspectionsSummaryInfo() {
        String[] stringArray = new String[]{"Inspection ID", "Inspection Group", "Inspection Name", "Inspection Language", "Inspection Type", "Absolute Time spent on Inspection, s", "Percent of Time spent on Inspection", "Problems Count", "Times Inspection was Performed"};
        String headerCSV = this.toCSVLine(stringArray);
        Object object = new String[]{"qodana_inspections_summary.csv"};
        File logFile = Paths.get(PathManager.getLogPath(), object).toFile();
        if (logFile.isFile()) {
            logFile.delete();
        }
        Intrinsics.checkNotNull((Object)logFile);
        object = logFile;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            void $this$forEach$iv;
            Iterable $this$sortedByDescending$iv;
            BufferedWriter bw = (BufferedWriter)object;
            boolean bl = false;
            bw.write(headerCSV);
            Collection<InspectionInfo> collection = this.inspectionsSummaryInfo.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    InspectionInfo it = (InspectionInfo)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getDuration());
                    it = (InspectionInfo)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getDuration()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InspectionInfo inspectionInfo = (InspectionInfo)element$iv;
                boolean bl2 = false;
                bw.newLine();
                Object[] objectArray = new Object[9];
                objectArray[0] = inspectionInfo.getId();
                objectArray[1] = inspectionInfo.getGroupPath();
                objectArray[2] = inspectionInfo.getDisplayName();
                objectArray[3] = inspectionInfo.getLanguage();
                objectArray[4] = inspectionInfo.getKind();
                String string = "%.2f";
                Object[] objectArray2 = new Object[]{(double)this.inspectionAbsoluteTime(inspectionInfo.getDuration()) / 1000.0};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(this, *args)");
                string = "%.2f%%";
                objectArray2 = new Object[]{this.inspectionTimeProportionFromTotal(inspectionInfo.getDuration()) * (double)100};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(this, *args)");
                objectArray[7] = inspectionInfo.getProblemsCount();
                objectArray[8] = inspectionInfo.getPerformedTimesCount();
                bw.write(this.toCSVLine(objectArray));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void logDirectoriesInspectionsInfo() {
        if (this.projectRoot == null) {
            return;
        }
        List valuesToPrintBuffer = new ArrayList();
        Iterable $this$forEach$iv = inspectionGroups;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectionGroup it = (InspectionGroup)element$iv;
            boolean bl = false;
            valuesToPrintBuffer.add("Absolute Time spent on Inspection Group '" + it.getGroupName() + "', s");
            valuesToPrintBuffer.add("Percent of Time spent on Inspection Group '" + it.getGroupName() + "'");
            valuesToPrintBuffer.add("Inspections Problem Count in Group '" + it.getGroupName() + "'");
            valuesToPrintBuffer.add("Times Inspection from Group '" + it.getGroupName() + "' was Performed");
        }
        String[] $i$f$forEach22 = new String[]{"Directory", this.toCSVLine(valuesToPrintBuffer)};
        String headerCSV = this.toCSVLine($i$f$forEach22);
        Object object = new String[]{"qodana_directories_inspection_groups.csv"};
        File logFile = Paths.get(PathManager.getLogPath(), object).toFile();
        if (logFile.isFile()) {
            logFile.delete();
        }
        Intrinsics.checkNotNull((Object)logFile);
        object = logFile;
        Object object2 = Charsets.UTF_8;
        int it = 8192;
        Object bl = object;
        bl = new OutputStreamWriter((OutputStream)new FileOutputStream((File)bl), (Charset)object2);
        object = bl instanceof BufferedWriter ? (BufferedWriter)bl : new BufferedWriter((Writer)bl, it);
        object2 = null;
        try {
            BufferedWriter bw = (BufferedWriter)object;
            boolean bl2 = false;
            bw.write(headerCSV);
            Map<VirtualFile, InspectionGroupsInfosCollection> infosAllInspectedDirectories = this.inspectionGroupsInfosAllProjectDirectories();
            ArrayDeque directoriesStackDFS = new ArrayDeque();
            directoriesStackDFS.add((Object)this.projectRoot);
            while (!directoriesStackDFS.isEmpty()) {
                List inspectedSubDirectories;
                block14: {
                    Object object3;
                    String[] stringArray;
                    InspectionInfoQodanaReporterService inspectionInfoQodanaReporterService;
                    BufferedWriter bufferedWriter;
                    VirtualFile curDirectory;
                    block16: {
                        block15: {
                            void it2;
                            void $this$sortedBy$iv;
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            curDirectory = (VirtualFile)directoriesStackDFS.removeLast();
                            VirtualFile[] virtualFileArray = curDirectory.getChildren();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                            Object[] objectArray = virtualFileArray;
                            boolean $i$f$filter = false;
                            VirtualFile virtualFile2 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (void element$iv$iv : $this$filterTo$iv$iv) {
                                VirtualFile it3 = (VirtualFile)element$iv$iv;
                                boolean bl3 = false;
                                if (!infosAllInspectedDirectories.containsKey(it3)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            boolean $i$f$sortedBy = false;
                            inspectedSubDirectories = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(infosAllInspectedDirectories){
                                final /* synthetic */ Map $infosAllInspectedDirectories$inlined;
                                {
                                    this.$infosAllInspectedDirectories$inlined = map2;
                                }

                                public final int compare(T a, T b) {
                                    VirtualFile it = (VirtualFile)a;
                                    boolean bl = false;
                                    V v = this.$infosAllInspectedDirectories$inlined.get(it);
                                    Intrinsics.checkNotNull(v);
                                    it = (VirtualFile)b;
                                    Comparable comparable = Long.valueOf(InspectionGroupsInfosCollection.get-impl(((InspectionGroupsInfosCollection)v).unbox-impl(), "all").getInspectionsDuration());
                                    bl = false;
                                    V v2 = this.$infosAllInspectedDirectories$inlined.get(it);
                                    Intrinsics.checkNotNull(v2);
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(InspectionGroupsInfosCollection.get-impl(((InspectionGroupsInfosCollection)v2).unbox-impl(), "all").getInspectionsDuration()));
                                }
                            });
                            boolean directoryContainsInspectedFiles = this.directoriesInspectionGroupsInfos.containsKey(curDirectory);
                            if (inspectedSubDirectories.size() <= 1 && !directoryContainsInspectedFiles) break block14;
                            bw.newLine();
                            bufferedWriter = bw;
                            inspectionInfoQodanaReporterService = this;
                            String[] stringArray2 = stringArray = new String[2];
                            int n = 0;
                            virtualFile2 = this.projectRoot.getParent();
                            object3 = virtualFile2;
                            if (object3 == null) break block15;
                            Intrinsics.checkNotNull((Object)object3);
                            VirtualFile virtualFile3 = virtualFile2;
                            int n2 = n;
                            String[] stringArray3 = stringArray2;
                            InspectionInfoQodanaReporterService inspectionInfoQodanaReporterService2 = inspectionInfoQodanaReporterService;
                            BufferedWriter bufferedWriter2 = bufferedWriter;
                            boolean bl4 = false;
                            String string = VfsUtil.getRelativePath((VirtualFile)it2, (VirtualFile)curDirectory);
                            bufferedWriter = bufferedWriter2;
                            inspectionInfoQodanaReporterService = inspectionInfoQodanaReporterService2;
                            stringArray2 = stringArray3;
                            n = n2;
                            String string2 = string;
                            object3 = string2;
                            if (string2 != null) break block16;
                        }
                        object3 = curDirectory.getPath();
                    }
                    stringArray2[n] = object3;
                    InspectionGroupsInfosCollection inspectionGroupsInfosCollection = infosAllInspectedDirectories.get(curDirectory);
                    Intrinsics.checkNotNull((Object)inspectionGroupsInfosCollection);
                    stringArray[1] = InspectionInfoQodanaReporterService.logDirectoriesInspectionsInfo$inspectionGroupsInfosToCSVLine(valuesToPrintBuffer, this, inspectionGroupsInfosCollection.unbox-impl());
                    bufferedWriter.write(inspectionInfoQodanaReporterService.toCSVLine(stringArray));
                }
                directoriesStackDFS.addAll((Collection)inspectedSubDirectories);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private final Map<VirtualFile, InspectionGroupsInfosCollection> inspectionGroupsInfosAllProjectDirectories() {
        Map infosAllDirectories = new LinkedHashMap();
        Set<Map.Entry<VirtualFile, InspectionGroupsInfosCollection>> set = this.directoriesInspectionGroupsInfos.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            VirtualFile directory = (VirtualFile)entry.getKey();
            InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupsInfos = ((InspectionGroupsInfosCollection)entry.getValue()).unbox-impl();
            Intrinsics.checkNotNull((Object)directory);
            Iterable $this$forEach$iv2 = this.directoriesToProjectRoot(directory);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VirtualFile it = (VirtualFile)element$iv2;
                boolean bl2 = false;
                infosAllDirectories.compute(it, new BiFunction(inspectionGroupsInfos){
                    final /* synthetic */ InspectionGroupsInfosCollection.InspectionGroupInfo[] $inspectionGroupsInfos;
                    {
                        this.$inspectionGroupsInfos = $inspectionGroupsInfos;
                    }

                    @Nullable
                    public final InspectionGroupsInfosCollection.InspectionGroupInfo[] apply-CgQYNPs(@NotNull VirtualFile virtualFile2, @Nullable InspectionGroupsInfosCollection.InspectionGroupInfo[] v) {
                        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"<anonymous parameter 0>");
                        InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupInfoArray = v;
                        if (v == null) {
                            inspectionGroupInfoArray = InspectionGroupsInfosCollection.constructor-impl$default(null, 1, null);
                        }
                        InspectionGroupsInfosCollection.InspectionGroupInfo[] groupInfos = inspectionGroupInfoArray;
                        InspectionGroupsInfosCollection.add-x7W0VSw(groupInfos, this.$inspectionGroupsInfos);
                        return groupInfos;
                    }
                });
            }
        }
        return infosAllDirectories;
    }

    private final List<VirtualFile> directoriesToProjectRoot(VirtualFile $this$directoriesToProjectRoot) {
        List directories = new ArrayList();
        if (this.projectRoot == null) {
            return directories;
        }
        for (VirtualFile directory = $this$directoriesToProjectRoot; directory != null && this.contains(this.projectRoot, directory); directory = directory.getParent()) {
            directories.add(directory);
        }
        directories.add(this.projectRoot);
        return directories;
    }

    private final double inspectionTimeProportionFromTotal(long inspectionsDuration) {
        return (double)inspectionsDuration / (double)this.sumOfAllInspectionDurations.get();
    }

    private final long inspectionAbsoluteTime(long inspectionsDuration) {
        return (long)(this.inspectionTimeProportionFromTotal(inspectionsDuration) * (double)(this.timeLastInspectionFinished - this.timeFirstInspectionStarted.get()));
    }

    private final boolean contains(VirtualFile $this$contains, VirtualFile other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        return VfsUtil.isAncestor((VirtualFile)$this$contains, (VirtualFile)other, (boolean)true);
    }

    private final <T> String toCSVLine(T[] $this$toCSVLine) {
        return ArraysKt.joinToString$default((Object[])$this$toCSVLine, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
    }

    private final <T> String toCSVLine(List<? extends T> $this$toCSVLine) {
        return CollectionsKt.joinToString$default((Iterable)$this$toCSVLine, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String logDirectoriesInspectionsInfo$inspectionGroupsInfosToCSVLine(List<Object> valuesToPrintBuffer, InspectionInfoQodanaReporterService this$0, InspectionGroupsInfosCollection.InspectionGroupInfo[] inspectionGroupsInfos) {
        Object[] objectArray;
        void $this$mapTo$iv$iv;
        valuesToPrintBuffer.clear();
        Iterable $this$map$iv = inspectionGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            objectArray = (Object[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(InspectionGroupsInfosCollection.get-impl(inspectionGroupsInfos, it.getGroupName()));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InspectionGroupsInfosCollection.InspectionGroupInfo inspectionGroupInfo = (InspectionGroupsInfosCollection.InspectionGroupInfo)element$iv;
            boolean bl = false;
            String string = "%.2f";
            objectArray = new Object[]{(double)this$0.inspectionAbsoluteTime(inspectionGroupInfo.getInspectionsDuration()) / 1000.0};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            valuesToPrintBuffer.add(string2);
            string = "%.2f%%";
            objectArray = new Object[]{this$0.inspectionTimeProportionFromTotal(inspectionGroupInfo.getInspectionsDuration()) * (double)100};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
            valuesToPrintBuffer.add(string3);
            valuesToPrintBuffer.add(inspectionGroupInfo.getProblemsCount());
            valuesToPrintBuffer.add(inspectionGroupInfo.getPerformedTimesCount());
        }
        return this$0.toCSVLine(valuesToPrintBuffer);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new InspectionGroup[]{new InspectionGroup("all", (Function1<? super FinishedInspectionDescriptor, Boolean>)((Function1)Companion._inspectionGroups.1.INSTANCE))};
        _inspectionGroups = CollectionsKt.mutableListOf((Object[])objectArray);
        List<InspectionGroup> list2 = _inspectionGroups;
        Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.qodana.staticAnalysis.stat.InspectionInfoQodanaReporterService.InspectionGroup>");
        inspectionGroups = list2;
        Iterable $this$map$iv = inspectionGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InspectionGroup inspectionGroup = (InspectionGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGroupName());
        }
        mapInspectionGroupNameToIdx = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)var3_3), (Iterable)((Iterable)CollectionsKt.getIndices((Collection)inspectionGroups))));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\fJ\b\u0010\u0017\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$Companion;", "", "()V", "_inspectionGroups", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "inspectionGroups", "", "getInspectionGroups", "()Ljava/util/List;", "mapInspectionGroupNameToIdx", "", "", "", "addInspectionGroup", "", "inspectionGroup", "getInstance", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService;", "project", "Lcom/intellij/openapi/project/Project;", "removeInspectionGroupByName", "groupName", "updateMapInspectionGroupNameToIdx", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionInfoQodanaReporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n30#2,3:334\n1549#3:337\n1620#3,3:338\n*S KotlinDebug\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$Companion\n*L\n40#1:334,3\n62#1:337\n62#1:338,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<InspectionGroup> getInspectionGroups() {
            return inspectionGroups;
        }

        @NotNull
        public final InspectionInfoQodanaReporterService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<InspectionInfoQodanaReporterService> serviceClass$iv = InspectionInfoQodanaReporterService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (InspectionInfoQodanaReporterService)object;
        }

        public final void addInspectionGroup(@NotNull InspectionGroup inspectionGroup) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
            boolean bl2 = bl = !Intrinsics.areEqual((Object)inspectionGroup.getGroupName(), (Object)"all");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CollectionsKt.removeAll((List)_inspectionGroups, (Function1)((Function1)new Function1<InspectionGroup, Boolean>(inspectionGroup){
                final /* synthetic */ InspectionGroup $inspectionGroup;
                {
                    this.$inspectionGroup = $inspectionGroup;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull InspectionGroup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getGroupName(), (Object)this.$inspectionGroup.getGroupName());
                }
            }));
            _inspectionGroups.add(inspectionGroup);
            this.updateMapInspectionGroupNameToIdx();
        }

        public final void removeInspectionGroupByName(@NotNull String groupName) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            boolean bl2 = bl = !Intrinsics.areEqual((Object)groupName, (Object)"all");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            CollectionsKt.removeAll((List)_inspectionGroups, (Function1)((Function1)new Function1<InspectionGroup, Boolean>(groupName){
                final /* synthetic */ String $groupName;
                {
                    this.$groupName = $groupName;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull InspectionGroup it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getGroupName(), (Object)this.$groupName);
                }
            }));
            this.updateMapInspectionGroupNameToIdx();
        }

        /*
         * WARNING - void declaration
         */
        private final void updateMapInspectionGroupNameToIdx() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getInspectionGroups();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InspectionGroup inspectionGroup = (InspectionGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getGroupName());
            }
            mapInspectionGroupNameToIdx = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)((Iterable)CollectionsKt.getIndices((Collection)this.getInspectionGroups()))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "", "duration", "", "problemsCount", "", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "tool", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "(JILcom/intellij/codeInspection/ex/InspectListener$InspectionKind;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;)V", "getDuration", "()J", "inspectionKey", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionKey;", "getInspectionKey", "()Ljava/lang/String;", "getKind", "()Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "getProblemsCount", "()I", "getTool", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "intellij.qodana"})
    public static final class FinishedInspectionDescriptor {
        private final long duration;
        private final int problemsCount;
        @NotNull
        private final InspectListener.InspectionKind kind;
        @NotNull
        private final InspectionToolWrapper<?, ?> tool;
        @NotNull
        private final String inspectionKey;

        public FinishedInspectionDescriptor(long duration, int problemsCount, @NotNull InspectListener.InspectionKind kind, @NotNull InspectionToolWrapper<?, ?> tool) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Intrinsics.checkNotNullParameter(tool, (String)"tool");
            this.duration = duration;
            this.problemsCount = problemsCount;
            this.kind = kind;
            this.tool = tool;
            String string = this.tool.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            this.inspectionKey = string;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final int getProblemsCount() {
            return this.problemsCount;
        }

        @NotNull
        public final InspectListener.InspectionKind getKind() {
            return this.kind;
        }

        @NotNull
        public final InspectionToolWrapper<?, ?> getTool() {
            return this.tool;
        }

        @NotNull
        public final String getInspectionKey() {
            return this.inspectionKey;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0086\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "", "groupName", "", "containsInspection", "Lkotlin/Function1;", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getContainsInspection", "()Lkotlin/jvm/functions/Function1;", "getGroupName", "()Ljava/lang/String;", "contains", "finishedInspectionDescriptor", "intellij.qodana"})
    public static final class InspectionGroup {
        @NotNull
        private final String groupName;
        @NotNull
        private final Function1<FinishedInspectionDescriptor, Boolean> containsInspection;

        public InspectionGroup(@NotNull String groupName, @NotNull Function1<? super FinishedInspectionDescriptor, Boolean> containsInspection) {
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            Intrinsics.checkNotNullParameter(containsInspection, (String)"containsInspection");
            this.groupName = groupName;
            this.containsInspection = containsInspection;
        }

        @NotNull
        public final String getGroupName() {
            return this.groupName;
        }

        @NotNull
        public final Function1<FinishedInspectionDescriptor, Boolean> getContainsInspection() {
            return this.containsInspection;
        }

        public final boolean contains(@NotNull FinishedInspectionDescriptor finishedInspectionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)finishedInspectionDescriptor, (String)"finishedInspectionDescriptor");
            return (Boolean)this.containsInspection.invoke((Object)finishedInspectionDescriptor);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0083@\u0018\u00002\u00020\u0001:\u0001\"B\u001a\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0088\u0001\u0002\u0092\u0001\b\u0012\u0004\u0012\u00020\u00040\u0003\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006#"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection;", "", "arrInspectionGroupsInfos", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "constructor-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)[Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "[Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "add", "", "other", "add-x7W0VSw", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;[Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)V", "addFinishedInspection", "finishedInspection", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "addFinishedInspection-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;)V", "equals", "", "equals-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;Ljava/lang/Object;)Z", "get", "groupName", "", "get-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;Ljava/lang/String;)Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "hashCode", "", "hashCode-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)I", "toString", "toString-impl", "([Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;)Ljava/lang/String;", "InspectionGroupInfo", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionInfoQodanaReporterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n3792#2:334\n4307#2,2:335\n1855#3,2:337\n1855#3,2:339\n*S KotlinDebug\n*F\n+ 1 InspectionInfoQodanaReporterService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection\n*L\n132#1:334\n132#1:335,2\n133#1:337,2\n140#1:339,2\n*E\n"})
    private static final class InspectionGroupsInfosCollection {
        @NotNull
        private final InspectionGroupInfo[] arrInspectionGroupsInfos;

        /*
         * WARNING - void declaration
         */
        public static final void addFinishedInspection-impl(InspectionGroupInfo[] arg0, @NotNull FinishedInspectionDescriptor finishedInspection) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)finishedInspection, (String)"finishedInspection");
            InspectionGroupInfo[] $this$filter$iv = arg0;
            boolean $i$f$filter = false;
            InspectionGroupInfo[] inspectionGroupInfoArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.getInspectionGroup().contains(finishedInspection)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InspectionGroupInfo it = (InspectionGroupInfo)element$iv;
                boolean bl = false;
                it.setInspectionsDuration(it.getInspectionsDuration() + finishedInspection.getDuration());
                it.setProblemsCount(it.getProblemsCount() + finishedInspection.getProblemsCount());
                it.setPerformedTimesCount(it.getPerformedTimesCount() + 1);
            }
        }

        public static final void add-x7W0VSw(InspectionGroupInfo[] arg0, @NotNull InspectionGroupInfo[] other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Iterable $this$forEach$iv = ArraysKt.zip((Object[])arg0, (Object[])other);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                InspectionGroupInfo thisInfo = (InspectionGroupInfo)pair.component1();
                InspectionGroupInfo otherInfo = (InspectionGroupInfo)pair.component2();
                thisInfo.setInspectionsDuration(thisInfo.getInspectionsDuration() + otherInfo.getInspectionsDuration());
                thisInfo.setProblemsCount(thisInfo.getProblemsCount() + otherInfo.getProblemsCount());
                thisInfo.setPerformedTimesCount(thisInfo.getPerformedTimesCount() + otherInfo.getPerformedTimesCount());
            }
        }

        @NotNull
        public static final InspectionGroupInfo get-impl(InspectionGroupInfo[] arg0, @NotNull String groupName) {
            Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
            boolean bl = mapInspectionGroupNameToIdx.containsKey(groupName);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object v = mapInspectionGroupNameToIdx.get(groupName);
            Intrinsics.checkNotNull(v);
            return arg0[((Number)v).intValue()];
        }

        public static String toString-impl(InspectionGroupInfo[] arg0) {
            return "InspectionGroupsInfosCollection(arrInspectionGroupsInfos=" + Arrays.toString(arg0) + ")";
        }

        public String toString() {
            return InspectionGroupsInfosCollection.toString-impl(this.arrInspectionGroupsInfos);
        }

        public static int hashCode-impl(InspectionGroupInfo[] arg0) {
            return Arrays.hashCode(arg0);
        }

        public int hashCode() {
            return InspectionGroupsInfosCollection.hashCode-impl(this.arrInspectionGroupsInfos);
        }

        public static boolean equals-impl(InspectionGroupInfo[] arg0, Object other) {
            if (!(other instanceof InspectionGroupsInfosCollection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((InspectionGroupsInfosCollection)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return InspectionGroupsInfosCollection.equals-impl(this.arrInspectionGroupsInfos, other);
        }

        private /* synthetic */ InspectionGroupsInfosCollection(InspectionGroupInfo[] arrInspectionGroupsInfos) {
            this.arrInspectionGroupsInfos = arrInspectionGroupsInfos;
        }

        @NotNull
        public static InspectionGroupInfo[] constructor-impl(@NotNull InspectionGroupInfo[] arrInspectionGroupsInfos) {
            Intrinsics.checkNotNullParameter((Object)arrInspectionGroupsInfos, (String)"arrInspectionGroupsInfos");
            return arrInspectionGroupsInfos;
        }

        public static /* synthetic */ InspectionGroupInfo[] constructor-impl$default(InspectionGroupInfo[] inspectionGroupInfoArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                int n2 = 0;
                int n3 = Companion.getInspectionGroups().size();
                InspectionGroupInfo[] inspectionGroupInfoArray2 = new InspectionGroupInfo[n3];
                while (n2 < n3) {
                    int n4 = n2++;
                    inspectionGroupInfoArray2[n4] = new InspectionGroupInfo(Companion.getInspectionGroups().get(n4), 0L, 0, 0, 14, null);
                }
                inspectionGroupInfoArray = inspectionGroupInfoArray2;
            }
            return InspectionGroupsInfosCollection.constructor-impl(inspectionGroupInfoArray);
        }

        public static final /* synthetic */ InspectionGroupsInfosCollection box-impl(InspectionGroupInfo[] v) {
            return new InspectionGroupsInfosCollection(v);
        }

        public final /* synthetic */ InspectionGroupInfo[] unbox-impl() {
            return this.arrInspectionGroupsInfos;
        }

        public static final boolean equals-impl0(InspectionGroupInfo[] p1, InspectionGroupInfo[] p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroupsInfosCollection$InspectionGroupInfo;", "", "inspectionGroup", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "inspectionsDuration", "", "problemsCount", "", "performedTimesCount", "(Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;JII)V", "getInspectionGroup", "()Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionGroup;", "getInspectionsDuration", "()J", "setInspectionsDuration", "(J)V", "getPerformedTimesCount", "()I", "setPerformedTimesCount", "(I)V", "getProblemsCount", "setProblemsCount", "intellij.qodana"})
        public static final class InspectionGroupInfo {
            @NotNull
            private final InspectionGroup inspectionGroup;
            private long inspectionsDuration;
            private int problemsCount;
            private int performedTimesCount;

            public InspectionGroupInfo(@NotNull InspectionGroup inspectionGroup, long inspectionsDuration, int problemsCount, int performedTimesCount) {
                Intrinsics.checkNotNullParameter((Object)inspectionGroup, (String)"inspectionGroup");
                this.inspectionGroup = inspectionGroup;
                this.inspectionsDuration = inspectionsDuration;
                this.problemsCount = problemsCount;
                this.performedTimesCount = performedTimesCount;
            }

            public /* synthetic */ InspectionGroupInfo(InspectionGroup inspectionGroup, long l, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 2) != 0) {
                    l = 0L;
                }
                if ((n3 & 4) != 0) {
                    n = 0;
                }
                if ((n3 & 8) != 0) {
                    n2 = 0;
                }
                this(inspectionGroup, l, n, n2);
            }

            @NotNull
            public final InspectionGroup getInspectionGroup() {
                return this.inspectionGroup;
            }

            public final long getInspectionsDuration() {
                return this.inspectionsDuration;
            }

            public final void setInspectionsDuration(long l) {
                this.inspectionsDuration = l;
            }

            public final int getProblemsCount() {
                return this.problemsCount;
            }

            public final void setProblemsCount(int n) {
                this.problemsCount = n;
            }

            public final int getPerformedTimesCount() {
                return this.performedTimesCount;
            }

            public final void setPerformedTimesCount(int n) {
                this.performedTimesCount = n;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BE\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 \u00a8\u0006%"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$InspectionInfo;", "", "descriptor", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;", "(Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionInfoQodanaReporterService$FinishedInspectionDescriptor;)V", "duration", "", "problemsCount", "", "performedTimesCount", "id", "", "displayName", "groupPath", "language", "kind", "Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "(JIILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;)V", "getDisplayName", "()Ljava/lang/String;", "getDuration", "()J", "setDuration", "(J)V", "getGroupPath", "getId", "getKind", "()Lcom/intellij/codeInspection/ex/InspectListener$InspectionKind;", "getLanguage", "getPerformedTimesCount", "()I", "setPerformedTimesCount", "(I)V", "getProblemsCount", "setProblemsCount", "addFinishedInspection", "", "intellij.qodana"})
    private static final class InspectionInfo {
        private long duration;
        private int problemsCount;
        private int performedTimesCount;
        @NotNull
        private final String id;
        @NotNull
        private final String displayName;
        @NotNull
        private final String groupPath;
        @NotNull
        private final String language;
        @NotNull
        private final InspectListener.InspectionKind kind;

        public InspectionInfo(long duration, int problemsCount, int performedTimesCount, @NotNull String id, @NotNull String displayName, @NotNull String groupPath, @NotNull String language, @NotNull InspectListener.InspectionKind kind) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)groupPath, (String)"groupPath");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.duration = duration;
            this.problemsCount = problemsCount;
            this.performedTimesCount = performedTimesCount;
            this.id = id;
            this.displayName = displayName;
            this.groupPath = groupPath;
            this.language = language;
            this.kind = kind;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final void setDuration(long l) {
            this.duration = l;
        }

        public final int getProblemsCount() {
            return this.problemsCount;
        }

        public final void setProblemsCount(int n) {
            this.problemsCount = n;
        }

        public final int getPerformedTimesCount() {
            return this.performedTimesCount;
        }

        public final void setPerformedTimesCount(int n) {
            this.performedTimesCount = n;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getGroupPath() {
            return this.groupPath;
        }

        @NotNull
        public final String getLanguage() {
            return this.language;
        }

        @NotNull
        public final InspectListener.InspectionKind getKind() {
            return this.kind;
        }

        public InspectionInfo(@NotNull FinishedInspectionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            long l = descriptor2.getDuration();
            int n = descriptor2.getProblemsCount();
            String string = descriptor2.getTool().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            String string2 = descriptor2.getTool().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
            String[] stringArray = descriptor2.getTool().getGroupPath();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getGroupPath(...)");
            String string3 = InspectionCategoryGroupProviderKt.makeCategoryId((String[])stringArray);
            String string4 = descriptor2.getTool().getLanguage();
            if (string4 == null) {
                string4 = "none";
            }
            this(l, n, 1, string, string2, string3, string4, descriptor2.getKind());
        }

        public final void addFinishedInspection(@NotNull FinishedInspectionDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            boolean bl = Intrinsics.areEqual((Object)this.id, (Object)descriptor2.getTool().getID());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.duration += descriptor2.getDuration();
            this.problemsCount += descriptor2.getProblemsCount();
            ++this.performedTimesCount;
        }
    }
}

