/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel;

import com.intellij.gradle.toolingExtension.impl.model.dependencyGraphModel.GradleDependencyReportGenerator;
import com.intellij.gradle.toolingExtension.impl.util.javaPluginUtil.JavaPluginUtil;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependenciesImpl;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependenciesImpl;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;

public class GradleDependencyGraphModelBuilder
implements ModelBuilderService {
    private final GradleDependencyReportGenerator reportGenerator = new GradleDependencyReportGenerator();

    public boolean canBuild(String modelName) {
        return ProjectDependencies.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        boolean resolveSourceSetDependencies = Boolean.parseBoolean(System.getProperty("idea.resolveSourceSetDependencies", "false"));
        if (!resolveSourceSetDependencies || !DependencyResolverImpl.isIsNewDependencyResolutionApplicable()) {
            return null;
        }
        SourceSetContainer sourceSetContainer = JavaPluginUtil.getSourceSetContainer(project);
        if (sourceSetContainer == null) {
            return null;
        }
        ProjectDependenciesImpl dependencies = new ProjectDependenciesImpl();
        for (SourceSet sourceSet : sourceSetContainer) {
            String compileConfigurationName = sourceSet.getCompileClasspathConfigurationName();
            Configuration compileConfiguration = (Configuration)project.getConfigurations().findByName(compileConfigurationName);
            if (compileConfiguration == null) continue;
            String runtimeConfigurationName = sourceSet.getRuntimeClasspathConfigurationName();
            Configuration runtimeConfiguration = (Configuration)project.getConfigurations().findByName(runtimeConfigurationName);
            if (runtimeConfiguration == null) continue;
            DependencyScopeNode compileScopeNode = this.reportGenerator.buildDependencyGraph(compileConfiguration, project);
            DependencyScopeNode runtimeScopeNode = this.reportGenerator.buildDependencyGraph(runtimeConfiguration, project);
            if (compileScopeNode.getDependencies().isEmpty() && runtimeScopeNode.getDependencies().isEmpty()) continue;
            dependencies.add((ComponentDependencies)new ComponentDependenciesImpl(sourceSet.getName(), compileScopeNode, runtimeScopeNode));
        }
        return dependencies.getComponentsDependencies().isEmpty() ? null : dependencies;
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        if (modelName == null) {
            GradleDependencyGraphModelBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDependencyGraphModelBuilder.$$$reportNull$$$0(1);
        }
        if (context == null) {
            GradleDependencyGraphModelBuilder.$$$reportNull$$$0(2);
        }
        if (exception == null) {
            GradleDependencyGraphModelBuilder.$$$reportNull$$$0(3);
        }
        context.getMessageReporter().createMessage().withGroup("gradle.dependencyGraphModel.group").withKind(Message.Kind.WARNING).withTitle("Dependency graph model failure").withException(exception).reportMessage(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "modelName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "exception";
                break;
            }
        }
        objectArray[1] = "com/intellij/gradle/toolingExtension/impl/model/dependencyGraphModel/GradleDependencyGraphModelBuilder";
        objectArray[2] = "reportErrorMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

