/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.util;

import org.gradle.api.Project;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDependencyArtifactPolicyUtil {
    private static final String DOWNLOAD_SOURCES_FORCE_PROPERTY_NAME = "idea.gradle.download.sources.force";
    private static final String DOWNLOAD_SOURCES_PROPERTY_NAME = "idea.gradle.download.sources";

    public static boolean shouldDownloadSources(@NotNull Project project) {
        String forcePropertyValue;
        if (project == null) {
            GradleDependencyArtifactPolicyUtil.$$$reportNull$$$0(0);
        }
        if ((forcePropertyValue = System.getProperty(DOWNLOAD_SOURCES_FORCE_PROPERTY_NAME)) != null) {
            return Boolean.parseBoolean(forcePropertyValue);
        }
        IdeaPlugin ideaPlugin = GradleDependencyArtifactPolicyUtil.findIdeaPlugin(project);
        if (ideaPlugin != null) {
            return ideaPlugin.getModel().getModule().isDownloadSources();
        }
        return Boolean.parseBoolean(System.getProperty(DOWNLOAD_SOURCES_PROPERTY_NAME, "false"));
    }

    public static boolean shouldDownloadJavadoc(@NotNull Project project) {
        IdeaPlugin ideaPlugin;
        if (project == null) {
            GradleDependencyArtifactPolicyUtil.$$$reportNull$$$0(1);
        }
        if ((ideaPlugin = GradleDependencyArtifactPolicyUtil.findIdeaPlugin(project)) != null) {
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            return ideaModule.isDownloadJavadoc();
        }
        return false;
    }

    public static void setPolicy(@NotNull Project project, boolean downloadSources, boolean downloadJavadocs) {
        if (project == null) {
            GradleDependencyArtifactPolicyUtil.$$$reportNull$$$0(2);
        }
        project.getPlugins().withType(IdeaPlugin.class, plugin -> {
            IdeaModule module = plugin.getModel().getModule();
            module.setDownloadSources(downloadSources);
            module.setDownloadJavadoc(downloadJavadocs);
        });
    }

    @Nullable
    private static IdeaPlugin findIdeaPlugin(@NotNull Project project) {
        IdeaPlugin ideaPlugin;
        if (project == null) {
            GradleDependencyArtifactPolicyUtil.$$$reportNull$$$0(3);
        }
        if ((ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class)) != null) {
            return ideaPlugin;
        }
        if (project.getParent() != null) {
            return GradleDependencyArtifactPolicyUtil.findIdeaPlugin(project.getParent());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/util/GradleDependencyArtifactPolicyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldDownloadSources";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldDownloadJavadoc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPolicy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findIdeaPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

