/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FileHistoryPersistence;
import com.intellij.filePrediction.features.history.FilePredictionNGramFeatures;
import com.intellij.internal.ml.ngram.NGramIncrementalModelRunner;
import com.intellij.internal.ml.ngram.NGramModelScorer;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManager;", "", "model", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "(Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;)V", "calcNGramFeatures", "Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "candidates", "", "", "calcNextFileProbability", "", "fileUrl", "onFileOpened", "", "saveFileHistoryAsync", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ml.impl"})
public final class FileHistoryManager {
    @NotNull
    private final NGramIncrementalModelRunner model;

    public FileHistoryManager(@NotNull NGramIncrementalModelRunner model2) {
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        this.model = model2;
    }

    public final void saveFileHistoryAsync(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        FileHistoryPersistence.INSTANCE.saveNGramsAsync(project2, this.model);
    }

    public final void onFileOpened(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        this.model.learnNextToken(fileUrl);
    }

    @NotNull
    public final FilePredictionNGramFeatures calcNGramFeatures(@NotNull List<String> candidates) {
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Map result2 = new HashMap();
        NGramModelScorer scorer = this.model.createScorer();
        for (String candidate : candidates) {
            result2.put(candidate, scorer.score(candidate));
        }
        return new FilePredictionNGramFeatures(result2);
    }

    public final double calcNextFileProbability(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        NGramModelScorer scorer = this.model.createScorer();
        return scorer.score(fileUrl);
    }
}

