/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\t*\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "browser", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesTreeBrowser;", "createIncomingChangesBrowser", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "loadIncomingChanges", "inBackground", "", "setIncomingChanges", "changeLists", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "Companion", "DisplayNameSupplier", "IncomingChangesListener", "VisibilityPredicate", "intellij.platform.vcs.impl"})
public final class IncomingChangesViewProvider
implements ChangesViewContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private CommittedChangesTreeBrowser browser;

    public IncomingChangesViewProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CommittedChangesTreeBrowser it = this.createIncomingChangesBrowser();
        boolean bl = false;
        this.browser = it;
        content.setComponent((JComponent)it);
        content.setDisposer(() -> IncomingChangesViewProvider.initTabContent$lambda$1$lambda$0(this));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)it);
        Topic<CommittedChangesListener> topic = CommittedChangesCache.COMMITTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"COMMITTED_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new IncomingChangesListener());
        this.loadIncomingChanges(false);
    }

    private final CommittedChangesTreeBrowser createIncomingChangesBrowser() {
        CommittedChangesTreeBrowser committedChangesTreeBrowser;
        CommittedChangesTreeBrowser $this$createIncomingChangesBrowser_u24lambda_u242 = committedChangesTreeBrowser = new CommittedChangesTreeBrowser(this.project, CollectionsKt.emptyList());
        boolean bl = false;
        $this$createIncomingChangesBrowser_u24lambda_u242.getEmptyText().setText(VcsBundle.message("incoming.changes.not.loaded.message", new Object[0]));
        AnAction anAction = ActionManager.getInstance().getAction("IncomingChangesToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup group2 = (ActionGroup)anAction;
        $this$createIncomingChangesBrowser_u24lambda_u242.setToolBar($this$createIncomingChangesBrowser_u24lambda_u242.createGroupFilterToolbar(this.project, group2, null, CollectionsKt.emptyList()).getComponent());
        $this$createIncomingChangesBrowser_u24lambda_u242.setTableContextMenu(group2, CollectionsKt.emptyList());
        return committedChangesTreeBrowser;
    }

    private final void loadIncomingChanges(boolean inBackground) {
        CommittedChangesCache cache = CommittedChangesCache.getInstance(this.project);
        cache.hasCachesForAnyRoot((Consumer<? super Boolean>)((Consumer)arg_0 -> IncomingChangesViewProvider.loadIncomingChanges$lambda$3((Function1)new Function1<Boolean, Unit>(cache, this, inBackground){
            final /* synthetic */ CommittedChangesCache $cache;
            final /* synthetic */ IncomingChangesViewProvider this$0;
            final /* synthetic */ boolean $inBackground;
            {
                this.$cache = $cache;
                this.this$0 = $receiver;
                this.$inBackground = $inBackground;
                super(1);
            }

            public final void invoke(boolean hasCaches) {
                if (!hasCaches) {
                    return;
                }
                List<CommittedChangeList> cachedIncomingChanges = this.$cache.getCachedIncomingChanges();
                if (cachedIncomingChanges != null) {
                    CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.access$getBrowser$p(this.this$0);
                    if (committedChangesTreeBrowser != null) {
                        IncomingChangesViewProvider.access$setIncomingChanges(this.this$0, committedChangesTreeBrowser, cachedIncomingChanges);
                    }
                } else {
                    this.$cache.loadIncomingChangesAsync((Consumer<? super List<CommittedChangeList>>)((Consumer)arg_0 -> loadIncomingChanges.1.invoke$lambda$0((Function1)new Function1<List<CommittedChangeList>, Unit>(this.this$0){
                        final /* synthetic */ IncomingChangesViewProvider this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(List<CommittedChangeList> incomingChanges) {
                            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0, incomingChanges){
                                final /* synthetic */ IncomingChangesViewProvider this$0;
                                final /* synthetic */ List<CommittedChangeList> $incomingChanges;
                                {
                                    this.this$0 = $receiver;
                                    this.$incomingChanges = $incomingChanges;
                                    super(0);
                                }

                                public final void invoke() {
                                    CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.access$getBrowser$p(this.this$0);
                                    if (committedChangesTreeBrowser != null) {
                                        List<CommittedChangeList> list2 = this.$incomingChanges;
                                        Intrinsics.checkNotNullExpressionValue(list2, (String)"$incomingChanges");
                                        IncomingChangesViewProvider.access$setIncomingChanges(this.this$0, committedChangesTreeBrowser, list2);
                                    }
                                }
                            }), (int)1, null);
                        }
                    }, arg_0)), this.$inBackground);
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)));
    }

    private final void setIncomingChanges(CommittedChangesTreeBrowser $this$setIncomingChanges, List<? extends CommittedChangeList> changeLists) {
        $this$setIncomingChanges.getEmptyText().setText(VcsBundle.message("incoming.changes.empty.message", new Object[0]));
        $this$setIncomingChanges.setItems(changeLists, CommittedChangesBrowserUseCase.INCOMING);
    }

    private static final void initTabContent$lambda$1$lambda$0(IncomingChangesViewProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.browser = null;
    }

    private static final void loadIncomingChanges$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$loadIncomingChanges(IncomingChangesViewProvider $this, boolean inBackground) {
        $this.loadIncomingChanges(inBackground);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$Companion;", "", "()V", "isIncomingChangesAvailable", "", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIncomingChangesAvailable(@NotNull AbstractVcs vcs) {
            Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
            CachingCommittedChangesProvider<CommittedChangeList, ?> cachingCommittedChangesProvider = vcs.getCachingCommittedChangesProvider();
            return cachingCommittedChangesProvider != null ? cachingCommittedChangesProvider.supportsIncomingChanges() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "()V", "get", "intellij.platform.vcs.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string2 = VcsBundle.message("incoming.changes.tab", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$IncomingChangesListener;", "Lcom/intellij/openapi/vcs/changes/committed/CommittedChangesListener;", "(Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider;)V", "changesCleared", "", "changesLoaded", "location", "Lcom/intellij/openapi/vcs/RepositoryLocation;", "changes", "", "Lcom/intellij/openapi/vcs/versionBrowser/CommittedChangeList;", "incomingChangesUpdated", "receivedChanges", "refreshErrorStatusChanged", "lastError", "Lcom/intellij/openapi/vcs/VcsException;", "updateModel", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nIncomingChangesViewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingChangesViewProvider.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$IncomingChangesListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
    private final class IncomingChangesListener
    implements CommittedChangesListener {
        public void changesLoaded(@NotNull RepositoryLocation location, @NotNull List<? extends CommittedChangeList> changes) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.updateModel();
        }

        public void incomingChangesUpdated(@Nullable List<? extends CommittedChangeList> receivedChanges) {
            this.updateModel();
        }

        @Override
        public void changesCleared() {
            CommittedChangesTreeBrowser committedChangesTreeBrowser = IncomingChangesViewProvider.this.browser;
            if (committedChangesTreeBrowser != null) {
                IncomingChangesViewProvider.this.setIncomingChanges(committedChangesTreeBrowser, CollectionsKt.emptyList());
            }
        }

        @Override
        public void refreshErrorStatusChanged(@Nullable VcsException lastError) {
            block0: {
                VcsException vcsException = lastError;
                if (vcsException == null) break block0;
                VcsException vcsException2 = vcsException;
                IncomingChangesViewProvider incomingChangesViewProvider = IncomingChangesViewProvider.this;
                VcsException it = vcsException2;
                boolean bl = false;
                VcsBalloonProblemNotifier.showOverChangesView(incomingChangesViewProvider.project, it.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }

        private final void updateModel() {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(IncomingChangesViewProvider.this){
                final /* synthetic */ IncomingChangesViewProvider this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (IncomingChangesViewProvider.access$getProject$p(this.this$0).isDisposed() || IncomingChangesViewProvider.access$getBrowser$p(this.this$0) == null) {
                        return;
                    }
                    IncomingChangesViewProvider.access$loadIncomingChanges(this.this$0, true);
                }
            }), (int)1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "()V", "test", "", "project", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nIncomingChangesViewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingChangesViewProvider.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n12474#2,2:106\n*S KotlinDebug\n*F\n+ 1 IncomingChangesViewProvider.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesViewProvider$VisibilityPredicate\n*L\n93#1:106,2\n*E\n"})
    public static final class VisibilityPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project2) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance(project2).getAllActiveVcss();
                Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
                Object[] $this$any$iv = abstractVcsArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    AbstractVcs it = (AbstractVcs)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Companion.isIncomingChangesAvailable(it)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }
    }
}

