/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.Nullable;

public class IgnoreLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int IN_ENTRY = 2;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    static final char[] ZZ_CMAP_Z = IgnoreLexer.zzUnpackCMap("\u0001\u0000\u0087@");
    static final char[] ZZ_CMAP_Y = IgnoreLexer.zzUnpackCMap("\u0001\u0000\u007f\u0080");
    static final char[] ZZ_CMAP_A = IgnoreLexer.zzUnpackCMap("\t\u0000\u0001\u0002\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0001\u0012\u0000\u0001\u0002\u0001\u0004\u0001\u0000\u0001\u0003\u000b\u0000\u0001\u0005\n\u0000\u0001\u000e \u0000\u0001\u0006\u0001\u000f\u0001\u0007\u0003\u0000\u0001\f\f\u0000\u0001\n\u0004\u0000\u0001\b\u0001\u000b\u0003\u0000\u0001\r\u0001\t\u0086\u0000");
    private static final int[] ZZ_ACTION = IgnoreLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0001\u0002\u0006\u0001\u0007\u0001\b\u0001\t\u0001\u0006\u0001\u0000\u0001\u0004\u0001\n\u0001\u0000\u0001\n\u0001\u000b\u0004\u0000\u0001\f";
    private static final int[] ZZ_ROWMAP = IgnoreLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0010\u0000 \u00000\u0000@\u0000P\u0000 \u0000`\u0000p\u0000\u0080\u0000 \u0000 \u0000 \u0000\u0090\u00000\u0000\u00a0\u0000\u00b0\u0000\u00c0\u0000\u00d0\u0000\u00e0\u0000\u00f0\u0000\u0100\u0000\u0110\u0000\u0120\u0000 ";
    private static final int[] ZZ_TRANS = IgnoreLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0003\u0003\u0001\b\u0007\u0003\u0001\t\u0001\u0004\u0001\n\u0002\t\u0001\u000b\u0001\f\u0001\r\u0007\t\u0001\u000e\u0011\u0000\u0001\u0004\u0001\u000f\u000e\u0000\u0001\u0004\u0001\u0005\r\u0000\u0001\u0010\u0001\u0000\u0001\u0010\u0001\u0011\f\u0010\t\u0000\u0001\u0012\u0006\u0000\u0001\t\u0001\u0000\u0003\t\u0003\u0000\u0007\t\u0001\u000e\u0001\t\u0001\u0004\u0001\n\u0002\t\u0003\u0000\u0007\t\u0001\u000e\u0001\t\u0001\u0000\r\t\u0001\u000e\u0001\u0010\u0001\u0000\u000e\u0010\u0001\u0013\u0001\u0000\u0001\u0013\u0001\u0014\f\u0013\n\u0000\u0001\u0015\u0005\u0000\u0001\u0013\u0001\u0000\u000e\u0013\u0001\u0014\u0001\u0000\u000e\u0014\u000b\u0000\u0001\u0016\u0010\u0000\u0001\u0017\u0010\u0000\u0001\u0018\u0010\u0000\u0001\u0019\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = IgnoreLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\u0003\u0001\u0001\t\u0003\u0001\u0003\t\u0001\u0001\u0001\u0000\u0002\u0001\u0001\u0000\u0002\u0001\u0004\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private IgnoreLanguage language;

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 13] | ch >> 7 & 0x3F] | ch & 0x7F];
    }

    private static int[] zzUnpackAction() {
        int[] result2 = new int[25];
        int offset = 0;
        offset = IgnoreLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value2 = packed.charAt(i++);
            do {
                result2[j++] = value2;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[25];
        int offset = 0;
        offset = IgnoreLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result2[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result2 = new int[304];
        int offset = 0;
        offset = IgnoreLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value2 = packed.charAt(i++);
            do {
                result2[j++] = --value2;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[25];
        int offset = 0;
        offset = IgnoreLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value2 = packed.charAt(i++);
            do {
                result2[j++] = value2;
            } while (--count > 0);
        }
        return j;
    }

    public IgnoreLexer(@Nullable VirtualFile virtualFile) {
        this((Reader)null);
        if (virtualFile != null && virtualFile.getFileType() instanceof IgnoreFileType) {
            this.language = ((IgnoreFileType)virtualFile.getFileType()).getIgnoreLanguage();
        }
    }

    private boolean isSyntaxSupported() {
        return this.language == null || this.language.isSyntaxSupported();
    }

    public IgnoreLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i = 0; i < length; i += 2) {
            size += packed.charAt(i);
        }
        char[] map2 = new char[size];
        int i = 0;
        int j = 0;
        while (i < packed.length()) {
            int count = packed.charAt(i++);
            char value2 = packed.charAt(i++);
            do {
                map2[j++] = value2;
            } while (--count > 0);
        }
        return map2;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start2, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start2;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message2;
        try {
            message2 = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message2 = ZZ_ERROR_MSG[0];
        }
        throw new Error(message2);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block26: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + IgnoreLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.yypushback(1);
                    this.yybegin(2);
                }
                case 13: {
                    continue block26;
                }
                case 2: {
                    this.yybegin(0);
                    return IgnoreTypes.CRLF;
                }
                case 14: {
                    continue block26;
                }
                case 3: {
                    return IgnoreTypes.CRLF;
                }
                case 15: {
                    continue block26;
                }
                case 4: {
                    return IgnoreTypes.COMMENT;
                }
                case 16: {
                    continue block26;
                }
                case 5: {
                    return IgnoreTypes.NEGATION;
                }
                case 17: {
                    continue block26;
                }
                case 6: {
                    this.yybegin(2);
                    return IgnoreTypes.VALUE;
                }
                case 18: {
                    continue block26;
                }
                case 7: {
                    this.yybegin(2);
                    return IgnoreTypes.SLASH;
                }
                case 19: {
                    continue block26;
                }
                case 8: {
                    this.yybegin(2);
                    return IgnoreTypes.BRACKET_LEFT;
                }
                case 20: {
                    continue block26;
                }
                case 9: {
                    this.yybegin(2);
                    return IgnoreTypes.BRACKET_RIGHT;
                }
                case 21: {
                    continue block26;
                }
                case 10: {
                    return IgnoreTypes.SECTION;
                }
                case 22: {
                    continue block26;
                }
                case 11: {
                    return IgnoreTypes.HEADER;
                }
                case 23: {
                    continue block26;
                }
                case 12: {
                    if (this.isSyntaxSupported()) {
                        return IgnoreTypes.SYNTAX_KEY;
                    }
                    this.yybegin(2);
                    this.yypushback(this.yylength());
                }
                case 24: {
                    continue block26;
                }
            }
            this.zzScanError(1);
        }
    }
}

