/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextUtil;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface ScopeInfo {
    public static final ScopeInfo PROJECT = new ScopeInfo(){

        @Override
        public String getScopeName(@NotNull DataContext dataContext, ActionInfo actionInfo) {
            if (dataContext == null) {
                1.$$$reportNull$$$0(0);
            }
            return VcsBundle.message("update.project.scope.name", new Object[0]);
        }

        @Override
        public boolean filterExistsInVcs() {
            return true;
        }

        @Override
        public List<FilePath> getRoots(@NotNull DataContext dataContext, @NotNull ActionInfo actionInfo) {
            AbstractVcs[] vcses;
            if (dataContext == null) {
                1.$$$reportNull$$$0(1);
            }
            if (actionInfo == null) {
                1.$$$reportNull$$$0(2);
            }
            ArrayList<FilePath> result2 = new ArrayList<FilePath>();
            Project project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
            for (AbstractVcs vcs : vcses = vcsManager2.getAllActiveVcss()) {
                VirtualFile[] files2;
                if (actionInfo.getEnvironment(vcs) == null) continue;
                for (VirtualFile file : files2 = vcsManager2.getRootsUnderVcs(vcs)) {
                    result2.add(VcsUtil.getFilePath(file));
                }
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/update/ScopeInfo$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getScopeName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRoots";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final ScopeInfo FILES = new ScopeInfo(){

        @Override
        public String getScopeName(@NotNull DataContext dataContext, ActionInfo actionInfo) {
            List<FilePath> roots;
            if (dataContext == null) {
                2.$$$reportNull$$$0(0);
            }
            if ((roots = this.getRoots(dataContext, actionInfo)).isEmpty()) {
                return VcsBundle.message("update.files.scope.name", new Object[0]);
            }
            boolean directory = roots.get(0).isDirectory();
            if (roots.size() == 1) {
                if (directory) {
                    return VcsBundle.message("update.directory.scope.name", new Object[0]);
                }
                return VcsBundle.message("update.file.scope.name", new Object[0]);
            }
            if (directory) {
                return VcsBundle.message("update.directories.scope.name", new Object[0]);
            }
            return VcsBundle.message("update.files.scope.name", new Object[0]);
        }

        @Override
        public boolean filterExistsInVcs() {
            return true;
        }

        @Override
        public List<FilePath> getRoots(@NotNull DataContext dataContext, @NotNull ActionInfo actionInfo) {
            if (dataContext == null) {
                2.$$$reportNull$$$0(1);
            }
            if (actionInfo == null) {
                2.$$$reportNull$$$0(2);
            }
            return VcsContextUtil.selectedFilePaths(dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/update/ScopeInfo$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getScopeName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRoots";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @Deprecated
    default public FilePath[] getRoots(VcsContext context, @NotNull ActionInfo actionInfo) {
        if (actionInfo == null) {
            ScopeInfo.$$$reportNull$$$0(0);
        }
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)context.getProject()).add(VcsDataKeys.FILE_PATHS, Arrays.asList(context.getSelectedFilePaths())).build();
        return this.getRoots(dataContext, actionInfo).toArray(new FilePath[0]);
    }

    public List<FilePath> getRoots(@NotNull DataContext var1, @NotNull ActionInfo var2);

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getScopeName(@NotNull DataContext var1, ActionInfo var2);

    public boolean filterExistsInVcs();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionInfo", "com/intellij/openapi/vcs/update/ScopeInfo", "getRoots"));
    }
}

