/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.ui.navigation.History;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.actions.ActionController;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
extends AbstractVcsLogUi
implements MainVcsLogUi {
    @NonNls
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final MyVcsLogUiPropertiesListener myPropertiesListener;
    @NotNull
    private final History myHistory;
    @NotNull
    private final LinkedHashMap<String, VcsLogHighlighter> myHighlighters;

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection initialFilters) {
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(4);
        }
        this(id, logData, manager, uiProperties, refresher, initialFilters, true);
    }

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection initialFilters, boolean isEditorDiffPreview) {
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(5);
        }
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(7);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(8);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(9);
        }
        super(id, logData, manager, refresher);
        this.myHighlighters = new LinkedHashMap();
        this.myUiProperties = uiProperties;
        VcsLogFilterUiEx filterUi = this.createFilterUi(filters -> this.applyFiltersAndUpdateUi((VcsLogFilterCollection)filters), initialFilters, this);
        this.myMainFrame = this.createMainFrame(logData, uiProperties, filterUi, isEditorDiffPreview);
        LOG_HIGHLIGHTER_FACTORY_EP.addChangeListener(this::updateHighlighters, (Disposable)this);
        ApplicationManager.getApplication().invokeLater(this::updateHighlighters, o -> this.myDisposableFlag.isDisposed());
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener, this);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
        this.applyFiltersAndUpdateUi(this.myMainFrame.getFilterUi().getFilters());
    }

    @NotNull
    protected MainFrame createMainFrame(@NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi, boolean isEditorDiffPreview) {
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(10);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(11);
        }
        if (filterUi == null) {
            VcsLogUiImpl.$$$reportNull$$$0(12);
        }
        return new MainFrame(logData, this, uiProperties, filterUi, isEditorDiffPreview, this);
    }

    @NotNull
    protected VcsLogFilterUiEx createFilterUi(@NotNull Consumer<VcsLogFilterCollection> filterConsumer, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        if (filterConsumer == null) {
            VcsLogUiImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(14);
        }
        return new VcsLogClassicFilterUi(this.myLogData, filterConsumer, this.myUiProperties, this.myColorManager, filters, parentDisposable);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    protected MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(15);
        }
        return mainFrame;
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId2, boolean commitExists, @NotNull PairFunction<? super VisiblePack, ? super T, Integer> rowGetter) {
        if (commitId2 == null) {
            VcsLogUiImpl.$$$reportNull$$$0(16);
        }
        if (rowGetter == null) {
            VcsLogUiImpl.$$$reportNull$$$0(17);
        }
        if (this.getFilterUi().getFilters().isEmpty() || !commitExists) {
            super.handleCommitNotFound(commitId2, commitExists, rowGetter);
            return;
        }
        ArrayList<NotificationAction> actions2 = new ArrayList<NotificationAction>();
        actions2.add(NotificationAction.createSimple((String)VcsLogBundle.message("vcs.log.commit.does.not.match.view.and.reset.link", new Object[0]), () -> {
            this.getFilterUi().clearFilters();
            this.invokeOnChange(() -> this.jumpTo(commitId2, rowGetter, (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), false, true), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
        }));
        VcsProjectLog projectLog = VcsProjectLog.getInstance(this.myProject);
        if (projectLog.getDataManager() == this.myLogData) {
            actions2.add(NotificationAction.createSimple((String)VcsLogBundle.message("vcs.log.commit.does.not.match.view.in.tab.link", new Object[0]), () -> {
                MainVcsLogUi ui2 = projectLog.openLogTab(VcsLogFilterObject.collection(new VcsLogFilter[0]));
                if (ui2 != null) {
                    VcsLogUtil.invokeOnChange(ui2, () -> ui2.jumpTo(commitId2, rowGetter, (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), false, true), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
                }
            }));
        }
        VcsNotifier.getInstance(this.myProject).notifyWarning("vcs.log.commit.not.found", "", VcsLogUiImpl.getCommitNotFoundMessage(commitId2, true), (NotificationAction[])actions2.toArray(NotificationAction[]::new));
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property2;
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(18);
        }
        return this.myUiProperties.exists(property2 = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id)) && this.myUiProperties.get(property2) != false;
    }

    protected void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            VcsLogUiImpl.$$$reportNull$$$0(19);
        }
        this.myRefresher.onFiltersChange(filters);
        JComponent toolbar2 = this.myMainFrame.getToolbar();
        toolbar2.revalidate();
        toolbar2.repaint();
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myMainFrame.getGraphTable();
        if (vcsLogGraphTable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(20);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public JComponent getMainComponent() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(21);
        }
        return mainFrame;
    }

    @Override
    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        VcsLogFilterUiEx vcsLogFilterUiEx = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUiEx == null) {
            VcsLogUiImpl.$$$reportNull$$$0(22);
        }
        return vcsLogFilterUiEx;
    }

    @Override
    @NotNull
    public ChangesBrowserBase getChangesBrowser() {
        VcsLogChangesBrowser vcsLogChangesBrowser = this.myMainFrame.getChangesBrowser();
        if (vcsLogChangesBrowser == null) {
            VcsLogUiImpl.$$$reportNull$$$0(23);
        }
        return vcsLogChangesBrowser;
    }

    @Override
    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myMainFrame.getToolbar();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(24);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        MainVcsLogUiProperties mainVcsLogUiProperties = this.myUiProperties;
        if (mainVcsLogUiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(25);
        }
        return mainVcsLogUiProperties;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void selectFilePath(@NotNull FilePath filePath, boolean requestFocus) {
        if (filePath == null) {
            VcsLogUiImpl.$$$reportNull$$$0(26);
        }
        this.getMainFrame().selectFilePath(filePath, requestFocus);
    }

    private void updateHighlighters() {
        this.myHighlighters.forEach((s, highlighter) -> this.getTable().removeHighlighter((VcsLogHighlighter)highlighter));
        this.myHighlighters.clear();
        for (VcsLogHighlighterFactory factory : LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
            VcsLogHighlighter highlighter2 = factory.createHighlighter(this.myLogData, this);
            this.myHighlighters.put(factory.getId(), highlighter2);
            if (!this.isHighlighterEnabled(factory.getId())) continue;
            this.getTable().addHighlighter(highlighter2);
        }
        this.getTable().repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 20, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterConsumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainFrame";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createMainFrame";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFilterUi";
                break;
            }
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "applyFiltersAndUpdateUi";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePath";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 15, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string2);
        };
    }

    private class MyVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
            if (property2 == null) {
                MyVcsLogUiPropertiesListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property2)) {
                VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property2)) {
                this.onShowLongEdgesChanged();
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property2)) {
                VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
            } else if (CommonUiProperties.COLUMN_ID_ORDER.equals(property2)) {
                VcsLogUiImpl.this.getTable().onColumnOrderSettingChanged();
            } else if (property2 instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                VcsLogHighlighter highlighter = VcsLogUiImpl.this.myHighlighters.get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property2).getId());
                if (((Boolean)VcsLogUiImpl.this.myUiProperties.get(property2)).booleanValue()) {
                    VcsLogUiImpl.this.getTable().addHighlighter(highlighter);
                } else {
                    VcsLogUiImpl.this.getTable().removeHighlighter(highlighter);
                }
                VcsLogUiImpl.this.getTable().repaint();
            } else if (property2 instanceof TableColumnWidthProperty) {
                VcsLogUiImpl.this.getTable().forceReLayout(((TableColumnWidthProperty)property2).getColumn());
            }
        }

        private void onShowLongEdgesChanged() {
            boolean newLongEdgesHiddenValue;
            ActionController<Integer> actionController = VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController();
            boolean oldLongEdgesHiddenValue = actionController.areLongEdgesHidden();
            boolean bl = newLongEdgesHiddenValue = VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false;
            if (newLongEdgesHiddenValue != oldLongEdgesHiddenValue) {
                actionController.setLongEdgesHidden(newLongEdgesHiddenValue);
                VcsLogUiImpl.this.getTable().repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/VcsLogUiImpl$MyVcsLogUiPropertiesListener", "onPropertyChanged"));
        }
    }
}

