/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions.history;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.CreatePatchFromChangesAction;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreatePatchFromHistoryActionProvider
implements AnActionExtensionProvider {
    private final boolean mySilentClipboard;

    private CreatePatchFromHistoryActionProvider(boolean silentClipboard) {
        this.mySilentClipboard = silentClipboard;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(1);
        }
        return e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(2);
        }
        Project project2 = e.getProject();
        FileHistoryUi ui2 = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (project2 == null || ui2 == null || selection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        String commitMessage = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        e.getPresentation().setEnabled(VcsLogCommitSelection.isNotEmpty(selection) && commitMessage != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CreatePatchFromHistoryActionProvider.$$$reportNull$$$0(3);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, this);
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        String commitMessage = (String)e.getRequiredData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
        selection.requestFullDetails(detailsList -> {
            List<Change> changes = VcsLogUtil.collectChanges(detailsList);
            CreatePatchFromChangesAction.createPatch(project2, commitMessage, changes, this.mySilentClipboard);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryActionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/history/CreatePatchFromHistoryActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }

    public static class Clipboard
    extends CreatePatchFromHistoryActionProvider {
        public Clipboard() {
            super(true);
        }
    }

    public static class Dialog
    extends CreatePatchFromHistoryActionProvider {
        public Dialog() {
            super(false);
        }
    }
}

