/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.convert.AdvancedDtdOptions;
import org.intellij.plugins.relaxNG.convert.AdvancedOptionsDialog;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.jetbrains.annotations.NotNull;

public class ConvertSchemaSettingsImpl
implements ConvertSchemaSettings {
    static final String OUTPUT_TYPE = "output-type";
    static final String OUTPUT_PATH = "output-path";
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final Project myProject;
    private final SchemaType myInputType;
    private Map<String, ?> myInputOptions;
    private Map<String, ?> myOutputOptions;
    private JPanel myRoot;
    private JRadioButton myOutputRng;
    private JRadioButton myOutputRnc;
    private JRadioButton myOutputXsd;
    private JRadioButton myOutputDtd;
    private ComboBox<String> myEncoding;
    private JTextField myIndent;
    private JTextField myLineLength;
    private TextFieldWithBrowseButton myOutputDestination;

    public ConvertSchemaSettingsImpl(Project project2, @NotNull SchemaType inputType, VirtualFile firstFile) {
        if (inputType == null) {
            ConvertSchemaSettingsImpl.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myInputOptions = Collections.emptyMap();
        this.myOutputOptions = Collections.emptyMap();
        this.myProject = project2;
        this.myInputType = inputType;
        LanguageFileType type2 = switch (inputType) {
            case SchemaType.RNG -> {
                this.myOutputRng.setVisible(false);
                this.myOutputXsd.setSelected(true);
                yield XmlFileType.INSTANCE;
            }
            case SchemaType.RNC -> {
                this.myOutputRnc.setVisible(false);
                this.myOutputRng.setSelected(true);
                yield RncFileType.getInstance();
            }
            case SchemaType.XSD -> {
                this.myOutputXsd.setVisible(false);
                this.myOutputRng.setSelected(true);
                yield XmlFileType.INSTANCE;
            }
            case SchemaType.DTD -> {
                this.myOutputDtd.setVisible(false);
                this.myOutputRng.setSelected(true);
                yield DTDFileType.INSTANCE;
            }
            case SchemaType.XML -> {
                this.myOutputRng.setSelected(true);
                yield XmlFileType.INSTANCE;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        };
        Charset[] charsets = CharsetToolkit.getAvailableCharsets();
        ArrayList<String> suggestions = new ArrayList<String>(charsets.length);
        for (Charset charset : charsets) {
            if (!charset.canEncode()) continue;
            String name = charset.name();
            suggestions.add(name);
        }
        this.myEncoding.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(suggestions)));
        Charset charset = EncodingProjectManager.getInstance((Project)project2).getDefaultCharset();
        this.myEncoding.setSelectedItem((Object)charset.name());
        CodeStyleSettings styleSettings = CodeStyle.getSettings((Project)project2);
        int indent = styleSettings.getIndentSize((FileType)type2);
        this.myIndent.setText(String.valueOf(indent));
        this.myLineLength.setText(String.valueOf(styleSettings.getDefaultRightMargin()));
        SchemaType outputType = this.getOutputType();
        this.myLineLength.setEnabled(outputType == SchemaType.DTD || outputType == SchemaType.RNC);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        Module module = ProjectRootManager.getInstance((Project)project2).getFileIndex().getModuleForFile(firstFile);
        descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)module);
        this.myOutputDestination.addBrowseFolderListener(RelaxngBundle.message("relaxng.convert-schema.settings.destination.title", new Object[0]), RelaxngBundle.message("relaxng.convert-schema.settings.destination.message", new Object[0]), project2, descriptor);
        JTextField tf = this.myOutputDestination.getTextField();
        tf.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ConvertSchemaSettingsImpl.this.myPropertyChangeSupport.firePropertyChange(ConvertSchemaSettingsImpl.OUTPUT_PATH, null, ConvertSchemaSettingsImpl.this.getOutputDestination());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/relaxNG/convert/ConvertSchemaSettingsImpl$1", "textChanged"));
            }
        });
        tf.setText(firstFile.getParent().getPath().replace('/', File.separatorChar));
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SchemaType type2 = ConvertSchemaSettingsImpl.this.getOutputType();
                    ConvertSchemaSettingsImpl.this.myPropertyChangeSupport.firePropertyChange(ConvertSchemaSettingsImpl.OUTPUT_TYPE, null, (Object)type2);
                    ConvertSchemaSettingsImpl.this.myLineLength.setEnabled(type2 == SchemaType.DTD || type2 == SchemaType.RNC);
                }
            }
        };
        this.myOutputRng.addItemListener(listener2);
        this.myOutputRnc.addItemListener(listener2);
        this.myOutputXsd.addItemListener(listener2);
        this.myOutputDtd.addItemListener(listener2);
        if (inputType == SchemaType.DTD) {
            this.myInputOptions = AdvancedDtdOptions.prepareNamespaceMap(project2, firstFile);
        }
    }

    @Override
    @NotNull
    public SchemaType getOutputType() {
        if (this.myOutputRng.isSelected()) {
            SchemaType schemaType = SchemaType.RNG;
            if (schemaType == null) {
                ConvertSchemaSettingsImpl.$$$reportNull$$$0(1);
            }
            return schemaType;
        }
        if (this.myOutputRnc.isSelected()) {
            SchemaType schemaType = SchemaType.RNC;
            if (schemaType == null) {
                ConvertSchemaSettingsImpl.$$$reportNull$$$0(2);
            }
            return schemaType;
        }
        if (this.myOutputXsd.isSelected()) {
            SchemaType schemaType = SchemaType.XSD;
            if (schemaType == null) {
                ConvertSchemaSettingsImpl.$$$reportNull$$$0(3);
            }
            return schemaType;
        }
        assert (this.myOutputDtd.isSelected());
        SchemaType schemaType = SchemaType.DTD;
        if (schemaType == null) {
            ConvertSchemaSettingsImpl.$$$reportNull$$$0(4);
        }
        return schemaType;
    }

    @Override
    public String getOutputEncoding() {
        return (String)this.myEncoding.getSelectedItem();
    }

    @Override
    public int getIndent() {
        return ConvertSchemaSettingsImpl.parseInt(this.myIndent.getText().trim());
    }

    private static int parseInt(String s) {
        try {
            return s.length() > 0 ? Integer.parseInt(s) : -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public int getLineLength() {
        return ConvertSchemaSettingsImpl.parseInt(this.myLineLength.getText());
    }

    @Override
    public String getOutputDestination() {
        return this.myOutputDestination.getText();
    }

    @Override
    public void addAdvancedSettings(List<? super String> inputParams, List<? super String> outputParams) {
        ConvertSchemaSettingsImpl.setParams(this.myInputOptions, inputParams);
        if (this.getOutputType() == SchemaType.XSD) {
            ConvertSchemaSettingsImpl.setParams(this.myOutputOptions, outputParams);
        }
    }

    private static void setParams(Map<String, ?> map2, List<? super String> inputParams) {
        Set<String> set = map2.keySet();
        for (String s : set) {
            Object value2 = map2.get(s);
            if (value2 == Boolean.TRUE) {
                inputParams.add(s);
                continue;
            }
            if (value2 == Boolean.FALSE) {
                inputParams.add("no-" + s);
                continue;
            }
            if (value2 == null) continue;
            inputParams.add(s + "=" + value2);
        }
    }

    public JComponent getRoot() {
        return this.myRoot;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myOutputDestination;
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener2) {
        this.myPropertyChangeSupport.addPropertyChangeListener(name, listener2);
    }

    public void showAdvancedSettings() {
        AdvancedOptionsDialog dialog = new AdvancedOptionsDialog(this.myProject, this.myInputType, this.getOutputType());
        dialog.setOptions(this.myInputOptions, this.myOutputOptions);
        if (dialog.showAndGet()) {
            this.myInputOptions = dialog.getInputOptions();
            this.myOutputOptions = dialog.getOutputOptions();
        }
    }

    public boolean hasAdvancedSettings() {
        return this.getOutputType() == SchemaType.XSD || this.myInputType == SchemaType.DTD;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JTextField jTextField2;
        ComboBox comboBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.border-title.output-type"), (int)0, (int)0, null, null));
        this.myOutputRnc = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.radio-button.relax-ng-compact-syntax"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputXsd = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.radio-button.w3c-xml-schema"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputDtd = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.radio-button.dtd"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputRng = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.radio-button.relax-ng-xml-syntax"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.border-title.output-options"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.label.encoding"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEncoding = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myIndent = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.label.indent"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.label.line-length"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLineLength = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RelaxngBundle", ConvertSchemaSettingsImpl.class).getString("relaxng.convert-schema.settings.border-title.output-destination"), (int)0, (int)0, null, null));
        this.myOutputDestination = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        jLabel.setLabelFor((Component)comboBox);
        jLabel2.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                if (++i == string2.length()) break;
                if (!bl && string2.charAt(i) != '&') {
                    bl = true;
                    c = string2.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/convert/ConvertSchemaSettingsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/convert/ConvertSchemaSettingsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

