/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.util.GradleDslModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.PropertiesElementDescription;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Experimental
public class GradleBlockModelMap {
    private Map<Class<? extends GradleDslModel>, Map<Class<? extends GradleDslModel>, BlockModelBuilder<?, ?>>> blockMapCache = new ConcurrentHashMap();
    private Map<Class<? extends GradlePropertiesDslElement>, ImmutableMap<String, PropertiesElementDescription>> elementMapCache = new ConcurrentHashMap<Class<? extends GradlePropertiesDslElement>, ImmutableMap<String, PropertiesElementDescription>>();

    GradleBlockModelMap() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                GradleBlockModelMap.this.blockMapCache.clear();
                GradleBlockModelMap.this.elementMapCache.clear();
            }

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                GradleBlockModelMap.this.blockMapCache.clear();
                GradleBlockModelMap.this.elementMapCache.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBlockModelMap$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public <M extends GradleDslModel, PM extends GradleDslModel, PD extends GradlePropertiesDslElement> M getBlockModel(PD dslElement, Class<? extends PM> parentType, Class<M> modelInterface) {
        this.validateTypes(dslElement, parentType, modelInterface);
        Map<Class<GradleDslModel>, BlockModelBuilder<?, ?>> blockMap = this.getOrCreateBlockMap(parentType);
        BlockModelBuilder<?, ?> builder = blockMap.get(modelInterface);
        if (builder == null) {
            throw new IllegalArgumentException("Block model for " + modelInterface + " is not registered in " + parentType);
        }
        return (M)builder.create(dslElement);
    }

    private <P extends GradleDslModel, M extends GradleDslModel> void validateTypes(GradlePropertiesDslElement element, Class<? extends P> parentType, Class<M> modelInterface) {
    }

    @NotNull
    public ImmutableMap<String, PropertiesElementDescription> getOrCreateElementMap(Class<? extends GradlePropertiesDslElement> parentType) {
        ImmutableMap immutableMap = this.elementMapCache.computeIfAbsent(parentType, GradleBlockModelMap::calculateElements);
        if (immutableMap == null) {
            GradleBlockModelMap.$$$reportNull$$$0(0);
        }
        return immutableMap;
    }

    @NotNull
    private Map<Class<? extends GradleDslModel>, BlockModelBuilder<?, ?>> getOrCreateBlockMap(Class<? extends GradleDslModel> parentType) {
        Map map = this.blockMapCache.computeIfAbsent(parentType, GradleBlockModelMap::calculateBlocks);
        if (map == null) {
            GradleBlockModelMap.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    public <T extends GradleDslModel> Set<Class<? extends GradleDslModel>> childrenOf(Class<T> parentType) {
        Map<Class<GradleDslModel>, BlockModelBuilder<?, ?>> modelsMap = this.getOrCreateBlockMap(parentType);
        Set<Class<? extends GradleDslModel>> set = Collections.unmodifiableSet(modelsMap.keySet());
        if (set == null) {
            GradleBlockModelMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @TestOnly
    void resetCache() {
        this.blockMapCache.clear();
        this.elementMapCache.clear();
    }

    public static ImmutableMap<String, PropertiesElementDescription> getElementMap(Class<? extends GradlePropertiesDslElement> parentType) {
        return ((GradleBlockModelMap)ApplicationManager.getApplication().getService(GradleBlockModelMap.class)).getOrCreateElementMap(parentType);
    }

    public static <T extends GradleDslModel, P extends GradleDslModel, PD extends GradlePropertiesDslElement> T get(PD dslElement, Class<? extends P> parentType, Class<T> modelInterface) {
        return GradleBlockModelMap.getInstance().getBlockModel(dslElement, parentType, modelInterface);
    }

    public static GradleBlockModelMap getInstance() {
        return (GradleBlockModelMap)ApplicationManager.getApplication().getService(GradleBlockModelMap.class);
    }

    private static ImmutableMap<String, PropertiesElementDescription> calculateElements(Class<? extends GradlePropertiesDslElement> pt) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BlockModelProvider.EP.forEachExtensionSafe(p -> {
            Map<String, PropertiesElementDescription<?>> elementsMap = p.elementsMap();
            if (elementsMap != null) {
                builder.putAll(elementsMap);
            }
        });
        return builder.build();
    }

    private static Map<Class<? extends GradleDslModel>, BlockModelBuilder<?, ?>> calculateBlocks(Class<? extends GradleDslModel> parentType) {
        HashMap result = new HashMap();
        BlockModelProvider.EP.forEachExtensionSafe(p -> {
            if (!parentType.isAssignableFrom(p.getParentClass())) {
                return;
            }
            List builders = p.availableModels();
            if (builders != null) {
                builders.forEach(builder -> result.put((Class<? extends GradleDslModel>)builder.modelClass(), (BlockModelBuilder<?, ?>)builder));
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/gradle/dsl/model/GradleBlockModelMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateElementMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBlockMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenOf";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    @ApiStatus.Experimental
    public static interface BlockModelBuilder<M extends GradleDslModel, P extends GradlePropertiesDslElement> {
        @NotNull
        public Class<M> modelClass();

        @NotNull
        public M create(@NotNull P var1);
    }

    @ApiStatus.Experimental
    public static interface BlockModelProvider<ParentModel extends GradleDslModel, ParentDsl extends GradlePropertiesDslElement> {
        public static final ExtensionPointName<BlockModelProvider> EP = ExtensionPointName.create((String)"org.jetbrains.idea.gradle.dsl.blockModel");

        @NotNull
        public Class<ParentModel> getParentClass();

        @NotNull
        public List<BlockModelBuilder<?, ParentDsl>> availableModels();

        @NotNull
        public Map<String, PropertiesElementDescription<?>> elementsMap();
    }
}

