/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.features;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.TextSearchContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeIdMapper;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.usages.impl.ScopeRuleValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereStateFeaturesProvider;", "", "()V", "getAllTabQueryFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "", "query", "", "getFileQueryFeatures", "getSearchStateFeatures", "project", "Lcom/intellij/openapi/project/Project;", "tabId", "searchScope", "Lcom/intellij/ide/util/scopeChooser/ScopeDescriptor;", "isSearchEverywhere", "getTextContributorFeatures", "hasSuitableContributor", "currentTabId", "featuresTab", "containsAbbreviations", "", "isCamelCase", "Companion", "intellij.searchEverywhereMl.ranking"})
@SourceDebugExtension(value={"SMAP\nSearchEverywhereStateFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereStateFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereStateFeaturesProvider\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,112:1\n1064#2,2:113\n163#2,6:115\n163#2,6:121\n1183#2,3:127\n420#2:130\n502#2,5:131\n1064#2,2:136\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereStateFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereStateFeaturesProvider\n*L\n55#1:113,2\n80#1:115,6\n84#1:121,6\n100#1:127,3\n110#1:130\n110#1:131,5\n110#1:136,2\n*E\n"})
public final class SearchEverywhereStateFeaturesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntEventField QUERY_LENGTH_DATA_KEY = EventFields.Int((String)"queryLength");
    @NotNull
    private static final BooleanEventField IS_EMPTY_QUERY_DATA_KEY = EventFields.Boolean((String)"isEmptyQuery");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_PATH_DATA_KEY = EventFields.Boolean((String)"queryContainsPath");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY = EventFields.Boolean((String)"queryContainsCommandChar");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_SPACES_DATA_KEY = EventFields.Boolean((String)"queryContainsSpaces");
    @NotNull
    private static final BooleanEventField QUERY_IS_CAMEL_CASE_DATA_KEY = EventFields.Boolean((String)"queryIsCamelCase");
    @NotNull
    private static final BooleanEventField QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY = EventFields.Boolean((String)"queryContainsAbbreviations");
    @NotNull
    private static final BooleanEventField QUERY_IS_ALL_UPPERCASE_DATA_KEY = EventFields.Boolean((String)"queryIsAllUppercase");
    @NotNull
    private static final BooleanEventField IS_DUMB_MODE = EventFields.Boolean((String)"isDumbMode");
    @NotNull
    private static final StringEventField SEARCH_SCOPE_DATA_KEY = EventFields.StringValidatedByCustomRule((String)"searchScope", ScopeRuleValidator.class);
    @NotNull
    private static final BooleanEventField IS_SEARCH_EVERYWHERE_DATA_KEY = EventFields.Boolean((String)"isSearchEverywhere");
    @NotNull
    private static final BooleanEventField IS_CASE_SENSITIVE = EventFields.Boolean((String)"isCaseSensitive");
    @NotNull
    private static final BooleanEventField IS_WHOLE_WORDS_ONLY = EventFields.Boolean((String)"isWholeWordsOnly");
    @NotNull
    private static final BooleanEventField IS_REGULAR_EXPRESSIONS = EventFields.Boolean((String)"isRegularExpressions");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EventPair<?>> getSearchStateFeatures(@Nullable Project project, @NotNull String tabId, @NotNull String query, @Nullable ScopeDescriptor searchScope, boolean isSearchEverywhere) {
        Object object;
        boolean bl;
        BooleanEventField booleanEventField;
        Object[] objectArray;
        block6: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            objectArray = new EventPair[7];
            objectArray[0] = QUERY_LENGTH_DATA_KEY.with((Object)query.length());
            objectArray[1] = IS_EMPTY_QUERY_DATA_KEY.with((Object)(((CharSequence)query).length() == 0 ? 1 : 0));
            objectArray[2] = QUERY_CONTAINS_SPACES_DATA_KEY.with((Object)StringsKt.contains$default((CharSequence)query, (CharSequence)" ", (boolean)false, (int)2, null));
            objectArray[3] = QUERY_IS_CAMEL_CASE_DATA_KEY.with((Object)this.isCamelCase(query));
            objectArray[4] = QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY.with((Object)this.containsAbbreviations(query));
            CharSequence charSequence = query;
            booleanEventField = QUERY_IS_ALL_UPPERCASE_DATA_KEY;
            int n = 5;
            Object[] objectArray2 = objectArray;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isUpperCase(it)) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        boolean bl3 = bl;
        objectArray2[n] = booleanEventField.with((Object)bl3);
        objectArray[6] = IS_SEARCH_EVERYWHERE_DATA_KEY.with((Object)isSearchEverywhere);
        ArrayList features2 = CollectionsKt.arrayListOf((Object[])objectArray);
        Project project2 = project;
        if (project2 != null) {
            Project it = project2;
            boolean bl4 = false;
            boolean isDumb = DumbService.Companion.isDumb(project);
            features2.add(IS_DUMB_MODE.with((Object)isDumb));
        }
        String string = FileSearchEverywhereContributor.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        if (this.hasSuitableContributor(tabId, string)) {
            features2.addAll((Collection)this.getFileQueryFeatures(query));
        }
        if (this.hasSuitableContributor(tabId, "SearchEverywhereContributor.All")) {
            features2.addAll((Collection)this.getAllTabQueryFeatures(query));
        }
        if ((object = searchScope) != null && (object = object.getDisplayName()) != null) {
            Object searchScopeDisplayName = object;
            boolean bl5 = false;
            String scopeId = ScopeIdMapper.Companion.getInstance().getScopeSerializationId((String)searchScopeDisplayName);
            features2.add(SEARCH_SCOPE_DATA_KEY.with((Object)scopeId));
        }
        if (project != null && Intrinsics.areEqual((Object)tabId, (Object)TextSearchContributor.class.getSimpleName())) {
            features2.addAll((Collection)this.getTextContributorFeatures(project));
        }
        return features2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<Boolean>> getFileQueryFeatures(String query) {
        int n;
        int n2;
        BooleanEventField booleanEventField;
        int n3;
        block2: {
            void $this$indexOfLast$iv;
            n3 = StringsKt.getLastIndex((CharSequence)query);
            CharSequence charSequence = query;
            booleanEventField = QUERY_CONTAINS_PATH_DATA_KEY;
            boolean $i$f$indexOfLast = false;
            int n4 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n4) {
                do {
                    int index$iv = n4--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '/' || it == '\\')) continue;
                    n2 = index$iv;
                    break block2;
                } while (0 <= n4);
            }
            n2 = -1;
        }
        int n5 = n = n2;
        return CollectionsKt.listOf((Object)booleanEventField.with((Object)(1 <= n5 ? n5 < n3 : false)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<Boolean>> getAllTabQueryFeatures(String query) {
        int n;
        BooleanEventField booleanEventField;
        block2: {
            void $this$indexOfLast$iv;
            CharSequence charSequence = query;
            booleanEventField = QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '/')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n2);
            }
            n = -1;
        }
        int n3 = n;
        return CollectionsKt.listOf((Object)booleanEventField.with((Object)(n3 == 0 ? 1 : 0)));
    }

    private final List<EventPair<Boolean>> getTextContributorFeatures(Project project) {
        FindModel findModel = FindManager.getInstance((Project)project).getFindInProjectModel();
        boolean bl = false;
        Object[] objectArray = new EventPair[]{IS_CASE_SENSITIVE.with((Object)findModel.isCaseSensitive()), IS_WHOLE_WORDS_ONLY.with((Object)findModel.isWholeWordsOnly()), IS_REGULAR_EXPRESSIONS.with((Object)findModel.isRegularExpressions())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean hasSuitableContributor(String currentTabId, String featuresTab) {
        return Intrinsics.areEqual((Object)currentTabId, (Object)featuresTab) || Intrinsics.areEqual((Object)currentTabId, (Object)"SearchEverywhereContributor.All");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCamelCase(CharSequence $this$isCamelCase) {
        CharSequence $this$forEachIndexed$iv = $this$isCamelCase;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int index = n;
            boolean bl = false;
            if (index == 0 || Character.isUpperCase((char)c) == Character.isUpperCase($this$isCamelCase.charAt(index - 1))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsAbbreviations(CharSequence $this$containsAbbreviations) {
        boolean bl;
        block2: {
            void $this$filterTo$iv$iv;
            CharSequence $this$filter$iv = $this$containsAbbreviations;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                if (!Character.isLetter(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            CharSequence $this$all$iv = (CharSequence)((Object)destination$iv$iv);
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl3 = false;
                if (Character.isUpperCase(it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/searchEverywhereMl/ranking/features/SearchEverywhereStateFeaturesProvider$Companion;", "", "()V", "IS_CASE_SENSITIVE", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_DUMB_MODE", "getIS_DUMB_MODE$intellij_searchEverywhereMl_ranking", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_EMPTY_QUERY_DATA_KEY", "getIS_EMPTY_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking", "IS_REGULAR_EXPRESSIONS", "IS_SEARCH_EVERYWHERE_DATA_KEY", "IS_WHOLE_WORDS_ONLY", "QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY", "getQUERY_CONTAINS_ABBREVIATIONS_DATA_KEY$intellij_searchEverywhereMl_ranking", "QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY", "getQUERY_CONTAINS_COMMAND_CHAR_DATA_KEY$intellij_searchEverywhereMl_ranking", "QUERY_CONTAINS_PATH_DATA_KEY", "getQUERY_CONTAINS_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking", "QUERY_CONTAINS_SPACES_DATA_KEY", "getQUERY_CONTAINS_SPACES_DATA_KEY$intellij_searchEverywhereMl_ranking", "QUERY_IS_ALL_UPPERCASE_DATA_KEY", "getQUERY_IS_ALL_UPPERCASE_DATA_KEY$intellij_searchEverywhereMl_ranking", "QUERY_IS_CAMEL_CASE_DATA_KEY", "getQUERY_IS_CAMEL_CASE_DATA_KEY$intellij_searchEverywhereMl_ranking", "QUERY_LENGTH_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getQUERY_LENGTH_DATA_KEY$intellij_searchEverywhereMl_ranking", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "SEARCH_SCOPE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFeaturesDefinition", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "intellij.searchEverywhereMl.ranking"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntEventField getQUERY_LENGTH_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_LENGTH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EMPTY_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return IS_EMPTY_QUERY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_CONTAINS_PATH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_COMMAND_CHAR_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_CONTAINS_COMMAND_CHAR_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_SPACES_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_CONTAINS_SPACES_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_IS_CAMEL_CASE_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_IS_CAMEL_CASE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_CONTAINS_ABBREVIATIONS_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_CONTAINS_ABBREVIATIONS_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getQUERY_IS_ALL_UPPERCASE_DATA_KEY$intellij_searchEverywhereMl_ranking() {
            return QUERY_IS_ALL_UPPERCASE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_DUMB_MODE$intellij_searchEverywhereMl_ranking() {
            return IS_DUMB_MODE;
        }

        @NotNull
        public final List<EventField<?>> getFeaturesDefinition() {
            Object[] objectArray = new PrimitiveEventField[]{this.getQUERY_LENGTH_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getIS_EMPTY_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getQUERY_CONTAINS_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getQUERY_CONTAINS_COMMAND_CHAR_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getQUERY_CONTAINS_SPACES_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getQUERY_IS_CAMEL_CASE_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getQUERY_CONTAINS_ABBREVIATIONS_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getQUERY_IS_ALL_UPPERCASE_DATA_KEY$intellij_searchEverywhereMl_ranking(), this.getIS_DUMB_MODE$intellij_searchEverywhereMl_ranking(), SEARCH_SCOPE_DATA_KEY, IS_SEARCH_EVERYWHERE_DATA_KEY, IS_CASE_SENSITIVE, IS_WHOLE_WORDS_ONLY, IS_REGULAR_EXPRESSIONS};
            return CollectionsKt.arrayListOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

