/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hi;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.hi.HindiStemFilter;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;

public final class HindiAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public HindiAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    public HindiAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public HindiAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result2 = new LowerCaseFilter(source);
        result2 = new DecimalDigitFilter(result2);
        if (!this.stemExclusionSet.isEmpty()) {
            result2 = new SetKeywordMarkerFilter(result2, this.stemExclusionSet);
        }
        result2 = new IndicNormalizationFilter(result2);
        result2 = new HindiNormalizationFilter(result2);
        result2 = new StopFilter(result2, this.stopwords);
        result2 = new HindiStemFilter(result2);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result2);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result2 = new LowerCaseFilter(in);
        result2 = new DecimalDigitFilter(result2);
        result2 = new IndicNormalizationFilter(result2);
        result2 = new HindiNormalizationFilter(result2);
        return result2;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(HindiAnalyzer.class.getResourceAsStream(HindiAnalyzer.DEFAULT_STOPWORD_FILE), HindiAnalyzer.DEFAULT_STOPWORD_FILE), HindiAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

