/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.text.VersionComparatorUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.project.DefaultProjectDependenciesResolver;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3Sl4jLoggerWrapper;
import org.jetbrains.idea.maven.server.Maven3XServerEmbedder;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.embedder.CustomMaven36ArtifactDescriptorReader;
import org.jetbrains.idea.maven.server.embedder.CustomMaven36ArtifactResolver;

public class Maven36ServerEmbedderImpl
extends Maven3XServerEmbedder {
    public Maven36ServerEmbedderImpl(MavenEmbedderSettings settings) throws RemoteException {
        super(settings);
    }

    protected void customizeComponents(@Nullable MavenWorkspaceMap workspaceMap) {
        super.customizeComponents(workspaceMap);
        if (this.myEmbedderSettings.useCustomDependenciesResolver()) {
            PluginDependenciesResolver pluginDependenciesResolver;
            ProjectDependenciesResolver projectDependenciesResolver;
            RepositorySystem repositorySystem;
            ArtifactDescriptorReader artifactDescriptorReader;
            ArtifactResolver artifactResolver = (ArtifactResolver)this.getComponent(ArtifactResolver.class);
            if (artifactResolver instanceof DefaultArtifactResolver) {
                artifactResolver = new CustomMaven36ArtifactResolver(artifactResolver);
                this.addComponent(artifactResolver, ArtifactResolver.class);
            }
            if ((artifactDescriptorReader = (ArtifactDescriptorReader)this.getComponent(ArtifactDescriptorReader.class)) instanceof DefaultArtifactDescriptorReader) {
                ((DefaultArtifactDescriptorReader)artifactDescriptorReader).setArtifactResolver(artifactResolver);
                artifactDescriptorReader = new CustomMaven36ArtifactDescriptorReader(artifactDescriptorReader);
                this.addComponent(artifactDescriptorReader, ArtifactDescriptorReader.class);
            }
            if ((repositorySystem = (RepositorySystem)this.getComponent(RepositorySystem.class)) instanceof DefaultRepositorySystem) {
                DefaultRepositorySystem defaultRepositorySystem = (DefaultRepositorySystem)repositorySystem;
                defaultRepositorySystem.setArtifactResolver(artifactResolver);
                defaultRepositorySystem.setArtifactDescriptorReader(artifactDescriptorReader);
                DependencyCollector dependencyCollector = VersionComparatorUtil.compare((String)this.getMavenVersion(), (String)"3.9.0") >= 0 ? (DependencyCollector)this.getComponentIfExists(DependencyCollector.class, "df") : (DependencyCollector)this.getComponentIfExists(DependencyCollector.class);
                try {
                    Method method = dependencyCollector.getClass().getMethod("setArtifactDescriptorReader", ArtifactDescriptorReader.class);
                    method.invoke((Object)dependencyCollector, artifactDescriptorReader);
                    defaultRepositorySystem.setDependencyCollector(dependencyCollector);
                }
                catch (Throwable e) {
                    MavenServerGlobals.getLogger().warn(e);
                }
            }
            if ((projectDependenciesResolver = (ProjectDependenciesResolver)this.getComponent(ProjectDependenciesResolver.class)) instanceof DefaultProjectDependenciesResolver) {
                try {
                    DefaultProjectDependenciesResolver defaultResolver = (DefaultProjectDependenciesResolver)projectDependenciesResolver;
                    Field repoSystemField = defaultResolver.getClass().getDeclaredField("repoSystem");
                    repoSystemField.setAccessible(true);
                    repoSystemField.set(defaultResolver, repositorySystem);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().warn((Throwable)e);
                }
            }
            if ((pluginDependenciesResolver = (PluginDependenciesResolver)this.getComponent(PluginDependenciesResolver.class)) instanceof DefaultPluginDependenciesResolver) {
                try {
                    DefaultPluginDependenciesResolver defaultResolver = (DefaultPluginDependenciesResolver)pluginDependenciesResolver;
                    Field repoSystemField = defaultResolver.getClass().getDeclaredField("repoSystem");
                    repoSystemField.setAccessible(true);
                    repoSystemField.set(defaultResolver, repositorySystem);
                }
                catch (Exception e) {
                    MavenServerGlobals.getLogger().warn((Throwable)e);
                }
            }
        }
    }

    protected void resetComponents() {
        ArtifactDescriptorReader artifactDescriptorReader;
        super.resetComponents();
        ArtifactResolver artifactResolver = (ArtifactResolver)this.getComponent(ArtifactResolver.class);
        if (artifactResolver instanceof CustomMaven36ArtifactResolver) {
            ((CustomMaven36ArtifactResolver)artifactResolver).reset();
        }
        if ((artifactDescriptorReader = (ArtifactDescriptorReader)this.getComponent(ArtifactDescriptorReader.class)) instanceof CustomMaven36ArtifactDescriptorReader) {
            ((CustomMaven36ArtifactDescriptorReader)artifactDescriptorReader).reset();
        }
    }

    protected void initLogging(Maven3ServerConsoleLogger consoleWrapper) {
        Maven3Sl4jLoggerWrapper.setCurrentWrapper(consoleWrapper);
    }
}

