/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.ReportSectionsUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageReport {
    private final File myDataFile;
    private File mySourceMapFile;
    private final boolean myAppendUnloaded;
    private final ClassFinder myClassFinder;
    private final boolean myMergeFile;

    /*
     * WARNING - void declaration
     */
    public CoverageReport(File dataFile, boolean appendUnloaded, ClassFinder classFinder, boolean mergeFile) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myDataFile = var1_1;
        this.myAppendUnloaded = var2_2;
        this.myClassFinder = var3_3;
        this.myMergeFile = mergeFile;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void save(ProjectData projectData) {
        projectData.stop();
        CoverageIOUtil.FileLock lock = null;
        try {
            void var1_1;
            CoverageReport.finalizeCoverage(projectData, this.myAppendUnloaded, this.myClassFinder, this.mySourceMapFile != null);
            lock = CoverageIOUtil.FileLock.lock(this.myDataFile);
            if (this.myMergeFile) {
                ProjectData load = ProjectDataLoader.load(this.myDataFile);
                projectData.merge(load);
            }
            CoverageReport.save((ProjectData)var1_1, this.myDataFile, this.mySourceMapFile);
        }
        catch (OutOfMemoryError e) {
            ErrorReporter.warn("Out of memory error occurred, try to increase memory available for the JVM, or make include / exclude patterns more specific", e);
            CoverageIOUtil.FileLock.unlock(lock);
            return;
        }
        catch (Throwable e2) {
            void var3_6;
            ErrorReporter.warn("Unexpected error during report saving", (Throwable)var3_6);
            {
                catch (Throwable throwable) {
                    void var2_3;
                    CoverageIOUtil.FileLock.unlock((CoverageIOUtil.FileLock)var2_3);
                    throw throwable;
                }
            }
            CoverageIOUtil.FileLock.unlock(lock);
            return;
        }
        CoverageIOUtil.FileLock.unlock(lock);
        return;
    }

    /*
     * WARNING - void declaration
     */
    public void setSourceMapFile(File sourceMapFile) {
        void var1_1;
        this.mySourceMapFile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void finalizeCoverage(ProjectData projectData, boolean appendUnloaded, ClassFinder cf, boolean calculateSource) {
        ProjectData projectData2;
        void var1_1;
        projectData.applyHits();
        if (var1_1 != false) {
            void var3_3;
            void var2_2;
            UnloadedUtil.appendUnloaded(projectData, (ClassFinder)var2_2, (boolean)var3_3, projectData.isBranchCoverage());
        }
        projectData.applyLineMappings();
        projectData2.dropIgnoredLines();
    }

    /*
     * WARNING - void declaration
     */
    public static void save(ProjectData projectData, File dataFile, File sourceMapFile) {
        DataOutputStream os = null;
        try {
            void var2_3;
            ProjectData projectData2;
            os = CoverageIOUtil.openWriteFile(dataFile);
            TObjectIntHashMap<String> dict = new TObjectIntHashMap<String>();
            HashMap<String, ClassData> classes = new HashMap<String, ClassData>(projectData.getClasses());
            CoverageIOUtil.writeINT(os, classes.size());
            CoverageReport.saveDictionary(os, dict, classes);
            CoverageReport.saveData(os, dict, classes);
            CoverageIOUtil.writeINT(os, 1);
            CoverageIOUtil.writeUTF(os, CoverageReport.getExtraInfoString());
            ReportSectionsUtil.saveSections(projectData2, os, dict);
            CoverageReport.saveSourceMap(classes, (File)var2_3);
        }
        catch (IOException e) {
            try {
                void var1_2;
                ErrorReporter.warn("Error writing file " + var1_2.getPath(), e);
            }
            catch (Throwable throwable) {
                void var3_4;
                CoverageIOUtil.close((Closeable)var3_4);
                throw throwable;
            }
            CoverageIOUtil.close(os);
            return;
        }
        CoverageIOUtil.close(os);
        return;
    }

    private static String getExtraInfoString() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public static void saveSourceMap(Map<String, ClassData> classes, File sourceMapFile) {
        if (sourceMapFile == null) {
            return;
        }
        Map<Object, Object> readNames = Collections.emptyMap();
        try {
            if (sourceMapFile.exists() && sourceMapFile.length() > 0L) {
                readNames = CoverageReport.loadSourceMapFromFile(classes, sourceMapFile);
            }
        }
        catch (IOException e) {
            ErrorReporter.warn("Error loading source map from " + sourceMapFile.getPath(), e);
        }
        try {
            Map<String, ClassData> map;
            void var2_2;
            CoverageReport.doSaveSourceMap((Map<String, String>)var2_2, sourceMapFile, map);
            return;
        }
        catch (IOException e) {
            void var3_4;
            void var1_1;
            ErrorReporter.warn("Error writing source map " + var1_1.getPath(), (Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void loadAndApplySourceMap(ProjectData projectData, File sourceMapFile) throws IOException {
        Map<String, String> map;
        map = CoverageReport.loadSourceMapFromFile(new HashMap<String, ClassData>(), (File)((Object)map));
        for (Map.Entry entry : map.entrySet()) {
            void var3_4;
            String className = (String)entry.getKey();
            String string = (String)entry.getValue();
            ClassData data = projectData.getClassData(className);
            if (data == null) continue;
            var3_4.setSource(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> loadSourceMapFromFile(Map<String, ClassData> classes, File sourceMapFile) throws IOException {
        void var4_7;
        DataInputStream in = null;
        try {
            void var3_5;
            in = new DataInputStream(new FileInputStream(sourceMapFile));
            int classNumber = CoverageIOUtil.readINT(in);
            HashMap<String, String> readNames = new HashMap<String, String>(classNumber);
            for (int i = 0; i < classNumber; ++i) {
                ClassData data;
                String className = CoverageIOUtil.readUTFFast(in);
                String classSource = CoverageIOUtil.readUTFFast(in);
                if ("".equals(classSource) || (data = classes.get(className)) != null && data.getSource() != null && data.getSource().equals(classSource)) continue;
                readNames.put(className, classSource);
            }
            var4_7 = var3_5;
        }
        catch (Throwable throwable) {
            void var2_4;
            CoverageIOUtil.close((Closeable)var2_4);
            throw throwable;
        }
        CoverageIOUtil.close(in);
        return var4_7;
    }

    private static void saveData(DataOutputStream os, final TObjectIntHashMap<String> dict, Map<String, ClassData> classes) throws IOException {
        for (ClassData classData : classes.values()) {
            classData.save(os, new DictionaryLookup(){

                /*
                 * WARNING - void declaration
                 */
                public final int getDictionaryIndex(String className) {
                    if (dict.containsKey(className)) {
                        void var1_1;
                        return dict.get(var1_1);
                    }
                    return -1;
                }
            });
        }
    }

    private static void saveDictionary(DataOutputStream os, TObjectIntHashMap<String> dict, Map<String, ClassData> classes) throws IOException {
        Iterator iterator;
        int i = 0;
        for (String className : iterator.keySet()) {
            dict.put(className, i++);
            CoverageIOUtil.writeUTF(os, className);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void doSaveSourceMap(Map<String, String> classNameToFile, File sourceMapFile, Map<String, ClassData> classes) throws IOException {
        HashMap<String, String> sources = new HashMap<String, String>(classNameToFile);
        for (ClassData classData : classes.values()) {
            Iterator<Map.Entry<String, String>> iterator;
            if (sources.containsKey(classData.getName())) continue;
            sources.put(classData.getName(), ((ClassData)((Object)iterator)).getSource());
        }
        DataOutputStream out = null;
        try {
            void var1_6;
            out = CoverageIOUtil.openWriteFile((File)var1_6);
            CoverageIOUtil.writeINT(out, sources.size());
            for (Map.Entry<String, String> entry : sources.entrySet()) {
                void var0_4;
                CoverageIOUtil.writeUTF(out, entry.getKey());
                String value = entry.getValue();
                CoverageIOUtil.writeUTF(out, (String)(value != null ? var0_4 : ""));
            }
        }
        catch (Throwable throwable) {
            void var2_7;
            CoverageIOUtil.close((Closeable)var2_7);
            throw throwable;
        }
        CoverageIOUtil.close(out);
    }
}

