/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenArtifactResolutionRequest;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0004()*+B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ:\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J8\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J<\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J4\u0010%\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0019R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "artifacts", "", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "myIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "syncConsole", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Ljava/util/Collection;Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;)V", "myArtifacts", "collectArtifactsToDownload", "", "Lorg/jetbrains/idea/maven/model/MavenId;", "Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadData;", "mavenProjects", "Lorg/jetbrains/idea/maven/project/MavenProject;", "types", "", "Lorg/jetbrains/idea/maven/importing/MavenExtraArtifactType;", "console", "Lorg/jetbrains/idea/maven/project/MavenConsole;", "download", "Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadResult;", "embedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "downloadSources", "", "downloadDocs", "toDownload", "downloadedFiles", "", "Ljava/io/File;", "downloadSourcesAndJavadocs", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "Companion", "DownloadData", "DownloadElement", "DownloadResult", "intellij.maven"})
public final class MavenArtifactDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenProjectsTree myProjectsTree;
    @Nullable
    private final ProgressIndicator myIndicator;
    @Nullable
    private final MavenSyncConsole syncConsole;
    @Nullable
    private final Collection<MavenArtifact> myArtifacts;

    public MavenArtifactDownloader(@NotNull Project myProject, @NotNull MavenProjectsTree myProjectsTree, @Nullable Collection<? extends MavenArtifact> artifacts, @Nullable ProgressIndicator myIndicator, @Nullable MavenSyncConsole syncConsole) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myProjectsTree, (String)"myProjectsTree");
        this.myProject = myProject;
        this.myProjectsTree = myProjectsTree;
        this.myIndicator = myIndicator;
        this.syncConsole = syncConsole;
        this.myArtifacts = artifacts == null ? null : (Collection)new HashSet<MavenArtifact>(artifacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DownloadResult downloadSourcesAndJavadocs(@NotNull Collection<? extends MavenProject> mavenProjects2, boolean downloadSources, boolean downloadDocs, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console) throws MavenProcessCanceledException {
        Intrinsics.checkNotNullParameter(mavenProjects2, (String)"mavenProjects");
        Intrinsics.checkNotNullParameter((Object)embeddersManager, (String)"embeddersManager");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        MultiMap<String, MavenProject> projectMultiMap = MavenUtil.groupByBasedir(mavenProjects2, this.myProjectsTree);
        DownloadResult result2 = new DownloadResult();
        for (Map.Entry entry : projectMultiMap.entrySet()) {
            MavenEmbedderWrapper embedder;
            Intrinsics.checkNotNull((Object)entry);
            String baseDir2 = (String)entry.getKey();
            Collection mavenProjectsForBaseDir = (Collection)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DOWNLOAD, baseDir2), (String)"getEmbedder(...)");
            try {
                Intrinsics.checkNotNull((Object)mavenProjectsForBaseDir);
                DownloadResult chunk = this.download(mavenProjectsForBaseDir, embedder, downloadSources, downloadDocs, console);
                Iterator iterator = mavenProjectsForBaseDir.iterator();
                while (iterator.hasNext()) {
                    MavenProject each;
                    MavenProject mavenProject2 = each = (MavenProject)iterator.next();
                    Intrinsics.checkNotNull((Object)mavenProject2);
                    this.myProjectsTree.fireArtifactsDownloaded(mavenProject2);
                }
                result2.resolvedDocs.addAll((Collection<MavenId>)chunk.resolvedDocs);
                result2.resolvedSources.addAll((Collection<MavenId>)chunk.resolvedSources);
                result2.unresolvedDocs.addAll((Collection<MavenId>)chunk.unresolvedDocs);
                result2.unresolvedSources.addAll((Collection<MavenId>)chunk.unresolvedSources);
            }
            finally {
                embeddersManager.release(embedder);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DownloadResult download(Collection<? extends MavenProject> mavenProjects2, MavenEmbedderWrapper embedder, boolean downloadSources, boolean downloadDocs, MavenConsole console) throws MavenProcessCanceledException {
        DownloadResult downloadResult;
        Collection downloadedFiles = new ConcurrentLinkedQueue();
        try {
            List types = new ArrayList(2);
            if (downloadSources) {
                types.add(MavenExtraArtifactType.SOURCES);
            }
            if (downloadDocs) {
                types.add(MavenExtraArtifactType.DOCS);
            }
            String string = downloadSources && downloadDocs ? MavenProjectBundle.message("maven.downloading", new Object[0]) : (downloadSources ? MavenProjectBundle.message("maven.downloading.sources", new Object[0]) : MavenProjectBundle.message("maven.downloading.docs", new Object[0]));
            Intrinsics.checkNotNull((Object)string);
            String caption = string;
            ProgressIndicator progressIndicator = this.myIndicator;
            if (progressIndicator != null) {
                progressIndicator.setText(caption);
            }
            Map<MavenId, DownloadData> artifacts = this.collectArtifactsToDownload(mavenProjects2, types, console);
            downloadResult = this.download(embedder, artifacts, downloadedFiles, console);
        }
        finally {
            Set filesToRefresh = new HashSet();
            for (File file : downloadedFiles) {
                filesToRefresh.add(file);
                File file2 = file.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                filesToRefresh.add(file2);
            }
            LocalFileSystem.getInstance().refreshIoFiles((Iterable)filesToRefresh, true, false, null);
        }
        return downloadResult;
    }

    private final Map<MavenId, DownloadData> collectArtifactsToDownload(Collection<? extends MavenProject> mavenProjects2, List<? extends MavenExtraArtifactType> types, MavenConsole console) {
        Map result2 = new HashMap();
        Set dependencyTypesFromSettings = new HashSet();
        if (!((Boolean)ReadAction.compute(() -> MavenArtifactDownloader.collectArtifactsToDownload$lambda$0(this, dependencyTypesFromSettings))).booleanValue()) {
            return result2;
        }
        for (MavenProject mavenProject2 : mavenProjects2) {
            Intrinsics.checkNotNullExpressionValue(mavenProject2.getRemoteRepositories(), (String)"getRemoteRepositories(...)");
            for (MavenArtifact eachDependency : mavenProject2.getDependencies()) {
                List<MavenRemoteRepository> repositories;
                String dependencyType;
                if (this.myArtifacts != null && !this.myArtifacts.contains(eachDependency) || StringsKt.equals((String)"system", (String)eachDependency.getScope(), (boolean)true) || this.myProjectsTree.findProject(eachDependency.getMavenId()) != null || !dependencyTypesFromSettings.contains(dependencyType = eachDependency.getType()) && !mavenProject2.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
                MavenId id = eachDependency.getMavenId();
                DownloadData data2 = (DownloadData)result2.get(id);
                if (data2 == null) {
                    data2 = new DownloadData();
                    Intrinsics.checkNotNull((Object)id);
                    result2.put(id, data2);
                }
                data2.getRepositories().addAll((Collection<MavenRemoteRepository>)repositories);
                for (MavenExtraArtifactType mavenExtraArtifactType : types) {
                    Pair<String, String> classifierAndExtension;
                    Intrinsics.checkNotNullExpressionValue(mavenProject2.getClassifierAndExtension(eachDependency, mavenExtraArtifactType), (String)"getClassifierAndExtension(...)");
                    String classifier = eachDependency.getFullClassifier((String)classifierAndExtension.first);
                    String extension = (String)classifierAndExtension.second;
                    data2.getClassifiersWithExtensions().add(new DownloadElement(classifier, extension, mavenExtraArtifactType));
                }
            }
        }
        return result2;
    }

    private final DownloadResult download(MavenEmbedderWrapper embedder, Map<MavenId, DownloadData> toDownload, Collection<File> downloadedFiles, MavenConsole console) throws MavenProcessCanceledException {
        DownloadResult result2 = new DownloadResult();
        result2.unresolvedSources.addAll((Collection<MavenId>)toDownload.keySet());
        result2.unresolvedDocs.addAll((Collection<MavenId>)toDownload.keySet());
        ArrayList<MavenArtifactResolutionRequest> requests = new ArrayList<MavenArtifactResolutionRequest>();
        for (Map.Entry<MavenId, DownloadData> object : toDownload.entrySet()) {
            MavenId id = object.getKey();
            DownloadData data2 = object.getValue();
            ProgressIndicator progressIndicator = this.myIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            for (DownloadElement eachElement : data2.getClassifiersWithExtensions()) {
                MavenArtifactInfo info = new MavenArtifactInfo(id, eachElement.getExtension(), eachElement.getClassifier());
                MavenArtifactResolutionRequest request = new MavenArtifactResolutionRequest(info, (List)new ArrayList(data2.getRepositories()));
                requests.add(request);
            }
        }
        List<MavenArtifact> artifacts = embedder.resolveArtifacts((Collection<MavenArtifactResolutionRequest>)requests, this.myIndicator, this.syncConsole, console);
        for (MavenArtifact artifact : artifacts) {
            File file;
            Intrinsics.checkNotNullExpressionValue((Object)artifact.getFile(), (String)"getFile(...)");
            if (!file.exists()) continue;
            downloadedFiles.add(file);
            MavenId mavenId2 = new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            if (Intrinsics.areEqual((Object)MavenExtraArtifactType.SOURCES.getDefaultClassifier(), (Object)artifact.getClassifier())) {
                result2.resolvedSources.add(mavenId2);
                result2.unresolvedSources.remove(mavenId2);
                continue;
            }
            result2.resolvedDocs.add(mavenId2);
            result2.unresolvedDocs.remove(mavenId2);
        }
        return result2;
    }

    private static final Boolean collectArtifactsToDownload$lambda$0(MavenArtifactDownloader this$0, Set $dependencyTypesFromSettings) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dependencyTypesFromSettings, (String)"$dependencyTypesFromSettings");
        if (this$0.myProject.isDisposed()) {
            return false;
        }
        Set<String> set = MavenProjectsManager.getInstance(this$0.myProject).getImportingSettings().getDependencyTypesAsSet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getDependencyTypesAsSet(...)");
        $dependencyTypesFromSettings.addAll((Collection)set);
        return true;
    }

    @JvmStatic
    @NotNull
    public static final DownloadResult download(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Collection<? extends MavenProject> mavenProjects2, @Nullable Collection<? extends MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, @NotNull MavenEmbedderWrapper embedder, @Nullable MavenProgressIndicator progressIndicator) throws MavenProcessCanceledException {
        return Companion.download(project2, projectsTree, mavenProjects2, artifacts, downloadSources, downloadDocs, embedder, progressIndicator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$Companion;", "", "()V", "download", "Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadResult;", "project", "Lcom/intellij/openapi/project/Project;", "projectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "artifacts", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "downloadSources", "", "downloadDocs", "embedder", "Lorg/jetbrains/idea/maven/server/MavenEmbedderWrapper;", "progressIndicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DownloadResult download(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull Collection<? extends MavenProject> mavenProjects2, @Nullable Collection<? extends MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, @NotNull MavenEmbedderWrapper embedder, @Nullable MavenProgressIndicator progressIndicator) throws MavenProcessCanceledException {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectsTree, (String)"projectsTree");
            Intrinsics.checkNotNullParameter(mavenProjects2, (String)"mavenProjects");
            Intrinsics.checkNotNullParameter((Object)embedder, (String)"embedder");
            MavenProgressIndicator mavenProgressIndicator = progressIndicator;
            ProgressIndicator indicator = mavenProgressIndicator != null ? mavenProgressIndicator.getIndicator() : null;
            MavenProgressIndicator mavenProgressIndicator2 = progressIndicator;
            MavenSyncConsole syncConsole = mavenProgressIndicator2 != null ? mavenProgressIndicator2.getSyncConsole() : null;
            return new MavenArtifactDownloader(project2, projectsTree, artifacts, indicator, syncConsole).download(mavenProjects2, embedder, downloadSources, downloadDocs, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0004j\b\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadData;", "", "()V", "classifiersWithExtensions", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadElement;", "Lkotlin/collections/LinkedHashSet;", "getClassifiersWithExtensions", "()Ljava/util/LinkedHashSet;", "repositories", "Lorg/jetbrains/idea/maven/model/MavenRemoteRepository;", "getRepositories", "intellij.maven"})
    private static final class DownloadData {
        @NotNull
        private final LinkedHashSet<MavenRemoteRepository> repositories = new LinkedHashSet();
        @NotNull
        private final LinkedHashSet<DownloadElement> classifiersWithExtensions = new LinkedHashSet();

        @NotNull
        public final LinkedHashSet<MavenRemoteRepository> getRepositories() {
            return this.repositories;
        }

        @NotNull
        public final LinkedHashSet<DownloadElement> getClassifiersWithExtensions() {
            return this.classifiersWithExtensions;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J-\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadElement;", "", "classifier", "", "extension", "type", "Lorg/jetbrains/idea/maven/importing/MavenExtraArtifactType;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/idea/maven/importing/MavenExtraArtifactType;)V", "getClassifier", "()Ljava/lang/String;", "getExtension", "getType", "()Lorg/jetbrains/idea/maven/importing/MavenExtraArtifactType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.maven"})
    private static final class DownloadElement {
        @Nullable
        private final String classifier;
        @Nullable
        private final String extension;
        @Nullable
        private final MavenExtraArtifactType type;

        public DownloadElement(@Nullable String classifier, @Nullable String extension, @Nullable MavenExtraArtifactType type2) {
            this.classifier = classifier;
            this.extension = extension;
            this.type = type2;
        }

        @Nullable
        public final String getClassifier() {
            return this.classifier;
        }

        @Nullable
        public final String getExtension() {
            return this.extension;
        }

        @Nullable
        public final MavenExtraArtifactType getType() {
            return this.type;
        }

        @Nullable
        public final String component1() {
            return this.classifier;
        }

        @Nullable
        public final String component2() {
            return this.extension;
        }

        @Nullable
        public final MavenExtraArtifactType component3() {
            return this.type;
        }

        @NotNull
        public final DownloadElement copy(@Nullable String classifier, @Nullable String extension, @Nullable MavenExtraArtifactType type2) {
            return new DownloadElement(classifier, extension, type2);
        }

        public static /* synthetic */ DownloadElement copy$default(DownloadElement downloadElement, String string, String string2, MavenExtraArtifactType mavenExtraArtifactType, int n, Object object) {
            if ((n & 1) != 0) {
                string = downloadElement.classifier;
            }
            if ((n & 2) != 0) {
                string2 = downloadElement.extension;
            }
            if ((n & 4) != 0) {
                mavenExtraArtifactType = downloadElement.type;
            }
            return downloadElement.copy(string, string2, mavenExtraArtifactType);
        }

        @NotNull
        public String toString() {
            return "DownloadElement(classifier=" + this.classifier + ", extension=" + this.extension + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = this.classifier == null ? 0 : this.classifier.hashCode();
            result2 = result2 * 31 + (this.extension == null ? 0 : this.extension.hashCode());
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadElement)) {
                return false;
            }
            DownloadElement downloadElement = (DownloadElement)other;
            if (!Intrinsics.areEqual((Object)this.classifier, (Object)downloadElement.classifier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extension, (Object)downloadElement.extension)) {
                return false;
            }
            return this.type == downloadElement.type;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/project/MavenArtifactDownloader$DownloadResult;", "", "()V", "resolvedDocs", "", "Lorg/jetbrains/idea/maven/model/MavenId;", "resolvedSources", "unresolvedDocs", "unresolvedSources", "intellij.maven"})
    public static final class DownloadResult {
        @JvmField
        @NotNull
        public final Set<MavenId> resolvedSources;
        @JvmField
        @NotNull
        public final Set<MavenId> resolvedDocs;
        @JvmField
        @NotNull
        public final Set<MavenId> unresolvedSources;
        @JvmField
        @NotNull
        public final Set<MavenId> unresolvedDocs;

        public DownloadResult() {
            ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
            this.resolvedSources = keySetView;
            ConcurrentHashMap.KeySetView keySetView2 = ConcurrentHashMap.newKeySet();
            Intrinsics.checkNotNullExpressionValue(keySetView2, (String)"newKeySet(...)");
            this.resolvedDocs = keySetView2;
            ConcurrentHashMap.KeySetView keySetView3 = ConcurrentHashMap.newKeySet();
            Intrinsics.checkNotNullExpressionValue(keySetView3, (String)"newKeySet(...)");
            this.unresolvedSources = keySetView3;
            ConcurrentHashMap.KeySetView keySetView4 = ConcurrentHashMap.newKeySet();
            Intrinsics.checkNotNullExpressionValue(keySetView4, (String)"newKeySet(...)");
            this.unresolvedDocs = keySetView4;
        }
    }
}

