/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.FilePosition;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.server.LocalMavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenWrapperMapping;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport;", "", "()V", "downloadAndInstallMaven", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "urlString", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getDistName", "distUrl", "getMd5Hash", "string", "getZipFile", "Ljava/io/File;", "distributionUrl", "makeMavenBinRunnable", "", "mavenHome", "unpackZipFile", "zipFile", "unzip", "zip", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenWrapperSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,222:1\n1#2:223\n13309#3,2:224\n*S KotlinDebug\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport\n*L\n143#1:224,2\n*E\n"})
public final class MavenWrapperSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";

    @NotNull
    public final MavenDistribution downloadAndInstallMaven(@NotNull String urlString, @Nullable ProgressIndicator indicator) throws IOException {
        Object object;
        Object[] partFile;
        MavenDistribution current;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        MavenDistribution mavenDistribution = current = Companion.getCurrentDistribution(urlString);
        if (mavenDistribution != null) {
            return mavenDistribution;
        }
        File zipFile = this.getZipFile(urlString);
        if (!zipFile.isFile()) {
            block6: {
                partFile = new File(zipFile.getParentFile(), zipFile.getName() + ".part-" + System.currentTimeMillis());
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    object = progressIndicator;
                    ProgressIndicator $this$downloadAndInstallMaven_u24lambda_u240 = object;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{urlString};
                    $this$downloadAndInstallMaven_u24lambda_u240.setText(SyncBundle.message("maven.sync.wrapper.downloading.from", objectArray));
                }
                try {
                    HttpRequests.request((String)urlString).forceHttps(false).connectTimeout(30000).readTimeout(30000).saveToFile((File)partFile, indicator);
                }
                catch (Throwable t) {
                    if (!(t instanceof ControlFlowException)) break block6;
                    throw new RuntimeException(SyncBundle.message("maven.sync.wrapper.downloading.canceled", new Object[0]));
                }
            }
            FileUtil.rename((File)partFile, (File)zipFile);
        }
        if (!zipFile.isFile()) {
            partFile = new Object[]{urlString};
            throw new RuntimeException(SyncBundle.message("cannot.download.zip.from", partFile));
        }
        File home = this.unpackZipFile(zipFile, indicator).getCanonicalFile();
        object = MavenWrapperMapping.Companion.getInstance().getMyState$intellij_maven().mapping;
        String string = home.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String string2 = string;
        object.put(urlString, string2);
        Path path2 = home.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return new LocalMavenDistribution(path2, urlString);
    }

    private final File unpackZipFile(File zipFile, ProgressIndicator indicator) {
        this.unzip(zipFile, indicator);
        Object[] dirs = zipFile.getParentFile().listFiles(MavenWrapperSupport::unpackZipFile$lambda$1);
        if (dirs == null || dirs.length != 1) {
            MavenLog.LOG.warn("Expected exactly 1 top level dir in Maven distribution, found: " + (dirs != null ? ArraysKt.asList((Object[])dirs) : null));
            Object[] objectArray = new Object[]{zipFile.getAbsoluteFile()};
            throw new IllegalStateException(SyncBundle.message("zip.is.not.correct", objectArray));
        }
        Object mavenHome = dirs[0];
        if (!SystemInfo.isWindows) {
            this.makeMavenBinRunnable((File)mavenHome);
        }
        Intrinsics.checkNotNull((Object)mavenHome);
        return mavenHome;
    }

    private final void makeMavenBinRunnable(File mavenHome) {
        File mvnExe = new File(mavenHome, "bin/mvn").getCanonicalFile();
        Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
        Files.setPosixFilePermissions(mvnExe.toPath(), permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unzip(File zip, ProgressIndicator indicator) {
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2;
            ProgressIndicator $this$unzip_u24lambda_u242 = progressIndicator2 = progressIndicator;
            boolean bl = false;
            $this$unzip_u24lambda_u242.setText(SyncBundle.message("maven.sync.wrapper.unpacking", new Object[0]));
        }
        File unpackDir = zip.getParentFile();
        String destinationCanonicalPath = unpackDir.getCanonicalPath();
        boolean errorUnpacking = true;
        try {
            Closeable closeable = new ZipFile(zip);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl3 = false;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Enumeration<? extends ZipEntry> entries = enumeration;
                while (entries.hasMoreElements()) {
                    ZipEntry entry;
                    Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.zip.ZipEntry");
                    File destFile = new File(unpackDir, entry.getName());
                    String canonicalPath = destFile.getCanonicalPath();
                    Intrinsics.checkNotNull((Object)canonicalPath);
                    Intrinsics.checkNotNull((Object)destinationCanonicalPath);
                    if (!StringsKt.startsWith$default((String)canonicalPath, (String)destinationCanonicalPath, (boolean)false, (int)2, null)) {
                        FileUtil.delete((File)zip);
                        throw new RuntimeException("Directory traversal attack detected, zip file is malicious and IDEA dropped it");
                    }
                    if (entry.isDirectory()) {
                        destFile.mkdirs();
                        continue;
                    }
                    destFile.getParentFile().mkdirs();
                    Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(destFile));
                    Throwable throwable2 = null;
                    try {
                        BufferedOutputStream it = (BufferedOutputStream)closeable2;
                        boolean bl2 = false;
                        int n = StreamUtil.copy((InputStream)zipFile.getInputStream(entry), (OutputStream)it);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zipFile = Unit.INSTANCE;
            }
            catch (Throwable zipFile) {
                throwable = zipFile;
                throw zipFile;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            errorUnpacking = false;
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                Closeable $this$unzip_u24lambda_u245 = closeable = progressIndicator3;
                boolean bl = false;
                Object[] bl3 = new Object[]{destinationCanonicalPath};
                $this$unzip_u24lambda_u245.setText(SyncBundle.message("maven.sync.wrapper.unpacked.into", bl3));
            }
        }
        catch (Throwable throwable) {
            if (errorUnpacking) {
                ProgressIndicator progressIndicator4 = indicator;
                if (progressIndicator4 != null) {
                    ProgressIndicator progressIndicator5;
                    ProgressIndicator $this$unzip_u24lambda_u246 = progressIndicator5 = progressIndicator4;
                    boolean bl = false;
                    $this$unzip_u24lambda_u246.setText(SyncBundle.message("maven.sync.wrapper.failure", new Object[0]));
                }
                File[] fileArray = zip.getParentFile().listFiles(arg_0 -> MavenWrapperSupport.unzip$lambda$7(zip, arg_0));
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv[j];
                        boolean bl = false;
                        FileUtil.delete((File)it);
                    }
                }
            }
            throw throwable;
        }
    }

    private final File getZipFile(String distributionUrl) {
        String baseName = this.getDistName(distributionUrl);
        String string = FileUtil.getNameWithoutExtension((String)baseName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String distName = string;
        String md5Hash = this.getMd5Hash(distributionUrl);
        File file = MavenUtil.resolveM2Dir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveM2Dir(...)");
        File m2dir = file;
        File distsDir = new File(m2dir, "wrapper/dists");
        File file2 = new File(new File(new File(distsDir, distName), md5Hash), baseName).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
        return file2;
    }

    private final String getDistName(String distUrl) {
        String string;
        int p = StringsKt.lastIndexOf$default((CharSequence)distUrl, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (p < 0) {
            string = distUrl;
        } else {
            String string2 = distUrl.substring(p + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    private final String getMd5Hash(String string) {
        String string2;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            String string3 = string;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            messageDigest.update(bytes);
            string2 = new BigInteger(1, messageDigest.digest()).toString(32);
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (Exception var4) {
            throw new RuntimeException("Could not hash input string.", var4);
        }
        return string2;
    }

    private static final boolean unpackZipFile$lambda$1(File it) {
        return it.isDirectory();
    }

    private static final boolean unzip$lambda$7(File $zip, File it) {
        Intrinsics.checkNotNullParameter((Object)$zip, (String)"$zip");
        return !Intrinsics.areEqual((Object)it.getName(), (Object)$zip.getName());
    }

    @JvmStatic
    @Nullable
    public static final String getWrapperDistributionUrl(@Nullable VirtualFile baseDir2) {
        return Companion.getWrapperDistributionUrl(baseDir2);
    }

    @JvmStatic
    public static final void showUnsecureWarning(@NotNull MavenSyncConsole console, @Nullable VirtualFile mavenProjectMultimodulePath) {
        Companion.showUnsecureWarning(console, mavenProjectMultimodulePath);
    }

    @JvmStatic
    @Nullable
    public static final MavenDistribution getCurrentDistribution(@NotNull String urlString) {
        return Companion.getCurrentDistribution(urlString);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile getWrapperProperties(@Nullable VirtualFile baseDir2) {
        return Companion.getWrapperProperties(baseDir2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0019\u0010\u000b\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion;", "", "()V", "DISTRIBUTION_URL_PROPERTY", "", "getCurrentDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "urlString", "getWrapperDistributionUrl", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWrapperProperties", "Lorg/jetbrains/annotations/Nullable;", "showUnsecureWarning", "", "console", "Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "mavenProjectMultimodulePath", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenWrapperSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n350#2,7:223\n1#3:230\n*S KotlinDebug\n*F\n+ 1 MavenWrapperSupport.kt\norg/jetbrains/idea/maven/server/MavenWrapperSupport$Companion\n*L\n193#1:223,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String getWrapperDistributionUrl(@Nullable VirtualFile baseDir2) {
            VirtualFile virtualFile = this.getWrapperProperties(baseDir2);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile wrapperProperties = virtualFile;
            Properties properties = new Properties();
            ByteArrayInputStream stream = new ByteArrayInputStream(wrapperProperties.contentsToByteArray(true));
            properties.load(stream);
            return properties.getProperty(DISTRIBUTION_URL_PROPERTY);
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        public final void showUnsecureWarning(@NotNull MavenSyncConsole console, @Nullable VirtualFile mavenProjectMultimodulePath) {
            FilePosition filePosition;
            int n;
            VirtualFile properties;
            block4: {
                Iterator iterator;
                int index$iv;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
                        properties = this.getWrapperProperties(mavenProjectMultimodulePath);
                        Object object = properties;
                        if (object == null || (object = object.getInputStream()) == null) break block5;
                        Object object2 = object;
                        Charset charset = properties.getCharset();
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                        Charset charset2 = charset;
                        Reader reader = new InputStreamReader((InputStream)object2, charset2);
                        int n2 = 8192;
                        object = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
                        if (object == null) break block5;
                        Object $this$indexOfFirst$iv = object;
                        boolean $i$f$indexOfFirst = false;
                        index$iv = 0;
                        iterator = $this$indexOfFirst$iv.iterator();
                        break block6;
                    }
                    n = -1;
                    break block4;
                }
                while (iterator.hasNext()) {
                    Object item$iv = iterator.next();
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.startsWith$default((String)it, (String)DISTRIBUTION_URL_PROPERTY, (boolean)false, (int)2, null)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int line = n;
            VirtualFile virtualFile = properties;
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                boolean bl = false;
                filePosition = new FilePosition(virtualFile2.toNioPath().toFile(), line, 0);
            } else {
                filePosition = null;
            }
            FilePosition position = filePosition;
            String string = SyncBundle.message("maven.sync.wrapper.http.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = SyncBundle.message("maven.sync.wrapper.http.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            console.addWarning(string, string2, position);
        }

        @JvmStatic
        @Nullable
        public final MavenDistribution getCurrentDistribution(@NotNull String urlString) {
            Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
            MavenWrapperMapping mapping = MavenWrapperMapping.Companion.getInstance();
            String cachedHome = mapping.getMyState$intellij_maven().mapping.get(urlString);
            if (cachedHome != null) {
                Path path2 = Path.of(cachedHome, new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return new LocalMavenDistribution(path2, urlString);
                }
                mapping.getMyState$intellij_maven().mapping.remove(urlString);
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final VirtualFile getWrapperProperties(@Nullable VirtualFile baseDir2) {
            VirtualFile virtualFile = baseDir2;
            return virtualFile != null && (virtualFile = virtualFile.findChild(".mvn")) != null && (virtualFile = virtualFile.findChild("wrapper")) != null ? virtualFile.findChild("maven-wrapper.properties") : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

