/*
 * Decompiled with CFR 0.152.
 */
package training.learn;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonUtil;
import training.dsl.impl.LessonContextImpl;
import training.dsl.impl.LessonExecutor;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.NewLearnProjectUtil;
import training.learn.OpenLessonActivities;
import training.learn.OpenLessonParameters;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.course.LessonType;
import training.learn.exceptons.LessonPreparationException;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonManager;
import training.project.ProjectUtils;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.statistic.StatisticLessonListener;
import training.ui.LearnToolWindow;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J3\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bH\u0002J?\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010%\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0003J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u001a\u0010+\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010,\u001a\u00020-H\u0002J,\u0010.\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u00103\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0002J\u001a\u00106\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ltraining/learn/OpenLessonActivities;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "addStatisticLessonListenerIfNeeded", "", "currentProject", "Lcom/intellij/openapi/project/Project;", "lesson", "Ltraining/learn/course/Lesson;", "askSwitchToLearnProjectBack", "learnProject", "findLearnProjectInOpenedProjects", "langSupport", "Ltraining/lang/LangSupport;", "finishProjectInitialization", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "getFileInLearnProject", "Lcom/intellij/openapi/vfs/VirtualFile;", "getScratchFile", "project", "filename", "", "hideOtherViews", "initLearnProject", "projectToClose", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "openLearnProjectFromWelcomeScreen", "openLesson", "params", "Ltraining/learn/OpenLessonParameters;", "openLessonForPreparedProject", "openLessonWhenLearnPanelIsReady", "vf", "openLessonWhenLearnProjectStart", "openOnboardingFromWelcomeScreen", "onboarding", "openReadme", "prepareAndOpenLesson", "withCleanup", "", "processDslLesson", "Ltraining/learn/course/KLesson;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "projectWhereToStartLesson", "showLearnPanel", "preferredAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "waitLearningToolwindow", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nOpenLessonActivities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenLessonActivities.kt\ntraining/learn/OpenLessonActivities\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,502:1\n42#2,10:503\n1747#3,3:513\n1282#4,2:516\n10#5:518\n*S KotlinDebug\n*F\n+ 1 OpenLessonActivities.kt\ntraining/learn/OpenLessonActivities\n*L\n167#1:503,10\n314#1:513,3\n499#1:516,2\n64#1:518\n*E\n"})
public final class OpenLessonActivities {
    @NotNull
    public static final OpenLessonActivities INSTANCE = new OpenLessonActivities();
    @NotNull
    private static final Logger LOG;

    private OpenLessonActivities() {
    }

    @RequiresEdt
    public final void openLesson(@NotNull OpenLessonParameters params) {
        LearnToolWindow activeToolWindow;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Project projectWhereToStartLesson = params.getProjectWhereToStartLesson();
        LOG.debug(projectWhereToStartLesson.getName() + ": start openLesson method");
        LessonManager.Companion.getInstance().stopLesson();
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        if (learnToolWindow == null) {
            LearnToolWindow learnToolWindow2;
            LearnToolWindow it = learnToolWindow2 = UtilsKt.getLearnToolWindowForProject(projectWhereToStartLesson);
            boolean bl = false;
            LearningUiManager.INSTANCE.setActiveToolWindow$intellij_featuresTrainer(it);
            learnToolWindow = learnToolWindow2;
        }
        if ((activeToolWindow = learnToolWindow) != null && !Intrinsics.areEqual((Object)activeToolWindow.getProject(), (Object)projectWhereToStartLesson)) {
            activeToolWindow.setModulesPanel$intellij_featuresTrainer();
        }
        if (!params.getForceStartLesson() && LessonManager.Companion.getInstance().lessonShouldBeOpenedCompleted(params.getLesson())) {
            Unit unit;
            LearnToolWindow learnToolWindow3 = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
            if (learnToolWindow3 != null) {
                learnToolWindow3.setLearnPanel$intellij_featuresTrainer();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new IllegalStateException(("No active toolwindow in " + projectWhereToStartLesson).toString());
            }
            LessonManager lessonManager = LessonManager.Companion.getInstance();
            Lesson lesson = params.getLesson();
            Intrinsics.checkNotNull((Object)lesson, (String)"null cannot be cast to non-null type training.learn.course.KLesson");
            lessonManager.openLessonPassed$intellij_featuresTrainer((KLesson)lesson, projectWhereToStartLesson);
            return;
        }
        try {
            LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
            if (langSupport2 == null) {
                throw new Exception("Language for learning plugin is not defined");
            }
            LangSupport langSupport3 = langSupport2;
            Project learnProject = LearningUiManager.INSTANCE.getLearnProject();
            if (learnProject != null && !UtilsKt.isLearningProject(learnProject, langSupport3.getPrimaryLanguage())) {
                learnProject = null;
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to get cached LearnProject " + (learnProject != null));
            if (learnProject == null) {
                learnProject = this.findLearnProjectInOpenedProjects(langSupport3);
            }
            LOG.debug(projectWhereToStartLesson.getName() + ": trying to find LearnProject in opened projects " + (learnProject != null));
            if (learnProject != null) {
                LearningUiManager.INSTANCE.setLearnProject(learnProject);
            }
            LessonType lessonType = params.getLesson().getLessonType();
            if (lessonType == LessonType.SCRATCH && !params.getForceLearningProject() && langSupport3.isSdkConfigured(projectWhereToStartLesson)) {
                LOG.debug(projectWhereToStartLesson.getName() + ": scratch based lesson");
            } else if (lessonType == LessonType.USER_PROJECT) {
                LOG.debug("The lesson opened in user project " + projectWhereToStartLesson.getName());
            } else if (learnProject == null || learnProject.isDisposed()) {
                if (!UtilsKt.isLearningProject(projectWhereToStartLesson, langSupport3.getPrimaryLanguage())) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 1. learnProject is null or disposed");
                    this.initLearnProject(projectWhereToStartLesson, null, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(projectWhereToStartLesson, params){
                        final /* synthetic */ Project $projectWhereToStartLesson;
                        final /* synthetic */ OpenLessonParameters $params;
                        {
                            this.$projectWhereToStartLesson = $projectWhereToStartLesson;
                            this.$params = $params;
                            super(1);
                        }

                        public final void invoke(@NotNull Project it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            OpenLessonActivities.access$getLOG$p().debug(this.$projectWhereToStartLesson.getName() + ": 1. ... LearnProject has been started");
                            OpenLessonActivities.access$openLessonWhenLearnProjectStart(OpenLessonActivities.INSTANCE, new OpenLessonParameters(it, this.$params.getLesson(), this.$params.getForceStartLesson(), this.$params.getStartingWay(), true));
                            OpenLessonActivities.access$getLOG$p().debug(this.$projectWhereToStartLesson.getName() + ": 1. ... open lesson when learn project has been started");
                        }
                    }));
                    return;
                }
                LOG.debug(projectWhereToStartLesson.getName() + ": 0. learnProject is null but the current project (" + projectWhereToStartLesson.getName() + ")is LearnProject then just getFileInLearnProject");
                LearningUiManager.INSTANCE.setLearnProject(projectWhereToStartLesson);
                learnProject = projectWhereToStartLesson;
            } else {
                if (learnProject.isOpen() && !Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 3. LearnProject is opened but not focused. Ask user to focus to LearnProject");
                    this.askSwitchToLearnProjectBack(learnProject, projectWhereToStartLesson);
                    return;
                }
                if (learnProject.isOpen() && Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                    LOG.debug(projectWhereToStartLesson.getName() + ": 4. LearnProject is the current project");
                } else {
                    throw new Exception("Unable to start Learn project");
                }
            }
            if (lessonType.isProject$intellij_featuresTrainer()) {
                if (lessonType == LessonType.USER_PROJECT) {
                    this.prepareAndOpenLesson(params, false);
                } else {
                    if (!Intrinsics.areEqual((Object)projectWhereToStartLesson, (Object)learnProject)) {
                        LOG.error((Throwable)new Exception("Invalid learning project initialization: projectWhereToStartLesson = " + projectWhereToStartLesson + ", learnProject = " + learnProject));
                        return;
                    }
                    OpenLessonActivities.prepareAndOpenLesson$default(this, params, false, 2, null);
                }
            } else {
                this.openLessonForPreparedProject(params);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareAndOpenLesson(OpenLessonParameters params, boolean withCleanup) {
        void title$iv;
        String string = LearnBundle.INSTANCE.message("learn.project.initializing.process", new Object[0]);
        Project project$iv = params.getProjectWhereToStartLesson();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, params, withCleanup){
            final /* synthetic */ OpenLessonParameters $params$inlined;
            final /* synthetic */ boolean $withCleanup$inlined;
            {
                this.$params$inlined = openLessonParameters;
                this.$withCleanup$inlined = bl;
                super($project, $title, $cancellable);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    Project project = this.$params$inlined.getProjectWhereToStartLesson();
                    Lesson lessonToOpen = this.$params$inlined.getLesson();
                    try {
                        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
                        if (langSupport2 == null) {
                            throw new IllegalStateException(("No lang support for lesson: " + lessonToOpen.getId()).toString());
                        }
                        LangSupport langSupport3 = langSupport2;
                        if (this.$withCleanup$inlined) {
                            langSupport3.cleanupBeforeLessons(project);
                        }
                        lessonToOpen.prepare(project);
                        VirtualFile root = ProjectUtils.INSTANCE.getProjectRoot(langSupport3);
                        VirtualFile[] virtualFileArray = new VirtualFile[]{root};
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
                    }
                    catch (LessonPreparationException e) {
                        OpenLessonActivities $this$thisLogger$iv = OpenLessonActivities.INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(OpenLessonActivities.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("Error occurred when preparing the lesson " + lessonToOpen.getId(), (Throwable)e);
                        break block5;
                    }
                    catch (Throwable t) {
                        OpenLessonActivities $this$thisLogger$iv = OpenLessonActivities.INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(OpenLessonActivities.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Error occurred when preparing the lesson " + lessonToOpen.getId(), t);
                        break block5;
                    }
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.$params$inlined){
                        final /* synthetic */ OpenLessonParameters $params;
                        {
                            this.$params = $params;
                            super(0);
                        }

                        public final void invoke() {
                            OpenLessonActivities.access$openLessonForPreparedProject(OpenLessonActivities.INSTANCE, this.$params);
                        }
                    }), (int)1, null);
                }
            }
        });
    }

    static /* synthetic */ void prepareAndOpenLesson$default(OpenLessonActivities openLessonActivities, OpenLessonParameters openLessonParameters, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        openLessonActivities.prepareAndOpenLesson(openLessonParameters, bl);
    }

    private final void openLessonForPreparedProject(OpenLessonParameters params) {
        VirtualFile vf;
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw new Exception("Language should be defined by now");
        }
        LangSupport langSupport3 = langSupport2;
        Project project = params.getProjectWhereToStartLesson();
        Lesson lesson = params.getLesson();
        if (lesson.getLessonType() == LessonType.SCRATCH) {
            LOG.debug(project.getName() + ": scratch based lesson");
            String string = lesson.getSampleFilePath();
            if (string == null) {
                string = langSupport3.getScratchFileName();
            }
            v2 = this.getScratchFile(project, lesson, string);
        } else {
            LOG.debug(project.getName() + ": 4. LearnProject is the current project");
            v2 = vf = this.getFileInLearnProject(langSupport3, lesson);
        }
        if (lesson.getLessonType() != LessonType.SCRATCH) {
            FileEditorManagerEx.Companion.getInstanceEx(project).closeOpenedEditors();
        }
        if (lesson.getLessonType() != LessonType.SCRATCH || Intrinsics.areEqual((Object)LearningUiManager.INSTANCE.getLearnProject(), (Object)project)) {
            this.hideOtherViews(project);
        }
        if (this.showLearnPanel(project, lesson.preferredLearnWindowAnchor(project))) {
            this.openLessonWhenLearnPanelIsReady(params, vf);
        } else {
            this.waitLearningToolwindow(params, vf);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void openLessonWhenLearnPanelIsReady(OpenLessonParameters params, VirtualFile vf) {
        LearnToolWindow learnToolWindow;
        Project project = params.getProjectWhereToStartLesson();
        LOG.debug(project.getName() + ": Add listeners to lesson");
        this.addStatisticLessonListenerIfNeeded(project, params.getLesson());
        LOG.debug(project.getName() + ": Set lesson view");
        LearningUiManager learningUiManager = LearningUiManager.INSTANCE;
        LearnToolWindow learnToolWindow2 = UtilsKt.getLearnToolWindowForProject(project);
        if (learnToolWindow2 != null) {
            void it;
            LearnToolWindow learnToolWindow3;
            LearnToolWindow learnToolWindow4 = learnToolWindow3 = learnToolWindow2;
            LearningUiManager learningUiManager2 = learningUiManager;
            boolean bl = false;
            it.setLearnPanel$intellij_featuresTrainer();
            learningUiManager = learningUiManager2;
            learnToolWindow = learnToolWindow3;
        } else {
            learnToolWindow = null;
        }
        learningUiManager.setActiveToolWindow$intellij_featuresTrainer(learnToolWindow);
        LOG.debug(project.getName() + ": XmlLesson onStart()");
        params.getLesson().onStart$intellij_featuresTrainer(params.getStartingWay());
        LOG.debug(project.getName() + ": PREPARING TO START LESSON:");
        LOG.debug(project.getName() + ": 1. Open or find editor");
        TextEditor textEditor = null;
        if (vf != null && FileEditorManager.getInstance((Project)project).isFileOpen(vf)) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getEditors(vf);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
        }
        if (vf != null && textEditor == null) {
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(vf, true, true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                textEditor = (TextEditor)fileEditor;
            }
            if (textEditor == null) {
                LOG.error("Cannot open editor for " + vf);
                if (params.getLesson().getLessonType() == LessonType.SCRATCH) {
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(vf, this){
                        final /* synthetic */ VirtualFile $vf;
                        final /* synthetic */ OpenLessonActivities this$0;
                        {
                            this.$vf = $vf;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$vf, this.this$0){
                                final /* synthetic */ VirtualFile $vf;
                                final /* synthetic */ OpenLessonActivities this$0;
                                {
                                    this.$vf = $vf;
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$vf.delete((Object)this.this$0);
                                }
                            }));
                        }
                    }), (int)1, null);
                }
            }
        }
        LOG.debug(project.getName() + ": 2. Set the focus on this editor");
        if (vf != null) {
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, vf), true);
        }
        LOG.debug(project.getName() + ": 4. Process lesson");
        if (!(params.getLesson() instanceof KLesson)) {
            throw new IllegalStateException("Unknown lesson format".toString());
        }
        this.processDslLesson((KLesson)params.getLesson(), textEditor, project, vf);
    }

    private final void waitLearningToolwindow(OpenLessonParameters params, VirtualFile vf) {
        Project project = params.getProjectWhereToStartLesson();
        MessageBusConnection connect = project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connect.subscribe(topic, (Object)new ToolWindowManagerListener(connect, project, params, vf){
            final /* synthetic */ MessageBusConnection $connect;
            final /* synthetic */ Project $project;
            final /* synthetic */ OpenLessonParameters $params;
            final /* synthetic */ VirtualFile $vf;
            {
                this.$connect = $connect;
                this.$project = $project;
                this.$params = $params;
                this.$vf = $vf;
            }

            public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
                ToolWindow toolWindow;
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                if (ids.contains("Learn") && (toolWindow = toolWindowManager.getToolWindow("Learn")) != null) {
                    this.$connect.disconnect();
                    ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.$project, this.$params, this.$vf){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ OpenLessonParameters $params;
                        final /* synthetic */ VirtualFile $vf;
                        {
                            this.$project = $project;
                            this.$params = $params;
                            this.$vf = $vf;
                            super(0);
                        }

                        public final void invoke() {
                            OpenLessonActivities.access$showLearnPanel(OpenLessonActivities.INSTANCE, this.$project, this.$params.getLesson().preferredLearnWindowAnchor(this.$project));
                            OpenLessonActivities.access$openLessonWhenLearnPanelIsReady(OpenLessonActivities.INSTANCE, this.$params, this.$vf);
                        }
                    }), (int)1, null);
                }
            }
        });
    }

    private final void processDslLesson(KLesson lesson, TextEditor textEditor, Project projectWhereToStartLesson, VirtualFile vf) {
        TextEditor textEditor2 = textEditor;
        LessonExecutor executor = new LessonExecutor(lesson, projectWhereToStartLesson, (Editor)(textEditor2 != null ? textEditor2.getEditor() : null), vf);
        LessonContextImpl lessonContext = new LessonContextImpl(executor);
        TextEditor textEditor3 = textEditor;
        LessonManager.Companion.getInstance().initDslLesson$intellij_featuresTrainer((Editor)(textEditor3 != null ? textEditor3.getEditor() : null), lesson, executor);
        lesson.getFullLessonContent().invoke((Object)lessonContext);
        executor.startLesson();
    }

    private final void hideOtherViews(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> OpenLessonActivities.hideOtherViews$lambda$3(project));
    }

    private final void addStatisticLessonListenerIfNeeded(Project currentProject, Lesson lesson) {
        boolean bl;
        StatisticLessonListener statLessonListener;
        block4: {
            statLessonListener = new StatisticLessonListener(currentProject);
            Iterable $this$any$iv = lesson.getLessonListeners$intellij_featuresTrainer();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LessonListener it = (LessonListener)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof StatisticLessonListener)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            lesson.addLessonListener(statLessonListener);
        }
    }

    private final void openReadme(Project project) {
        VirtualFile root = ProjectUtils.INSTANCE.getCurrentLearningProjectRoot();
        VirtualFile virtualFile = root.findFileByRelativePath("README.md");
        if (virtualFile == null) {
            return;
        }
        VirtualFile readme = virtualFile;
        TextEditorWithPreview.openPreviewForFile((Project)project, (VirtualFile)readme);
    }

    public final void openOnboardingFromWelcomeScreen(@NotNull Lesson onboarding, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)onboarding, (String)"onboarding");
        StatisticBase.Companion.logLearnProjectOpenedForTheFirstTime(StatisticBase.LearnProjectOpeningWay.ONBOARDING_PROMOTER);
        this.initLearnProject(null, selectedSdk, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(onboarding){
            final /* synthetic */ Lesson $onboarding;
            {
                this.$onboarding = $onboarding;
                super(1);
            }

            public final void invoke(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                StartupManager.getInstance((Project)project).runAfterOpened(() -> openOnboardingFromWelcomeScreen.1.invoke$lambda$0(this.$onboarding, project));
            }

            private static final void invoke$lambda$0(Lesson $onboarding, Project $project) {
                Intrinsics.checkNotNullParameter((Object)$onboarding, (String)"$onboarding");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>($onboarding, $project){
                    final /* synthetic */ Lesson $onboarding;
                    final /* synthetic */ Project $project;
                    {
                        this.$onboarding = $onboarding;
                        this.$project = $project;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.$onboarding.getProperties().getCanStartInDumbMode()) {
                            CourseManager.openLesson$default(CourseManager.Companion.getInstance(), this.$project, this.$onboarding, LessonStartingWay.ONBOARDING_PROMOTER, true, false, 16, null);
                        } else {
                            DumbService.Companion.getInstance(this.$project).runWhenSmart(() -> openOnboardingFromWelcomeScreen.1.1.invoke$lambda$0(this.$project, this.$onboarding));
                        }
                    }

                    private static final void invoke$lambda$0(Project $project, Lesson $onboarding) {
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        Intrinsics.checkNotNullParameter((Object)$onboarding, (String)"$onboarding");
                        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), $project, $onboarding, LessonStartingWay.ONBOARDING_PROMOTER, true, false, 16, null);
                    }
                }), (int)1, null);
            }
        }));
    }

    public final void openLearnProjectFromWelcomeScreen(@Nullable Sdk selectedSdk) {
        StatisticBase.Companion.logLearnProjectOpenedForTheFirstTime(StatisticBase.LearnProjectOpeningWay.LEARN_IDE);
        this.initLearnProject(null, selectedSdk, (Function1<? super Project, Unit>)((Function1)openLearnProjectFromWelcomeScreen.1.INSTANCE));
    }

    private final boolean showLearnPanel(Project project, ToolWindowAnchor preferredAnchor) {
        ToolWindow toolWindow = UtilsKt.learningToolWindow(project);
        if (toolWindow == null) {
            return false;
        }
        ToolWindow learn = toolWindow;
        if (!Intrinsics.areEqual((Object)learn.getAnchor(), (Object)preferredAnchor) && learn.getType() == ToolWindowType.DOCKED) {
            learn.setAnchor(preferredAnchor, null);
        }
        learn.show();
        return true;
    }

    @RequiresEdt
    private final void openLessonWhenLearnProjectStart(OpenLessonParameters params) {
        if (params.getLesson().getProperties().getCanStartInDumbMode()) {
            this.prepareAndOpenLesson(params, false);
            return;
        }
        Project myLearnProject = params.getProjectWhereToStartLesson();
        StartupManager startupManager = StartupManager.getInstance((Project)myLearnProject);
        if (startupManager instanceof StartupManagerEx && startupManager.postStartupActivityPassed()) {
            OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson(myLearnProject, params);
        } else {
            startupManager.runAfterOpened(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$lambda$7(myLearnProject, params));
        }
    }

    private final VirtualFile getScratchFile(Project project, Lesson lesson, String filename) {
        String string = lesson.getLanguageId();
        if (string == null) {
            throw new IllegalStateException(("Scratch lesson " + lesson.getId() + " should define language").toString());
        }
        String languageId = string;
        Language languageByID = UtilsKt.findLanguageByID(languageId);
        VirtualFile virtualFile = ScratchFileService.getInstance().findFile((RootType)ScratchRootType.getInstance(), filename, ScratchFileService.Option.create_if_missing);
        if (virtualFile == null) {
            throw new IllegalStateException(("Cannot create scratch file " + filename + " for " + languageByID + " language ID in " + project.getName()).toString());
        }
        VirtualFile vf = virtualFile;
        ScratchFileService.getInstance().getScratchesMapping().setMapping(vf, (Object)languageByID);
        FileEditorManager.getInstance((Project)project).closeFile(vf);
        return vf;
    }

    private final void askSwitchToLearnProjectBack(Project learnProject, Project currentProject) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)learnProject.getName(), (String)"getName(...)");
        Messages.showInfoMessage((Project)currentProject, (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.message", objectArray), (String)LearnBundle.INSTANCE.message("dialog.askToSwitchToLearnProject.title", new Object[0]));
    }

    private final VirtualFile getFileInLearnProject(LangSupport langSupport2, Lesson lesson) {
        boolean bl;
        if (!lesson.getProperties().getOpenFileAtStart()) {
            LOG.debug(lesson.getName() + " does not open any file at the start");
            return null;
        }
        Computable<VirtualFile> function2 = new Computable<VirtualFile>(lesson, langSupport2){
            final /* synthetic */ Lesson $lesson;
            final /* synthetic */ LangSupport $langSupport;
            {
                this.$lesson = $lesson;
                this.$langSupport = $langSupport;
            }

            @NotNull
            public VirtualFile compute() {
                String string;
                VirtualFile dir;
                String string2 = this.$lesson.getSampleFilePath();
                if (string2 == null && (string2 = this.$lesson.getModule().getSampleFilePath()) == null) {
                    LangSupport langSupport2 = this.$lesson.getModule().getPrimaryLanguage();
                    string2 = langSupport2 != null ? langSupport2.getSampleFilePath() : null;
                    if (string2 == null) {
                        throw new IllegalStateException(("No file provided to start lesson " + this.$lesson.getName() + " (" + this.$lesson.getId() + ") for " + this.$langSupport.getPrimaryLanguage() + " course").toString());
                    }
                }
                String relativeFilePath = string2;
                VirtualFile root = ProjectUtils.INSTANCE.getProjectRoot(this.$langSupport);
                VirtualFile virtualFile = root.findFileByRelativePath(relativeFilePath);
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    return it;
                }
                int lastSeparator = StringsKt.lastIndexOf$default((CharSequence)relativeFilePath, (String)"/", (int)0, (boolean)false, (int)6, null);
                if (lastSeparator != -1) {
                    String string3 = relativeFilePath.substring(0, lastSeparator);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    v3 = VfsUtil.createDirectoryIfMissing((VirtualFile)root, (String)string3);
                } else {
                    v3 = dir = root;
                }
                if (lastSeparator == -1) {
                    string = relativeFilePath;
                } else {
                    String string4 = relativeFilePath.substring(lastSeparator + 1);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                }
                String fileName = string;
                VirtualFile virtualFile2 = dir.createChildData((Object)this, fileName);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
                return virtualFile2;
            }
        };
        VirtualFile vf = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)function2);
        boolean bl2 = bl = vf != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return vf;
    }

    private final void initLearnProject(Project projectToClose, Sdk selectedSdk, Function1<? super Project, Unit> postInitCallback) {
        LangSupport langSupport2 = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport2 == null) {
            throw new Exception("Language for learning plugin is not defined");
        }
        LangSupport langSupport3 = langSupport2;
        Project project = this.findLearnProjectInOpenedProjects(langSupport3);
        if (project != null) {
            Project it = project;
            boolean bl = false;
            postInitCallback.invoke((Object)it);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && projectToClose != null && !NewLearnProjectUtil.INSTANCE.showDialogOpenLearnProject(projectToClose)) {
            return;
        }
        try {
            NewLearnProjectUtil.INSTANCE.createLearnProject(projectToClose, langSupport3, selectedSdk, (Function1<? super Project, Unit>)((Function1)new Function1<Project, Unit>(langSupport3, postInitCallback){
                final /* synthetic */ LangSupport $langSupport;
                final /* synthetic */ Function1<Project, Unit> $postInitCallback;
                {
                    this.$langSupport = $langSupport;
                    this.$postInitCallback = $postInitCallback;
                    super(1);
                }

                public final void invoke(@NotNull Project learnProject) {
                    Intrinsics.checkNotNullParameter((Object)learnProject, (String)"learnProject");
                    try {
                        this.$langSupport.applyToProjectAfterConfigure().invoke((Object)learnProject);
                    }
                    catch (Throwable e) {
                        OpenLessonActivities.access$getLOG$p().error(e);
                        OpenLessonActivities.access$getLOG$p().error("The configuration will be retried after 2 seconds");
                        new Alarm().addRequest(() -> initLearnProject.2.invoke$lambda$0(this.$langSupport, learnProject, this.$postInitCallback), 2000);
                        return;
                    }
                    OpenLessonActivities.access$finishProjectInitialization(OpenLessonActivities.INSTANCE, learnProject, this.$postInitCallback);
                }

                private static final void invoke$lambda$0(LangSupport $langSupport, Project $learnProject, Function1 $postInitCallback) {
                    Intrinsics.checkNotNullParameter((Object)$langSupport, (String)"$langSupport");
                    Intrinsics.checkNotNullParameter((Object)$learnProject, (String)"$learnProject");
                    Intrinsics.checkNotNullParameter((Object)$postInitCallback, (String)"$postInitCallback");
                    $langSupport.applyToProjectAfterConfigure().invoke((Object)$learnProject);
                    OpenLessonActivities.access$finishProjectInitialization(OpenLessonActivities.INSTANCE, $learnProject, $postInitCallback);
                }
            }));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private final void finishProjectInitialization(Project learnProject, Function1<? super Project, Unit> postInitCallback) {
        LearningUiManager.INSTANCE.setLearnProject(learnProject);
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(postInitCallback, learnProject){
            final /* synthetic */ Function1<Project, Unit> $postInitCallback;
            final /* synthetic */ Project $learnProject;
            {
                this.$postInitCallback = $postInitCallback;
                this.$learnProject = $learnProject;
                super(0);
            }

            public final void invoke() {
                this.$postInitCallback.invoke((Object)this.$learnProject);
            }
        }), (int)1, null);
    }

    private final Project findLearnProjectInOpenedProjects(LangSupport langSupport2) {
        Project project;
        block1: {
            Project[] openProjects;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Project[] $this$firstOrNull$iv = openProjects = projectArray;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!UtilsKt.isLearningProject(it, langSupport2.getPrimaryLanguage())) continue;
                project = element$iv;
                break block1;
            }
            project = null;
        }
        return project;
    }

    private static final void hideOtherViews$lambda$3(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        LessonUtil.INSTANCE.hideStandardToolwindows($project);
    }

    private static final void openLessonWhenLearnProjectStart$openLesson$lambda$6$lambda$5(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void openLessonWhenLearnProjectStart$openLesson$lambda$6(Project $myLearnProject, OpenLessonParameters $params) {
        Intrinsics.checkNotNullParameter((Object)$myLearnProject, (String)"$myLearnProject");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        Function0 openWhenSmart2 = (Function0)new Function0<Unit>($myLearnProject, $params){
            final /* synthetic */ Project $myLearnProject;
            final /* synthetic */ OpenLessonParameters $params;
            {
                this.$myLearnProject = $myLearnProject;
                this.$params = $params;
                super(0);
            }

            public final void invoke() {
                DumbService.Companion.getInstance(this.$myLearnProject).runWhenSmart(() -> openLessonWhenLearnProjectStart.openLesson.1.openWhenSmart.1.invoke$lambda$0(this.$params));
            }

            private static final void invoke$lambda$0(OpenLessonParameters $params) {
                Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
                OpenLessonActivities.access$prepareAndOpenLesson(OpenLessonActivities.INSTANCE, $params, false);
            }
        };
        new Alarm().addRequest(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson$lambda$6$lambda$5(openWhenSmart2), 500);
    }

    private static final void openLessonWhenLearnProjectStart$openLesson(Project myLearnProject, OpenLessonParameters $params) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(myLearnProject);
        ToolWindow learnToolWindow = toolWindowManager.getToolWindow("Learn");
        if (learnToolWindow != null) {
            DumbService.Companion.getInstance(myLearnProject).runWhenSmart(() -> OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson$lambda$6(myLearnProject, $params));
        }
    }

    private static final void openLessonWhenLearnProjectStart$lambda$7(Project $myLearnProject, OpenLessonParameters $params) {
        Intrinsics.checkNotNullParameter((Object)$myLearnProject, (String)"$myLearnProject");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        OpenLessonActivities.openLessonWhenLearnProjectStart$openLesson($myLearnProject, $params);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$openLessonWhenLearnProjectStart(OpenLessonActivities $this, OpenLessonParameters params) {
        $this.openLessonWhenLearnProjectStart(params);
    }

    public static final /* synthetic */ boolean access$showLearnPanel(OpenLessonActivities $this, Project project, ToolWindowAnchor preferredAnchor) {
        return $this.showLearnPanel(project, preferredAnchor);
    }

    public static final /* synthetic */ void access$openLessonWhenLearnPanelIsReady(OpenLessonActivities $this, OpenLessonParameters params, VirtualFile vf) {
        $this.openLessonWhenLearnPanelIsReady(params, vf);
    }

    public static final /* synthetic */ void access$openReadme(OpenLessonActivities $this, Project project) {
        $this.openReadme(project);
    }

    public static final /* synthetic */ void access$hideOtherViews(OpenLessonActivities $this, Project project) {
        $this.hideOtherViews(project);
    }

    public static final /* synthetic */ void access$finishProjectInitialization(OpenLessonActivities $this, Project learnProject, Function1 postInitCallback) {
        $this.finishProjectInitialization(learnProject, (Function1<? super Project, Unit>)postInitCallback);
    }

    public static final /* synthetic */ void access$openLessonForPreparedProject(OpenLessonActivities $this, OpenLessonParameters params) {
        $this.openLessonForPreparedProject(params);
    }

    public static final /* synthetic */ void access$prepareAndOpenLesson(OpenLessonActivities $this, OpenLessonParameters params, boolean withCleanup) {
        $this.prepareAndOpenLesson(params, withCleanup);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenLessonActivities.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

