/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.util.OutputWrapper;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.logging.LogLevel;
import org.gradle.process.internal.JvmOptions;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleConnectorService;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressListener;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.service.project.GradleOperationHelperExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

public class GradleExecutionHelper {
    private static final Logger LOG = Logger.getInstance(GradleExecutionHelper.class);

    @NotNull
    public <T> ModelBuilder<T> getModelBuilder(@NotNull Class<T> modelType, @NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (modelType == null) {
            GradleExecutionHelper.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(1);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(2);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(4);
        }
        ModelBuilder operation = connection.model(modelType);
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, settings2, listener2);
        ModelBuilder modelBuilder = operation;
        if (modelBuilder == null) {
            GradleExecutionHelper.$$$reportNull$$$0(5);
        }
        return modelBuilder;
    }

    @NotNull
    public BuildLauncher getBuildLauncher(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(6);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(7);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(8);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(10);
        }
        BuildLauncher operation = connection.newBuild();
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, tasksAndArguments, settings2, listener2);
        BuildLauncher buildLauncher = operation;
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(11);
        }
        return buildLauncher;
    }

    @NotNull
    public TestLauncher getTestLauncher(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(12);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(13);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(14);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(15);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(16);
        }
        TestLauncher operation = connection.newTestLauncher();
        GradleExecutionHelper.prepare(connection, (LongRunningOperation)operation, id, tasksAndArguments, settings2, listener2);
        TestLauncher testLauncher = operation;
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(17);
        }
        return testLauncher;
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(18);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(19);
        }
        return this.execute(projectPath, settings2, null, null, null, f);
    }

    public <T> T execute(@NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @NotNull Function<? super ProjectConnection, ? extends T> f) {
        String projectDir;
        File projectPathFile;
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(20);
        }
        if (f == null) {
            GradleExecutionHelper.$$$reportNull$$$0(21);
        }
        if ((projectPathFile = new File(projectPath)).isFile() && projectPath.endsWith("gradle") && projectPathFile.getParent() != null) {
            List arguments;
            projectDir = projectPathFile.getParent();
            if (settings2 != null && !(arguments = settings2.getArguments()).contains("-b") && !arguments.contains("--build-file")) {
                settings2.withArguments(new String[]{"-b", projectPath});
            }
        } else {
            projectDir = projectPath;
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return (T)GradleConnectorService.withGradleConnection(projectDir, taskId, settings2, listener2, cancellationToken, connection -> {
            try {
                return GradleExecutionHelper.maybeFixSystemProperties(() -> f.fun(connection), projectDir);
            }
            catch (ExternalSystemException | ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Gradle execution error", e);
                Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
                ExternalSystemException externalSystemException = new ExternalSystemException(ExceptionUtil.getMessage((Throwable)rootCause), e, new String[0]);
                externalSystemException.initCause(e);
                throw externalSystemException;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T maybeFixSystemProperties(@NotNull Computable<T> action2, String projectDir) {
        if (action2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(22);
        }
        Map<String, String> keyToMask = ((SystemPropertiesAdjuster)ApplicationManager.getApplication().getService(SystemPropertiesAdjuster.class)).getKeyToMask(projectDir);
        HashMap<String, String> oldValues = new HashMap<String, String>();
        try {
            keyToMask.forEach((key, newVal) -> {
                String oldVal = System.getProperty(key);
                oldValues.put((String)key, oldVal);
                if (oldVal != null) {
                    SystemProperties.setProperty((String)key, (String)newVal);
                }
            });
            Object object = action2.compute();
            return (T)object;
        }
        finally {
            oldValues.forEach((k, v) -> {
                if (v != null) {
                    System.setProperty(k, v);
                }
            });
        }
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(23);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(24);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(25);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(26);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(27);
        }
        this.ensureInstalledWrapper(id, projectPath, settings2, null, listener2, cancellationToken);
    }

    public void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @Nullable GradleVersion gradleVersion2, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(28);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(29);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(30);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(31);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(32);
        }
        if (!settings2.getDistributionType().isWrapped()) {
            return;
        }
        if (settings2.getDistributionType() == DistributionType.DEFAULT_WRAPPED && GradleUtil.findDefaultWrapperPropertiesFile(projectPath) != null) {
            return;
        }
        GradleConnectorService.withGradleConnection(projectPath, id, settings2, listener2, cancellationToken, connection -> {
            this.ensureInstalledWrapper(id, projectPath, settings2, gradleVersion2, listener2, (ProjectConnection)connection, cancellationToken);
            return null;
        });
    }

    /*
     * Exception decompiling
     */
    private void ensureInstalledWrapper(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion, @NotNull ExternalSystemTaskNotificationListener listener, @NotNull ProjectConnection connection, @NotNull CancellationToken cancellationToken) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeWrapperTask(@NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull String projectPath, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull CancellationToken cancellationToken) {
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(39);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(40);
        }
        if (projectPath == null) {
            GradleExecutionHelper.$$$reportNull$$$0(41);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(42);
        }
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(43);
        }
        if (cancellationToken == null) {
            GradleExecutionHelper.$$$reportNull$$$0(44);
        }
        GradleExecutionHelper.maybeFixSystemProperties(() -> {
            BuildLauncher launcher = this.getBuildLauncher(connection, id, List.of("wrapper"), settings2, listener2);
            launcher.withCancellationToken(cancellationToken);
            launcher.run();
            return null;
        }, projectPath);
    }

    @NotNull
    private static Supplier<String> setupWrapperTaskInInitScript(@Nullable GradleVersion gradleVersion2, @NotNull GradleExecutionSettings settings2) throws IOException {
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(45);
        }
        File wrapperFilesLocation = FileUtil.createTempDirectory((String)"wrap", (String)"loc");
        File jarFile = new File(wrapperFilesLocation, "gradle-wrapper.jar");
        File scriptFile = new File(wrapperFilesLocation, "gradlew");
        File fileWithPathToProperties = new File(wrapperFilesLocation, "path.tmp");
        Path initScriptFile2 = GradleInitScriptUtil.createWrapperInitScript(gradleVersion2, jarFile, scriptFile, fileWithPathToProperties);
        settings2.withArguments(new String[]{"--init-script", initScriptFile2.toString()});
        Supplier<String> supplier = () -> FileUtil.loadFileOrNull((File)fileWithPathToProperties);
        if (supplier == null) {
            GradleExecutionHelper.$$$reportNull$$$0(46);
        }
        return supplier;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(ProjectResolverContext projectResolverContext) {
        CancellationTokenSource cancellationTokenSource = projectResolverContext.getCancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(projectResolverContext.getConnection(), projectResolverContext.getExternalSystemTaskId(), projectResolverContext.getListener(), cancellationToken, projectResolverContext.getSettings());
    }

    public static void prepare(@NotNull ProjectConnection connection, @NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(47);
        }
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(48);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(49);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(50);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(51);
        }
        GradleExecutionHelper.prepare(connection, operation, id, Collections.emptyList(), settings2, listener2);
    }

    private static void prepare(@NotNull ProjectConnection connection, @NotNull LongRunningOperation operation, @NotNull ExternalSystemTaskId id, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(52);
        }
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(53);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(54);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(55);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(56);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(57);
        }
        GradleExecutionHelper.clearSystemProperties(operation);
        GradleExecutionHelper.applyIdeaParameters(settings2);
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, settings2);
        GradleExecutionHelper.setupJvmArguments(operation, settings2, buildEnvironment);
        GradleExecutionHelper.setupLogging(settings2, buildEnvironment);
        GradleExecutionHelper.setupArguments(operation, tasksAndArguments, settings2);
        GradleExecutionHelper.setupEnvironment(operation, settings2, id, listener2, buildEnvironment);
        GradleExecutionHelper.setupJavaHome(operation, settings2);
        GradleExecutionHelper.setupProgressListeners(operation, settings2, id, listener2, buildEnvironment);
        GradleExecutionHelper.setupStandardIO(operation, settings2, id, listener2);
        GradleOperationHelperExtension.EP_NAME.forEachExtensionSafe(proc -> proc.prepareForExecution(id, operation, settings2, buildEnvironment));
    }

    private static void clearSystemProperties(LongRunningOperation operation) {
        operation.withSystemProperties(Collections.emptyMap());
    }

    private static void applyIdeaParameters(@NotNull GradleExecutionSettings settings2) {
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(58);
        }
        if (settings2.isOfflineWork()) {
            settings2.withArgument("--offline");
        }
        settings2.withArgument("-Didea.active=true");
        settings2.withArgument("-Didea.version=" + GradleExecutionHelper.getIdeaVersion());
        settings2.withArgument("-Didea.vendor.name=" + ApplicationInfo.getInstance().getShortCompanyName());
    }

    private static void setupProgressListeners(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable BuildEnvironment buildEnvironment) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(59);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(60);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(61);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(62);
        }
        String buildRootDir = GradleExecutionHelper.getBuildRoot(buildEnvironment);
        GradleProgressListener progressListener = new GradleProgressListener(listener2, id, buildRootDir);
        operation.addProgressListener((org.gradle.tooling.ProgressListener)progressListener);
        operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TASK, OperationType.FILE_DOWNLOAD});
        if (settings2.isRunAsTest() && settings2.isBuiltInTestEventsUsed()) {
            operation.addProgressListener((ProgressListener)progressListener, new OperationType[]{OperationType.TEST, OperationType.TEST_OUTPUT, OperationType.TASK});
        }
    }

    private static void setupStandardIO(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(63);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(64);
        }
        if (id == null) {
            GradleExecutionHelper.$$$reportNull$$$0(65);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(66);
        }
        operation.setStandardOutput((OutputStream)new OutputWrapper(listener2, id, true));
        operation.setStandardError((OutputStream)new OutputWrapper(listener2, id, false));
        InputStream inputStream = (InputStream)settings2.getUserData(ExternalSystemRunConfiguration.RUN_INPUT_KEY);
        if (inputStream != null) {
            operation.setStandardInput(inputStream);
        }
    }

    private static void setupJvmArguments(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2, @Nullable BuildEnvironment buildEnvironment) {
        List<String> jvmArgs;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(67);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(68);
        }
        if (!(jvmArgs = settings2.getJvmArguments()).isEmpty()) {
            List<String> merged;
            if (buildEnvironment != null) {
                BuildIdentifier buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
                List buildJvmArguments = buildIdentifier == null || "buildSrc".equals(buildIdentifier.getRootDir().getName()) ? ContainerUtil.emptyList() : buildEnvironment.getJava().getJvmArguments();
                merged = GradleExecutionHelper.mergeBuildJvmArguments(buildJvmArguments, jvmArgs);
            } else {
                merged = jvmArgs;
            }
            List filteredArgs = ContainerUtil.mapNotNull((Collection)merged, s -> StringUtil.isEmpty((String)s) ? null : s);
            operation.setJvmArguments(ArrayUtilRt.toStringArray((Collection)filteredArgs));
        }
    }

    private static void setupJavaHome(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2) {
        String javaHome;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(69);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(70);
        }
        if ((javaHome = settings2.getJavaHome()) != null && new File(javaHome).isDirectory()) {
            LOG.debug("Java home to set for Gradle operation: " + javaHome);
            operation.setJavaHome(new File(javaHome));
        }
    }

    private static void setupArguments(@NotNull LongRunningOperation operation, @NotNull List<String> tasksAndArguments, @NotNull GradleExecutionSettings settings2) {
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(71);
        }
        if (tasksAndArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(72);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(73);
        }
        GradleCommandLine commandLine = GradleCommandLineUtil.parseCommandLine(tasksAndArguments, settings2.getArguments());
        commandLine = GradleExecutionHelper.fixUpGradleCommandLine(commandLine);
        LOG.info("Passing command-line to Gradle Tooling API: " + StringUtil.join(GradleExecutionHelper.obfuscatePasswordParameters(commandLine.getTokens()), (String)" "));
        if (operation instanceof TestLauncher) {
            TestLauncher testLauncher = (TestLauncher)operation;
            GradleExecutionHelper.setupTestLauncherArguments(testLauncher, commandLine);
        } else if (operation instanceof BuildLauncher) {
            BuildLauncher buildLauncher = (BuildLauncher)operation;
            GradleExecutionHelper.setupBuildLauncherArguments(buildLauncher, commandLine, settings2);
        } else {
            operation.withArguments(commandLine.getTokens());
        }
    }

    @NotNull
    private static GradleCommandLine fixUpGradleCommandLine(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(74);
        }
        ArrayList<GradleCommandLineTask> tasks2 = new ArrayList<GradleCommandLineTask>();
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            String name2 = task2.getName();
            List options = ContainerUtil.filter((Collection)task2.getOptions(), it -> !GradleExecutionHelper.isWildcardTestPattern(it));
            tasks2.add(new GradleCommandLineTask(name2, options));
        }
        return new GradleCommandLine(tasks2, (List<? extends GradleCommandLineOption>)commandLine.getOptions());
    }

    private static boolean isWildcardTestPattern(@NotNull GradleCommandLineOption option) {
        if (option == null) {
            GradleExecutionHelper.$$$reportNull$$$0(75);
        }
        return option.getName().equals("--tests") && option.getValues().size() == 1 && (option.getValues().get(0).equals("*") || option.getValues().get(0).equals("'*'") || option.getValues().get(0).equals("\"*\""));
    }

    private static void setupTestLauncherArguments(@NotNull TestLauncher testLauncher, @NotNull GradleCommandLine commandLine) {
        if (testLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(76);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(77);
        }
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            Set<String> patterns = GradleCommandLineUtil.getTestPatterns(task2);
            if (!patterns.isEmpty()) {
                testLauncher.withTestsFor(it -> it.forTaskPath(task2.getName()).includePatterns((Collection)patterns));
                continue;
            }
            testLauncher.forTasks(ArrayUtil.toStringArray(task2.getTokens()));
        }
        testLauncher.withArguments(commandLine.getOptions().getTokens());
    }

    private static void setupBuildLauncherArguments(@NotNull BuildLauncher buildLauncher, @NotNull GradleCommandLine commandLine, @NotNull GradleExecutionSettings settings2) {
        if (buildLauncher == null) {
            GradleExecutionHelper.$$$reportNull$$$0(78);
        }
        if (commandLine == null) {
            GradleExecutionHelper.$$$reportNull$$$0(79);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(80);
        }
        buildLauncher.forTasks(ArrayUtil.toStringArray(commandLine.getTasks().getTokens()));
        buildLauncher.withArguments(commandLine.getOptions().getTokens());
        if (settings2.isTestTaskRerun()) {
            Path initScript2 = GradleInitScriptUtil.createTestInitScript();
            buildLauncher.addArguments(new String[]{"--init-script", initScript2.toString()});
        }
    }

    private static void setupLogging(@NotNull GradleExecutionSettings settings2, @Nullable BuildEnvironment buildEnvironment) {
        Application application;
        String gradleLogLevel;
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(81);
        }
        List arguments = settings2.getArguments();
        Collection options = GradleCommandLineOptionsProvider.LOGGING_OPTIONS.getOptions();
        List<String> optionsNames = GradleCommandLineOptionsProvider.getAllOptionsNames(options);
        if (buildEnvironment == null || !GradleExecutionHelper.isRootDirAvailable(buildEnvironment)) {
            return;
        }
        GradleProperties properties = GradlePropertiesFile.INSTANCE.getProperties(settings2.getServiceDirectory(), buildEnvironment.getBuildIdentifier().getRootDir().toPath());
        Property<String> loggingLevelProperty = properties.getGradleLoggingLevel();
        String string2 = gradleLogLevel = loggingLevelProperty != null ? loggingLevelProperty.getValue() : null;
        if (!ContainerUtil.exists(optionsNames, it -> arguments.contains(it)) && gradleLogLevel != null) {
            try {
                LogLevel logLevel = LogLevel.valueOf((String)gradleLogLevel.toUpperCase());
                switch (logLevel) {
                    case DEBUG: {
                        settings2.withArgument("-d");
                        break;
                    }
                    case INFO: {
                        settings2.withArgument("-i");
                        break;
                    }
                    case WARN: {
                        settings2.withArgument("-w");
                        break;
                    }
                    case QUIET: {
                        settings2.withArgument("-q");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("org.gradle.logging.level must be one of quiet, warn, lifecycle, info, or debug");
            }
        }
        if ((application = ApplicationManager.getApplication()) != null && application.isUnitTestMode() && !ContainerUtil.exists(optionsNames, it -> arguments.contains(it))) {
            settings2.withArgument("--info");
        }
    }

    private static boolean isRootDirAvailable(@NotNull BuildEnvironment environment) {
        if (environment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(82);
        }
        try {
            environment.getBuildIdentifier().getRootDir();
        }
        catch (UnsupportedMethodException e) {
            return false;
        }
        return true;
    }

    @Nullable
    private static BuildIdentifier getBuildIdentifier(@NotNull BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            GradleExecutionHelper.$$$reportNull$$$0(83);
        }
        try {
            return buildEnvironment.getBuildIdentifier();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return null;
        }
    }

    @Nullable
    private static String getBuildRoot(@Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            return null;
        }
        BuildIdentifier buildIdentifier = GradleExecutionHelper.getBuildIdentifier(buildEnvironment);
        return buildIdentifier == null ? null : buildIdentifier.getRootDir().getPath();
    }

    private static void setupEnvironment(@NotNull LongRunningOperation operation, @NotNull GradleExecutionSettings settings2, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable BuildEnvironment buildEnvironment) {
        TargetEnvironmentConfiguration environmentConfiguration2;
        boolean isEnvironmentCustomizationSupported;
        if (operation == null) {
            GradleExecutionHelper.$$$reportNull$$$0(84);
        }
        if (settings2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(85);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(86);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(87);
        }
        String gradleVersion2 = buildEnvironment != null ? buildEnvironment.getGradle().getGradleVersion() : null;
        boolean bl = isEnvironmentCustomizationSupported = gradleVersion2 != null && GradleVersion.version((String)gradleVersion2).getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0;
        if (!isEnvironmentCustomizationSupported) {
            if (!settings2.isPassParentEnvs() || !settings2.getEnv().isEmpty()) {
                listener2.onTaskOutput(taskId, String.format("The version of Gradle you are using%s does not support the environment variables customization feature. Support for this is available in Gradle 3.5 and all later versions.\n", gradleVersion2 == null ? "" : " (" + gradleVersion2 + ")"), false);
            }
            return;
        }
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = ExternalSystemExecutionAware.Companion.getEnvironmentConfigurationProvider((ExternalSystemExecutionSettings)settings2);
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = environmentConfiguration2 = environmentConfigurationProvider != null ? environmentConfigurationProvider.getEnvironmentConfiguration() : null;
        if (environmentConfiguration2 != null && !"local".equals(environmentConfiguration2.getTypeId())) {
            if (settings2.isPassParentEnvs()) {
                LOG.warn("Host system environment variables will not be passed for the target run.");
            }
            operation.setEnvironmentVariables(settings2.getEnv());
            return;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withEnvironment(settings2.getEnv());
        commandLine.withParentEnvironmentType(settings2.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        Map effectiveEnvironment = commandLine.getEffectiveEnvironment();
        operation.setEnvironmentVariables(effectiveEnvironment);
    }

    @ApiStatus.Internal
    static List<String> mergeBuildJvmArguments(@NotNull List<String> jvmArgs, @NotNull List<String> jvmArgsFromIdeSettings) {
        if (jvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(88);
        }
        if (jvmArgsFromIdeSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(89);
        }
        List<String> mergedJvmArgs = GradleExecutionHelper.mergeJvmArgs(jvmArgs, jvmArgsFromIdeSettings);
        JvmOptions jvmOptions = new JvmOptions(null);
        jvmOptions.setAllJvmArgs(mergedJvmArgs);
        return jvmOptions.getAllJvmArgs();
    }

    @ApiStatus.Internal
    static List<String> mergeJvmArgs(@NotNull List<String> jvmArgs, @NotNull List<String> jvmArgsFromIdeSettings) {
        if (jvmArgs == null) {
            GradleExecutionHelper.$$$reportNull$$$0(90);
        }
        if (jvmArgsFromIdeSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(91);
        }
        MultiMap argumentsMap = MultiMap.createLinkedSet();
        String lastKey = null;
        for (String jvmArg : ContainerUtil.concat(jvmArgs, jvmArgsFromIdeSettings)) {
            if (jvmArg.startsWith("-")) {
                argumentsMap.putValue((Object)jvmArg, (Object)"");
                lastKey = jvmArg;
                continue;
            }
            if (lastKey != null) {
                argumentsMap.putValue((Object)lastKey, (Object)jvmArg);
                lastKey = null;
                continue;
            }
            argumentsMap.putValue((Object)jvmArg, (Object)"");
        }
        LinkedHashMap<String, String> mergedKeys = new LinkedHashMap<String, String>();
        LinkedHashSet argKeySet = new LinkedHashSet(argumentsMap.keySet());
        for (String argKey : argKeySet) {
            Collection values = argumentsMap.getModifiable((Object)argKey);
            if (values.size() == 1 && ((String)values.iterator().next()).isEmpty()) {
                Couple<String> couple = GradleExecutionHelper.splitArg(argKey);
                mergedKeys.put((String)couple.first, (String)couple.second);
                continue;
            }
            mergedKeys.put(argKey, "");
            LinkedHashMap<String, String> mergedArgs = new LinkedHashMap<String, String>();
            for (String jvmArg : values) {
                if (jvmArg.isEmpty()) continue;
                Couple<String> couple = GradleExecutionHelper.splitArg(jvmArg);
                mergedArgs.put((String)couple.first, (String)couple.second);
            }
            values.clear();
            mergedArgs.forEach((key, value) -> values.add(key + value));
        }
        SmartList mergedArgs = new SmartList();
        mergedKeys.forEach((arg_0, arg_1) -> GradleExecutionHelper.lambda$mergeJvmArgs$14((List)mergedArgs, arg_0, arg_1));
        argKeySet.stream().filter(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$15((List)mergedArgs, arg_0)).forEach(arg_0 -> ((MultiMap)argumentsMap).remove(arg_0));
        argumentsMap.remove((Object)"--add-opens");
        SmartList result = new SmartList();
        argumentsMap.keySet().forEach(arg_0 -> GradleExecutionHelper.lambda$mergeJvmArgs$17(argumentsMap, (List)result, arg_0));
        return result;
    }

    private static Couple<String> splitArg(String arg) {
        int i = arg.indexOf(61);
        return i <= 0 ? Couple.of((Object)arg, (Object)"") : Couple.of((Object)arg.substring(0, i), (Object)arg.substring(i));
    }

    @ApiStatus.Internal
    public static void attachTargetPathMapperInitScript(@NotNull GradleExecutionSettings executionSettings) {
        if (executionSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(92);
        }
        Path initScriptFile2 = GradleInitScriptUtil.createTargetPathMapperInitScript();
        executionSettings.prependArguments(new String[]{"--init-script", initScriptFile2.toString()});
    }

    @ApiStatus.Internal
    public static void attachIdeaPluginConfigurator(@NotNull GradleExecutionSettings executionSettings) {
        if (executionSettings == null) {
            GradleExecutionHelper.$$$reportNull$$$0(93);
        }
        Path initScriptPath = GradleInitScriptUtil.createIdeaPluginConfiguratorInitScript();
        executionSettings.prependArguments(new String[]{"--init-script", initScriptPath.toString()});
    }

    @ApiStatus.Experimental
    @NotNull
    public static Map<String, String> getConfigurationInitScripts(@NonNls GradleRunConfiguration configuration) {
        String initScript2 = (String)configuration.getUserData(GradleTaskManager.INIT_SCRIPT_KEY);
        if (StringUtil.isNotEmpty((String)initScript2)) {
            String prefix = Objects.requireNonNull((String)configuration.getUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY), "init script file prefix is required");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(prefix, initScript2);
            String taskStateInitScript = GradleExecutionHelper.getTaskStateInitScript(configuration);
            if (taskStateInitScript != null) {
                map.put("ijtgttaskstate", taskStateInitScript);
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            if (linkedHashMap == null) {
                GradleExecutionHelper.$$$reportNull$$$0(94);
            }
            return linkedHashMap;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            GradleExecutionHelper.$$$reportNull$$$0(95);
        }
        return map;
    }

    @Nullable
    private static String getTaskStateInitScript(@NonNls GradleRunConfiguration configuration) {
        RunConfigurationTaskState taskState = (RunConfigurationTaskState)configuration.getUserData(RunConfigurationTaskState.getKEY());
        if (taskState == null) {
            return null;
        }
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        TargetProgressIndicator progressIndicator = TargetProgressIndicator.EMPTY;
        try {
            taskState.prepareTargetEnvironmentRequest((TargetEnvironmentRequest)request, progressIndicator);
            LocalTargetEnvironment environment = request.prepareEnvironment(progressIndicator);
            return taskState.handleCreatedTargetEnvironment((TargetEnvironment)environment, progressIndicator);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public static GradleVersion getGradleVersion(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(96);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(97);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(98);
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationTokenSource, null);
        GradleVersion gradleVersion2 = null;
        if (buildEnvironment != null) {
            gradleVersion2 = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        return gradleVersion2;
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationTokenSource cancellationTokenSource, @Nullable GradleExecutionSettings settings2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(99);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(100);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(101);
        }
        CancellationToken cancellationToken = cancellationTokenSource != null ? cancellationTokenSource.token() : null;
        return GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, cancellationToken, settings2);
    }

    @Nullable
    private static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable GradleExecutionSettings settings2) {
        if (connection == null) {
            GradleExecutionHelper.$$$reportNull$$$0(102);
        }
        if (taskId == null) {
            GradleExecutionHelper.$$$reportNull$$$0(103);
        }
        if (listener2 == null) {
            GradleExecutionHelper.$$$reportNull$$$0(104);
        }
        return GradleExecutionHelper.getBuildEnvironment(connection, taskId, listener2, (CancellationToken)null, settings2);
    }

    @Nullable
    public static BuildEnvironment getBuildEnvironment(@NotNull ProjectConnection connection, @NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2, @Nullable CancellationToken cancellationToken, @Nullable GradleExecutionSettings settings2) {
        BuildEnvironment buildEnvironment;
        block10: {
            if (connection == null) {
                GradleExecutionHelper.$$$reportNull$$$0(105);
            }
            if (taskId == null) {
                GradleExecutionHelper.$$$reportNull$$$0(106);
            }
            if (listener2 == null) {
                GradleExecutionHelper.$$$reportNull$$$0(107);
            }
            buildEnvironment = null;
            try {
                String javaHome;
                ModelBuilder modelBuilder = connection.model(BuildEnvironment.class);
                if (cancellationToken != null) {
                    modelBuilder.withCancellationToken(cancellationToken);
                }
                if (settings2 != null && (javaHome = settings2.getJavaHome()) != null && new File(javaHome).isDirectory()) {
                    modelBuilder.setJavaHome(new File(javaHome));
                }
                GradleProgressListener gradleProgressListener = new GradleProgressListener(listener2, taskId);
                modelBuilder.addProgressListener((org.gradle.tooling.ProgressListener)gradleProgressListener);
                modelBuilder.addProgressListener((ProgressListener)gradleProgressListener);
                modelBuilder.setStandardOutput((OutputStream)new OutputWrapper(listener2, taskId, true));
                modelBuilder.setStandardError((OutputStream)new OutputWrapper(listener2, taskId, false));
                buildEnvironment = (BuildEnvironment)modelBuilder.get();
                if (!LOG.isDebugEnabled()) break block10;
                try {
                    String version = buildEnvironment.getGradle().getGradleVersion();
                    LOG.debug("Gradle version: " + version);
                    if (GradleVersion.version((String)version).compareTo(GradleVersion.version((String)"2.6")) >= 0) {
                        LOG.debug("Gradle java home: " + buildEnvironment.getJava().getJavaHome());
                        LOG.debug("Gradle jvm arguments: " + buildEnvironment.getJava().getJvmArguments());
                    }
                }
                catch (Throwable t) {
                    LOG.debug(t);
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to obtain build environment from Gradle daemon.", t);
            }
        }
        return buildEnvironment;
    }

    @NotNull
    public static Set<String> getToolingExtensionsJarPaths(@NotNull Set<Class<?>> toolingExtensionClasses) {
        if (toolingExtensionClasses == null) {
            GradleExecutionHelper.$$$reportNull$$$0(108);
        }
        Set set = ContainerUtil.map2SetNotNull(toolingExtensionClasses, aClass -> {
            String path = PathManager.getJarPathForClass((Class)aClass);
            if (path != null) {
                if (FileUtilRt.getNameWithoutExtension((String)path).equals("gradle-api-" + GradleVersion.current().getBaseVersion())) {
                    LOG.warn("The gradle api jar shouldn't be added to the gradle daemon classpath: {" + aClass + "," + path + "}");
                    return null;
                }
                if (FileUtil.normalize((String)path).endsWith("lib/app.jar")) {
                    String message = "Attempting to pass whole IDEA app [" + path + "] into Gradle Daemon for class [" + aClass + "]";
                    if (ApplicationManagerEx.isInIntegrationTest()) {
                        LOG.error(message);
                    } else {
                        LOG.warn(message);
                    }
                }
                return FileUtil.toCanonicalPath((String)path);
            }
            return null;
        });
        if (set == null) {
            GradleExecutionHelper.$$$reportNull$$$0(109);
        }
        return set;
    }

    @NotNull
    static List<String> obfuscatePasswordParameters(@NotNull List<String> commandLineArguments) {
        if (commandLineArguments == null) {
            GradleExecutionHelper.$$$reportNull$$$0(110);
        }
        ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
        String PASSWORD_PARAMETER_IDENTIFIER = ".password=";
        for (String option : commandLineArguments) {
            int index = option.indexOf(".password=");
            if (index == -1) {
                replaced.add(option);
                continue;
            }
            replaced.add(option.substring(0, index + ".password=".length()) + "*********");
        }
        ArrayList<String> arrayList = replaced;
        if (arrayList == null) {
            GradleExecutionHelper.$$$reportNull$$$0(111);
        }
        return arrayList;
    }

    private static String getIdeaVersion() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        return appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$17(MultiMap argumentsMap, List result, String key) {
        argumentsMap.get((Object)key).forEach(val -> {
            result.add(key);
            if (StringUtil.isNotEmpty((String)val)) {
                result.add(val);
            }
        });
    }

    private static /* synthetic */ boolean lambda$mergeJvmArgs$15(List mergedArgs, String argKey) {
        return !mergedArgs.contains(argKey);
    }

    private static /* synthetic */ void lambda$mergeJvmArgs$14(List mergedArgs, String s1, String s2) {
        mergedArgs.add(s1 + s2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11, 17, 46, 94, 95, 109, 111 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelType";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 37: 
            case 43: 
            case 47: 
            case 52: 
            case 96: 
            case 99: 
            case 102: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 23: 
            case 28: 
            case 33: 
            case 39: 
            case 49: 
            case 54: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 25: 
            case 30: 
            case 35: 
            case 40: 
            case 45: 
            case 50: 
            case 56: 
            case 58: 
            case 60: 
            case 64: 
            case 68: 
            case 70: 
            case 73: 
            case 80: 
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 26: 
            case 31: 
            case 36: 
            case 42: 
            case 51: 
            case 57: 
            case 62: 
            case 66: 
            case 87: 
            case 98: 
            case 101: 
            case 104: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 11: 
            case 17: 
            case 46: 
            case 94: 
            case 95: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 8: 
            case 14: 
            case 55: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksAndArguments";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 29: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 27: 
            case 32: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 48: 
            case 53: 
            case 59: 
            case 63: 
            case 67: 
            case 69: 
            case 71: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 74: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testLauncher";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildLauncher";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildEnvironment";
                break;
            }
            case 86: 
            case 97: 
            case 100: 
            case 103: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgs";
                break;
            }
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmArgsFromIdeSettings";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionSettings";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLauncher";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLauncher";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "setupWrapperTaskInInitScript";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationInitScripts";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsJarPaths";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "obfuscatePasswordParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModelBuilder";
                break;
            }
            case 5: 
            case 11: 
            case 17: 
            case 46: 
            case 94: 
            case 95: 
            case 109: 
            case 111: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBuildLauncher";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTestLauncher";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "maybeFixSystemProperties";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "ensureInstalledWrapper";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "executeWrapperTask";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setupWrapperTaskInInitScript";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "applyIdeaParameters";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressListeners";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setupStandardIO";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setupJvmArguments";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setupJavaHome";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setupArguments";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "fixUpGradleCommandLine";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isWildcardTestPattern";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setupTestLauncherArguments";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "setupBuildLauncherArguments";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "setupLogging";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isRootDirAvailable";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getBuildIdentifier";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "setupEnvironment";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "mergeBuildJvmArguments";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "mergeJvmArgs";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "attachTargetPathMapperInitScript";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "attachIdeaPluginConfigurator";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getBuildEnvironment";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getToolingExtensionsJarPaths";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "obfuscatePasswordParameters";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 11, 17, 46, 94, 95, 109, 111 -> new IllegalStateException(string2);
        };
    }

    @ApiStatus.Internal
    public static class SystemPropertiesAdjuster {
        public SystemPropertiesAdjuster() {
            LOG.info("Gradle system adjuster service: " + this.getClass().getName());
        }

        public Map<String, String> getKeyToMask(@NotNull String projectDir) {
            if (projectDir == null) {
                SystemPropertiesAdjuster.$$$reportNull$$$0(0);
            }
            HashMap<String, String> propertiesFixes = new HashMap<String, String>();
            if (Registry.is((String)"gradle.tooling.adjust.user.dir", (boolean)true)) {
                propertiesFixes.put("user.dir", projectDir);
            }
            propertiesFixes.put("java.system.class.loader", null);
            propertiesFixes.put("jna.noclasspath", null);
            propertiesFixes.put("jna.boot.library.path", null);
            propertiesFixes.put("jna.nosys", null);
            return propertiesFixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "org/jetbrains/plugins/gradle/service/execution/GradleExecutionHelper$SystemPropertiesAdjuster", "getKeyToMask"));
        }
    }
}

