/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.warmup.WarmupLogger;
import com.intellij.ide.warmup.WarmupStatus;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.CoroutinesKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleWarmupConfigurator;
import org.jetbrains.plugins.gradle.service.notification.ExternalAnnotationsProgressNotificationManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0019\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleHeadlessLoggingProjectActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "addAnnotationListener", "", "addStateNotificationListener", "project", "Lcom/intellij/openapi/project/Project;", "progressManager", "Lcom/intellij/openapi/externalSystem/service/notification/ExternalSystemProgressNotificationManager;", "addTaskNotificationListener", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.gradle.common"})
public final class GradleHeadlessLoggingProjectActivity
implements ProjectActivity {
    @NotNull
    private final CoroutineScope scope;

    public GradleHeadlessLoggingProjectActivity(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        if (!Intrinsics.areEqual((Object)WarmupStatus.Companion.currentStatus(application), (Object)WarmupStatus.InProgress.INSTANCE) || !Registry.is((String)"ide.warmup.use.predicates")) {
            return Unit.INSTANCE;
        }
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        Intrinsics.checkNotNull((Object)progressManager);
        this.addTaskNotificationListener(progressManager);
        this.addStateNotificationListener(project, progressManager);
        this.addAnnotationListener();
        return Unit.INSTANCE;
    }

    private final void addTaskNotificationListener(ExternalSystemProgressNotificationManager progressManager) {
        GradleWarmupConfigurator.LoggingNotificationListener listener2 = new GradleWarmupConfigurator.LoggingNotificationListener(new CommandLineInspectionProgressReporter(){

            public void reportError(@Nullable String message) {
                if (message == null) {
                    return;
                }
                WarmupLogger.Companion.error(message, null);
            }

            public void reportMessage(int minVerboseLevel, @Nullable String message) {
                if (message == null) {
                    return;
                }
                WarmupLogger.Companion.message(message);
            }
        });
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)listener2);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressManager, listener2, null){
            int label;
            final /* synthetic */ ExternalSystemProgressNotificationManager $progressManager;
            final /* synthetic */ GradleWarmupConfigurator.LoggingNotificationListener $listener;
            {
                this.$progressManager = $progressManager;
                this.$listener = $listener;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$listener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void addStateNotificationListener(Project project, ExternalSystemProgressNotificationManager progressManager) {
        GradleWarmupConfigurator.StateNotificationListener notificationListener2 = new GradleWarmupConfigurator.StateNotificationListener(project, this.scope);
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)notificationListener2);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(progressManager, notificationListener2, null){
            int label;
            final /* synthetic */ ExternalSystemProgressNotificationManager $progressManager;
            final /* synthetic */ GradleWarmupConfigurator.StateNotificationListener $notificationListener;
            {
                this.$progressManager = $progressManager;
                this.$notificationListener = $notificationListener;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this.$notificationListener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void addAnnotationListener() {
        ExternalAnnotationsProgressNotificationManager externalAnnotationsNotificationManager = ExternalAnnotationsProgressNotificationManager.Companion.getInstance();
        GradleWarmupConfigurator.StateExternalAnnotationNotificationListener externalAnnotationsProgressListener = new GradleWarmupConfigurator.StateExternalAnnotationNotificationListener();
        externalAnnotationsNotificationManager.addNotificationListener(externalAnnotationsProgressListener);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)this.scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(externalAnnotationsNotificationManager, externalAnnotationsProgressListener, null){
            int label;
            final /* synthetic */ ExternalAnnotationsProgressNotificationManager $externalAnnotationsNotificationManager;
            final /* synthetic */ GradleWarmupConfigurator.StateExternalAnnotationNotificationListener $externalAnnotationsProgressListener;
            {
                this.$externalAnnotationsNotificationManager = $externalAnnotationsNotificationManager;
                this.$externalAnnotationsProgressListener = $externalAnnotationsProgressListener;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$externalAnnotationsNotificationManager.removeNotificationListener(this.$externalAnnotationsProgressListener);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }
}

