/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/VersionCatalogsLocator;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getVersionCatalogsForModule", "", "", "Ljava/nio/file/Path;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.gradle.common"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogsLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogsLocator.kt\norg/jetbrains/plugins/gradle/service/resolve/VersionCatalogsLocator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n453#2:27\n403#2:28\n1238#3,4:29\n*S KotlinDebug\n*F\n+ 1 VersionCatalogsLocator.kt\norg/jetbrains/plugins/gradle/service/resolve/VersionCatalogsLocator\n*L\n24#1:27\n24#1:28\n24#1:29,4\n*E\n"})
public final class VersionCatalogsLocator {
    @NotNull
    private final Project myProject;

    public VersionCatalogsLocator(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Path> getVersionCatalogsForModule(@NotNull Module module) {
        void $this$mapValuesTo$iv$iv;
        DataNode dataNode;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                String string2 = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (string2 == null) {
                    return MapsKt.emptyMap();
                }
                String externalProjectPath2 = string2;
                ExternalProjectInfo externalProjectInfo = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, externalProjectPath2);
                if (externalProjectInfo == null) {
                    return MapsKt.emptyMap();
                }
                ExternalProjectInfo projectInfo = externalProjectInfo;
                dataNode = projectInfo.getExternalProjectStructure();
                if (dataNode == null) break block6;
                DataNode it = dataNode;
                boolean bl = false;
                DataNode dataNode2 = ExternalSystemApiUtil.find((DataNode)it, BuildScriptClasspathData.VERSION_CATALOGS);
                Object object = dataNode2 != null ? (VersionCatalogsModel)dataNode2.getData() : null;
                dataNode = object;
                if (object != null) break block7;
            }
            return MapsKt.emptyMap();
        }
        DataNode versionCatalogsModel = dataNode;
        Map map = versionCatalogsModel.getCatalogsLocations();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getCatalogsLocations(...)");
        Map $this$mapValues$iv = map;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Path path = Path.of((String)entry.getValue(), new String[0]);
            map4.put(k, path);
        }
        return destination$iv$iv;
    }
}

