/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitOptions;
import git4idea.checkin.GitEmptyCommitProblemDetector;
import git4idea.checkin.GitGpgCommitException;
import git4idea.checkin.GitGpgProblemDetector;
import git4idea.checkin.GitRepositoryCommitterKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lgit4idea/checkin/GitRepositoryCommitter;", "", "repository", "Lgit4idea/repo/GitRepository;", "commitOptions", "Lgit4idea/checkin/GitCommitOptions;", "(Lgit4idea/repo/GitRepository;Lgit4idea/checkin/GitCommitOptions;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lgit4idea/repo/GitRepository;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "commitStaged", "", "messageFile", "Ljava/io/File;", "commitMessage", "", "intellij.vcs.git"})
public final class GitRepositoryCommitter {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GitCommitOptions commitOptions;

    public GitRepositoryCommitter(@NotNull GitRepository repository, @NotNull GitCommitOptions commitOptions) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commitOptions, (String)"commitOptions");
        this.repository = repository;
        this.commitOptions = commitOptions;
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @NotNull
    public final VirtualFile getRoot() {
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return virtualFile;
    }

    public final void commitStaged(@NotNull String commitMessage) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        GitCheckinEnvironment.runWithMessageFile(this.getProject(), this.getRoot(), commitMessage, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)arg_0 -> GitRepositoryCommitter.commitStaged$lambda$0((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ GitRepositoryCommitter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(File messageFile) {
                Intrinsics.checkNotNull((Object)messageFile);
                this.this$0.commitStaged(messageFile);
            }
        }, arg_0)));
    }

    public final void commitStaged(@NotNull File messageFile) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)messageFile, (String)"messageFile");
        GitGpgProblemDetector gpgProblemDetector = new GitGpgProblemDetector();
        GitEmptyCommitProblemDetector emptyCommitProblemDetector = new GitEmptyCommitProblemDetector();
        GitLineHandler handler = new GitLineHandler(this.getProject(), this.getRoot(), GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addLineListener(gpgProblemDetector);
        handler.addLineListener(emptyCommitProblemDetector);
        GitRepositoryCommitterKt.access$setCommitMessage(handler, messageFile);
        GitRepositoryCommitterKt.access$setCommitOptions(handler, this.commitOptions);
        handler.endOptions();
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult command = gitCommandResult;
        try {
            command.throwOnError(new int[0]);
        }
        catch (VcsException e) {
            if (gpgProblemDetector.isDetected()) {
                throw new GitGpgCommitException(e);
            }
            if (emptyCommitProblemDetector.isDetected()) {
                throw new VcsException(GitBundle.message("git.commit.nothing.to.commit.error.message", new Object[0]));
            }
            throw e;
        }
    }

    private static final void commitStaged$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

