/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.google.common.net.HostAndPort;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.TildeExpandFilenameException;
import com.intellij.util.SystemProperties;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0000\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002\u001a$\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00020\u001cH\u0000\u001a\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0002H\u0000\u001a\u001e\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010#0\"2\u0006\u0010$\u001a\u00020\u0002H\u0000\u001a&\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u001dH\u0000\u001a&\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u001dH\u0000\u001a\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0002H\u0000\u001a\f\u0010*\u001a\u00020\u0002*\u00020\u0014H\u0000\"2\u0010\u0000\u001a&\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0001j\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"cachedExceptions", "Ljava/util/HashMap;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lkotlin/collections/HashMap;", "cachedHomes", "defaultKnownHostsFiles", "", "Ljava/nio/file/Path;", "getDefaultKnownHostsFiles", "()Ljava/util/List;", "homesLock", "Ljava/lang/Object;", "getCachedOrRetrieveUserHome", "username", "getHostName", "getUserHome", "getUserHomeUsingShell", "parseJump", "Lcom/intellij/ssh/config/ProxyJumpOptions;", "value", "parseOpenSshConfigForwardInfo", "Lcom/intellij/ssh/config/OpenSshConfigForwardInfo;", "conf", "percentExpand", "pattern", "tokens", "", "", "resolveHostName", "hostName", "host", "splitHostPort", "Lkotlin/Pair;", "", "hostPort", "splitMinHead", "delimiter", "splitMinTail", "tildeExpandFilename", "path", "toProxyCommand", "intellij.platform.ssh"})
@JvmName(name="OpenSSHConfigUtil")
@SourceDebugExtension(value={"SMAP\nopenSSHConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 openSSHConfigUtil.kt\ncom/intellij/ssh/config/OpenSSHConfigUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,298:1\n1174#2,2:299\n1#3:301\n37#4,2:302\n*S KotlinDebug\n*F\n+ 1 openSSHConfigUtil.kt\ncom/intellij/ssh/config/OpenSSHConfigUtil\n*L\n25#1:299,2\n265#1:302,2\n*E\n"})
public final class OpenSSHConfigUtil {
    @NotNull
    private static final Object homesLock = new Object();
    @NotNull
    private static final HashMap<String, String> cachedHomes = new HashMap();
    @NotNull
    private static final HashMap<String, Exception> cachedExceptions = new HashMap();

    @NotNull
    public static final String percentExpand(@NotNull String pattern, @NotNull Map<Character, String> tokens) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        StringBuilder builder = new StringBuilder(pattern.length());
        boolean escapeOn = false;
        CharSequence $this$forEach$iv = pattern;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            Pair pair = ch == '%' && !escapeOn ? TuplesKt.to((Object)"", (Object)true) : (ch == '%' && escapeOn ? TuplesKt.to((Object)Character.valueOf('%'), (Object)false) : (tokens.containsKey(Character.valueOf(ch)) && escapeOn ? TuplesKt.to((Object)tokens.get(Character.valueOf(ch)), (Object)false) : (escapeOn ? TuplesKt.to((Object)("%" + ch), (Object)false) : TuplesKt.to((Object)Character.valueOf(ch), (Object)false))));
            Object string = pair.component1();
            boolean nextEscapeOn = (Boolean)pair.component2();
            builder.append(string);
            escapeOn = nextEscapeOn;
        }
        if (escapeOn) {
            builder.append('%');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String resolveHostName(@NotNull String hostName, @NotNull String host2) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        return OpenSSHConfigUtil.percentExpand(hostName, MapsKt.mapOf((Pair)TuplesKt.to((Object)Character.valueOf('h'), (Object)host2)));
    }

    @NotNull
    public static final String tildeExpandFilename(@NotNull String path) {
        List pathSeparators;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[]{"\\", "/"};
            v0 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            v0 = pathSeparators = CollectionsKt.listOf((Object)"/");
        }
        if (StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null)) {
            String string;
            Pair pair = StringsKt.findAnyOf$default((CharSequence)path, (Collection)pathSeparators, (int)1, (boolean)false, (int)4, null);
            int index = pair != null ? ((Number)pair.getFirst()).intValue() : path.length();
            String string2 = path.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String suffix = string2;
            if (index == 1) {
                string = SystemProperties.getUserHome();
            } else {
                String string3;
                String string4 = path.substring(1, index);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String username = string4;
                try {
                    string3 = OpenSSHConfigUtil.getCachedOrRetrieveUserHome(username);
                }
                catch (Exception e) {
                    throw new TildeExpandFilenameException("Failed to expand ~" + username + " in " + path, e);
                }
                string = string3;
            }
            String string5 = string;
            Intrinsics.checkNotNull((Object)string5);
            String userHome = string5;
            return userHome + suffix;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String getCachedOrRetrieveUserHome(String username) {
        Object object = homesLock;
        synchronized (object) {
            boolean bl = false;
            String cachedHome = cachedHomes.get(username);
            if (cachedHome != null) {
                return cachedHome;
            }
            Exception cachedException = cachedExceptions.get(username);
            if (cachedException != null) {
                throw new RuntimeException("Previous attempt to retrieve home directory for `" + username + "` user failed", cachedException);
            }
            try {
                String userHome = OpenSSHConfigUtil.getUserHome(username);
                ((Map)cachedHomes).put(username, userHome);
                return userHome;
            }
            catch (Exception e) {
                ((Map)cachedExceptions).put(username, e);
                throw e;
            }
        }
    }

    private static final String getUserHome(String username) {
        if (Intrinsics.areEqual((Object)SystemProperties.getUserName(), (Object)username)) {
            String string = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
            return string;
        }
        if (!SystemInfo.isWindows) {
            return OpenSSHConfigUtil.getUserHomeUsingShell(username);
        }
        return ((Object)Paths.get(SystemProperties.getUserHome(), new String[0]).resolveSibling(username)).toString();
    }

    private static final String getUserHomeUsingShell(String username) {
        String[] stringArray = new String[]{"sh", "-c", "echo ~" + username};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        try {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)1000);
            if (processOutput.getExitCode() != 0) {
                throw new RuntimeException("Shell exited with code " + processOutput.getExitCode());
            }
            String string = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String home2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (Intrinsics.areEqual((Object)home2, (Object)("~" + username))) {
                throw new RuntimeException("Shell didn't expand ~" + username + ". Probably user does not exist.");
            }
            return home2;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve home directory for `" + username + "` user using `" + commandLine.getCommandLineString() + "` command", e);
        }
    }

    private static final String getHostName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String toProxyCommand(@NotNull ProxyJumpOptions $this$toProxyCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$toProxyCommand, (String)"<this>");
        StringBuilder optionsBuilder = new StringBuilder();
        if ($this$toProxyCommand.getUser() != null) {
            optionsBuilder.append(" -l " + $this$toProxyCommand.getUser());
        }
        if ($this$toProxyCommand.getPort() != null) {
            optionsBuilder.append(" -p " + $this$toProxyCommand.getPort());
        }
        if ($this$toProxyCommand.getExtra() != null) {
            optionsBuilder.append(" -J " + $this$toProxyCommand.getExtra());
        }
        String string = optionsBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String options = string;
        return "ssh" + options + " -W '[%h]:%p' " + $this$toProxyCommand.getHost();
    }

    @NotNull
    public static final ProxyJumpOptions parseJump(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Pair<String, String> pair = OpenSSHConfigUtil.splitMinHead(value, ',');
        String firstJump = (String)pair.component1();
        String extraJumps = (String)pair.component2();
        if (StringsKt.startsWith$default((String)firstJump, (String)"ssh://", (boolean)false, (int)2, null)) {
            URI uri = URI.create(firstJump);
            String user2 = uri.getUserInfo();
            String host2 = uri.getHost();
            Integer port2 = uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort());
            Intrinsics.checkNotNull((Object)host2);
            return new ProxyJumpOptions(user2, host2, port2, extraJumps);
        }
        Pair<String, String> pair2 = OpenSSHConfigUtil.splitMinTail(firstJump, '@');
        String user3 = (String)pair2.component1();
        String hostPort = (String)pair2.component2();
        Pair<String, Integer> pair3 = OpenSSHConfigUtil.splitHostPort(hostPort);
        String host3 = (String)pair3.component1();
        Integer port3 = (Integer)pair3.component2();
        return new ProxyJumpOptions(user3, host3, port3, extraJumps);
    }

    @NotNull
    public static final Pair<String, String> splitMinHead(@NotNull String value, char delimiter) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int i = StringsKt.indexOf$default((CharSequence)value, (char)delimiter, (int)0, (boolean)false, (int)6, null);
        if (i == -1) {
            pair = TuplesKt.to((Object)value, null);
        } else {
            String string = value.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = value.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            pair = TuplesKt.to((Object)string, (Object)string2);
        }
        return pair;
    }

    @NotNull
    public static final Pair<String, String> splitMinTail(@NotNull String value, char delimiter) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int i = StringsKt.lastIndexOf$default((CharSequence)value, (char)delimiter, (int)0, (boolean)false, (int)6, null);
        if (i == -1) {
            pair = TuplesKt.to(null, (Object)value);
        } else {
            String string = value.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = value.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            pair = TuplesKt.to((Object)string, (Object)string2);
        }
        return pair;
    }

    @NotNull
    public static final Pair<String, Integer> splitHostPort(@NotNull String hostPort) {
        HostAndPort hostAndPort;
        Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
        if (((CharSequence)hostPort).length() == 0) {
            throw new IllegalArgumentException("host[:port] must not be empty");
        }
        if (StringsKt.endsWith$default((CharSequence)hostPort, (char)':', (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Port is not specified after the colon `:`");
        }
        HostAndPort $this$splitHostPort_u24lambda_u242 = hostAndPort = HostAndPort.fromString((String)hostPort).requireBracketsForIPv6();
        boolean bl = false;
        return $this$splitHostPort_u24lambda_u242.hasPort() ? TuplesKt.to((Object)$this$splitHostPort_u24lambda_u242.getHost(), (Object)$this$splitHostPort_u24lambda_u242.getPort()) : TuplesKt.to((Object)$this$splitHostPort_u24lambda_u242.getHost(), null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final OpenSshConfigForwardInfo parseOpenSshConfigForwardInfo(@NotNull String conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        var2_1 = (String[])conf;
        var3_2 = new Regex("( +|:)");
        var4_5 = 0;
        $this$toTypedArray$iv = var3_2.split((CharSequence)var2_1, var4_5);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        splitConf = thisCollection$iv.toArray(new String[0]);
        switch (splitConf.length) {
            case 3: {
                thisCollection$iv = new SpreadBuilder(2);
                thisCollection$iv.add("");
                thisCollection$iv.addSpread(splitConf);
                v0 = (String[])thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                break;
            }
            case 4: {
                v0 = splitConf;
                break;
            }
            default: {
                throw new IllegalStateException("Can't parse " + conf);
            }
        }
        var2_1 = v0;
        bindHost = var2_1[0];
        bindPortStr = var2_1[1];
        host = var2_1[2];
        portStr = var2_1[3];
        try {
            block11: {
                var7_10 = bindHost;
                switch (var7_10.hashCode()) {
                    case 0: {
                        if (var7_10.equals("")) break;
                        ** break;
                    }
                    case -1204607085: {
                        if (var7_10.equals("localhost")) break;
                        ** break;
                    }
                    case 42: {
                        if (!var7_10.equals("*")) ** break;
                        v1 = "0.0.0.0";
                        break block11;
                    }
                }
                v1 = "127.0.0.1";
                break block11;
lbl43:
                // 4 sources

                v1 = bindHost;
            }
            var7_10 = new OpenSshConfigForwardInfo(v1, Integer.parseInt(bindPortStr), host, Integer.parseInt(portStr));
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't parse " + conf, e);
        }
        return var7_10;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<Path> getDefaultKnownHostsFiles() {
        List list2;
        Path dir = Ssh.getHomeSshDirectory();
        Path file1 = dir.resolve("known_hosts");
        Path file2 = dir.resolve("known_hosts2");
        Intrinsics.checkNotNull((Object)file1);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file1, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Intrinsics.checkNotNull((Object)file2);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(file2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object[] objectArray = new Path[]{file1, file2};
                list2 = CollectionsKt.listOf((Object[])objectArray);
                return list2;
            }
        }
        Intrinsics.checkNotNull((Object)file2);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (Files.exists(file2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            list2 = CollectionsKt.listOf((Object)file2);
            return list2;
        }
        list2 = CollectionsKt.listOf((Object)file1);
        return list2;
    }
}

