/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.json;

import ai.grazie.utils.json.JSON;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/grazie/utils/json/JSONObject;", "", "content", "", "json", "Lai/grazie/utils/json/JSON;", "(Ljava/lang/String;Lai/grazie/utils/json/JSON;)V", "getContent", "()Ljava/lang/String;", "getJson", "()Lai/grazie/utils/json/JSON;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "utils-json"})
public final class JSONObject {
    @NotNull
    private final String content;
    @NotNull
    private final JSON json;

    public JSONObject(@NotNull String content, @NotNull JSON json) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.content = content;
        this.json = json;
        try {
            JsonElement jsonElement = this.json.parseJsonElement(this.content);
            if (!(jsonElement instanceof JsonObject)) {
                throw new IllegalArgumentException("Expected JsonObject but actually it was " + Reflection.getOrCreateKotlinClass(jsonElement.getClass()).getSimpleName());
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid JSON object received");
        }
    }

    public /* synthetic */ JSONObject(String string2, JSON jSON, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            jSON = JSON.Default.INSTANCE;
        }
        this(string2, jSON);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final JSON getJson() {
        return this.json;
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final JSON component2() {
        return this.json;
    }

    @NotNull
    public final JSONObject copy(@NotNull String content, @NotNull JSON json) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return new JSONObject(content, json);
    }

    public static /* synthetic */ JSONObject copy$default(JSONObject jSONObject, String string2, JSON jSON, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = jSONObject.content;
        }
        if ((n & 2) != 0) {
            jSON = jSONObject.json;
        }
        return jSONObject.copy(string2, jSON);
    }

    @NotNull
    public String toString() {
        return "JSONObject(content=" + this.content + ", json=" + this.json + ")";
    }

    public int hashCode() {
        int result2 = this.content.hashCode();
        result2 = result2 * 31 + this.json.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONObject)) {
            return false;
        }
        JSONObject jSONObject = (JSONObject)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)jSONObject.content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.json, (Object)jSONObject.json);
    }
}

