/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/text/CodeProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "shouldSuppressInText", "text", "Lcom/intellij/grazie/text/TextContent;", "textAround", "", "range", "Lcom/intellij/openapi/util/TextRange;", "InDocumentation", "InPlainText", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCodeProblemFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeProblemFilter.kt\ncom/intellij/grazie/text/CodeProblemFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1747#2,3:45\n*S KotlinDebug\n*F\n+ 1 CodeProblemFilter.kt\ncom/intellij/grazie/text/CodeProblemFilter\n*L\n21#1:45,3\n*E\n"})
public class CodeProblemFilter
extends ProblemFilter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        TextRange it;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (!problem.shouldSuppressInCodeLikeFragments()) return false;
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        if (!this.shouldSuppressInText(textContent)) return false;
        List<TextRange> list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (TextRange)element$iv;
            boolean bl = false;
            TextContent textContent2 = problem.getText();
            Intrinsics.checkNotNullExpressionValue((Object)textContent2, (String)"getText(...)");
            charSequence = textContent2;
            Intrinsics.checkNotNull((Object)it);
        } while (!Text.INSTANCE.looksLikeCode(this.textAround(charSequence, it)));
        return true;
    }

    protected boolean shouldSuppressInText(@NotNull TextContent text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return text2.getDomain() == TextContent.TextDomain.COMMENTS || text2.getDomain() == TextContent.TextDomain.LITERALS;
    }

    private final CharSequence textAround(CharSequence text2, TextRange range) {
        return text2.subSequence(RangesKt.coerceAtLeast((int)(range.getStartOffset() - 20), (int)0), RangesKt.coerceAtMost((int)(range.getEndOffset() + 20), (int)text2.length()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/text/CodeProblemFilter$InDocumentation;", "Lcom/intellij/grazie/text/CodeProblemFilter;", "()V", "shouldSuppressInText", "", "text", "Lcom/intellij/grazie/text/TextContent;", "intellij.grazie.core"})
    public static final class InDocumentation
    extends CodeProblemFilter {
        @Override
        protected boolean shouldSuppressInText(@NotNull TextContent text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return text2.getDomain() == TextContent.TextDomain.DOCUMENTATION;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/text/CodeProblemFilter$InPlainText;", "Lcom/intellij/grazie/text/CodeProblemFilter;", "()V", "shouldSuppressInText", "", "text", "Lcom/intellij/grazie/text/TextContent;", "intellij.grazie.core"})
    public static final class InPlainText
    extends CodeProblemFilter {
        @Override
        protected boolean shouldSuppressInText(@NotNull TextContent text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return text2.getDomain() == TextContent.TextDomain.PLAIN_TEXT;
        }
    }
}

