/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.service.SharedThreadPool;

final class ForkedGroovyc
implements GroovycFlavor {
    private final boolean myOptimizeClassLoading;
    private final ModuleChunk myChunk;

    ForkedGroovyc(boolean optimizeClassLoading, ModuleChunk chunk) {
        this.myOptimizeClassLoading = optimizeClassLoading;
        this.myChunk = chunk;
    }

    @Override
    public GroovycContinuation runGroovyc(Collection<String> compilationClassPath, boolean forStubs, CompileContext context, File tempFile, final GroovycOutputParser parser, String byteCodeTargetLevel) throws Exception {
        String grapeRoot;
        String configScript;
        int suggested;
        ArrayList<String> classpath = new ArrayList<String>();
        if (this.myOptimizeClassLoading) {
            classpath.addAll(GroovyBuilder.getGroovyRtRoots(true));
        } else {
            classpath.addAll(compilationClassPath);
        }
        JpsGroovySettings settings = JpsGroovycRunner.getGroovyCompilerSettings(context);
        ArrayList<Object> vmParams = new ArrayList<Object>();
        String heapSize = System.getProperty("groovyc.heap.size");
        if (heapSize == null && (suggested = Utils.suggestForkedCompilerHeapSize()) > 0) {
            heapSize = String.valueOf(suggested);
        }
        if (heapSize != null) {
            vmParams.add("-Xmx" + heapSize + "m");
        }
        vmParams.add("-Dfile.encoding=" + System.getProperty("file.encoding"));
        if ("false".equals(System.getProperty("groovyc.asm.resolving.only"))) {
            vmParams.add("-Dgroovyc.asm.resolving.only=false");
        }
        if (StringUtil.isNotEmpty((String)(configScript = settings.configScript))) {
            vmParams.add("-Dgroovyc.config.script=" + configScript);
        }
        if ((grapeRoot = System.getProperty("grape.root")) != null) {
            vmParams.add("-Dgrape.root=" + grapeRoot);
        }
        if (byteCodeTargetLevel != null) {
            vmParams.add("-Dgroovy.target.bytecode=" + byteCodeTargetLevel);
        }
        if ("true".equals(System.getProperty("groovyc.remove.annotations.for.stub.generation"))) {
            vmParams.add("-Dgroovyc.remove.annotations.for.stub.generation=true");
        }
        List cmd = ExternalProcessUtil.buildJavaCommandLine((String)ForkedGroovyc.getJavaExecutable(this.myChunk), (String)"org.jetbrains.groovy.compiler.rt.GroovycRunner", Collections.emptyList(), classpath, vmParams, this.getProgramParams(tempFile, settings, forStubs));
        Process process = Runtime.getRuntime().exec(ArrayUtilRt.toStringArray((Collection)cmd));
        BaseOSProcessHandler handler = new BaseOSProcessHandler(process, StringUtil.join((Collection)cmd, (String)" "), null){

            @NotNull
            public Future<?> executeTask(@NotNull Runnable task) {
                if (task == null) {
                    1.$$$reportNull$$$0(0);
                }
                Future future = SharedThreadPool.getInstance().submit(task);
                if (future == null) {
                    1.$$$reportNull$$$0(1);
                }
                return future;
            }

            public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
                if (text == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(3);
                }
                parser.notifyTextAvailable(text, outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "task";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/jps/incremental/groovy/ForkedGroovyc$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/jps/incremental/groovy/ForkedGroovyc$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeTask";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "executeTask";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "notifyTextAvailable";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        handler.startNotify();
        handler.waitFor();
        parser.notifyFinished(process.exitValue());
        return null;
    }

    private List<String> getProgramParams(File tempFile, JpsGroovySettings settings, boolean forStubs) {
        List programParams = List.of(this.myOptimizeClassLoading ? "optimize" : "do_not_optimize", forStubs ? "stubs" : "groovyc", tempFile.getPath());
        if (settings.invokeDynamic) {
            programParams = ContainerUtil.append(programParams, (Object[])new String[]{"--indy"});
        }
        return programParams;
    }

    private static String getJavaExecutable(ModuleChunk chunk) {
        JpsSdk<JpsDummyElement> sdk = GroovyBuilder.getJdk(chunk);
        return sdk != null ? JpsJavaSdkType.getJavaExecutable(sdk) : SystemProperties.getJavaHome() + "/bin/java";
    }
}

