/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions.scheme;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.config.SerializationHelper;
import com.intellij.internal.statistic.devkit.actions.TestParseEventsSchemeDialog;
import com.intellij.internal.statistic.devkit.actions.scheme.EventsSchemeJsonSchemaProviderFactoryKt;
import com.intellij.internal.statistic.devkit.actions.scheme.EventsTestSchemeGroupConfiguration;
import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.TextFieldCompletionProviderDumbAware;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaComplianceInspection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u000234BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020\rH\u0016J\u0006\u0010,\u001a\u00020\u0017J\b\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\r2\b\u0010/\u001a\u0004\u0018\u00010\u0007J\b\u00100\u001a\u00020\rH\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\tR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "productionGroups", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "initialGroup", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "generatedScheme", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "groupIdChangeListener", "Lkotlin/Function1;", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "allowAllEventsRadioButton", "Lcom/intellij/ui/components/JBRadioButton;", "currentGroup", "customRulesRadioButton", "eventsScheme", "", "", "generateSchemeButton", "Ljavax/swing/JComponent;", "groupIdTextField", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "getGroupIdTextField", "()Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "tempFile", "Lcom/intellij/psi/PsiFile;", "validationRulesEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "validationRulesEditorComponent", "createCompletionProvider", "Lcom/intellij/util/TextFieldCompletionProviderDumbAware;", "createCustomRules", "Lcom/intellij/openapi/ui/DialogPanel;", "createEditor", "file", "dispose", "getFocusedComponent", "updateGenerateSchemeButton", "updatePanel", "newGroup", "updateRulesOption", "validate", "Lcom/intellij/openapi/ui/ValidationInfo;", "Companion", "ProductionRules", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nEventsTestSchemeGroupConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,356:1\n10#2:357\n*S KotlinDebug\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration\n*L\n251#1:357\n*E\n"})
public final class EventsTestSchemeGroupConfiguration
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final TextFieldWithCompletion groupIdTextField;
    @NotNull
    private GroupValidationTestRule currentGroup;
    private JBRadioButton allowAllEventsRadioButton;
    private JBRadioButton customRulesRadioButton;
    private JComponent generateSchemeButton;
    @NotNull
    private final JComponent validationRulesEditorComponent;
    @NotNull
    private final PsiFile tempFile;
    @NotNull
    private final EditorEx validationRulesEditor;
    @NotNull
    private final Map<String, String> eventsScheme;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<ProductionRules> FUS_TEST_SCHEME_COMMON_RULES_KEY;

    public EventsTestSchemeGroupConfiguration(@NotNull Project project, @NotNull EventGroupRemoteDescriptors productionGroups, final @NotNull GroupValidationTestRule initialGroup, @NotNull List<GroupDescriptor> generatedScheme, final @Nullable Function1<? super GroupValidationTestRule, Unit> groupIdChangeListener) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)productionGroups, (String)"productionGroups");
        Intrinsics.checkNotNullParameter((Object)initialGroup, (String)"initialGroup");
        Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
        this.project = project;
        this.currentGroup = initialGroup;
        this.eventsScheme = Companion.createEventsScheme$intellij_platform_statistics_devkit(generatedScheme);
        this.groupIdTextField = new TextFieldWithCompletion(this.project, (TextCompletionProvider)this.createCompletionProvider(productionGroups), initialGroup.getGroupId(), true, true, true);
        this.groupIdTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                GroupValidationTestRule groupValidationTestRule = currentGroup;
                String string = this.getGroupIdTextField().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                groupValidationTestRule.setGroupId(string);
                if (groupIdChangeListener != null) {
                    groupIdChangeListener.invoke((Object)currentGroup);
                }
                this.updateGenerateSchemeButton();
            }
        });
        PsiFile psiFile = TestParseEventsSchemeDialog.createTempFile(this.project, "event-log-validation-rules", this.currentGroup.getCustomRules());
        Intrinsics.checkNotNull((Object)psiFile);
        this.tempFile = psiFile;
        this.tempFile.getVirtualFile().putUserData(EventsSchemeJsonSchemaProviderFactoryKt.getEVENTS_TEST_SCHEME_VALIDATION_RULES_KEY(), (Object)true);
        this.tempFile.putUserData(FUS_TEST_SCHEME_COMMON_RULES_KEY, (Object)new ProductionRules(productionGroups.rules));
        this.validationRulesEditor = this.createEditor(this.project, this.tempFile);
        this.validationRulesEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                GroupValidationTestRule groupValidationTestRule = currentGroup;
                String string = validationRulesEditor.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                groupValidationTestRule.setCustomRules(string);
            }
        });
        JComponent jComponent = this.validationRulesEditor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.validationRulesEditorComponent = jComponent;
        this.panel = (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = StatisticsBundle.message((String)"stats.group.id", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.getGroupIdTextField()).applyToComponent((Function1)1.INSTANCE).align((Align)AlignX.FILL.INSTANCE);
                    }
                });
                Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(){

                    public final void invoke(@NotNull Panel $this$buttonsGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = StatisticsBundle.message((String)"stats.use.custom.validation.rules", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                customRulesRadioButton = (JBRadioButton)ButtonKt.selected((Cell)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null).gap(RightGap.SMALL), (boolean)initialGroup.getUseCustomRules()).applyToComponent((Function1)new Function1<JBRadioButton, Unit>(){

                                    public final void invoke(@NotNull JBRadioButton $this$applyToComponent) {
                                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                        $this$applyToComponent.addChangeListener(arg_0 -> 1.invoke$lambda$0(this, arg_0));
                                    }

                                    private static final void invoke$lambda$0(EventsTestSchemeGroupConfiguration this$0, ChangeEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                        this$0.updateRulesOption();
                                    }
                                }).getComponent();
                                String string2 = StatisticsBundle.message((String)"stats.test.scheme.custom.rules.help", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(final @NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string = StatisticsBundle.message((String)"stats.allow.all.events", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                allowAllEventsRadioButton = (JBRadioButton)ButtonKt.selected((Cell)Row.radioButton$default((Row)$this$row, (String)string, null, (int)2, null), (!initialGroup.getUseCustomRules() ? 1 : 0) != 0).applyToComponent((Function1)new Function1<JBRadioButton, Unit>(){

                                    public final void invoke(@NotNull JBRadioButton $this$applyToComponent) {
                                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                        Icon icon = AllIcons.General.BalloonWarning12;
                                        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonWarning12");
                                        $this$row.icon(icon);
                                        $this$applyToComponent.addChangeListener(arg_0 -> 1.invoke$lambda$0(this, arg_0));
                                    }

                                    private static final void invoke$lambda$0(EventsTestSchemeGroupConfiguration this$0, ChangeEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                        this$0.updateRulesOption();
                                    }
                                }).getComponent();
                                String string2 = StatisticsBundle.message((String)"stats.allow.all.events.help", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
                            }
                        }), (int)1, null);
                    }
                }), (int)3, null);
                Row row = Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.createCustomRules()).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
                JBRadioButton jBRadioButton = customRulesRadioButton;
                if (jBRadioButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
                    jBRadioButton = null;
                }
                row.visibleIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBRadioButton)));
            }
        }));
        this.updateRulesOption();
    }

    public /* synthetic */ EventsTestSchemeGroupConfiguration(Project project, EventGroupRemoteDescriptors eventGroupRemoteDescriptors, GroupValidationTestRule groupValidationTestRule, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        this(project, eventGroupRemoteDescriptors, groupValidationTestRule, list, (Function1<? super GroupValidationTestRule, Unit>)function1);
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final TextFieldWithCompletion getGroupIdTextField() {
        return this.groupIdTextField;
    }

    private final DialogPanel createCustomRules() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCustomRules_u24lambda_u240 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(EventsTestSchemeGroupConfiguration.access$getValidationRulesEditorComponent$p(this.this$0)).align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        EventsTestSchemeGroupConfiguration.access$setGenerateSchemeButton$p(this.this$0, $this$row.button("Generate Scheme", (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                String scheme = (String)EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this.this$0).get(this.this$0.getGroupIdTextField().getText());
                                if (scheme != null) {
                                    WriteAction.run(() -> createCustomRules.1.invoke$lambda$0(this.this$0, scheme));
                                }
                            }

                            private static final void invoke$lambda$0(EventsTestSchemeGroupConfiguration this$0, String $scheme) {
                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                EventsTestSchemeGroupConfiguration.access$getValidationRulesEditor$p(this$0).getDocument().setText((CharSequence)$scheme);
                            }
                        }).getComponent());
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)createCustomRules.3.INSTANCE, (int)1, null);
            }
        }));
        boolean bl = false;
        $this$createCustomRules_u24lambda_u240.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGapsKt.UnscaledGaps$default((int)0, (int)2, (int)0, (int)0, (int)13, null));
        return dialogPanel;
    }

    private final void updateGenerateSchemeButton() {
        JBRadioButton jBRadioButton = this.customRulesRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
            jBRadioButton = null;
        }
        boolean useCustomRules = jBRadioButton.isSelected();
        JComponent jComponent = this.generateSchemeButton;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
            jComponent = null;
        }
        jComponent.setEnabled(useCustomRules && this.eventsScheme.get(this.groupIdTextField.getText()) != null);
        JComponent jComponent2 = this.generateSchemeButton;
        if (jComponent2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
            jComponent2 = null;
        }
        if (!jComponent2.isEnabled()) {
            JComponent jComponent3 = this.generateSchemeButton;
            if (jComponent3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
                jComponent3 = null;
            }
            jComponent3.setToolTipText(StatisticsBundle.message((String)"stats.scheme.generation.available.only.for.new.api", (Object[])new Object[0]));
        } else {
            JComponent jComponent4 = this.generateSchemeButton;
            if (jComponent4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generateSchemeButton");
                jComponent4 = null;
            }
            jComponent4.setToolTipText(null);
        }
    }

    private final TextFieldCompletionProviderDumbAware createCompletionProvider(EventGroupRemoteDescriptors productionGroups) {
        return new TextFieldCompletionProviderDumbAware(this, productionGroups){
            final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
            final /* synthetic */ EventGroupRemoteDescriptors $productionGroups;
            {
                this.this$0 = $receiver;
                this.$productionGroups = $productionGroups;
            }

            /*
             * WARNING - void declaration
             */
            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Iterable iterable = EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this.this$0).keySet();
                EventsTestSchemeGroupConfiguration eventsTestSchemeGroupConfiguration = this.this$0;
                boolean $i$f$map = false;
                void var9_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LookupElementBuilder.create((String)it).withInsertHandler((arg_0, arg_1) -> createCompletionProvider.1.addCompletionVariants$lambda$2$lambda$1(eventsTestSchemeGroupConfiguration, arg_0, arg_1)));
                }
                List generatedSchemeVariants = (List)destination$iv$iv;
                result.addAllElements((Iterable)generatedSchemeVariants);
                ArrayList arrayList = this.$productionGroups.groups;
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"groups");
                List productionGroupsVariants2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)arrayList), (Function1)createCompletionProvider.addCompletionVariants.productionGroupsVariants.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>(this.this$0){
                    final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this.this$0).keySet().contains(it);
                    }
                })), (Function1)((Function1)new Function1<String, LookupElementBuilder>(this.this$0){
                    final /* synthetic */ EventsTestSchemeGroupConfiguration this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final LookupElementBuilder invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return LookupElementBuilder.create((String)it).withInsertHandler((arg_0, arg_1) -> createCompletionProvider.addCompletionVariants.productionGroupsVariants.3.invoke$lambda$1(this.this$0, arg_0, arg_1));
                    }

                    private static final void invoke$lambda$1$lambda$0(EventsTestSchemeGroupConfiguration this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        EventsTestSchemeGroupConfiguration.access$getValidationRulesEditor$p(this$0).getDocument().setText((CharSequence)"{\n    \"event_id\": [],\n    \"event_data\": {}\n  }");
                    }

                    private static final void invoke$lambda$1(EventsTestSchemeGroupConfiguration this$0, InsertionContext insertionContext, LookupElement lookupElement) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<anonymous parameter 1>");
                        JBRadioButton jBRadioButton = EventsTestSchemeGroupConfiguration.access$getAllowAllEventsRadioButton$p(this$0);
                        if (jBRadioButton == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"allowAllEventsRadioButton");
                            jBRadioButton = null;
                        }
                        jBRadioButton.setSelected(true);
                        WriteAction.run(() -> createCompletionProvider.addCompletionVariants.productionGroupsVariants.3.invoke$lambda$1$lambda$0(this$0));
                    }
                })));
                result.addAllElements((Iterable)productionGroupsVariants2);
            }

            private static final void addCompletionVariants$lambda$2$lambda$1$lambda$0(EventsTestSchemeGroupConfiguration this$0, String $scheme) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                EventsTestSchemeGroupConfiguration.access$getValidationRulesEditor$p(this$0).getDocument().setText((CharSequence)$scheme);
            }

            private static final void addCompletionVariants$lambda$2$lambda$1(EventsTestSchemeGroupConfiguration this$0, InsertionContext insertionContext, LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String scheme = (String)EventsTestSchemeGroupConfiguration.access$getEventsScheme$p(this$0).get(item.getLookupString());
                if (scheme != null) {
                    JBRadioButton jBRadioButton = EventsTestSchemeGroupConfiguration.access$getCustomRulesRadioButton$p(this$0);
                    if (jBRadioButton == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
                        jBRadioButton = null;
                    }
                    jBRadioButton.setSelected(true);
                    WriteAction.run(() -> createCompletionProvider.1.addCompletionVariants$lambda$2$lambda$1$lambda$0(this$0, scheme));
                }
            }
        };
    }

    private final EditorEx createEditor(Project project, PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)this.currentGroup.getCustomRules());
        }
        VirtualFile virtualFile = file.getVirtualFile();
        Editor editor = EditorFactory.getInstance().createEditor(document, project, virtualFile, false);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        editor2.setFile(virtualFile);
        editor2.getSettings().setLineMarkerAreaShown(false);
        editor2.getSettings().setFoldingOutlineShown(false);
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("JSON");
        LightVirtualFile lightFile = new LightVirtualFile("Dummy.json", fileType, (CharSequence)"");
        EditorHighlighter highlighter = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(project, (VirtualFile)lightFile);
        try {
            editor2.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
        return editor2;
    }

    public final void updatePanel(@Nullable GroupValidationTestRule newGroup) {
        if (newGroup == null) {
            return;
        }
        this.currentGroup = newGroup;
        this.groupIdTextField.setText(newGroup.getGroupId());
        this.groupIdTextField.requestFocusInWindow();
        if (newGroup.getUseCustomRules()) {
            JBRadioButton jBRadioButton = this.customRulesRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
        } else {
            JBRadioButton jBRadioButton = this.allowAllEventsRadioButton;
            if (jBRadioButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"allowAllEventsRadioButton");
                jBRadioButton = null;
            }
            jBRadioButton.setSelected(true);
        }
        WriteAction.run(() -> EventsTestSchemeGroupConfiguration.updatePanel$lambda$1(this, newGroup));
    }

    private final void updateRulesOption() {
        this.updateGenerateSchemeButton();
        JBRadioButton jBRadioButton = this.customRulesRadioButton;
        if (jBRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customRulesRadioButton");
            jBRadioButton = null;
        }
        this.currentGroup.setUseCustomRules(jBRadioButton.isSelected());
    }

    @NotNull
    public final JComponent getFocusedComponent() {
        return (JComponent)this.groupIdTextField;
    }

    public void dispose() {
        WriteCommandAction.writeCommandAction((Project)this.project).run(() -> EventsTestSchemeGroupConfiguration.dispose$lambda$2(this));
        if (!this.validationRulesEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.validationRulesEditor);
        }
    }

    @NotNull
    public final List<ValidationInfo> validate() {
        return EventsTestSchemeGroupConfiguration.Companion.validateTestSchemeGroup(this.project, this.currentGroup, (JComponent)this.groupIdTextField, this.tempFile);
    }

    private static final void updatePanel$lambda$1(EventsTestSchemeGroupConfiguration this$0, GroupValidationTestRule $newGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.validationRulesEditor.getDocument().setText((CharSequence)$newGroup.getCustomRules());
    }

    private static final void dispose$lambda$2(EventsTestSchemeGroupConfiguration this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.tempFile.delete();
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static final /* synthetic */ JComponent access$getValidationRulesEditorComponent$p(EventsTestSchemeGroupConfiguration $this) {
        return $this.validationRulesEditorComponent;
    }

    public static final /* synthetic */ void access$setGenerateSchemeButton$p(EventsTestSchemeGroupConfiguration $this, JComponent jComponent) {
        $this.generateSchemeButton = jComponent;
    }

    public static final /* synthetic */ Map access$getEventsScheme$p(EventsTestSchemeGroupConfiguration $this) {
        return $this.eventsScheme;
    }

    public static final /* synthetic */ JBRadioButton access$getAllowAllEventsRadioButton$p(EventsTestSchemeGroupConfiguration $this) {
        return $this.allowAllEventsRadioButton;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EventsTestSchemeGroupConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"statistics.test.scheme.validation.rules.file");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FUS_TEST_SCHEME_COMMON_RULES_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\b\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J-\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J0\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002R'\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$Companion;", "", "()V", "FUS_TEST_SCHEME_COMMON_RULES_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$ProductionRules;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFUS_TEST_SCHEME_COMMON_RULES_KEY$intellij_platform_statistics_devkit", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createEventsScheme", "Ljava/util/HashMap;", "", "generatedScheme", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "createEventsScheme$intellij_platform_statistics_devkit", "createValidationRules", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;", "group", "isValidJson", "", "customRules", "validateCustomValidationRules", "Lcom/intellij/openapi/ui/ValidationInfo;", "project", "Lcom/intellij/openapi/project/Project;", "customRulesFile", "Lcom/intellij/psi/PsiFile;", "validateCustomValidationRules$intellij_platform_statistics_devkit", "validateTestSchemeGroup", "testSchemeGroup", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "groupIdTextField", "Ljavax/swing/JComponent;", "intellij.platform.statistics.devkit"})
    @SourceDebugExtension(value={"SMAP\nEventsTestSchemeGroupConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1549#2:357\n1620#2,3:358\n*S KotlinDebug\n*F\n+ 1 EventsTestSchemeGroupConfiguration.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$Companion\n*L\n296#1:357\n296#1:358,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ProductionRules> getFUS_TEST_SCHEME_COMMON_RULES_KEY$intellij_platform_statistics_devkit() {
            return FUS_TEST_SCHEME_COMMON_RULES_KEY;
        }

        @NotNull
        public final List<ValidationInfo> validateTestSchemeGroup(@NotNull Project project, @NotNull GroupValidationTestRule testSchemeGroup, @NotNull JComponent groupIdTextField) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)testSchemeGroup, (String)"testSchemeGroup");
            Intrinsics.checkNotNullParameter((Object)groupIdTextField, (String)"groupIdTextField");
            return this.validateTestSchemeGroup(project, testSchemeGroup, groupIdTextField, null);
        }

        private final List<ValidationInfo> validateTestSchemeGroup(Project project, GroupValidationTestRule testSchemeGroup, JComponent groupIdTextField, PsiFile customRulesFile) {
            String groupId = testSchemeGroup.getGroupId();
            List validationInfo = new ArrayList();
            if (((CharSequence)groupId).length() == 0) {
                validationInfo.add(new ValidationInfo(StatisticsBundle.message((String)"stats.specify.group.id", (Object[])new Object[0]), groupIdTextField));
            }
            if (testSchemeGroup.getUseCustomRules()) {
                validationInfo.addAll((Collection)this.validateCustomValidationRules$intellij_platform_statistics_devkit(project, testSchemeGroup.getCustomRules(), customRulesFile));
            }
            return validationInfo;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ValidationInfo> validateCustomValidationRules$intellij_platform_statistics_devkit(@NotNull Project project, @NotNull String customRules, @Nullable PsiFile customRulesFile) {
            void $this$mapTo$iv$iv;
            PsiFile psiFile;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)customRules, (String)"customRules");
            if (StringsKt.isBlank((CharSequence)customRules)) {
                return CollectionsKt.listOf((Object)new ValidationInfo(StatisticsBundle.message((String)"stats.unable.to.parse.validation.rules", (Object[])new Object[0])));
            }
            if (!this.isValidJson(customRules)) {
                return CollectionsKt.listOf((Object)new ValidationInfo(StatisticsBundle.message((String)"stats.unable.to.parse.validation.rules", (Object[])new Object[0])));
            }
            if (project == ProjectManager.getInstance().getDefaultProject()) {
                return CollectionsKt.emptyList();
            }
            if (customRulesFile != null) {
                psiFile = customRulesFile;
            } else {
                PsiFile psiFile2 = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)customRules);
                psiFile2.getVirtualFile().putUserData(EventsSchemeJsonSchemaProviderFactoryKt.getEVENTS_TEST_SCHEME_VALIDATION_RULES_KEY(), (Object)true);
                psiFile = psiFile2;
            }
            PsiFile file = psiFile;
            Map map = InspectionEngine.inspectEx(Collections.singletonList(new LocalInspectionToolWrapper((LocalInspectionTool)new JsonSchemaComplianceInspection())), (PsiFile)file, (TextRange)file.getTextRange(), (TextRange)file.getTextRange(), (boolean)true, (boolean)false, (boolean)true, (ProgressIndicator)((ProgressIndicator)new DaemonProgressIndicator()), (PairProcessor)PairProcessor.alwaysTrue());
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"inspectEx(...)");
            Map map2 = map;
            Iterable $this$map$iv = CollectionsKt.flatten((Iterable)map2.values());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void descriptor;
                ProblemDescriptor problemDescriptor = (ProblemDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ValidationInfo("Line " + (descriptor.getLineNumber() + 1) + ": " + descriptor.getDescriptionTemplate()));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final HashMap<String, String> createEventsScheme$intellij_platform_statistics_devkit(@NotNull List<GroupDescriptor> generatedScheme) {
            Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
            HashMap<String, String> eventsScheme = new HashMap<String, String>();
            for (GroupDescriptor group : generatedScheme) {
                EventGroupRemoteDescriptors.GroupRemoteRule validationRules = this.createValidationRules(group);
                if (validationRules == null) continue;
                ((Map)eventsScheme).put(group.getId(), SerializationHelper.INSTANCE.serialize((Object)validationRules));
            }
            return eventsScheme;
        }

        private final EventGroupRemoteDescriptors.GroupRemoteRule createValidationRules(GroupDescriptor group) {
            HashSet<String> eventIds = new HashSet<String>();
            HashMap eventData = new HashMap();
            Set events = group.getSchema();
            for (EventDescriptor event : events) {
                eventIds.add(event.getEvent());
                for (FieldDescriptor dataField : event.getFields()) {
                    Set validationRule = dataField.getValue();
                    Set validationRules = (Set)eventData.get(dataField.getPath());
                    if (validationRules == null) {
                        ((Map)eventData).put(dataField.getPath(), CollectionsKt.toHashSet((Iterable)validationRule));
                        continue;
                    }
                    validationRules.addAll(validationRule);
                }
            }
            if (eventIds.isEmpty() && eventData.isEmpty()) {
                return null;
            }
            EventGroupRemoteDescriptors.GroupRemoteRule rules = new EventGroupRemoteDescriptors.GroupRemoteRule();
            rules.event_id = eventIds;
            rules.event_data = eventData;
            return rules;
        }

        private final boolean isValidJson(String customRules) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                mapper.readTree(customRules);
                return true;
            }
            catch (JacksonException e) {
                return false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration$ProductionRules;", "", "rules", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;", "(Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors$GroupRemoteRule;)V", "regexps", "", "", "enums", "(Ljava/util/Set;Ljava/util/Set;)V", "getEnums", "()Ljava/util/Set;", "getRegexps", "intellij.platform.statistics.devkit"})
    public static final class ProductionRules {
        @NotNull
        private final Set<String> regexps;
        @NotNull
        private final Set<String> enums;

        public ProductionRules(@NotNull Set<String> regexps, @NotNull Set<String> enums) {
            Intrinsics.checkNotNullParameter(regexps, (String)"regexps");
            Intrinsics.checkNotNullParameter(enums, (String)"enums");
            this.regexps = regexps;
            this.enums = enums;
        }

        @NotNull
        public final Set<String> getRegexps() {
            return this.regexps;
        }

        @NotNull
        public final Set<String> getEnums() {
            return this.enums;
        }

        public ProductionRules(@Nullable EventGroupRemoteDescriptors.GroupRemoteRule rules) {
            Object object;
            Object object2 = rules;
            if (object2 == null || (object2 = ((EventGroupRemoteDescriptors.GroupRemoteRule)object2).regexps) == null || (object2 = object2.keySet()) == null) {
                object2 = SetsKt.emptySet();
            }
            if ((object = rules) == null || (object = ((EventGroupRemoteDescriptors.GroupRemoteRule)object).enums) == null || (object = object.keySet()) == null) {
                object = SetsKt.emptySet();
            }
            this((Set<String>)object2, (Set<String>)object);
        }
    }
}

