/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.codeStyleMapping.valueConversions;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.codeStyleMapping.util.Convertor;
import org.jetbrains.idea.eclipse.codeStyleMapping.util.UnexpectedIncomingValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/eclipse/codeStyleMapping/valueConversions/BracedCodeOnOneLineConvertor;", "Lorg/jetbrains/idea/eclipse/codeStyleMapping/util/Convertor;", "", "", "()V", "convertIncoming", "value", "(Ljava/lang/String;)Ljava/lang/Boolean;", "convertOutgoing", "intellij.eclipse"})
public final class BracedCodeOnOneLineConvertor
implements Convertor<String, Boolean> {
    @NotNull
    public static final BracedCodeOnOneLineConvertor INSTANCE = new BracedCodeOnOneLineConvertor();

    private BracedCodeOnOneLineConvertor() {
    }

    @Override
    @NotNull
    public Boolean convertIncoming(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return switch (string) {
            case "one_line_never" -> false;
            case "one_line_if_single_item", "one_line_always", "one_line_preserve", "one_line_if_empty" -> true;
            default -> throw new UnexpectedIncomingValue((Object)value);
        };
    }

    @Override
    @NotNull
    public String convertOutgoing(boolean value) {
        if (value) {
            return "one_line_preserve";
        }
        return "one_line_never";
    }
}

