/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.rd.DisposableEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentLog;
import com.jetbrains.rd.ide.document.DocumentLogRangeShifter;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.DocumentVersionHolder;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizerKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.ide.model.RdTextModificationKind;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EBM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020+2\u0006\u0010,\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020+2\u0006\u0010,\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002002\u0006\u00104\u001a\u000205H\u0002J\u0010\u00109\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0016J\u0018\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020'2\u0006\u0010,\u001a\u000200H\u0002J\b\u0010<\u001a\u00020=H\u0016J\u000e\u0010>\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0010\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010C\u001a\u00020+J\u000e\u0010D\u001a\u00020+2\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010#R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "Lcom/intellij/openapi/editor/ex/PrioritizedDocumentListener;", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "versionHolder", "Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;", "documentLog", "Lcom/jetbrains/rd/ide/document/DocumentLog;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "sendDocumentText", "", "forceWrite", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rd/ide/model/RdDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rd/ide/document/DocumentVersionHolder;Lcom/jetbrains/rd/ide/document/DocumentLog;Lcom/jetbrains/rd/ide/requests/PatchEngine;ZZ)V", "backendUpdateInProgressMarker", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getDocumentLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getDocumentLog", "()Lcom/jetbrains/rd/ide/document/DocumentLog;", "isReceivingChange", "()Z", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "()V", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "version", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "applyChange", "", "change", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "applyChangeCheckForce", "applyDocumentChange", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "applyResetDocumentChange", "Lcom/jetbrains/rd/ide/model/RdResetDocumentChange;", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "createRangeShifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "createRdDocumentChange", "documentChanged", "ensureDocumentVersion", "expectedVersion", "getPriority", "", "receiveDocumentChange", "resetVersion", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "sendDocumentChange", "sendInitialTextChange", "updateLastKnownVersion", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchEngineDocumentSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n*L\n1#1,289:1\n19#2,4:290\n19#2,4:294\n19#2,4:298\n31#3,2:302\n*S KotlinDebug\n*F\n+ 1 PatchEngineDocumentSynchronizer.kt\ncom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer\n*L\n64#1:290,4\n107#1:294,4\n119#1:298,4\n260#1:302,2\n*E\n"})
public class PatchEngineDocumentSynchronizer
implements PrioritizedDocumentListener,
DocumentSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime documentLifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDocumentModel modelDocument;
    @NotNull
    private final RdDocumentId documentId;
    @NotNull
    private final DocumentVersionHolder versionHolder;
    @NotNull
    private final DocumentLog documentLog;
    @NotNull
    private final PatchEngine engine;
    private final boolean sendDocumentText;
    private final boolean forceWrite;
    private boolean backendUpdateInProgressMarker;
    @NotNull
    private final Logger logger;
    private static int debugId;

    public PatchEngineDocumentSynchronizer(@NotNull Lifetime documentLifetime, @NotNull Document document, @NotNull RdDocumentModel modelDocument, @NotNull RdDocumentId documentId, @NotNull DocumentVersionHolder versionHolder, @NotNull DocumentLog documentLog, @NotNull PatchEngine engine, boolean sendDocumentText, boolean forceWrite) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)modelDocument), (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)versionHolder, (String)"versionHolder");
        Intrinsics.checkNotNullParameter((Object)documentLog, (String)"documentLog");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.documentLifetime = documentLifetime;
        this.document = document;
        this.modelDocument = modelDocument;
        this.documentId = documentId;
        this.versionHolder = versionHolder;
        this.documentLog = documentLog;
        this.engine = engine;
        this.sendDocumentText = sendDocumentText;
        this.forceWrite = forceWrite;
        String fileName = DocumentExKt.createLogCategory(this.getDocumentId());
        int n = debugId;
        debugId = n + 1;
        Logger logger = Logger.getInstance((String)("#com.jetbrains.rd.ide.document.Document#" + n + "(" + fileName + ")"));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.getDocument().addDocumentListener((DocumentListener)this, DisposableEx.createNestedDisposable$default(this.getDocumentLifetime(), null, 1, null));
    }

    @Override
    @NotNull
    public Lifetime getDocumentLifetime() {
        return this.documentLifetime;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    @Override
    @NotNull
    public RdDocumentId getDocumentId() {
        return this.documentId;
    }

    @NotNull
    protected final DocumentLog getDocumentLog() {
        return this.documentLog;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    @Override
    public boolean isReceivingChange() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.backendUpdateInProgressMarker;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        RdDocumentChangeBase rdDocumentChangeBase;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DocumentVersionHolder.incrementVersion$default(this.versionHolder, this.getDocument().getModificationStamp(), false, 2, null);
        if (this.backendUpdateInProgressMarker) {
            return;
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Document was changed from client side. Change event = " + PatchEngineDocumentSynchronizerKt.access$printSafeData(event));
        }
        if ((rdDocumentChangeBase = this.documentLog.getChange(this.versionHolder.getVersion())) == null) {
            RdDocumentChange rdDocumentChange;
            DocumentLog $this$documentChanged_u24lambda_u242 = this.documentLog;
            boolean bl = false;
            RdDocumentChange $this$documentChanged_u24lambda_u242_u24lambda_u241 = rdDocumentChange = this.createRdDocumentChange(event);
            boolean bl2 = false;
            this.documentLog.put(this.versionHolder.getVersion(), $this$documentChanged_u24lambda_u242_u24lambda_u241);
            rdDocumentChangeBase = rdDocumentChange;
        }
        RdDocumentChangeBase change = rdDocumentChangeBase;
        this.sendDocumentChange(change);
    }

    private final RdDocumentChange createRdDocumentChange(DocumentEvent event) {
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        RdTextModificationKind modificationSide = charSequence.length() == 0 && event instanceof DocumentEventImpl ? (((DocumentEventImpl)event).getInitialStartOffset() < ((DocumentEventImpl)event).getOffset() ? RdTextModificationKind.RightSide : (((DocumentEventImpl)event).getInitialStartOffset() + ((DocumentEventImpl)event).getInitialOldLength() > ((DocumentEventImpl)event).getOffset() ? RdTextModificationKind.LeftSide : RdTextModificationKind.NotSpecified)) : RdTextModificationKind.NotSpecified;
        return new RdDocumentChange(event.getOffset(), event.getMoveOffset(), ((Object)event.getNewFragment()).toString(), ((Object)event.getOldFragment()).toString(), modificationSide, event.getDocument().getTextLength() + event.getOldLength() - event.getNewLength(), this.sendDocumentText ? event.getDocument().getText() : null, event.isWholeTextReplaced(), this.getDocumentId());
    }

    public final void sendInitialTextChange() {
        boolean isIncremented = DocumentVersionHolder.incrementVersion$default(this.versionHolder, this.getDocument().getModificationStamp(), false, 2, null);
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        RdResetDocumentChange change = new RdResetDocumentChange(string, this.versionHolder.getVersion(), this.getDocumentId());
        if (isIncremented) {
            this.documentLog.put(this.versionHolder.getVersion(), change);
        }
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] sendInitialTextChange: send RdResetDocumentChange by engine. documentId=" + DocumentExKt.toDebugString(this.getDocumentId()) + ", newVersion=" + this.versionHolder.getVersion());
        }
        this.sendDocumentChange(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveDocumentChange(@NotNull RdDocumentChangeBase change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        try {
            this.backendUpdateInProgressMarker = true;
            if (change instanceof RdDocumentChange && this.getDocument().getTextLength() != ((RdDocumentChange)change).getOldDocumentLength()) {
                throw new IllegalStateException(("expected document length: " + ((RdDocumentChange)change).getOldDocumentLength() + ", but actual length: " + this.getDocument().getTextLength()).toString());
            }
            Logger $this$trace$iv = this.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Applying client document change: " + change);
            }
            ApplicationKt.getApplication().runWriteAction(() -> PatchEngineDocumentSynchronizer.receiveDocumentChange$lambda$6(this, change));
        }
        finally {
            this.backendUpdateInProgressMarker = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyChangeCheckForce(RdDocumentChangeBase change) {
        if (this.forceWrite && !this.getDocument().isWritable()) {
            this.getDocument().setReadOnly(false);
            try {
                this.applyChange(change);
            }
            finally {
                this.getDocument().setReadOnly(true);
            }
        } else {
            this.applyChange(change);
        }
    }

    private final void applyChange(RdDocumentChangeBase change) {
        RdDocumentVersion newVersion = DocumentVersionsKt.nextVersion(this.versionHolder.getVersion());
        this.documentLog.put(newVersion, change);
        RdDocumentChangeBase rdDocumentChangeBase = change;
        if (rdDocumentChangeBase instanceof RdResetDocumentChange) {
            this.applyResetDocumentChange((RdResetDocumentChange)change);
        } else if (rdDocumentChangeBase instanceof RdDocumentChange) {
            this.applyDocumentChange((RdDocumentChange)change);
            this.ensureDocumentVersion(newVersion, (RdDocumentChange)change);
        } else {
            this.logger.error((Throwable)new IllegalStateException("Unknown document change type: " + change));
        }
    }

    private final void applyResetDocumentChange(RdResetDocumentChange change) {
        this.getDocument().setText((CharSequence)change.getText());
        this.resetVersion(change.getVersion());
    }

    private final void applyDocumentChange(RdDocumentChange change) {
        int offset = change.getOffset();
        String oldText = change.getOldText();
        String newText = change.getNewText();
        if (Intrinsics.areEqual((Object)change.isWholeTextReplaced(), (Object)true)) {
            String initialNewText = this.getDocument().getText(new TextRange(0, offset)) + newText + this.getDocument().getText(new TextRange(offset + oldText.length(), this.getDocument().getTextLength()));
            this.getDocument().setText((CharSequence)initialNewText);
            return;
        }
        if (((CharSequence)oldText).length() == 0 && change.getModificationKind() == RdTextModificationKind.LeftSide) {
            int initialEnd = Math.min(this.getDocument().getTextLength(), offset + 1);
            String initialNewText = newText + this.getDocument().getText(new TextRange(offset, initialEnd));
            this.getDocument().replaceString(offset, initialEnd, (CharSequence)initialNewText);
            return;
        }
        if (((CharSequence)oldText).length() == 0 && change.getModificationKind() == RdTextModificationKind.RightSide) {
            int initialStart = Math.max(0, offset - 1);
            String initialNewText = this.getDocument().getText(new TextRange(initialStart, offset)) + newText;
            this.getDocument().replaceString(initialStart, offset, (CharSequence)initialNewText);
            return;
        }
        if (this.getDocument() instanceof DocumentImpl) {
            Document document = this.getDocument();
            Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.DocumentImpl");
            ((DocumentImpl)document).replaceString(offset, offset + oldText.length(), change.getMoveOffset(), (CharSequence)newText, LocalTimeCounter.currentTime(), false);
            return;
        }
        this.getDocument().replaceString(offset, offset + oldText.length(), (CharSequence)newText);
    }

    private final void ensureDocumentVersion(RdDocumentVersion expectedVersion, RdDocumentChange change) {
        if (Intrinsics.areEqual((Object)this.versionHolder.getVersion(), (Object)expectedVersion)) {
            return;
        }
        if (Intrinsics.areEqual((Object)DocumentVersionsKt.nextVersion(this.versionHolder.getVersion()), (Object)expectedVersion)) {
            this.logger.error((Throwable)new IllegalStateException("Document wasn't updated after applying document change. expectedVersion=" + expectedVersion + ", currentVersion=" + this.versionHolder.getVersion() + ", change=" + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + "."));
            this.versionHolder.incrementVersion(this.getDocument().getModificationStamp(), true);
            return;
        }
        this.logger.error((Throwable)new IllegalStateException("Unexpected document and versions state. expectedVersion=" + expectedVersion + ", currentVersion=" + this.versionHolder.getVersion() + ", change=" + PatchEngineDocumentSynchronizerKt.access$printSafeData(change) + "."));
    }

    public final void updateLastKnownVersion(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.documentLog.updateLastKnownVersion(version);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public int getPriority() {
        return 39;
    }

    @Override
    @NotNull
    public RdDocumentVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    @Override
    public void resetVersion(@NotNull AbstractDocumentVersion v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        RdDocumentVersion cfr_ignored_0 = (RdDocumentVersion)v;
        this.versionHolder.resetVersion((RdDocumentVersion)v, this.getDocument().getModificationStamp());
        this.documentLog.rollbackHistoryToVersion((RdDocumentVersion)v);
    }

    @Override
    @NotNull
    public IDocumentRangeShifter createRangeShifter() {
        return new DocumentLogRangeShifter(this.documentLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void sendDocumentChange(RdDocumentChangeBase change) {
        void $this$sendAccumulated$iv;
        PatchEngine patchEngine = this.engine;
        String description$iv = "PatchEngineDocumentSynchronizerKt.sendDocumentChange";
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated$iv, true, description$iv, null, 4, null));
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
            boolean bl = false;
            ChangeScope $this$sendDocumentChange_u24lambda_u247 = it$iv.getSession().getChangeScope();
            boolean bl2 = false;
            RdDocumentVersion oldVersion = this.versionHolder.getPreviousVersion();
            RdDocumentVersion newVersion = this.versionHolder.getVersion();
            if (!Intrinsics.areEqual((Object)oldVersion, (Object)newVersion)) {
                RdPatchDocumentVersion expectedVersion = new RdPatchDocumentVersion(oldVersion, change.getDocumentId());
                $this$sendDocumentChange_u24lambda_u247.pushExpected(expectedVersion);
                RdPatchDocumentVersion updatedVersion = new RdPatchDocumentVersion(newVersion, change.getDocumentId());
                $this$sendDocumentChange_u24lambda_u247.pushUpdated(updatedVersion);
                $this$sendDocumentChange_u24lambda_u247.pushChange(change);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void receiveDocumentChange$lambda$6$lambda$5(PatchEngineDocumentSynchronizer this$0, RdDocumentChangeBase $change) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$change, (String)"$change");
        this$0.applyChangeCheckForce($change);
    }

    private static final void receiveDocumentChange$lambda$6(PatchEngineDocumentSynchronizer this$0, RdDocumentChangeBase $change) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$change, (String)"$change");
        CommandProcessor instance = CommandProcessor.getInstance();
        if (instance.getCurrentCommand() != null) {
            this$0.applyChangeCheckForce($change);
        } else {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> PatchEngineDocumentSynchronizer.receiveDocumentChange$lambda$6$lambda$5(this$0, $change));
        }
        if ($change instanceof RdDocumentChange && ((RdDocumentChange)$change).getText() != null && !Intrinsics.areEqual((Object)this$0.getDocument().getText(), (Object)((RdDocumentChange)$change).getText())) {
            throw new IllegalStateException(("Not matched document text on version: " + this$0.versionHolder.getVersion().getValue()).toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer$Companion;", "", "()V", "debugId", "", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

