/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import groovy.lang.Closure;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolveExceptionContextualizer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultArtifactCollection;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.DefaultUnlockedConfiguration;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ProjectDependencyObservedListener;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;
import org.gradle.api.internal.artifacts.result.ResolutionResultInternal;
import org.gradle.api.internal.artifacts.transform.DefaultTransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributeContainerWithErrorMessage;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.WordUtils;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.WrapUtil;

public abstract class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator,
ResettableConfiguration {
    private final ConfigurationResolver resolver;
    private final DependencyMetaDataProvider metaDataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private DefaultDependencySet allDependencies;
    private DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final ProjectDependencyObservedListener dependencyObservedBroadcast;
    private final BuildOperationExecutor buildOperationExecutor;
    private final Instantiator instantiator;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private ResolutionStrategyInternal resolutionStrategy;
    private final FileCollectionFactory fileCollectionFactory;
    private final ResolveExceptionContextualizer exceptionContextualizer;
    private final Set<MutationValidator> childMutationValidators = Sets.newHashSet();
    private final MutationValidator parentMutationValidator = this::validateParentMutation;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final Path identityPath;
    private final Path projectPath;
    private final String name;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private Set<ExcludeRule> parsedExcludeRules;
    private final Object observationLock = new Object();
    private volatile ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private boolean dependenciesModified;
    private boolean canBeConsumed;
    private boolean canBeResolved;
    private boolean canBeDeclaredAgainst;
    private final boolean consumptionDeprecated;
    private final boolean resolutionDeprecated;
    private final boolean declarationDeprecated;
    private boolean usageCanBeMutated = true;
    private final ConfigurationRole roleAtCreation;
    private boolean canBeMutated = true;
    private AttributeContainerInternal configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final ImmutableAttributesFactory attributesFactory;
    private final ResolutionBackedFileCollection intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final Lazy<List<? extends DependencyMetadata>> syntheticDependencies = Lazy.unsafe().of(this::generateSyntheticDependencies);
    private final AtomicInteger copyCount = new AtomicInteger();
    private List<String> declarationAlternatives = ImmutableList.of();
    private List<String> resolutionAlternatives = ImmutableList.of();
    private final CalculatedModelValue<ResolveState> currentResolveState;
    private ConfigurationInternal consistentResolutionSource;
    private String consistentResolutionReason;
    private TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory;
    private final DefaultConfigurationFactory defaultConfigurationFactory;

    public DefaultConfiguration(DomainObjectContext domainObjectContext, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners, ProjectDependencyObservedListener dependencyObservedBroadcast, DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, DependencyLockingProvider dependencyLockingProvider, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, FileCollectionFactory fileCollectionFactory, BuildOperationExecutor buildOperationExecutor, Instantiator instantiator2, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, ImmutableAttributesFactory attributesFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, ResolveExceptionContextualizer exceptionContextualizer, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, DefaultConfigurationFactory defaultConfigurationFactory, TaskDependencyFactory taskDependencyFactory, ConfigurationRole roleAtCreation, boolean lockUsage) {
        super(taskDependencyFactory);
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.identityPath = domainObjectContext.identityPath(name);
        this.projectPath = domainObjectContext.projectPath(name);
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.metaDataProvider = metaDataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.dependencyResolutionListeners = dependencyResolutionListeners;
        this.dependencyObservedBroadcast = dependencyObservedBroadcast;
        this.buildOperationExecutor = buildOperationExecutor;
        this.instantiator = instantiator2;
        this.attributesFactory = attributesFactory;
        this.configurationAttributes = attributesFactory.mutable();
        this.domainObjectContext = domainObjectContext;
        this.intrinsicFiles = this.fileCollectionFromSpec(Specs.satisfyAll());
        this.exceptionContextualizer = exceptionContextualizer;
        this.resolvableDependencies = instantiator2.newInstance(ConfigurationResolvableDependencies.class, this);
        this.displayName = Describables.memoize(new ConfigurationDescription(this.identityPath));
        this.ownDependencies = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet(Describables.of(this.displayName, "dependencies"), this, this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet(Describables.of(this.displayName, "dependency constraints"), this, this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet(Describables.of(this.displayName, "artifacts"), this.ownArtifacts, fileCollectionFactory, taskDependencyFactory);
        this.outgoing = instantiator2.newInstance(DefaultConfigurationPublications.class, this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, instantiator2, artifactNotationParser, capabilityNotationParser, fileCollectionFactory, attributesFactory, domainObjectCollectionFactory, taskDependencyFactory);
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilder;
        this.currentResolveState = domainObjectContext.getModel().newCalculatedValue(ResolveState.NOT_RESOLVED);
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.canBeConsumed = roleAtCreation.isConsumable();
        this.canBeResolved = roleAtCreation.isResolvable();
        this.canBeDeclaredAgainst = roleAtCreation.isDeclarable();
        this.consumptionDeprecated = roleAtCreation.isConsumptionDeprecated();
        this.resolutionDeprecated = roleAtCreation.isResolutionDeprecated();
        this.declarationDeprecated = roleAtCreation.isDeclarationAgainstDeprecated();
        if (lockUsage) {
            this.preventUsageMutation();
        }
        this.roleAtCreation = roleAtCreation;
    }

    private static Action<Void> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Configuration.State getState() {
        ResolveState currentState = this.currentResolveState.get();
        ConfigurationInternal.InternalState resolvedState = currentState.state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (currentState.hasError()) {
                return Configuration.State.RESOLVED_WITH_FAILURES;
            }
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    @VisibleForTesting
    public ConfigurationInternal.InternalState getResolvedState() {
        this.warnOnInvalidInternalAPIUsage("getResolvedState()", ProperMethodUsage.RESOLVABLE);
        return this.currentResolveState.get().state;
    }

    @Override
    public Module getModule() {
        return this.metaDataProvider.getModule();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    @Override
    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    @Override
    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        for (Configuration configuration : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection(configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection(configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.removeCollection(configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    @Override
    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        for (Configuration configuration : extendsFrom) {
            if (configuration.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, configuration, configuration.getHierarchy()));
            }
            if (!this.extendsFrom.add(configuration)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection(configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection(configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.addCollection(configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Override
    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set<Configuration> result2 = WrapUtil.toLinkedSet(this);
        this.collectSuperConfigs(this, result2);
        return result2;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result2) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            result2.remove(superConfig);
            result2.add(superConfig);
            this.collectSuperConfigs(superConfig, result2);
        }
    }

    @Override
    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.warnOnDeprecatedUsage("defaultDependencies(Action)", ProperMethodUsage.DECLARABLE_AGAINST);
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions = this.defaultDependencyActions.add(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute((DependencySet)dependencies);
            }
        });
        return this;
    }

    @Override
    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.withDependencyActions = this.withDependencyActions.add(action);
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.defaultDependencyActions.execute(this.dependencies);
        this.withDependencyActions.execute(this.dependencies);
        this.defaultDependencyActions = ImmutableActionSet.empty();
        this.withDependencyActions = ImmutableActionSet.empty();
        for (Configuration superConfig : this.extendsFrom) {
            ((ConfigurationInternal)superConfig).runDependencyActions();
        }
    }

    @Override
    @Deprecated
    public Set<Configuration> getAll() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder)DeprecationLogger.deprecateAction("Calling the Configuration.getAll() method").withAdvice("Use the configurations container to access the set of configurations instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_configuration_get_all")).nagUser();
        return ImmutableSet.copyOf(this.configurationsProvider.getAll());
    }

    @Override
    public Set<File> resolve() {
        this.warnOnDeprecatedUsage("resolve()", ProperMethodUsage.RESOLVABLE);
        return this.getFiles();
    }

    @Override
    public Iterator<File> iterator() {
        return this.intrinsicFiles.iterator();
    }

    @Override
    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.intrinsicFiles.visitStructure(visitor);
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("configuration: " + this.identityPath);
    }

    @Override
    public boolean contains(File file) {
        this.warnOnInvalidInternalAPIUsage("contains(File)", ProperMethodUsage.RESOLVABLE);
        return this.intrinsicFiles.contains(file);
    }

    @Override
    public boolean isEmpty() {
        return this.intrinsicFiles.isEmpty();
    }

    @Override
    public Set<File> files(Dependency ... dependencies) {
        return this.fileCollection(dependencies).getFiles();
    }

    @Override
    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollection(dependencySpecClosure).getFiles();
    }

    @Override
    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollection(dependencySpec).getFiles();
    }

    @Override
    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        this.assertIsResolvable();
        this.warnOnDeprecatedUsage("fileCollection(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.fileCollectionFromSpec(dependencySpec);
    }

    private ResolutionBackedFileCollection fileCollectionFromSpec(Spec<? super Dependency> dependencySpec) {
        return new ResolutionBackedFileCollection(new SelectedArtifactsProvider(dependencySpec, this.configurationAttributes, Specs.satisfyAll(), false, false, new VisitedArtifactsSetProvider()), false, new DefaultResolutionHost(), this.taskDependencyFactory);
    }

    @Override
    public FileCollection fileCollection(Closure dependencySpecClosure) {
        this.warnOnDeprecatedUsage("fileCollection(Closure)", ProperMethodUsage.RESOLVABLE);
        return this.fileCollection(Specs.convertClosureToSpec(dependencySpecClosure));
    }

    @Override
    public FileCollection fileCollection(Dependency ... dependencies) {
        this.warnOnDeprecatedUsage("fileCollection(Dependency...)", ProperMethodUsage.RESOLVABLE);
        Set<Dependency> deps = WrapUtil.toLinkedSet(dependencies);
        return this.fileCollection(deps::contains);
    }

    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        this.markThisObserved(requestedState);
        this.markParentsObserved(requestedState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markThisObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) < 0) {
                this.observedState = requestedState;
            }
        }
    }

    @VisibleForTesting
    protected ConfigurationInternal.InternalState getObservedState() {
        return this.observedState;
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration : this.extendsFrom) {
            ((ConfigurationInternal)configuration).markAsObserved(requestedState);
        }
    }

    @Override
    public ResolvedConfiguration getResolvedConfiguration() {
        this.warnOnDeprecatedUsage("getResolvedConfiguration()", ProperMethodUsage.RESOLVABLE);
        return this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED).getResolvedConfiguration();
    }

    private ResolveState resolveToStateOrLater(ConfigurationInternal.InternalState requestedState) {
        this.assertIsResolvable();
        this.maybeEmitResolutionDeprecation();
        ResolveState currentState = this.currentResolveState.get();
        if (currentState.state.compareTo(requestedState) >= 0) {
            return currentState;
        }
        if (!this.domainObjectContext.getModel().hasMutableState()) {
            if (!this.workerThreadRegistry.isWorkerThread()) {
                throw new IllegalStateException("The configuration " + this.identityPath.toString() + " was resolved from a thread not managed by Gradle.");
            }
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour("Resolution of the configuration " + this.identityPath.toString() + " was attempted from a context different than the project context. Have a look at the documentation to understand why this is a problem and how it can be resolved.").willBecomeAnErrorInGradle9().withUserManual("viewing_debugging_dependencies", "sub:resolving-unsafe-configuration-resolution-errors")).nagUser();
            return this.domainObjectContext.getModel().fromMutableState(p -> this.resolveExclusively(requestedState));
        }
        return this.resolveExclusively(requestedState);
    }

    private ResolveState resolveExclusively(ConfigurationInternal.InternalState requestedState) {
        return this.currentResolveState.update(initial -> {
            ResolveState current = initial;
            if (requestedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                current = this.resolveGraphIfRequired(requestedState, current);
            }
            if (requestedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
                current = this.resolveArtifactsIfRequired(current);
            }
            return current;
        });
    }

    private ResolveState resolveGraphIfRequired(final ConfigurationInternal.InternalState requestedState, ResolveState currentState) {
        if (currentState.state == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED || currentState.state == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            if (this.dependenciesModified) {
                throw new InvalidUserDataException(String.format("Attempted to resolve %s that has been resolved previously.", this.getDisplayName()));
            }
            return currentState;
        }
        return this.buildOperationExecutor.call(new CallableBuildOperation<ResolveState>(){

            @Override
            public ResolveState call(BuildOperationContext context) {
                DefaultConfiguration.this.runDependencyActions();
                DefaultConfiguration.this.preventFromFurtherMutation();
                ResolvableDependenciesInternal incoming = (ResolvableDependenciesInternal)DefaultConfiguration.this.getIncoming();
                DefaultConfiguration.this.performPreResolveActions(incoming);
                ResolverResults results = DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this);
                DefaultConfiguration.this.dependenciesModified = false;
                ResolveState newState = new GraphResolved(results);
                DefaultConfiguration.this.currentResolveState.set(newState);
                DefaultConfiguration.this.markParentsObserved(requestedState);
                DefaultConfiguration.this.markReferencedProjectConfigurationsObserved(requestedState, results);
                if (!((ResolveState)newState).hasError()) {
                    ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve(incoming);
                    newState = (ResolveState)DefaultConfiguration.this.currentResolveState.get();
                }
                DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                if (DefaultConfiguration.this.resolutionStrategy != null) {
                    DefaultConfiguration.this.resolutionStrategy.discardStateRequiredForGraphResolution();
                }
                this.captureBuildOperationResult(context, results);
                return newState;
            }

            private void captureBuildOperationResult(BuildOperationContext context, ResolverResults results) {
                ResolveException failure = results.getFailure();
                if (failure != null) {
                    context.failed(failure);
                }
                ResolutionResult resolutionResult = results.getResolutionResult();
                context.setResult(ResolveConfigurationResolutionBuildOperationResult.create(resolutionResult, DefaultConfiguration.this.attributesFactory));
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                Path projectPath = DefaultConfiguration.this.domainObjectContext.getProjectPath();
                String projectPathString = null;
                if (!DefaultConfiguration.this.domainObjectContext.isScript() && projectPath != null) {
                    projectPathString = projectPath.getPath();
                }
                return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName).details(new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().getPath(), projectPathString, DefaultConfiguration.this.isVisible(), DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getRepositories()));
            }
        });
    }

    @Override
    public ConfigurationInternal getConsistentResolutionSource() {
        this.warnOnInvalidInternalAPIUsage("getConsistentResolutionSource()", ProperMethodUsage.RESOLVABLE);
        return this.consistentResolutionSource;
    }

    private Stream<DependencyConstraint> getConsistentResolutionConstraints() {
        if (this.consistentResolutionSource == null) {
            return Stream.empty();
        }
        this.assertThatConsistentResolutionIsPropertyConfigured();
        return this.consistentResolutionSource.getIncoming().getResolutionResult().getAllComponents().stream().map(this::registerConsistentResolutionConstraint).filter(Objects::nonNull);
    }

    private void assertThatConsistentResolutionIsPropertyConfigured() {
        if (!this.consistentResolutionSource.isCanBeResolved()) {
            throw new InvalidUserCodeException("You can't use " + this.consistentResolutionSource + " as a consistent resolution source for " + this + " because it isn't a resolvable configuration.");
        }
        this.assertNoDependencyResolutionConsistencyCycle();
    }

    private void assertNoDependencyResolutionConsistencyCycle() {
        LinkedHashSet sources = Sets.newLinkedHashSet();
        for (ConfigurationInternal src = this; src != null; src = src.getConsistentResolutionSource()) {
            if (sources.add(src)) continue;
            String cycle = sources.stream().map(Named::getName).collect(Collectors.joining(" -> ")) + " -> " + this.getName();
            throw new InvalidUserDataException("Cycle detected in consistent resolution sources: " + cycle);
        }
    }

    @Nullable
    private DependencyConstraint registerConsistentResolutionConstraint(ResolvedComponentResult result2) {
        if (result2.getId() instanceof ModuleComponentIdentifier) {
            ModuleVersionIdentifier moduleVersion = result2.getModuleVersion();
            DefaultDependencyConstraint constraint = DefaultDependencyConstraint.strictly(moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            constraint.because(this.consistentResolutionReason);
            return constraint;
        }
        return null;
    }

    private void performPreResolveActions(ResolvableDependencies incoming) {
        DependencyResolutionListener dependencyResolutionListener = this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(incoming);
        }
        finally {
            this.insideBeforeResolve = false;
        }
    }

    private void markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState requestedState, ResolverResults results) {
        ProjectInternal consumingProject = this.domainObjectContext.getProject();
        ProjectState consumingProjectState = consumingProject == null ? null : consumingProject.getOwner();
        for (ResolvedProjectConfiguration projectResult : results.getResolvedLocalComponents().getResolvedProjectConfigurations()) {
            ProjectState targetProjectState = this.projectStateRegistry.stateFor(projectResult.getId());
            this.dependencyObservedBroadcast.dependencyObserved(consumingProjectState, targetProjectState, requestedState, projectResult);
        }
    }

    private ResolveState resolveArtifactsIfRequired(ResolveState currentState) {
        if (currentState.state == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            return currentState;
        }
        if (currentState.state != ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new IllegalStateException("Cannot resolve artifacts before graph has been resolved.");
        }
        ResolverResults graphResults = currentState.getCachedResolverResults();
        ResolverResults artifactResults = this.resolver.resolveArtifacts(this, graphResults);
        return new ArtifactsResolved(artifactResults);
    }

    @Override
    public TransformUpstreamDependenciesResolverFactory getDependenciesResolverFactory() {
        this.warnOnInvalidInternalAPIUsage("getDependenciesResolverFactory()", ProperMethodUsage.RESOLVABLE);
        if (this.dependenciesResolverFactory == null) {
            this.dependenciesResolverFactory = new DefaultTransformUpstreamDependenciesResolverFactory(this.getIdentity(), new DefaultResolutionResultProvider(), this.domainObjectContext, this.calculatedValueContainerFactory, (attributes, filter) -> {
                ImmutableAttributes fullAttributes = this.attributesFactory.concat(this.configurationAttributes.asImmutable(), attributes);
                return new ResolutionBackedFileCollection(new SelectedArtifactsProvider(Specs.satisfyAll(), fullAttributes, filter, false, false, new VisitedArtifactsSetProvider()), false, new DefaultResolutionHost(), this.taskDependencyFactory);
            });
        }
        return this.dependenciesResolverFactory;
    }

    @Override
    public void resetResolutionState() {
        this.warnOnInvalidInternalAPIUsage("resetResolutionState()", ProperMethodUsage.RESOLVABLE);
        this.currentResolveState.set(ResolveState.NOT_RESOLVED);
    }

    private ResolverResults getResultsForBuildDependencies() {
        ResolveState currentState = this.currentResolveState.get();
        if (currentState.state == ConfigurationInternal.InternalState.UNRESOLVED) {
            throw new IllegalStateException("Cannot query results until resolution has happened.");
        }
        return currentState.getCachedResolverResults();
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        if (this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
            return this.resolveToStateOrLater(ConfigurationInternal.InternalState.GRAPH_RESOLVED).getCachedResolverResults();
        }
        ResolveState currentState = this.currentResolveState.update(initial -> {
            if (initial.state == ConfigurationInternal.InternalState.UNRESOLVED) {
                ResolverResults results = this.resolver.resolveBuildDependencies(this);
                this.markReferencedProjectConfigurationsObserved(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED, results);
                return new BuildDependenciesResolved(results);
            }
            return initial;
        });
        return currentState.getCachedResolverResults();
    }

    private ResolverResults getResultsForArtifacts() {
        ResolveState currentState = this.currentResolveState.get();
        if (currentState.state != ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            currentState = this.resolveExclusively(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
        }
        return currentState.getCachedResolverResults();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.assertIsResolvable();
        context.add(this.intrinsicFiles);
    }

    @Override
    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, this::getAllDependencies, this.taskDependencyFactory);
        }
        return new TasksFromDependentProjects(taskName, this.getName(), this.taskDependencyFactory);
    }

    @Override
    public DependencySet getDependencies() {
        return this.dependencies;
    }

    @Override
    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    @Override
    public boolean hasDependencies() {
        return !this.getAllDependencies().isEmpty();
    }

    @Override
    public int getEstimatedGraphSize() {
        int estimate = (int)(512.0 * Math.log(this.getAllDependencies().size()));
        return Math.max(10, estimate);
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.domainObjectCollectionFactory.newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencies.addCollection(configuration.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet(Describables.of(this.displayName, "all dependencies"), this, this.inheritedDependencies);
    }

    @Override
    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    @Override
    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection(configuration.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet(Describables.of(this.displayName, "all dependency constraints"), this, this.inheritedDependencyConstraints);
    }

    @Override
    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of(this.displayName, "all artifacts");
        if (!this.canBeMutated && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet(displayName, this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
            return;
        }
        if (this.canBeMutated) {
            this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection(allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet(displayName, this.inheritedArtifacts, this.fileCollectionFactory, this.taskDependencyFactory) : new DefaultPublishArtifactSet(displayName, this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet result2 = Sets.newLinkedHashSet();
        result2.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result2.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result2;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser<Object, ExcludeRule> parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = Sets.newLinkedHashSet();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add(parser.parseNotation(excludeRule));
            }
        }
    }

    public void setExcludeRules(Set<ExcludeRule> excludeRules) {
        this.warnOnInvalidInternalAPIUsage("setExcludeRules(Set)", ProperMethodUsage.DECLARABLE_AGAINST, ProperMethodUsage.RESOLVABLE);
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.clear();
        this.excludeRules.addAll(excludeRules);
    }

    @Override
    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Override
    @Deprecated
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    @Override
    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    @Override
    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        this.outgoing.collectVariants(visitor);
    }

    @Override
    public boolean isCanBeMutated() {
        return this.canBeMutated;
    }

    @Override
    public void preventFromFurtherMutation() {
        this.preventFromFurtherMutation(false);
    }

    @Override
    public List<? extends GradleException> preventFromFurtherMutationLenient() {
        return this.preventFromFurtherMutation(true);
    }

    private List<? extends GradleException> preventFromFurtherMutation(boolean lenient) {
        if (this.canBeMutated) {
            ImmutableAttributes delegatee = this.configurationAttributes.asImmutable();
            this.configurationAttributes = new ImmutableAttributeContainerWithErrorMessage(delegatee, this.displayName);
            this.outgoing.preventFromFurtherMutation();
            this.canBeMutated = false;
            this.preventUsageMutation();
            if (this.mustHaveUniqueAttributes(this) && !this.getAttributes().isEmpty()) {
                return this.ensureUniqueAttributes(lenient);
            }
        }
        return Collections.emptyList();
    }

    private List<? extends GradleException> ensureUniqueAttributes(boolean lenient) {
        Set<? extends ConfigurationInternal> all;
        Set<? extends ConfigurationInternal> set2 = all = this.configurationsProvider != null ? this.configurationsProvider.getAll() : null;
        if (all != null) {
            Collection<? extends Capability> allCapabilities = this.allCapabilitiesIncludingDefault(this);
            Predicate<ConfigurationInternal> isDuplicate = otherConfiguration -> this.hasSameCapabilitiesAs(allCapabilities, (ConfigurationInternal)otherConfiguration) && this.hasSameAttributesAs((ConfigurationInternal)otherConfiguration);
            List collisions = all.stream().filter((? super T c) -> c != this).filter(this::mustHaveUniqueAttributes).filter((? super T c) -> !c.isCanBeMutated()).filter(isDuplicate).map(ResolveContext::getDisplayName).collect(Collectors.toList());
            if (!collisions.isEmpty()) {
                DocumentedFailure.Builder builder = DocumentedFailure.builder();
                String advice = "Consider adding an additional attribute to one of the configurations to disambiguate them.";
                if (!lenient) {
                    advice = advice + "  Run the 'outgoingVariants' task for more details.";
                }
                GradleException gradleException = ((DocumentedFailure.Builder)builder.withSummary("Consumable configurations with identical capabilities within a project (other than the default configuration) must have unique attributes, but " + this.getDisplayName() + " and " + collisions + " contain identical attribute sets.").withAdvice(advice).withUserManual("upgrading_version_7", "unique_attribute_sets")).build();
                if (lenient) {
                    return Collections.singletonList(gradleException);
                }
                throw gradleException;
            }
        }
        return Collections.emptyList();
    }

    private boolean mustHaveUniqueAttributes(Configuration configuration) {
        return configuration.isCanBeConsumed() && !configuration.isCanBeResolved() && !"default".equals(configuration.getName());
    }

    private Collection<? extends Capability> allCapabilitiesIncludingDefault(Configuration conf) {
        if (conf.getOutgoing().getCapabilities().isEmpty()) {
            ProjectInternal project = this.domainObjectContext.getProject();
            if (project == null) {
                throw new IllegalStateException("Project is null for configuration '" + conf.getName() + "'.");
            }
            return Collections.singleton(new ProjectDerivedCapability(project));
        }
        return conf.getOutgoing().getCapabilities();
    }

    private boolean hasSameCapabilitiesAs(Collection<? extends Capability> allMyCapabilities, ConfigurationInternal other) {
        Collection<? extends Capability> allOtherCapabilities = this.allCapabilitiesIncludingDefault(other);
        return allMyCapabilities.size() == allOtherCapabilities.size() && allMyCapabilities.containsAll(allOtherCapabilities);
    }

    private boolean hasSameAttributesAs(ConfigurationInternal other) {
        return other.getAttributes().asMap().equals(this.getAttributes().asMap());
    }

    @Override
    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute(this.outgoing);
    }

    @Override
    public ConfigurationInternal copy() {
        this.warnOnDeprecatedUsage("copy()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(this.getDependencies(), this.getDependencyConstraints());
    }

    @Override
    public Configuration copyRecursive() {
        this.warnOnDeprecatedUsage("copyRecursive()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(this.getAllDependencies(), this.getAllDependencyConstraints());
    }

    @Override
    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        this.warnOnDeprecatedUsage("copy(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter(this.getDependencies(), dependencySpec), this.getDependencyConstraints());
    }

    @Override
    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        this.warnOnDeprecatedUsage("copyRecursive(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter(this.getAllDependencies(), dependencySpec), this.getAllDependencyConstraints());
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        boolean deprecateConsumption = !this.canBeConsumed || this.consumptionDeprecated;
        boolean deprecateResolution = !this.canBeResolved || this.resolutionDeprecated;
        boolean deprecateDeclarationAgainst = !this.canBeDeclaredAgainst || this.declarationDeprecated;
        DefaultConfigurationRole adjustedCurrentUsage = new DefaultConfigurationRole("adjusted current usage with deprecations", true, true, true, deprecateConsumption, deprecateResolution, deprecateDeclarationAgainst);
        DefaultConfiguration copiedConfiguration = this.newConfiguration(adjustedCurrentUsage);
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.declarationAlternatives = this.declarationAlternatives;
        copiedConfiguration.resolutionAlternatives = this.resolutionAlternatives;
        copiedConfiguration.getArtifacts().addAll(this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast(attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add(dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add(((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private DefaultConfiguration newConfiguration(ConfigurationRole role) {
        String newName = this.getNameWithCopySuffix();
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        RootComponentMetadataBuilder rootComponentMetadataBuilder = this.rootComponentMetadataBuilder.withConfigurationsProvider(configurationsProvider);
        Factory<ResolutionStrategyInternal> childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant(this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        DefaultUnlockedConfiguration copiedConfiguration = this.defaultConfigurationFactory.create(newName, configurationsProvider, childResolutionStrategy, rootComponentMetadataBuilder, role);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    @Override
    public Configuration copy(Closure dependencySpec) {
        return this.copy(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive(Specs.convertClosureToSpec(dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent() {
        this.warnOnInvalidInternalAPIUsage("toRootComponent()", ProperMethodUsage.RESOLVABLE);
        return this.rootComponentMetadataBuilder.toRootComponent(this.getName());
    }

    @Override
    public List<? extends DependencyMetadata> getSyntheticDependencies() {
        this.warnOnInvalidInternalAPIUsage("getSyntheticDependencies()", ProperMethodUsage.RESOLVABLE);
        return (List)this.syntheticDependencies.get();
    }

    private List<? extends DependencyMetadata> generateSyntheticDependencies() {
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(this.getModule());
        Stream<Object> dependencyLockingConstraintMetadata = Stream.empty();
        if (this.getResolutionStrategy().isDependencyLockingEnabled()) {
            DependencyLockingState dependencyLockingState = this.dependencyLockingProvider.loadLockState(this.name);
            boolean strict = dependencyLockingState.mustValidateLockState();
            dependencyLockingConstraintMetadata = dependencyLockingState.getLockedDependencies().stream().map(lockedDependency -> {
                String lockedVersion = lockedDependency.getVersion();
                DefaultMutableVersionConstraint versionConstraint = strict ? DefaultMutableVersionConstraint.withStrictVersion(lockedVersion) : DefaultMutableVersionConstraint.withVersion(lockedVersion);
                ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(lockedDependency.getGroup(), lockedDependency.getModule()), versionConstraint);
                return new LocalComponentDependencyMetadata(selector, ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, this.getLockReason(strict, lockedVersion));
            });
        }
        Stream<LocalComponentDependencyMetadata> consistentResolutionConstraintMetadata = this.getConsistentResolutionConstraints().map(dc -> {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dc.getGroup(), dc.getName()), dc.getVersionConstraint());
            return new LocalComponentDependencyMetadata(selector, ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, dc.getReason());
        });
        return (List)Stream.concat(dependencyLockingConstraintMetadata, consistentResolutionConstraintMetadata).collect(ImmutableList.toImmutableList());
    }

    private String getLockReason(boolean strict, String lockedVersion) {
        if (strict) {
            return "dependency was locked to version '" + lockedVersion + "'";
        }
        return "dependency was locked to version '" + lockedVersion + "' (update/lenient mode)";
    }

    @Override
    public Path getProjectPath() {
        return this.projectPath;
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public DomainObjectContext getDomainObjectContext() {
        return this.domainObjectContext;
    }

    @Override
    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure(closure, this.getResolutionStrategy());
        return this;
    }

    @Override
    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute(this.getResolutionStrategy());
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.preventIllegalParentMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        this.preventIllegalMutation(type);
        this.markAsModified(type);
        this.notifyChildren(type);
    }

    private void preventIllegalParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        ConfigurationInternal.InternalState resolvedState = this.currentResolveState.get().state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if (resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED && type == MutationValidator.MutationType.DEPENDENCIES) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
    }

    private void preventIllegalMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            this.assertIsDeclarable();
            return;
        }
        ConfigurationInternal.InternalState resolvedState = this.currentResolveState.get().state;
        if (resolvedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (resolvedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after task dependencies have been resolved", new Object[]{type, this.getDisplayName()}));
        }
        if ((this.observedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED || this.observedState == ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED) && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
        if (type == MutationValidator.MutationType.USAGE) {
            this.assertUsageIsMutable();
        }
    }

    private void markAsModified(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
            return;
        }
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.dependenciesModified = true;
    }

    private void notifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
    }

    private ConfigurationIdentity getIdentity() {
        String name = this.getName();
        String projectPath = this.domainObjectContext.getProjectPath() == null ? null : this.domainObjectContext.getProjectPath().toString();
        String buildPath = this.domainObjectContext.getBuildPath().toString();
        return new DefaultConfigurationIdentity(buildPath, projectPath, name);
    }

    private boolean isProperUsage(boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        for (ProperMethodUsage properUsage : properUsages) {
            if (!properUsage.isProperUsage(this, allowDeprecated)) continue;
            return true;
        }
        return false;
    }

    private void warnOnInvalidInternalAPIUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOnDeprecatedUsage(methodName, true, properUsages);
    }

    private void warnOnDeprecatedUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOnDeprecatedUsage(methodName, false, properUsages);
    }

    private void warnOnDeprecatedUsage(String methodName, boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        if (!this.isProperUsage(allowDeprecated, properUsages)) {
            String msgTemplate = "Calling configuration method '%s' is deprecated for configuration '%s', which has permitted usage(s):\n%s\nThis method is only meant to be called on configurations which allow the %susage(s): '%s'.";
            String currentUsageDesc = UsageDescriber.describeCurrentUsage(this);
            String properUsageDesc = ProperMethodUsage.summarizeProperUsage(properUsages);
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour(String.format(msgTemplate, methodName, this.getName(), currentUsageDesc, allowDeprecated ? "" : "(non-deprecated) ", properUsageDesc)).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_configuration_usage")).nagUser();
        }
    }

    private Optional<? extends RuntimeException> mapFailure(String type, Collection<Throwable> failures) {
        if (failures.isEmpty()) {
            return Optional.empty();
        }
        if (failures.size() == 1) {
            ResolveException resolveException = this.exceptionContextualizer.maybeContextualize(failures, this);
            if (resolveException != null) {
                return Optional.of(resolveException);
            }
            Throwable failure = failures.iterator().next();
            if (failure instanceof ResolveException) {
                resolveException = (ResolveException)failure;
                return Optional.of(this.exceptionContextualizer.contextualize(resolveException, this.getDisplayName()));
            }
        }
        return Optional.of(new DefaultLenientConfiguration.ArtifactResolveException(type, this.getIdentityPath().toString(), this.getDisplayName(), failures));
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    private void assertIsDeclarable() {
        if (!this.canBeDeclaredAgainst) {
            throw new IllegalStateException("Declaring dependencies for configuration '" + this.name + "' is not allowed as it is defined as 'canBeDeclared=false'.");
        }
    }

    @Override
    protected void assertCanCarryBuildDependencies() {
        this.assertIsResolvable();
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    @Override
    public Configuration attributes(Action<? super AttributeContainer> action) {
        this.warnOnDeprecatedUsage("attributes(Action)", ProperMethodUsage.CONSUMABLE, ProperMethodUsage.RESOLVABLE);
        action.execute(this.configurationAttributes);
        return this;
    }

    @Override
    public void preventUsageMutation() {
        this.usageCanBeMutated = false;
    }

    private void assertUsageIsMutable() {
        if (!this.usageCanBeMutated) {
            if (this.roleAtCreation != ConfigurationRoles.LEGACY) {
                throw new GradleException(String.format("Cannot change the allowed usage of %s, as it was locked upon creation to the role: '%s'.\nThis role permits the following usage:\n%s\nIdeally, each configuration should be used for a single purpose.", this.getDisplayName(), this.roleAtCreation.getName(), this.roleAtCreation.describeUsage()));
            }
            throw new GradleException(String.format("Cannot change the allowed usage of %s, as it has been locked.", this.getDisplayName()));
        }
    }

    private void maybeWarnOnChangingUsage(String usage, boolean current) {
        if (!this.isSpecialCaseOfChangingUsage(usage, current)) {
            String msgTemplate = "Allowed usage is changing for %s, %s. Ideally, usage should be fixed upon creation.";
            String changingUsage = usage + " was " + !current + " and is now " + current;
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour(String.format(msgTemplate, this.getDisplayName(), changingUsage)).withAdvice("Usage should be fixed upon creation.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
        }
    }

    private void maybeWarnOnRedundantUsageActivation(String usage, String method) {
        if (!this.isSpecialCaseOfRedundantUsageActivation()) {
            String msgTemplate = "The %s usage is already allowed on %s.";
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour(String.format(msgTemplate, usage, this.getDisplayName())).withAdvice(String.format("Remove the call to %s, it has no effect.", method))).willBeRemovedInGradle9().withUpgradeGuideSection(8, "redundant_configuration_usage_activation")).nagUser();
        }
    }

    private boolean isSpecialCaseOfChangingUsage(String usage, boolean current) {
        return this.isInitializing() || this.isDetachedConfiguration() || this.isInLegacyRole() || this.isPermittedConfigurationForUsageChange(usage, current);
    }

    private boolean isSpecialCaseOfRedundantUsageActivation() {
        return this.isInLegacyRole() || this.isDetachedConfiguration() || this.isPermittedConfigurationForRedundantActivation();
    }

    private boolean isInitializing() {
        return this.roleAtCreation == null;
    }

    private boolean isDetachedConfiguration() {
        return this.configurationsProvider instanceof DetachedConfigurationsProvider;
    }

    private boolean isInLegacyRole() {
        return this.roleAtCreation == ConfigurationRoles.LEGACY;
    }

    private boolean isPermittedConfigurationForUsageChange(String usage, boolean current) {
        return this.name.equals("apiElements") || this.name.equals("runtimeElements") && usage.equals("consumable") && !current;
    }

    private boolean isPermittedConfigurationForRedundantActivation() {
        return this.name.equals("runtimeClasspath") || this.name.equals("testFixturesRuntimeClasspath") || this.name.endsWith("testRuntimeClasspath") || this.name.endsWith("TestRuntimeClasspath");
    }

    @Override
    public boolean isDeprecatedForConsumption() {
        return this.consumptionDeprecated;
    }

    @Override
    public boolean isDeprecatedForResolution() {
        return this.resolutionDeprecated;
    }

    @Override
    public boolean isDeprecatedForDeclarationAgainst() {
        return this.declarationDeprecated;
    }

    @Override
    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    @Override
    public void setCanBeConsumed(boolean allowed) {
        if (this.canBeConsumed != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeConsumed = allowed;
            this.maybeWarnOnChangingUsage("consumable", allowed);
        } else if (this.canBeConsumed && allowed) {
            this.maybeWarnOnRedundantUsageActivation("consumable", "setCanBeConsumed(true)");
        }
    }

    @Override
    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    @Override
    public void setCanBeResolved(boolean allowed) {
        if (this.canBeResolved != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeResolved = allowed;
            this.maybeWarnOnChangingUsage("resolvable", allowed);
        } else if (this.canBeResolved && allowed) {
            this.maybeWarnOnRedundantUsageActivation("resolvable", "setCanBeResolved(true)");
        }
    }

    @Override
    public boolean isCanBeDeclared() {
        return this.canBeDeclaredAgainst;
    }

    @Override
    public void setCanBeDeclared(boolean allowed) {
        if (this.canBeDeclaredAgainst != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeDeclaredAgainst = allowed;
            this.maybeWarnOnChangingUsage("declarable", allowed);
        } else if (this.canBeDeclaredAgainst && allowed) {
            this.maybeWarnOnRedundantUsageActivation("declarable", "setCanBeDeclared(true)");
        }
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    @Override
    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    @Override
    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    @Override
    public void addDeclarationAlternatives(String ... alternativesForDeclaring) {
        this.declarationAlternatives = ImmutableList.builder().addAll(this.declarationAlternatives).addAll(Arrays.asList(alternativesForDeclaring)).build();
    }

    @Override
    public void addResolutionAlternatives(String ... alternativesForResolving) {
        this.resolutionAlternatives = ImmutableList.builder().addAll(this.resolutionAlternatives).addAll(Arrays.asList(alternativesForResolving)).build();
    }

    @Override
    public Configuration shouldResolveConsistentlyWith(Configuration versionsSource) {
        this.warnOnDeprecatedUsage("shouldResolveConsistentlyWith(Configuration)", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = (ConfigurationInternal)versionsSource;
        this.consistentResolutionReason = "version resolved in " + versionsSource + " by consistent resolution";
        return this;
    }

    @Override
    public Configuration disableConsistentResolution() {
        this.warnOnDeprecatedUsage("disableConsistentResolution()", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = null;
        this.consistentResolutionReason = null;
        return this;
    }

    @Override
    public ConfigurationRole getRoleAtCreation() {
        return this.roleAtCreation;
    }

    private DefaultArtifactCollection artifactCollection(AttributeContainerInternal attributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants, boolean selectFromAllVariants) {
        DefaultResolutionHost failureHandler = new DefaultResolutionHost();
        ResolutionBackedFileCollection files = new ResolutionBackedFileCollection(new SelectedArtifactsProvider(Specs.satisfyAll(), attributes, componentFilter, allowNoMatchingVariants, selectFromAllVariants, new VisitedArtifactsSetProvider()), lenient, failureHandler, this.taskDependencyFactory);
        return new DefaultArtifactCollection(files, lenient, failureHandler, this.calculatedValueContainerFactory);
    }

    private static enum ProperMethodUsage {
        CONSUMABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeConsumed();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForConsumption();
            }
        }
        ,
        RESOLVABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeResolved();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForResolution();
            }
        }
        ,
        DECLARABLE_AGAINST{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeDeclared();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForDeclarationAgainst();
            }
        };


        abstract boolean isAllowed(ConfigurationInternal var1);

        abstract boolean isDeprecated(ConfigurationInternal var1);

        boolean isProperUsage(ConfigurationInternal configuration, boolean allowDeprecated) {
            return this.isAllowed(configuration) && (allowDeprecated || !this.isDeprecated(configuration));
        }

        public static String buildProperName(ProperMethodUsage usage) {
            return WordUtils.capitalizeFully((String)usage.name().replace('_', ' '));
        }

        public static String summarizeProperUsage(ProperMethodUsage ... properUsages) {
            return Arrays.stream(properUsages).map(ProperMethodUsage::buildProperName).collect(Collectors.joining(", "));
        }
    }

    private class DefaultResolutionHost
    implements ResolutionHost {
        private DefaultResolutionHost() {
        }

        @Override
        public String getDisplayName() {
            return DefaultConfiguration.this.getDisplayName();
        }

        @Override
        public DisplayName displayName(String type) {
            return Describables.of(DefaultConfiguration.this, type);
        }

        @Override
        public Optional<? extends RuntimeException> mapFailure(String type, Collection<Throwable> failures) {
            return DefaultConfiguration.this.mapFailure(type, failures);
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    public static class ArtifactViewConfiguration
    implements ArtifactView.ViewConfiguration {
        private final ImmutableAttributesFactory attributesFactory;
        private final AttributeContainerInternal configurationAttributes;
        private AttributeContainerInternal viewAttributes;
        private Spec<? super ComponentIdentifier> componentFilter;
        private boolean lenient;
        private boolean reselectVariant;
        private boolean attributesUsed;

        public ArtifactViewConfiguration(ImmutableAttributesFactory attributesFactory, AttributeContainerInternal configurationAttributes) {
            this.attributesFactory = attributesFactory;
            this.configurationAttributes = configurationAttributes;
        }

        @Override
        public AttributeContainer getAttributes() {
            if (this.viewAttributes == null) {
                this.viewAttributes = this.reselectVariant ? this.attributesFactory.mutable() : this.attributesFactory.mutable(this.configurationAttributes);
                this.attributesUsed = true;
            }
            return this.viewAttributes;
        }

        @Override
        public ArtifactViewConfiguration attributes(Action<? super AttributeContainer> action) {
            action.execute(this.getAttributes());
            return this;
        }

        @Override
        public ArtifactViewConfiguration componentFilter(Spec<? super ComponentIdentifier> componentFilter) {
            this.assertComponentFilterUnset();
            this.componentFilter = componentFilter;
            return this;
        }

        @Override
        public boolean isLenient() {
            return this.lenient;
        }

        @Override
        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        @Override
        public ArtifactViewConfiguration lenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        @Override
        public ArtifactViewConfiguration withVariantReselection() {
            this.reselectVariant = true;
            return this;
        }

        private void assertComponentFilterUnset() {
            if (this.componentFilter != null) {
                throw new IllegalStateException("The component filter can only be set once before the view was computed");
            }
        }

        private Spec<? super ComponentIdentifier> lockComponentFilter() {
            if (this.componentFilter == null) {
                this.componentFilter = Specs.satisfyAll();
            }
            return this.componentFilter;
        }
    }

    public class ConfigurationResolvableDependencies
    implements ResolvableDependenciesInternal {
        @Override
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        @Override
        public String getPath() {
            return DefaultConfiguration.this.projectPath.getPath();
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.identityPath + "'";
        }

        @Override
        public FileCollection getFiles() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.intrinsicFiles;
        }

        @Override
        public DependencySet getDependencies() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencies();
        }

        @Override
        public DependencyConstraintSet getDependencyConstraints() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencyConstraints();
        }

        @Override
        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        @Override
        public void beforeResolve(Closure action) {
            this.beforeResolve(ConfigureUtil.configureUsing(action));
        }

        @Override
        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        @Override
        public void afterResolve(Closure action) {
            this.afterResolve(ConfigureUtil.configureUsing(action));
        }

        @Override
        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.assertIsResolvable();
            return new LenientResolutionResult(false);
        }

        @Override
        public ArtifactCollection getArtifacts() {
            return DefaultConfiguration.this.artifactCollection(DefaultConfiguration.this.configurationAttributes, Specs.satisfyAll(), false, false, false);
        }

        @Override
        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            ArtifactViewConfiguration config = this.createArtifactViewConfiguration();
            configAction.execute(config);
            return this.createArtifactView(config);
        }

        private ArtifactView createArtifactView(ArtifactViewConfiguration config) {
            AttributeContainerInternal viewAttributes = config.viewAttributes == null ? config.configurationAttributes : config.viewAttributes;
            boolean allowNoMatchingVariants = config.attributesUsed;
            return new ConfigurationArtifactView(viewAttributes, config.lockComponentFilter(), config.lenient, allowNoMatchingVariants, config.reselectVariant);
        }

        private ArtifactViewConfiguration createArtifactViewConfiguration() {
            return DefaultConfiguration.this.instantiator.newInstance(ArtifactViewConfiguration.class, DefaultConfiguration.this.attributesFactory, DefaultConfiguration.this.configurationAttributes);
        }

        @Override
        public AttributeContainer getAttributes() {
            return DefaultConfiguration.this.configurationAttributes;
        }

        @Override
        public ResolutionResult getLenientResolutionResult() {
            return new LenientResolutionResult(true);
        }

        private class LenientResolutionResult
        implements ResolutionResultInternal {
            private final boolean lenient;
            private volatile Throwable nonFatalFailure;
            private volatile ResolutionResult delegate;

            private LenientResolutionResult(boolean lenient) {
                this.lenient = lenient;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void resolve() {
                if (this.delegate == null) {
                    LenientResolutionResult lenientResolutionResult = this;
                    synchronized (lenientResolutionResult) {
                        if (this.delegate == null) {
                            ResolveState currentState = DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
                            this.delegate = currentState.getCachedResolverResults().getResolutionResult();
                            this.nonFatalFailure = currentState.getCachedResolverResults().getNonFatalFailure();
                            if (this.nonFatalFailure != null && !this.lenient) {
                                throw UncheckedException.throwAsUncheckedException(this.nonFatalFailure);
                            }
                        }
                    }
                }
            }

            @Override
            public ResolvedComponentResult getRoot() {
                this.resolve();
                return this.delegate.getRoot();
            }

            @Override
            public Provider<ResolvedComponentResult> getRootComponent() {
                return new DefaultProvider<ResolvedComponentResult>(this::getRoot);
            }

            @Override
            public Provider<Throwable> getNonFatalFailure() {
                return new DefaultProvider<Throwable>(() -> {
                    this.resolve();
                    return this.nonFatalFailure;
                });
            }

            @Override
            public Set<? extends DependencyResult> getAllDependencies() {
                this.resolve();
                return this.delegate.getAllDependencies();
            }

            @Override
            public void allDependencies(Action<? super DependencyResult> action) {
                this.resolve();
                this.delegate.allDependencies(action);
            }

            @Override
            public void allDependencies(Closure closure) {
                this.resolve();
                this.delegate.allDependencies(closure);
            }

            @Override
            public Set<ResolvedComponentResult> getAllComponents() {
                this.resolve();
                return this.delegate.getAllComponents();
            }

            @Override
            public void allComponents(Action<? super ResolvedComponentResult> action) {
                this.resolve();
                this.delegate.allComponents(action);
            }

            @Override
            public void allComponents(Closure closure) {
                this.resolve();
                this.delegate.allComponents(closure);
            }

            @Override
            public AttributeContainer getRequestedAttributes() {
                return this.delegate.getRequestedAttributes();
            }

            public int hashCode() {
                this.resolve();
                return this.delegate.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof LenientResolutionResult) {
                    this.resolve();
                    return this.delegate.equals(((LenientResolutionResult)obj).delegate);
                }
                return false;
            }

            public String toString() {
                return "lenient resolution result for " + this.delegate;
            }
        }

        private class ConfigurationArtifactView
        implements ArtifactView {
            private final AttributeContainerInternal viewAttributes;
            private final Spec<? super ComponentIdentifier> componentFilter;
            private final boolean lenient;
            private final boolean allowNoMatchingVariants;
            private final boolean selectFromAllVariants;

            ConfigurationArtifactView(AttributeContainerInternal viewAttributes, Spec<? super ComponentIdentifier> componentFilter, boolean lenient, boolean allowNoMatchingVariants, boolean selectFromAllVariants) {
                this.viewAttributes = viewAttributes;
                this.componentFilter = componentFilter;
                this.lenient = lenient;
                this.allowNoMatchingVariants = allowNoMatchingVariants;
                this.selectFromAllVariants = selectFromAllVariants;
            }

            @Override
            public AttributeContainer getAttributes() {
                return this.viewAttributes.asImmutable();
            }

            @Override
            public ArtifactCollection getArtifacts() {
                return DefaultConfiguration.this.artifactCollection(this.viewAttributes, this.componentFilter, this.lenient, this.allowNoMatchingVariants, this.selectFromAllVariants);
            }

            @Override
            public FileCollection getFiles() {
                return new ResolutionBackedFileCollection(new SelectedArtifactsProvider(Specs.satisfyAll(), this.viewAttributes, this.componentFilter, this.allowNoMatchingVariants, this.selectFromAllVariants, new VisitedArtifactsSetProvider()), this.lenient, new DefaultResolutionHost(), DefaultConfiguration.this.taskDependencyFactory);
            }
        }
    }

    private static class ArtifactsResolved
    extends WithResults {
        public ArtifactsResolved(ResolverResults results) {
            super(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED, results);
        }
    }

    private static class GraphResolved
    extends WithResults {
        public GraphResolved(ResolverResults cachedResolverResults) {
            super(ConfigurationInternal.InternalState.GRAPH_RESOLVED, cachedResolverResults);
        }
    }

    private static class BuildDependenciesResolved
    extends WithResults {
        public BuildDependenciesResolved(ResolverResults results) {
            super(ConfigurationInternal.InternalState.BUILD_DEPENDENCIES_RESOLVED, results);
        }
    }

    private static class WithResults
    extends ResolveState {
        final ResolverResults cachedResolverResults;

        WithResults(ConfigurationInternal.InternalState state, ResolverResults cachedResolverResults) {
            super(state);
            this.cachedResolverResults = cachedResolverResults;
        }

        @Override
        boolean hasError() {
            return this.cachedResolverResults.hasError();
        }

        @Override
        public ResolverResults getCachedResolverResults() {
            return this.cachedResolverResults;
        }

        @Override
        public ResolvedConfiguration getResolvedConfiguration() {
            return this.cachedResolverResults.getResolvedConfiguration();
        }
    }

    private static abstract class ResolveState {
        static final ResolveState NOT_RESOLVED = new ResolveState(ConfigurationInternal.InternalState.UNRESOLVED){

            @Override
            public ResolvedConfiguration getResolvedConfiguration() {
                throw new IllegalStateException();
            }

            @Override
            public ResolverResults getCachedResolverResults() {
                throw new IllegalStateException();
            }

            @Override
            public boolean hasError() {
                return false;
            }
        };
        final ConfigurationInternal.InternalState state;

        ResolveState(ConfigurationInternal.InternalState state) {
            this.state = state;
        }

        abstract boolean hasError();

        public abstract ResolvedConfiguration getResolvedConfiguration();

        public abstract ResolverResults getCachedResolverResults();
    }

    private static class SelectedArtifactsProvider
    implements ResolutionResultProvider<SelectedArtifactSet> {
        private final Spec<? super Dependency> dependencySpec;
        private final AttributeContainerInternal viewAttributes;
        private final Spec<? super ComponentIdentifier> componentSpec;
        private final boolean allowNoMatchingVariants;
        private final boolean selectFromAllVariants;
        private final ResolutionResultProvider<VisitedArtifactSet> resultProvider;

        public SelectedArtifactsProvider(Spec<? super Dependency> dependencySpec, AttributeContainerInternal viewAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean allowNoMatchingVariants, boolean selectFromAllVariants, ResolutionResultProvider<VisitedArtifactSet> resultProvider) {
            this.dependencySpec = dependencySpec;
            this.viewAttributes = viewAttributes;
            this.componentSpec = componentSpec;
            this.allowNoMatchingVariants = allowNoMatchingVariants;
            this.selectFromAllVariants = selectFromAllVariants;
            this.resultProvider = resultProvider;
        }

        @Override
        public SelectedArtifactSet getTaskDependencyValue() {
            return this.resultProvider.getTaskDependencyValue().select(this.dependencySpec, this.viewAttributes.asImmutable(), this.componentSpec, this.allowNoMatchingVariants, this.selectFromAllVariants);
        }

        @Override
        public SelectedArtifactSet getValue() {
            return this.resultProvider.getValue().select(this.dependencySpec, this.viewAttributes.asImmutable(), this.componentSpec, this.allowNoMatchingVariants, this.selectFromAllVariants);
        }
    }

    private class VisitedArtifactsSetProvider
    implements ResolutionResultProvider<VisitedArtifactSet> {
        private VisitedArtifactsSetProvider() {
        }

        @Override
        public VisitedArtifactSet getTaskDependencyValue() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired().getVisitedArtifacts();
        }

        @Override
        public VisitedArtifactSet getValue() {
            DefaultConfiguration.this.assertIsResolvable();
            ResolveState currentState = DefaultConfiguration.this.resolveToStateOrLater(ConfigurationInternal.InternalState.ARTIFACTS_RESOLVED);
            return currentState.getCachedResolverResults().getVisitedArtifacts();
        }
    }

    private class DefaultResolutionResultProvider
    implements ResolutionResultProvider<ResolutionResult> {
        private DefaultResolutionResultProvider() {
        }

        @Override
        public ResolutionResult getTaskDependencyValue() {
            return DefaultConfiguration.this.getResultsForBuildDependencies().getResolutionResult();
        }

        @Override
        public ResolutionResult getValue() {
            return DefaultConfiguration.this.getResultsForArtifacts().getResolutionResult();
        }
    }

    private static class DefaultConfigurationIdentity
    implements ConfigurationIdentity {
        private final String buildPath;
        private final String projectPath;
        private final String name;

        public DefaultConfigurationIdentity(String buildPath, @Nullable String projectPath, String name) {
            this.buildPath = buildPath;
            this.projectPath = projectPath;
            this.name = name;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath;
        }

        @Override
        @Nullable
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            Path path = Path.path(this.buildPath);
            if (this.projectPath != null) {
                path = path.append(Path.path(this.projectPath));
            }
            path = path.child(this.name);
            return "Configuration '" + path.toString() + "'";
        }
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        @Override
        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }
}

