/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFilesCollectingVisitor;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public class DefaultResolvedConfiguration
implements ResolvedConfiguration {
    private final DefaultLenientConfiguration configuration;

    public DefaultResolvedConfiguration(DefaultLenientConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean hasError() {
        return this.configuration.hasError();
    }

    @Override
    public void rethrowFailure() throws ResolveException {
        this.configuration.rethrowFailure();
    }

    @Override
    public LenientConfiguration getLenientConfiguration() {
        return this.configuration;
    }

    @Override
    public Set<File> getFiles() throws ResolveException {
        return this.getFiles(Specs.satisfyAll());
    }

    @Override
    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
        ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor();
        this.configuration.select(dependencySpec).visitArtifacts(visitor, false);
        Collection<Throwable> failures = visitor.getFailures();
        if (!failures.isEmpty()) {
            throw new DefaultLenientConfiguration.ArtifactResolveException("files", this.configuration.getResolveContext().getIdentityPath().toString(), this.configuration.getResolveContext().getDisplayName(), failures);
        }
        return visitor.getFiles();
    }

    @Override
    public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
        this.rethrowFailure();
        return this.configuration.getFirstLevelModuleDependencies();
    }

    @Override
    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
        this.rethrowFailure();
        return this.configuration.getFirstLevelModuleDependencies(dependencySpec);
    }

    @Override
    public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
        this.rethrowFailure();
        ArtifactCollectingVisitor visitor = new ArtifactCollectingVisitor();
        this.configuration.select().visitArtifacts(visitor, false);
        return visitor.getArtifacts();
    }
}

