/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.descriptor;

import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public abstract class UrlRepositoryDescriptor
extends RepositoryDescriptor {
    public final URI url;
    public final ImmutableList<String> metadataSources;
    public final boolean authenticated;
    public final ImmutableList<String> authenticationSchemes;

    protected UrlRepositoryDescriptor(String id, String name, URI url, ImmutableList<String> metadataSources, boolean authenticated, ImmutableList<String> authenticationSchemes) {
        super(id, name);
        this.url = url;
        this.metadataSources = metadataSources;
        this.authenticated = authenticated;
        this.authenticationSchemes = authenticationSchemes;
    }

    public abstract ImmutableList<ResourcePattern> getMetadataResources();

    public abstract ImmutableList<ResourcePattern> getArtifactResources();

    @Override
    protected void addProperties(ImmutableSortedMap.Builder<String, Object> builder) {
        if (this.url != null) {
            builder.put((Object)Property.URL.name(), (Object)this.url);
        }
        builder.put((Object)Property.METADATA_SOURCES.name(), this.metadataSources);
        builder.put((Object)Property.AUTHENTICATED.name(), (Object)this.authenticated);
        builder.put((Object)Property.AUTHENTICATION_SCHEMES.name(), this.authenticationSchemes);
    }

    static abstract class Builder<T extends Builder<T>> {
        private static final StringInterner REPOSITORY_ID_INTERNER = new StringInterner();
        final String name;
        final URI url;
        ImmutableList<String> metadataSources;
        Boolean authenticated;
        ImmutableList<String> authenticationSchemes;

        Builder(String name, URI url) {
            this.name = name;
            this.url = url;
        }

        protected T self() {
            return (T)this;
        }

        public T setMetadataSources(List<String> metadataSources) {
            this.metadataSources = ImmutableList.copyOf(metadataSources);
            return this.self();
        }

        public T setAuthenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return this.self();
        }

        public T setAuthenticationSchemes(List<String> authenticationSchemes) {
            this.authenticationSchemes = ImmutableList.copyOf(authenticationSchemes);
            return this.self();
        }

        protected String calculateId(Class<? extends ExternalResourceResolver<?>> implementation, List<ResourcePattern> metadataResources, List<ResourcePattern> artifactResources, List<String> metadataSources, Consumer<Hasher> additionalInputs) {
            Hasher cacheHasher = Hashing.newHasher();
            cacheHasher.putString(implementation.getName());
            cacheHasher.putInt(metadataResources.size());
            for (ResourcePattern ivyPattern : metadataResources) {
                cacheHasher.putString(ivyPattern.getPattern());
            }
            cacheHasher.putInt(artifactResources.size());
            for (ResourcePattern artifactPattern : artifactResources) {
                cacheHasher.putString(artifactPattern.getPattern());
            }
            cacheHasher.putInt(metadataResources.size());
            for (String source : metadataSources) {
                cacheHasher.putString(source);
            }
            additionalInputs.accept(cacheHasher);
            return REPOSITORY_ID_INTERNER.intern(cacheHasher.hash().toString());
        }
    }

    public static enum Property {
        URL,
        METADATA_SOURCES,
        AUTHENTICATED,
        AUTHENTICATION_SCHEMES;

    }
}

