/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.internal.Cast;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public interface ValueSupplier {
    public ValueProducer getProducer();

    public boolean calculatePresence(ValueConsumer var1);

    public static class ChangingExecutionTimeValue<T>
    extends ExecutionTimeValue<T> {
        private final ProviderInternal<T> provider;

        private ChangingExecutionTimeValue(ProviderInternal<T> provider) {
            this.provider = provider;
        }

        public String toString() {
            return String.format("changing(%s)", this.provider);
        }

        @Override
        public boolean isChangingValue() {
            return true;
        }

        @Override
        public boolean hasChangingContent() {
            return true;
        }

        @Override
        public ProviderInternal<T> getChangingValue() {
            return this.provider;
        }

        @Override
        public ProviderInternal<T> toProvider() {
            return this.provider;
        }

        @Override
        public ExecutionTimeValue<T> withChangingContent() {
            return this;
        }

        @Override
        public ExecutionTimeValue<T> withSideEffect(@Nullable SideEffect<? super T> sideEffect) {
            if (sideEffect == null) {
                return this;
            }
            return new ChangingExecutionTimeValue<T>(this.provider.withSideEffect(sideEffect));
        }
    }

    public static class FixedExecutionTimeValue<T>
    extends ExecutionTimeValue<T> {
        private final T value;
        private final boolean changingContent;
        private final SideEffect<? super T> sideEffect;

        private FixedExecutionTimeValue(T value, boolean changingContent, @Nullable SideEffect<? super T> sideEffect) {
            this.value = value;
            this.changingContent = changingContent;
            this.sideEffect = sideEffect;
        }

        public String toString() {
            return String.format("fixed(%s)", this.value);
        }

        @Override
        public boolean hasFixedValue() {
            return true;
        }

        @Override
        public boolean hasChangingContent() {
            return this.changingContent;
        }

        @Override
        public T getFixedValue() {
            return this.value;
        }

        @Override
        @Nullable
        public SideEffect<? super T> getSideEffect() {
            return this.sideEffect;
        }

        @Override
        public Value<T> toValue() {
            return this.sideEffect == null ? Value.of(this.value) : Value.withSideEffect(this.value, this.sideEffect);
        }

        @Override
        public ProviderInternal<T> toProvider() {
            ProviderInternal<Object> provider = this.changingContent ? new Providers.FixedValueWithChangingContentProvider<T>(this.value) : Providers.of(this.value);
            return this.sideEffect == null ? provider : provider.withSideEffect(this.sideEffect);
        }

        @Override
        public ExecutionTimeValue<T> withChangingContent() {
            return new FixedExecutionTimeValue<T>(this.value, true, this.sideEffect);
        }

        @Override
        public ExecutionTimeValue<T> withSideEffect(@Nullable SideEffect<? super T> sideEffect) {
            if (sideEffect == null) {
                return this;
            }
            if (this.sideEffect == null) {
                return new FixedExecutionTimeValue<T>(this.value, this.changingContent, sideEffect);
            }
            return new FixedExecutionTimeValue<T>(this.value, this.changingContent, SideEffect.composite(this.sideEffect, sideEffect));
        }
    }

    public static class MissingExecutionTimeValue
    extends ExecutionTimeValue<Object> {
        public String toString() {
            return "missing";
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public ProviderInternal<Object> toProvider() {
            return Providers.notDefined();
        }

        @Override
        public ExecutionTimeValue<Object> withChangingContent() {
            return this;
        }

        @Override
        public Value<Object> toValue() {
            return Value.missing();
        }

        @Override
        public ExecutionTimeValue<Object> withSideEffect(@Nullable SideEffect<? super Object> sideEffect) {
            return this;
        }
    }

    public static abstract class ExecutionTimeValue<T> {
        private static final MissingExecutionTimeValue MISSING = new MissingExecutionTimeValue();

        public boolean isMissing() {
            return false;
        }

        public boolean hasFixedValue() {
            return false;
        }

        public boolean isChangingValue() {
            return false;
        }

        public boolean hasChangingContent() {
            return false;
        }

        public T getFixedValue() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public ProviderInternal<T> getChangingValue() throws IllegalStateException {
            throw new IllegalStateException();
        }

        @Nullable
        public SideEffect<? super T> getSideEffect() throws IllegalStateException {
            return null;
        }

        public Value<T> toValue() throws IllegalStateException {
            throw new IllegalStateException();
        }

        public abstract ProviderInternal<T> toProvider();

        public abstract ExecutionTimeValue<T> withChangingContent();

        public abstract ExecutionTimeValue<T> withSideEffect(@Nullable SideEffect<? super T> var1);

        public static <T> ExecutionTimeValue<T> missing() {
            return (ExecutionTimeValue)Cast.uncheckedCast(MISSING);
        }

        public static <T> ExecutionTimeValue<T> fixedValue(T value) {
            assert (value != null);
            return new FixedExecutionTimeValue(value, false, null);
        }

        public static <T> ExecutionTimeValue<T> ofNullable(@Nullable T value) {
            if (value == null) {
                return ExecutionTimeValue.missing();
            }
            return ExecutionTimeValue.fixedValue(value);
        }

        public static <T> ExecutionTimeValue<T> value(Value<T> value) {
            if (value.isMissing()) {
                return ExecutionTimeValue.missing();
            }
            return ExecutionTimeValue.fixedValue(value.getWithoutSideEffect()).withSideEffect(value.getSideEffect());
        }

        public static <T> ExecutionTimeValue<T> changingValue(ProviderInternal<T> provider) {
            return new ChangingExecutionTimeValue(provider);
        }
    }

    public static class Missing<T>
    implements Value<T> {
        private final List<DisplayName> path;

        private Missing() {
            this.path = ImmutableList.of();
        }

        private Missing(List<DisplayName> path) {
            this.path = path;
        }

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        @Nullable
        public SideEffect<? super T> getSideEffect() {
            return null;
        }

        @Override
        public T get() throws IllegalStateException {
            throw new IllegalStateException();
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        public T orElse(T defaultValue) {
            return defaultValue;
        }

        @Override
        public T getWithoutSideEffect() throws IllegalStateException {
            return this.get();
        }

        @Override
        public <R> Value<R> transform(Transformer<? extends R, ? super T> transformer) {
            return this.asType();
        }

        @Override
        public Value<T> withSideEffect(@Nullable SideEffect<? super T> sideEffect) {
            return this;
        }

        @Override
        public List<DisplayName> getPathToOrigin() {
            return this.path;
        }

        @Override
        public <S> Value<S> asType() {
            return (Value)Cast.uncheckedCast(this);
        }

        @Override
        public Value<T> pushWhenMissing(@Nullable DisplayName displayName) {
            if (displayName == null) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.path.size() + 1));
            builder.add((Object)displayName);
            builder.addAll(this.path);
            return new Missing<T>((List<DisplayName>)builder.build());
        }

        @Override
        public Value<T> addPathsFrom(Value<?> rightValue) {
            if (this.path.isEmpty()) {
                return rightValue.asType();
            }
            Missing other = (Missing)rightValue;
            if (other.path.isEmpty()) {
                return this;
            }
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.path.size() + other.path.size()));
            builder.addAll(this.path);
            builder.addAll(other.path);
            return new Missing<T>((List<DisplayName>)builder.build());
        }

        public String toString() {
            return this.path.isEmpty() ? "missing" : String.format("missing(path=%s)", this.path);
        }
    }

    public static class Present<T>
    implements Value<T> {
        private final T result;
        private final SideEffect<? super T> sideEffect;

        private Present(T result2) {
            this.result = result2;
            this.sideEffect = null;
        }

        private Present(T result2, @Nullable SideEffect<? super T> sideEffect) {
            this.result = result2;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        @Override
        public T get() throws IllegalStateException {
            this.runSideEffect();
            return this.result;
        }

        @Override
        public T orNull() {
            return this.get();
        }

        @Override
        public T orElse(T defaultValue) {
            return this.get();
        }

        @Override
        public T getWithoutSideEffect() throws IllegalStateException {
            return this.result;
        }

        @Override
        public <R> Value<R> transform(Transformer<? extends R, ? super T> transformer) {
            R transformResult = transformer.transform(this.result);
            if (transformResult == null || this.sideEffect == null) {
                return Value.ofNullable(transformResult);
            }
            return new Present<R>(transformResult, SideEffect.fixed(this.result, this.sideEffect));
        }

        @Override
        public Value<T> withSideEffect(@Nullable SideEffect<? super T> sideEffect) {
            if (sideEffect == null) {
                return this;
            }
            SideEffect<? super T> composedSideEffect = this.sideEffect == null ? sideEffect : SideEffect.composite(this.sideEffect, sideEffect);
            return new Present<T>(this.result, composedSideEffect);
        }

        @Override
        public Value<T> pushWhenMissing(@Nullable DisplayName displayName) {
            return this;
        }

        @Override
        @Nullable
        public SideEffect<? super T> getSideEffect() {
            return this.sideEffect;
        }

        @Override
        public <S> Value<S> asType() {
            throw new IllegalStateException();
        }

        @Override
        public List<DisplayName> getPathToOrigin() {
            throw new IllegalStateException();
        }

        @Override
        public Value<T> addPathsFrom(Value<?> rightValue) {
            throw new IllegalStateException();
        }

        private void runSideEffect() {
            if (this.sideEffect != null) {
                this.sideEffect.execute(this.result);
            }
        }

        public String toString() {
            return this.sideEffect == null ? String.format("value(%s)", this.result) : String.format("valueWithSideEffect(%s, %s)", this.result, this.sideEffect);
        }
    }

    public static interface Value<T> {
        public static final Value<Object> MISSING = new Missing<Object>();
        public static final Value<Void> SUCCESS = new Present<Void>((Object)null);

        public static <T> Value<T> ofNullable(@Nullable T value) {
            if (value == null) {
                return MISSING.asType();
            }
            return new Present((Object)value);
        }

        public static <T> Value<T> missing() {
            return MISSING.asType();
        }

        public static <T> Value<T> of(T value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            return new Present((Object)value);
        }

        public static Value<Void> present() {
            return SUCCESS;
        }

        public static <T> Value<T> withSideEffect(T value, SideEffect<? super T> sideEffect) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            return new Present(value, sideEffect);
        }

        public T get() throws IllegalStateException;

        @Nullable
        public T orNull();

        public T orElse(T var1);

        public T getWithoutSideEffect() throws IllegalStateException;

        public <R> Value<R> transform(Transformer<? extends R, ? super T> var1);

        public Value<T> withSideEffect(@Nullable SideEffect<? super T> var1);

        public List<DisplayName> getPathToOrigin();

        public boolean isMissing();

        @Nullable
        public SideEffect<? super T> getSideEffect();

        public <S> Value<S> asType();

        public Value<T> pushWhenMissing(@Nullable DisplayName var1);

        public Value<T> addPathsFrom(Value<?> var1);
    }

    public static class SideEffectBuilder<T> {
        List<SideEffect<T>> sideEffects = new ArrayList<SideEffect<T>>();

        void add(@Nullable SideEffect<? super T> sideEffect) {
            if (sideEffect == null) {
                return;
            }
            this.sideEffects.add((SideEffect)Cast.uncheckedCast(sideEffect));
        }

        @Nullable
        public SideEffect<T> build() {
            return this.sideEffects.isEmpty() ? null : SideEffect.composite(this.sideEffects);
        }
    }

    public static class CompositeSideEffect<T>
    implements SideEffect<T> {
        private final List<SideEffect<? super T>> sideEffects;

        @Nullable
        private static <T> SideEffect<T> of(Iterable<SideEffect<T>> sideEffects) {
            ArrayList<SideEffect<T>> flatSideEffects = new ArrayList<SideEffect<T>>();
            for (SideEffect<T> sideEffect : sideEffects) {
                if (sideEffect == null) continue;
                if (sideEffect instanceof CompositeSideEffect) {
                    CompositeSideEffect compositeSideEffect = (CompositeSideEffect)Cast.uncheckedNonnullCast(sideEffect);
                    flatSideEffects.addAll(compositeSideEffect.sideEffects);
                    continue;
                }
                flatSideEffects.add(sideEffect);
            }
            if (flatSideEffects.isEmpty()) {
                return null;
            }
            if (flatSideEffects.size() == 1) {
                return (SideEffect)Cast.uncheckedNonnullCast(flatSideEffects.get(0));
            }
            return new CompositeSideEffect<T>(flatSideEffects);
        }

        private CompositeSideEffect(Iterable<SideEffect<? super T>> sideEffects) {
            this.sideEffects = ImmutableList.copyOf(sideEffects);
        }

        @Override
        public void execute(T t) {
            for (SideEffect<T> sideEffect : this.sideEffects) {
                sideEffect.execute(t);
            }
        }

        public String toString() {
            return "composite(" + this.sideEffects + ")";
        }
    }

    public static class FixedSideEffect<T, A>
    implements SideEffect<T> {
        private final A value;
        private final SideEffect<? super A> sideEffect;

        @Nullable
        private static <T, A> FixedSideEffect<T, A> of(A value, @Nullable SideEffect<? super A> sideEffect) {
            if (sideEffect == null) {
                return null;
            }
            if (sideEffect instanceof FixedSideEffect) {
                return (FixedSideEffect)Cast.uncheckedNonnullCast(sideEffect);
            }
            return new FixedSideEffect<T, A>(value, sideEffect);
        }

        private FixedSideEffect(A value, SideEffect<? super A> sideEffect) {
            this.value = value;
            this.sideEffect = sideEffect;
        }

        @Override
        public void execute(T t) {
            this.sideEffect.execute(this.value);
        }

        public String toString() {
            return "fixed(" + this.value + ", " + this.sideEffect + ")";
        }
    }

    public static interface SideEffect<T>
    extends Serializable {
        public void execute(T var1);

        @Nullable
        public static <T, A> SideEffect<T> fixed(A value, @Nullable SideEffect<A> sideEffect) {
            return FixedSideEffect.of(value, sideEffect);
        }

        @Nullable
        public static <T, A> SideEffect<T> fixedFrom(Value<A> value) {
            if (value.isMissing()) {
                return null;
            }
            return SideEffect.fixed(value.getWithoutSideEffect(), value.getSideEffect());
        }

        @Nullable
        public static <T, A> SideEffect<T> fixedFrom(ExecutionTimeValue<A> value) {
            if (!value.hasFixedValue()) {
                return null;
            }
            return SideEffect.fixed(value.getFixedValue(), value.getSideEffect());
        }

        @Nullable
        public static <T> SideEffect<T> composite(Iterable<SideEffect<T>> sideEffects) {
            return CompositeSideEffect.of(sideEffects);
        }

        @SafeVarargs
        @Nullable
        public static <T> SideEffect<T> composite(SideEffect<? super T> ... sideEffects) {
            List sideEffectList = (List)Cast.uncheckedNonnullCast(Arrays.asList(sideEffects));
            return CompositeSideEffect.of(sideEffectList);
        }

        public static <T> SideEffectBuilder<T> builder() {
            return new SideEffectBuilder();
        }
    }

    public static class NoProducer
    implements ValueProducer {
        @Override
        public boolean isProducesDifferentValueOverTime() {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }
    }

    public static class UnknownProducer
    implements ValueProducer {
        @Override
        public boolean isKnown() {
            return false;
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }
    }

    public static class PlusProducer
    implements ValueProducer {
        private final ValueProducer left;
        private final ValueProducer right;

        public PlusProducer(ValueProducer left, ValueProducer right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean isKnown() {
            return this.left.isKnown() || this.right.isKnown();
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return this.left.isProducesDifferentValueOverTime() || this.right.isProducesDifferentValueOverTime();
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            this.left.visitProducerTasks(visitor);
            this.right.visitProducerTasks(visitor);
        }
    }

    public static class TaskProducer
    implements ValueProducer {
        private final Task task;
        private boolean content;

        public TaskProducer(Task task, boolean content) {
            this.task = task;
            this.content = content;
        }

        @Override
        public boolean isProducesDifferentValueOverTime() {
            return false;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
            visitor.execute(this.task);
        }

        @Override
        public void visitContentProducerTasks(Action<? super Task> visitor) {
            if (this.content) {
                visitor.execute(this.task);
            }
        }
    }

    public static class ExternalValueProducer
    implements ValueProducer {
        @Override
        public boolean isProducesDifferentValueOverTime() {
            return true;
        }

        @Override
        public void visitProducerTasks(Action<? super Task> visitor) {
        }
    }

    public static interface ValueProducer {
        public static final NoProducer NO_PRODUCER = new NoProducer();
        public static final UnknownProducer UNKNOWN_PRODUCER = new UnknownProducer();

        default public boolean isKnown() {
            return true;
        }

        public boolean isProducesDifferentValueOverTime();

        public void visitProducerTasks(Action<? super Task> var1);

        default public void visitContentProducerTasks(Action<? super Task> visitor) {
            this.visitProducerTasks(visitor);
        }

        default public ValueProducer plus(ValueProducer producer) {
            if (this == NO_PRODUCER) {
                return producer;
            }
            if (producer == NO_PRODUCER) {
                return this;
            }
            if (producer == this) {
                return this;
            }
            return new PlusProducer(this, producer);
        }

        public static ValueProducer noProducer() {
            return NO_PRODUCER;
        }

        public static ValueProducer unknown() {
            return UNKNOWN_PRODUCER;
        }

        public static ValueProducer externalValue() {
            return new ExternalValueProducer();
        }

        public static ValueProducer task(Task task) {
            return new TaskProducer(task, true);
        }

        public static ValueProducer taskState(Task task) {
            return new TaskProducer(task, false);
        }
    }

    public static enum ValueConsumer {
        DisallowUnsafeRead,
        IgnoreUnsafeRead;

    }
}

