/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collections;
import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.properties.PropertyVisitor;

@NonNullApi
public class DefaultTaskDestroyables
implements TaskDestroyablesInternal {
    private final TaskMutator taskMutator;
    private final FileCollectionFactory fileCollectionFactory;
    private final List<Object> registeredPaths = Lists.newArrayList();

    public DefaultTaskDestroyables(TaskMutator taskMutator, FileCollectionFactory fileCollectionFactory) {
        this.taskMutator = taskMutator;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public void register(Object ... paths) {
        this.taskMutator.mutate("TaskDestroys.register(Object...)", () -> Collections.addAll(this.registeredPaths, paths));
    }

    @Override
    public void visitRegisteredProperties(PropertyVisitor visitor) {
        for (Object registeredPath : this.registeredPaths) {
            visitor.visitDestroyableProperty(registeredPath);
        }
    }

    @Override
    public FileCollection getRegisteredFiles() {
        return this.fileCollectionFactory.resolving("destroyables", this.registeredPaths);
    }
}

