/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.text;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.reporting.ReportRenderer;

public class StyledTable {
    private final String indent;
    private final List<String> headers;
    private final List<Row> rows;

    public StyledTable(String indent, List<String> headers, List<Row> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            if (rows.get((int)i).text.size() == headers.size()) continue;
            throw new IllegalArgumentException("Header and row " + i + " must have the same number of columns");
        }
        this.indent = indent;
        this.headers = ImmutableList.copyOf(headers);
        this.rows = ImmutableList.copyOf(rows);
    }

    public static final class Renderer
    extends ReportRenderer<StyledTable, StyledTextOutput> {
        @Override
        public void render(StyledTable model, StyledTextOutput output) {
            int[] colWidths = new int[model.headers.size()];
            for (int i2 = 0; i2 < model.headers.size(); ++i2) {
                int finalI = i2;
                colWidths[i2] = Stream.concat(Stream.of((String)model.headers.get(i2)), model.rows.stream().map(row -> row.text.get(finalI))).mapToInt(String::length).max().orElse(0);
            }
            output.style(StyledTextOutput.Style.Header);
            this.printRow(model, output, colWidths, model.headers, ' ');
            output.style(StyledTextOutput.Style.Normal);
            output.println();
            this.printRow(model, output, colWidths, (List)IntStream.range(0, colWidths.length).mapToObj(i -> "").collect(ImmutableList.toImmutableList()), '-');
            output.println();
            List rowList = model.rows;
            for (int i3 = 0; i3 < rowList.size(); ++i3) {
                Row row2 = (Row)rowList.get(i3);
                output.style(row2.style);
                this.printRow(model, output, colWidths, row2.text, ' ');
                output.style(StyledTextOutput.Style.Normal);
                if (i3 >= rowList.size() - 1) continue;
                output.println();
            }
        }

        private void printRow(StyledTable model, StyledTextOutput output, int[] colWidths, List<String> row, char padChar) {
            output.withStyle(StyledTextOutput.Style.Normal).text(model.indent + "|" + padChar);
            for (int i = 0; i < row.size(); ++i) {
                output.text(Strings.padEnd((String)row.get(i), (int)colWidths[i], (char)padChar));
                if (i >= row.size() - 1) continue;
                output.withStyle(StyledTextOutput.Style.Normal).text(padChar + "|" + padChar);
            }
            output.withStyle(StyledTextOutput.Style.Normal).text(padChar + "|");
        }
    }

    public static final class Row {
        public final List<String> text;
        public final StyledTextOutput.Style style;

        public Row(List<String> text, StyledTextOutput.Style style) {
            this.text = ImmutableList.copyOf(text);
            this.style = style;
        }
    }
}

