/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.RelativePathSpec;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.file.excludes.FileSystemDefaultExcludesListener;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scope.Global.class)
public class PatternSpecFactory
implements FileSystemDefaultExcludesListener {
    public static final PatternSpecFactory INSTANCE = new PatternSpecFactory();
    private String[] previousDefaultExcludes;
    private final Map<CaseSensitivity, Spec<FileTreeElement>> defaultExcludeSpecCache = new EnumMap<CaseSensitivity, Spec<FileTreeElement>>(CaseSensitivity.class);

    @Override
    public void onDefaultExcludesChanged(List<String> excludes) {
        this.setDefaultExcludesFromSettings(excludes.toArray(new String[0]));
    }

    public Spec<FileTreeElement> createSpec(PatternSet patternSet) {
        return Specs.intersect(this.createIncludeSpec(patternSet), Specs.negate(this.createExcludeSpec(patternSet)));
    }

    public Spec<FileTreeElement> createIncludeSpec(PatternSet patternSet) {
        ArrayList<Spec<FileTreeElement>> allIncludeSpecs = new ArrayList<Spec<FileTreeElement>>(1 + patternSet.getIncludeSpecs().size());
        if (!patternSet.getIncludes().isEmpty()) {
            allIncludeSpecs.add(this.createSpec(patternSet.getIncludes(), true, patternSet.isCaseSensitive()));
        }
        allIncludeSpecs.addAll(patternSet.getIncludeSpecs());
        return Specs.union(allIncludeSpecs);
    }

    public Spec<FileTreeElement> createExcludeSpec(PatternSet patternSet) {
        ArrayList<Spec<FileTreeElement>> allExcludeSpecs = new ArrayList<Spec<FileTreeElement>>(2 + patternSet.getExcludeSpecs().size());
        if (!patternSet.getExcludes().isEmpty()) {
            allExcludeSpecs.add(this.createSpec(patternSet.getExcludes(), false, patternSet.isCaseSensitive()));
        }
        allExcludeSpecs.add(this.getDefaultExcludeSpec(CaseSensitivity.forCaseSensitive(patternSet.isCaseSensitive())));
        allExcludeSpecs.addAll(patternSet.getExcludeSpecs());
        if (allExcludeSpecs.isEmpty()) {
            return Specs.satisfyNone();
        }
        return Specs.union(allExcludeSpecs);
    }

    private synchronized Spec<FileTreeElement> getDefaultExcludeSpec(CaseSensitivity caseSensitivity) {
        String[] defaultExcludes = DirectoryScanner.getDefaultExcludes();
        if (this.defaultExcludeSpecCache.isEmpty()) {
            this.updateDefaultExcludeSpecCache(defaultExcludes);
        } else if (this.invalidChangeOfExcludes(defaultExcludes)) {
            this.failOnChangedDefaultExcludes(this.previousDefaultExcludes, defaultExcludes);
        }
        return this.defaultExcludeSpecCache.get((Object)caseSensitivity);
    }

    private boolean invalidChangeOfExcludes(String[] defaultExcludes) {
        return !Arrays.equals(this.previousDefaultExcludes, defaultExcludes);
    }

    private void failOnChangedDefaultExcludes(String[] excludesFromSettings, String[] newDefaultExcludes) {
        List<String> sortedExcludesFromSettings = Arrays.asList(excludesFromSettings);
        sortedExcludesFromSettings.sort(Comparator.naturalOrder());
        List<String> sortedNewExcludes = Arrays.asList(newDefaultExcludes);
        sortedNewExcludes.sort(Comparator.naturalOrder());
        throw new InvalidUserCodeException(String.format("Cannot change default excludes during the build. They were changed from %s to %s. Configure default excludes in the settings script instead.", sortedExcludesFromSettings, sortedNewExcludes));
    }

    public synchronized void setDefaultExcludesFromSettings(String[] excludesFromSettings) {
        if (!Arrays.equals(this.previousDefaultExcludes, excludesFromSettings)) {
            this.updateDefaultExcludeSpecCache(excludesFromSettings);
        }
    }

    private void updateDefaultExcludeSpecCache(String[] defaultExcludes) {
        this.previousDefaultExcludes = defaultExcludes;
        List<String> patterns = Arrays.asList(defaultExcludes);
        for (CaseSensitivity caseSensitivity : CaseSensitivity.values()) {
            this.defaultExcludeSpecCache.put(caseSensitivity, this.createSpec(patterns, false, caseSensitivity.isCaseSensitive()));
        }
    }

    protected Spec<FileTreeElement> createSpec(Collection<String> patterns, boolean include, boolean caseSensitive) {
        if (patterns.isEmpty()) {
            return include ? Specs.satisfyAll() : Specs.satisfyNone();
        }
        PatternMatcher matcher = PatternMatcherFactory.getPatternsMatcher(include, caseSensitive, patterns);
        return new RelativePathSpec(matcher);
    }

    private static enum CaseSensitivity {
        CASE_SENSITIVE(true),
        CASE_INSENSITIVE(false);

        private final boolean caseSensitive;

        private CaseSensitivity(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public static CaseSensitivity forCaseSensitive(boolean caseSensitive) {
            return caseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }
    }
}

