/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.BuildController;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildController
implements BuildController {
    private final BuildWorkGraph workGraph;
    private final Set<ExportedTaskNode> scheduled = new LinkedHashSet<ExportedTaskNode>();
    private final Set<ExportedTaskNode> queuedForExecution = new LinkedHashSet<ExportedTaskNode>();
    private final WorkerLeaseService workerLeaseService;
    private State state = State.DiscoveringTasks;

    public DefaultBuildController(BuildState build2, WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
        this.workGraph = build2.getWorkGraph().newWorkGraph();
    }

    @Override
    public void queueForExecution(ExportedTaskNode taskNode) {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.add(taskNode);
    }

    @Override
    public void populateWorkGraph(Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.populateWorkGraph(action);
    }

    @Override
    public void addFilter(Spec<Task> filter) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.addFilter(filter);
    }

    @Override
    public void addFinalization(BiConsumer<EntryTaskSelector.Context, QueryableExecutionPlan> finalization) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.addFinalization(finalization);
    }

    @Override
    public boolean scheduleQueuedTasks() {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.removeAll(this.scheduled);
        if (this.queuedForExecution.isEmpty()) {
            return false;
        }
        boolean added = this.workGraph.schedule(this.queuedForExecution);
        this.scheduled.addAll(this.queuedForExecution);
        this.queuedForExecution.clear();
        return added;
    }

    @Override
    public void finalizeWorkGraph() {
        this.assertInState(State.DiscoveringTasks);
        if (!this.queuedForExecution.isEmpty()) {
            throw new IllegalStateException("Queued tasks have not been scheduled.");
        }
        HashSet<TaskInternal> visited = new HashSet<TaskInternal>();
        HashSet<TaskInternal> visiting = new HashSet<TaskInternal>();
        for (ExportedTaskNode node : this.scheduled) {
            DefaultBuildController.checkForCyclesFor(node.getTask(), visited, visiting);
        }
        this.workGraph.finalizeGraph();
        this.state = State.ReadyToRun;
    }

    @Override
    public void startExecution(ExecutorService executorService, Consumer<ExecutionResult<Void>> completionHandler) {
        this.assertInState(State.ReadyToRun);
        executorService.submit(new BuildOpRunnable(CurrentBuildOperationRef.instance().get(), completionHandler));
        this.state = State.RunningTasks;
    }

    @Override
    public void stop() {
        this.workGraph.stop();
    }

    private void assertInState(State expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Build is in unexpected state: " + (Object)((Object)this.state));
        }
    }

    private static void checkForCyclesFor(TaskInternal task, Set<TaskInternal> visited, Set<TaskInternal> visiting) {
        if (visited.contains(task)) {
            return;
        }
        if (!visiting.add(task)) {
            CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> DefaultBuildController.visitDependenciesOf(node, connectedNodes::add));
            graphWalker.add((TaskInternal[])new TaskInternal[]{task});
            List<Set<TaskInternal>> cycles = graphWalker.findCycles();
            Set<TaskInternal> cycle = cycles.get(0);
            DirectedGraphRenderer<TaskInternal> graphRenderer = new DirectedGraphRenderer<TaskInternal>((node, output) -> output.withStyle(StyledTextOutput.Style.Identifier).text(node.getIdentityPath()), (node, values, connectedNodes) -> DefaultBuildController.visitDependenciesOf(node, dep -> {
                if (cycle.contains(dep)) {
                    connectedNodes.add(dep);
                }
            }));
            StringWriter writer2 = new StringWriter();
            graphRenderer.renderTo(task, writer2);
            throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer2));
        }
        DefaultBuildController.visitDependenciesOf(task, dep -> DefaultBuildController.checkForCyclesFor(dep, visited, visiting));
        visiting.remove(task);
        visited.add(task);
    }

    private static void visitDependenciesOf(TaskInternal task, Consumer<TaskInternal> consumer) {
        TaskNodeFactory taskNodeFactory = ((GradleInternal)task.getProject().getGradle()).getServices().get(TaskNodeFactory.class);
        TaskNode node = taskNodeFactory.getOrCreateNode(task);
        for (Node dependency : node.getAllSuccessors()) {
            if (!(dependency instanceof TaskNode)) continue;
            consumer.accept(((TaskNode)dependency).getTask());
        }
    }

    private ExecutionResult<Void> doRun() {
        try {
            return this.workerLeaseService.runAsWorkerThread(this.workGraph::runWork);
        }
        catch (Throwable t) {
            return ExecutionResult.failed(t);
        }
    }

    private class BuildOpRunnable
    implements Runnable {
        private final BuildOperationRef parentBuildOperation;
        private final Consumer<ExecutionResult<Void>> completionHandler;

        BuildOpRunnable(BuildOperationRef parentBuildOperation, Consumer<ExecutionResult<Void>> completionHandler) {
            this.parentBuildOperation = parentBuildOperation;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run() {
            CurrentBuildOperationRef.instance().with(this.parentBuildOperation, () -> this.completionHandler.accept(DefaultBuildController.this.doRun()));
        }
    }

    private static enum State {
        DiscoveringTasks,
        ReadyToRun,
        RunningTasks,
        Finished;

    }
}

