/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.BiFunction;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.execution.history.changes.AbstractFingerprintCompareStrategy;
import org.gradle.internal.execution.history.changes.Change;
import org.gradle.internal.execution.history.changes.ChangeContainer;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.NormalizedPathChangeDetector;
import org.gradle.internal.execution.history.changes.PropertyDiffListener;
import org.gradle.internal.execution.history.changes.SortedMapDiffUtil;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class OutputFileChanges
implements ChangeContainer {
    private final SortedMap<String, FileSystemSnapshot> previous;
    private final SortedMap<String, FileSystemSnapshot> current;

    public OutputFileChanges(SortedMap<String, FileSystemSnapshot> previous, SortedMap<String, FileSystemSnapshot> current) {
        this.previous = previous;
        this.current = current;
    }

    @Override
    public boolean accept(final ChangeVisitor visitor) {
        return SortedMapDiffUtil.diff(this.previous, this.current, new PropertyDiffListener<String, FileSystemSnapshot, FileSystemSnapshot>(){

            @Override
            public boolean removed(String previousProperty) {
                return true;
            }

            @Override
            public boolean added(String currentProperty) {
                return true;
            }

            @Override
            public boolean updated(String property2, FileSystemSnapshot previous, FileSystemSnapshot current) {
                String propertyTitle = "Output property '" + property2 + "'";
                return OutputFileChanges.this.visitChangesSince(previous, current, propertyTitle, visitor);
            }
        });
    }

    public boolean visitChangesSince(FileSystemSnapshot previous, FileSystemSnapshot current, String propertyTitle, ChangeVisitor visitor) {
        if (previous == current) {
            return true;
        }
        if (previous == FileSystemSnapshot.EMPTY) {
            return OutputFileChanges.visitAllChanges(current, visitor, (relativePath, snapshot) -> AbstractFingerprintCompareStrategy.FINGERPRINT_CHANGE_FACTORY.added(snapshot.getAbsolutePath(), propertyTitle, OutputFileChanges.createFingerprint(relativePath, snapshot)));
        }
        if (current == FileSystemSnapshot.EMPTY) {
            return OutputFileChanges.visitAllChanges(previous, visitor, (relativePath, snapshot) -> AbstractFingerprintCompareStrategy.FINGERPRINT_CHANGE_FACTORY.removed(snapshot.getAbsolutePath(), propertyTitle, OutputFileChanges.createFingerprint(relativePath, snapshot)));
        }
        FileSystemLocationSnapshot previousSnapshot = (FileSystemLocationSnapshot)previous;
        FileSystemLocationSnapshot currentSnapshot = (FileSystemLocationSnapshot)current;
        if (previousSnapshot.getHash().equals(currentSnapshot.getHash())) {
            return true;
        }
        if (currentSnapshot.getType() != FileType.Directory || previousSnapshot.getType() != FileType.Directory) {
            if (visitor.visitChange(AbstractFingerprintCompareStrategy.FINGERPRINT_CHANGE_FACTORY.modified(currentSnapshot.getAbsolutePath(), propertyTitle, OutputFileChanges.createRootFingerprint(previousSnapshot), OutputFileChanges.createRootFingerprint(currentSnapshot))) && OutputFileChanges.visitAllChildChanges(previousSnapshot, visitor, (relativePath, snapshot) -> AbstractFingerprintCompareStrategy.FINGERPRINT_CHANGE_FACTORY.removed(snapshot.getAbsolutePath(), propertyTitle, OutputFileChanges.createFingerprint(relativePath, snapshot)))) {
                return OutputFileChanges.visitAllChildChanges(currentSnapshot, visitor, (relativePath, snapshot) -> AbstractFingerprintCompareStrategy.FINGERPRINT_CHANGE_FACTORY.added(snapshot.getAbsolutePath(), propertyTitle, OutputFileChanges.createFingerprint(relativePath, snapshot)));
            }
            return false;
        }
        Map<String, FileSystemLocationFingerprint> previousFingerprint = OutputFileChanges.collectFingerprints(previous);
        Map<String, FileSystemLocationFingerprint> currentFingerprint = OutputFileChanges.collectFingerprints(current);
        return NormalizedPathChangeDetector.INSTANCE.visitChangesSince(previousFingerprint, currentFingerprint, propertyTitle, visitor);
    }

    private static boolean visitAllChanges(FileSystemSnapshot root, ChangeVisitor visitor, BiFunction<RelativePathSupplier, FileSystemLocationSnapshot, Change> changeFactory) {
        return root.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
            boolean shouldContinue = visitor.visitChange((Change)changeFactory.apply(relativePath, snapshot));
            return shouldContinue ? SnapshotVisitResult.CONTINUE : SnapshotVisitResult.TERMINATE;
        }) == SnapshotVisitResult.CONTINUE;
    }

    private static boolean visitAllChildChanges(FileSystemSnapshot root, ChangeVisitor visitor, BiFunction<RelativePathSupplier, FileSystemLocationSnapshot, Change> changeFactory) {
        return root.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
            if (relativePath.isRoot()) {
                return SnapshotVisitResult.CONTINUE;
            }
            boolean shouldContinue = visitor.visitChange((Change)changeFactory.apply(relativePath, snapshot));
            return shouldContinue ? SnapshotVisitResult.CONTINUE : SnapshotVisitResult.TERMINATE;
        }) == SnapshotVisitResult.CONTINUE;
    }

    private static Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        LinkedHashMap<String, FileSystemLocationFingerprint> result2 = new LinkedHashMap<String, FileSystemLocationFingerprint>();
        roots.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
            result2.put(snapshot.getAbsolutePath(), OutputFileChanges.createFingerprint(relativePath, snapshot));
            return SnapshotVisitResult.CONTINUE;
        });
        return result2;
    }

    private static DefaultFileSystemLocationFingerprint createFingerprint(RelativePathSupplier relativePath, FileSystemLocationSnapshot snapshot) {
        return OutputFileChanges.createFingerprint(relativePath.toRelativePath(), snapshot);
    }

    private static DefaultFileSystemLocationFingerprint createRootFingerprint(FileSystemLocationSnapshot snapshot) {
        return OutputFileChanges.createFingerprint("", snapshot);
    }

    private static DefaultFileSystemLocationFingerprint createFingerprint(String relativePath, FileSystemLocationSnapshot snapshot) {
        return new DefaultFileSystemLocationFingerprint(relativePath, snapshot.getType(), snapshot.getHash());
    }
}

