/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class DefaultWorkValidationContext
implements WorkValidationContext {
    private final Set<Class<?>> types = new HashSet();
    private final ImmutableList.Builder<ReportableProblem> problems = ImmutableList.builder();
    private final WorkValidationContext.TypeOriginInspector typeOriginInspector;
    private final Problems problemsService;

    public DefaultWorkValidationContext(WorkValidationContext.TypeOriginInspector typeOriginInspector, Problems problemsService) {
        this.problemsService = problemsService;
        this.typeOriginInspector = typeOriginInspector;
    }

    @Override
    public TypeValidationContext forType(Class<?> type, final boolean cacheable) {
        this.types.add(type);
        Supplier<Optional> pluginId = () -> this.typeOriginInspector.findPluginDefining(type);
        return new ProblemRecordingTypeValidationContext(type, pluginId){

            @Override
            protected void recordProblem(ReportableProblem problem2) {
                if (ValidationProblemId.onlyAffectsCacheableWork(problem2.getProblemType()) && !cacheable) {
                    return;
                }
                DefaultWorkValidationContext.this.problems.add((Object)problem2);
            }
        };
    }

    @Override
    public List<ReportableProblem> getProblems() {
        return this.problems.build();
    }

    public ImmutableSortedSet<Class<?>> getValidatedTypes() {
        return ImmutableSortedSet.copyOf(Comparator.comparing(Class::getName), this.types);
    }
}

